/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.i18n.POObject;
import org.hl7.fhir.utilities.i18n.POSource;

public class PoGetTextProducer
extends LanguageFileProducer {
    private int filecount;
    private boolean incLangInFilename;
    private String srcLang;

    public PoGetTextProducer(String rootFolder, String folderName, boolean useLangFolder) {
        super(rootFolder, folderName, useLangFolder);
    }

    public PoGetTextProducer() {
    }

    public PoGetTextProducer(String srcLang) {
        this.srcLang = srcLang;
    }

    @Override
    public LanguageFileProducer.LanguageProducerSession startSession(String id, String baseLang) throws IOException {
        return new POGetTextProducerSession(id, baseLang);
    }

    @Override
    public void finish() {
    }

    @Override
    public int fileCount() {
        return this.filecount;
    }

    @Override
    public List<LanguageFileProducer.TranslationUnit> loadSource(InputStream source) throws IOException {
        ArrayList<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        POSource polist = POSource.loadPOFile(source);
        Iterator<POObject> iterator = polist.getPOObjects().iterator();
        while (iterator.hasNext()) {
            POObject po;
            LanguageFileProducer.TranslationUnit tu = new LanguageFileProducer.TranslationUnit(this.srcLang == null ? polist.getLang() : this.srcLang, (po = iterator.next()).getId(), null, po.getMsgid(), po.getMsgstr().isEmpty() ? null : po.getMsgstrFirst());
            if (tu.getId() == null) continue;
            list.add(tu);
        }
        return list;
    }

    private String getFileName(String id, String baseLang, String targetLang) throws IOException {
        return Utilities.path(this.getRootFolder(), this.isUseLangFolder() ? targetLang : ".", this.getFolderName(), id + (String)(this.incLangInFilename ? "-" + baseLang + "-" + targetLang + ".po" : ""));
    }

    public boolean isIncLangInFilename() {
        return this.incLangInFilename;
    }

    public void setIncLangInFilename(boolean incLangInFilename) {
        this.incLangInFilename = incLangInFilename;
    }

    protected void ln(StringBuilder po, String line) {
        po.append(line + "\r\n");
    }

    @Override
    public void produce(String id, String baseLang, String targetLang, List<LanguageFileProducer.TranslationUnit> translations, String filename) throws IOException {
        POSource source = new POSource();
        for (LanguageFileProducer.TranslationUnit unit : translations) {
            POObject po = new POObject(unit.getId(), unit.getSrcText(), unit.getTgtText());
            po.setComment(unit.getContext());
            po.setOldMsgId(unit.getOriginal());
            source.getPOObjects().add(po);
        }
        source.savePOFile(this.getFileName(id, baseLang, targetLang) + ".po", 1, 0);
    }

    private String stripEoln(String s) {
        if (s == null) {
            return "";
        }
        s = s.replace("\r\n\r\n", " ").replace("\n\n", " ").replace("\r\r", " ");
        s = s.replace("\r\n", " ").replace("\n", " ").replace("\r", " ");
        return s;
    }

    public class POGetTextProducerSession
    extends LanguageFileProducer.LanguageProducerSession {
        public POGetTextProducerSession(String id, String baseLang) {
            super(id, baseLang);
        }

        @Override
        public LanguageFileProducer.LanguageProducerLanguageSession forLang(String targetLang) {
            return new POGetTextLanguageProducerLanguageSession(this.id, this.baseLang, targetLang);
        }

        @Override
        public void finish() throws IOException {
        }
    }

    public class POGetTextLanguageProducerLanguageSession
    extends LanguageFileProducer.LanguageProducerLanguageSession {
        POSource source;

        public POGetTextLanguageProducerLanguageSession(String id, String baseLang, String targetLang) {
            super(id, baseLang, targetLang);
            this.source = new POSource();
        }

        @Override
        public void finish() throws IOException {
            this.source.savePOFile(PoGetTextProducer.this.getFileName(this.id, this.baseLang, this.targetLang), 1, 0);
            ++PoGetTextProducer.this.filecount;
        }

        @Override
        public void entry(LanguageFileProducer.TextUnit unit) {
            POObject po = new POObject(unit.getId(), unit.getSrcText(), unit.getTgtText());
            po.setComment(unit.getContext());
            this.source.getPOObjects().add(po);
        }
    }
}

