/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.POObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(POSource.class);
    private String lang;
    private List<POObject> poObjects = new ArrayList<POObject>();
    private List<String> prefixes = new ArrayList<String>();

    public String getLang() {
        return this.lang;
    }

    public List<POObject> getPOObjects() {
        return this.poObjects;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }

    public static POSource loadPOFile(InputStream source) throws FileNotFoundException, IOException {
        return POSource.loadPOFile(FileUtilities.streamToLines(source));
    }

    public static POSource loadPOFile(String dest) throws FileNotFoundException, IOException {
        return POSource.loadPOFile(FileUtilities.fileToLines(new File(dest)));
    }

    private static POSource loadPOFile(String[] lines) throws FileNotFoundException, IOException {
        POSource poSource = new POSource();
        POObject poObject = null;
        for (int i = 0; i < lines.length; ++i) {
            Object s;
            String line = lines[i];
            if (Utilities.noString(line)) continue;
            if (line.startsWith("#:")) {
                if (poObject == null || poObject.getId() != null) {
                    poObject = new POObject();
                    poSource.poObjects.add(poObject);
                }
                poObject.setId(line.substring(2).trim());
                continue;
            }
            if (line.startsWith("# ") && line.contains(" -> ")) {
                poSource.lang = line.substring(line.indexOf("->") + 2).trim();
                continue;
            }
            if (line.startsWith("# ")) {
                if (poObject == null || poObject.getComment() != null) {
                    poObject = new POObject();
                    poSource.poObjects.add(poObject);
                }
                poObject.setComment(line.substring(1).trim());
                if (!poObject.getComment().contains("!!when")) continue;
                poObject.setOldMsgId(poObject.getComment().substring(poObject.getComment().indexOf("!!when")));
                poObject.setComment(poObject.getComment().substring(0, poObject.getComment().indexOf("!!when") - 1));
                poObject.setOldMsgId(poObject.getOldMsgId().substring(poObject.getOldMsgId().indexOf(": ") + 2).trim());
                poObject.setOldMsgId(poObject.getOldMsgId().substring(0, poObject.getOldMsgId().length() - 1));
                continue;
            }
            if (poObject == null) {
                poSource.prefixes.add(line);
                continue;
            }
            if (line.startsWith("#,")) {
                String flags = line.substring(2).trim();
                for (String flag : flags.split(",")) {
                    poObject.getFlags().add(flag.trim());
                }
                continue;
            }
            if (line.startsWith("#|")) {
                s = line.substring(2).trim();
                if (((String)s).startsWith("msgid ")) {
                    s = POSource.trimQuotes(((String)s).substring(6));
                }
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                poObject.setOldMsgId((String)s);
                continue;
            }
            if (line.startsWith("msgid ")) {
                s = POSource.trimQuotes(line.substring(5).trim());
                if (((String)s).endsWith("(" + poObject.getId() + ")")) {
                    s = ((String)s).substring(0, ((String)s).length() - (poObject.getId().length() + 3));
                }
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                poObject.setMsgid((String)s);
                continue;
            }
            if (line.startsWith("msgid_plural ")) {
                s = POSource.trimQuotes(line.substring(12).trim());
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                poObject.setMsgidPlural((String)s);
                continue;
            }
            if (line.startsWith("msgstr ")) {
                s = POSource.trimQuotes(line.substring(6).trim());
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                poObject.getMsgstr().add((String)s);
                continue;
            }
            if (line.startsWith("msgctxt ")) continue;
            if (line.startsWith("msgstr[")) {
                s = line.substring(7);
                int ii = ((String)s).indexOf("]");
                int c = Integer.valueOf(((String)s).substring(0, ii));
                s = POSource.trimQuotes(((String)s).substring(ii + 1).trim());
                while (i < lines.length - 1 && lines[i + 1].startsWith("\"")) {
                    s = (String)s + POSource.trimQuotes(lines[++i]);
                }
                while (((String)s).startsWith("!!")) {
                    s = ((String)s).substring(2);
                }
                if (c != poObject.getMsgstr().size()) {
                    log.warn("index issue");
                    continue;
                }
                poObject.getMsgstr().add((String)s);
                continue;
            }
            log.warn("unknown line: " + line);
        }
        return poSource;
    }

    private static String trimQuotes(String s) {
        if ((s = s.trim()).startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.trim().replace("\\\"", "\"");
    }

    public int savePOFile(String poFilePath, int numberOfPlurals, int noTrans) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String prefix : this.prefixes) {
            sb.append(prefix);
            sb.append("\r\n");
        }
        sb.append("\r\n");
        for (POObject poObject : this.poObjects) {
            if (poObject.getOldMsgId() != null) {
                sb.append("# " + poObject.getComment() + " (!!when last translated was: " + poObject.getOldMsgId() + ")\r\n");
            } else {
                sb.append("# " + poObject.getComment() + "\r\n");
            }
            sb.append("#: " + poObject.getId() + "\r\n");
            if (!poObject.getFlags().isEmpty()) {
                sb.append("#, " + CommaSeparatedStringBuilder.join(",", poObject.getFlags()) + "\r\n");
            }
            if (poObject.isDuplicate()) {
                sb.append("msgctxt \"" + poObject.getId() + "\"\r\n");
            }
            Object m = Utilities.noString(poObject.getMsgid()) ? "-- no content: do not translate #" + ++noTrans + " --" : poObject.getMsgid();
            sb.append("msgid \"" + POSource.wrapQuotes((String)m) + "\"\r\n");
            if (poObject.getMsgidPlural() != null) {
                sb.append("msgid_plural \"" + POSource.wrapQuotes(poObject.getMsgidPlural()) + "\"\r\n");
                while (poObject.getMsgstr().size() < numberOfPlurals) {
                    poObject.getMsgstr().add("");
                }
                for (int i = 0; i < poObject.getMsgstr().size(); ++i) {
                    String s = poObject.getMsgstr().get(i);
                    sb.append("msgstr[" + i + "] \"" + POSource.wrapQuotes(s) + "\"\r\n");
                }
            } else if (poObject.getMsgstr().size() == 0) {
                sb.append("msgstr \"\"\r\n");
            } else {
                sb.append("msgstr \"" + POSource.wrapQuotes(poObject.getMsgstr().get(0)) + "\"\r\n");
            }
            sb.append("\r\n");
        }
        FileUtilities.stringToFile(sb.toString(), poFilePath);
        return noTrans;
    }

    private static String wrapQuotes(String s) {
        return s.replace("\"", "\\\"");
    }
}

