/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.DurationUtil;

public class TimeTracker {
    private List<Session> sessions = new ArrayList<Session>();
    private List<Counter> records = new ArrayList<Counter>();
    private long globalStart = System.nanoTime();
    private long milestone = 0L;

    public Session start(String name) {
        Counter c = null;
        for (Counter t : this.records) {
            if (!t.name.equals(name)) continue;
            c = t;
        }
        if (c == null) {
            c = new Counter(name);
            this.records.add(c);
        }
        Session session = new Session(name);
        this.sessions.add(session);
        return session;
    }

    private void endSession(Session session) {
        this.sessions.remove(session);
        Counter c = null;
        for (Counter t : this.records) {
            if (!t.name.equals(session.name)) continue;
            c = t;
        }
        ++c.count;
        c.length = c.length + System.nanoTime() - session.start;
    }

    public String report() {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Counter c : this.records) {
            if (c.count != 1) continue;
            b.append(c.name + ": " + DurationUtil.presentDuration(c.length));
        }
        for (Counter c : this.records) {
            if (c.count <= 1) continue;
            b.append(c.name + ": " + DurationUtil.presentDuration(c.length) + " (#" + c.count + ")");
        }
        return "Times: " + b.toString();
    }

    public String clock() {
        return DurationUtil.presentDuration(System.nanoTime() - this.globalStart);
    }

    public String instant() {
        return DurationUtil.presentDuration(System.nanoTime() - this.globalStart);
    }

    public String milestone() {
        long start = this.milestone == 0L ? this.globalStart : this.milestone;
        this.milestone = System.nanoTime();
        return DurationUtil.presentDuration(this.milestone - start);
    }

    public boolean longerThan(int i) {
        long start = this.milestone == 0L ? this.globalStart : this.milestone;
        long diff = (System.nanoTime() - start) / 1000000L;
        return diff > (long)(i * 1000);
    }

    public class Counter {
        private String name;
        private int count;
        private long length;

        public Counter(String name) {
            this.name = name;
        }
    }

    public class Session {
        private long start = System.nanoTime();
        private String name;

        public Session(String name) {
            this.name = name;
        }

        public void end() {
            TimeTracker.this.endSession(this);
        }
    }
}

