/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.List;

public class SemverParser {
    private final String input;
    private int pos;
    private final List<String> parts;
    private final boolean allowWildcards;
    private final boolean requirePatch;

    public SemverParser(String input) {
        this(input, false, true);
    }

    public SemverParser(String input, boolean allowWildcards) {
        this(input, allowWildcards, true);
    }

    public SemverParser(String input, boolean allowWildcards, boolean requirePatch) {
        this.input = input;
        this.pos = 0;
        this.parts = new ArrayList<String>();
        this.allowWildcards = allowWildcards;
        this.requirePatch = requirePatch;
    }

    public ParseResult parse() {
        try {
            this.parseValidSemver();
            if (this.pos != this.input.length()) {
                throw new IllegalArgumentException(String.format("Unexpected characters at position %d: \"%s\"", this.pos, this.input.substring(this.pos)));
            }
            return ParseResult.success(this.parts);
        }
        catch (Exception e) {
            return ParseResult.error(e.getMessage());
        }
    }

    private void parseValidSemver() {
        this.parseVersionCore();
        if (this.peek() != null && this.peek().charValue() == '-') {
            this.consume('-');
            this.parts.add("-");
            this.parsePreRelease();
            if (this.peek() != null && this.peek().charValue() == '+') {
                this.consume('+');
                this.parts.add("+");
                this.parseBuild();
            }
        } else if (this.peek() != null && this.peek().charValue() == '+') {
            this.consume('+');
            this.parts.add("+");
            this.parseBuild();
        }
    }

    private void parseVersionCore() {
        String wildcard;
        String major = this.parseNumericIdentifier();
        this.parts.add(major);
        if (this.peek() == null || this.peek().charValue() != '.') {
            throw new IllegalArgumentException(String.format("Expected '.' after major version at position %d", this.pos));
        }
        this.consume('.');
        this.parts.add(".");
        boolean hasWildcardInMinor = false;
        if (this.allowWildcards && this.isWildcard(this.peek())) {
            wildcard = this.parseWildcard();
            this.parts.add(wildcard);
            hasWildcardInMinor = true;
        } else {
            String minor = this.parseNumericIdentifier();
            this.parts.add(minor);
        }
        if (hasWildcardInMinor) {
            if (this.peek() != null && this.peek().charValue() == '.') {
                this.consume('.');
                this.parts.add(".");
                if (this.allowWildcards && this.isWildcard(this.peek())) {
                    String patchWildcard = this.parseWildcard();
                    this.parts.add(patchWildcard);
                } else {
                    throw new IllegalArgumentException(String.format("After wildcard in version, only wildcards are allowed at position %d", this.pos));
                }
            }
            return;
        }
        if (!(this.requirePatch || this.peek() != null && this.peek().charValue() != '-' && this.peek().charValue() != '+')) {
            return;
        }
        if (this.peek() == null || this.peek().charValue() != '.') {
            if (this.requirePatch) {
                throw new IllegalArgumentException(String.format("Expected '.' after minor version at position %d", this.pos));
            }
            return;
        }
        this.consume('.');
        this.parts.add(".");
        if (this.allowWildcards && this.isWildcard(this.peek())) {
            wildcard = this.parseWildcard();
            this.parts.add(wildcard);
        } else {
            String patch = this.parseNumericIdentifier();
            this.parts.add(patch);
        }
    }

    private void parsePreRelease() {
        this.parseDotSeparatedPreReleaseIdentifiers();
    }

    private void parseDotSeparatedPreReleaseIdentifiers() {
        String identifier = this.parsePreReleaseIdentifier();
        this.parts.add(identifier);
        while (this.peek() != null && this.peek().charValue() == '.' && this.pos + 1 < this.input.length() && this.input.charAt(this.pos + 1) != '+') {
            this.consume('.');
            this.parts.add(".");
            String nextIdentifier = this.parsePreReleaseIdentifier();
            this.parts.add(nextIdentifier);
        }
    }

    private void parseBuild() {
        this.parseDotSeparatedBuildIdentifiers();
    }

    private void parseDotSeparatedBuildIdentifiers() {
        String identifier = this.parseBuildIdentifier();
        this.parts.add(identifier);
        while (this.peek() != null && this.peek().charValue() == '.') {
            this.consume('.');
            this.parts.add(".");
            String nextIdentifier = this.parseBuildIdentifier();
            this.parts.add(nextIdentifier);
        }
    }

    private String parsePreReleaseIdentifier() {
        if (this.allowWildcards && this.isWildcard(this.peek())) {
            return this.parseWildcard();
        }
        if (this.isValidNumericIdentifier()) {
            return this.parseNumericIdentifier();
        }
        return this.parseAlphanumericIdentifier();
    }

    private String parseBuildIdentifier() {
        if (this.allowWildcards && this.isWildcard(this.peek())) {
            return this.parseWildcard();
        }
        if (this.isValidDigitsOnly()) {
            return this.parseDigits();
        }
        return this.parseAlphanumericIdentifier();
    }

    private String parseNumericIdentifier() {
        int start = this.pos;
        if (this.peek() != null && this.peek().charValue() == '0') {
            this.consume('0');
            return "0";
        }
        if (this.isPositiveDigit(this.peek())) {
            this.consumePositiveDigit();
            this.parseOptionalDigits();
            return this.input.substring(start, this.pos);
        }
        throw new IllegalArgumentException(String.format("Expected numeric identifier at position %d", this.pos));
    }

    private String parseAlphanumericIdentifier() {
        int start = this.pos;
        boolean hasNonDigit = false;
        if (this.pos >= this.input.length()) {
            throw new IllegalArgumentException(String.format("Expected alphanumeric identifier at position %d", this.pos));
        }
        if (this.isNonDigit(this.peek())) {
            hasNonDigit = true;
            this.consumeNonDigit();
        } else if (this.isDigit(this.peek())) {
            this.consumeDigit();
        } else {
            throw new IllegalArgumentException(String.format("Expected alphanumeric identifier at position %d", this.pos));
        }
        while (this.isIdentifierCharacter(this.peek())) {
            if (this.isNonDigit(this.peek())) {
                hasNonDigit = true;
                this.consumeNonDigit();
                continue;
            }
            this.consumeDigit();
        }
        if (!hasNonDigit) {
            throw new IllegalArgumentException(String.format("Alphanumeric identifier must contain at least one non-digit at position %d", start));
        }
        return this.input.substring(start, this.pos);
    }

    private String parseDigits() {
        int start = this.pos;
        if (!this.isDigit(this.peek())) {
            throw new IllegalArgumentException(String.format("Expected digit at position %d", this.pos));
        }
        this.consumeDigit();
        this.parseOptionalDigits();
        return this.input.substring(start, this.pos);
    }

    private void parseOptionalDigits() {
        while (this.isDigit(this.peek())) {
            this.consumeDigit();
        }
    }

    private Character peek() {
        return this.pos < this.input.length() ? Character.valueOf(this.input.charAt(this.pos)) : null;
    }

    private void consume(char expected) {
        Character actual = this.peek();
        if (actual == null || actual.charValue() != expected) {
            throw new IllegalArgumentException(String.format("Expected '%c' at position %d, got '%s'", Character.valueOf(expected), this.pos, actual == null ? "end of input" : actual));
        }
        ++this.pos;
    }

    private boolean isPositiveDigit(Character ch) {
        return ch != null && ch.charValue() >= '1' && ch.charValue() <= '9';
    }

    private boolean isDigit(Character ch) {
        return ch != null && ch.charValue() >= '0' && ch.charValue() <= '9';
    }

    private boolean isLetter(Character ch) {
        return ch != null && (ch.charValue() >= 'A' && ch.charValue() <= 'Z' || ch.charValue() >= 'a' && ch.charValue() <= 'z');
    }

    private boolean isNonDigit(Character ch) {
        return this.isLetter(ch) || ch != null && ch.charValue() == '-';
    }

    private boolean isIdentifierCharacter(Character ch) {
        return this.isDigit(ch) || this.isNonDigit(ch);
    }

    private void consumePositiveDigit() {
        if (!this.isPositiveDigit(this.peek())) {
            throw new IllegalArgumentException(String.format("Expected positive digit at position %d", this.pos));
        }
        ++this.pos;
    }

    private void consumeDigit() {
        if (!this.isDigit(this.peek())) {
            throw new IllegalArgumentException(String.format("Expected digit at position %d", this.pos));
        }
        ++this.pos;
    }

    private void consumeNonDigit() {
        if (!this.isNonDigit(this.peek())) {
            throw new IllegalArgumentException(String.format("Expected non-digit at position %d", this.pos));
        }
        ++this.pos;
    }

    private boolean isValidDigitsOnly() {
        int tempPos;
        if (this.pos >= this.input.length() || !this.isDigit(Character.valueOf(this.input.charAt(this.pos)))) {
            return false;
        }
        for (tempPos = this.pos; tempPos < this.input.length() && this.isDigit(Character.valueOf(this.input.charAt(tempPos))); ++tempPos) {
        }
        return tempPos >= this.input.length() || this.input.charAt(tempPos) == '.' || this.input.charAt(tempPos) == '+' || !this.isIdentifierCharacter(Character.valueOf(this.input.charAt(tempPos)));
    }

    private boolean isValidNumericIdentifier() {
        if (this.pos >= this.input.length()) {
            return false;
        }
        if (this.input.charAt(this.pos) == '0') {
            return this.pos + 1 >= this.input.length() || !this.isIdentifierCharacter(Character.valueOf(this.input.charAt(this.pos + 1))) || this.input.charAt(this.pos + 1) == '.' || this.input.charAt(this.pos + 1) == '+';
        }
        if (this.isPositiveDigit(Character.valueOf(this.input.charAt(this.pos)))) {
            int tempPos;
            for (tempPos = this.pos + 1; tempPos < this.input.length() && this.isDigit(Character.valueOf(this.input.charAt(tempPos))); ++tempPos) {
            }
            return tempPos >= this.input.length() || !this.isIdentifierCharacter(Character.valueOf(this.input.charAt(tempPos))) || this.input.charAt(tempPos) == '.' || this.input.charAt(tempPos) == '+';
        }
        return false;
    }

    private boolean isNumericIdentifierStart() {
        Character ch = this.peek();
        return ch != null && (ch.charValue() == '0' || this.isPositiveDigit(ch));
    }

    private boolean isAlphanumericIdentifierStart() {
        boolean hasNonDigit = false;
        int tempPos = this.pos;
        while (tempPos < this.input.length() && this.isIdentifierCharacter(Character.valueOf(this.input.charAt(tempPos)))) {
            if (this.isNonDigit(Character.valueOf(this.input.charAt(tempPos)))) {
                hasNonDigit = true;
            }
            if (++tempPos >= this.input.length() || this.input.charAt(tempPos) != '.' && this.input.charAt(tempPos) != '+') continue;
        }
        return hasNonDigit && this.isIdentifierCharacter(this.peek());
    }

    private boolean isWildcard(Character ch) {
        return ch != null && (ch.charValue() == 'x' || ch.charValue() == 'X' || ch.charValue() == '*');
    }

    private String parseWildcard() {
        int start = this.pos;
        while (this.isWildcard(this.peek())) {
            ++this.pos;
        }
        if (start == this.pos) {
            throw new IllegalArgumentException(String.format("Expected wildcard at position %d", this.pos));
        }
        return this.input.substring(start, this.pos);
    }

    public static ParseResult parseSemver(String input) {
        SemverParser parser = new SemverParser(input);
        return parser.parse();
    }

    public static ParseResult parseSemver(String input, boolean allowWildcards) {
        SemverParser parser = new SemverParser(input, allowWildcards);
        return parser.parse();
    }

    public static ParseResult parseSemver(String input, boolean allowWildcards, boolean requirePatch) {
        SemverParser parser = new SemverParser(input, allowWildcards, requirePatch);
        return parser.parse();
    }

    public static class ParseResult {
        private final List<String> parts;
        private final String error;

        private ParseResult(List<String> parts, String error) {
            this.parts = parts;
            this.error = error;
        }

        public static ParseResult success(List<String> parts) {
            return new ParseResult(new ArrayList<String>(parts), null);
        }

        public static ParseResult error(String error) {
            return new ParseResult(null, error);
        }

        public boolean isSuccess() {
            return this.error == null;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public String getError() {
            return this.error;
        }

        public String getMajor() {
            if (!this.isSuccess() || this.parts.isEmpty()) {
                return null;
            }
            return this.parts.get(0);
        }

        public String getMinor() {
            if (!this.isSuccess() || this.parts.size() < 3) {
                return null;
            }
            return this.parts.get(2);
        }

        public String getPatch() {
            if (!this.isSuccess() || this.parts.size() < 5) {
                return null;
            }
            if (!".".equals(this.parts.get(3))) {
                return null;
            }
            return this.parts.get(4);
        }

        public String getReleaseLabel() {
            if (!this.isSuccess()) {
                return null;
            }
            int dashIndex = -1;
            for (int i = 0; i < this.parts.size(); ++i) {
                if (!"-".equals(this.parts.get(i))) continue;
                dashIndex = i;
                break;
            }
            if (dashIndex == -1) {
                return null;
            }
            int plusIndex = this.parts.size();
            for (int i = dashIndex + 1; i < this.parts.size(); ++i) {
                if (!"+".equals(this.parts.get(i))) continue;
                plusIndex = i;
                break;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = dashIndex + 1; i < plusIndex; ++i) {
                sb.append(this.parts.get(i));
            }
            return sb.length() > 0 ? sb.toString() : null;
        }

        public String getBuild() {
            if (!this.isSuccess()) {
                return null;
            }
            int plusIndex = -1;
            for (int i = 0; i < this.parts.size(); ++i) {
                if (!"+".equals(this.parts.get(i))) continue;
                plusIndex = i;
                break;
            }
            if (plusIndex == -1) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = plusIndex + 1; i < this.parts.size(); ++i) {
                sb.append(this.parts.get(i));
            }
            return sb.length() > 0 ? sb.toString() : null;
        }
    }
}

