/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.Comparator;

public class NaturalOrderComparator<T extends String>
implements Comparator<T> {
    int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = NaturalOrderComparator.charAt(a, ia);
            char cb = NaturalOrderComparator.charAt(b, ib);
            if (!NaturalOrderComparator.isDigit(ca) && !NaturalOrderComparator.isDigit(cb)) {
                return bias;
            }
            if (!NaturalOrderComparator.isDigit(ca)) {
                return -1;
            }
            if (!NaturalOrderComparator.isDigit(cb)) {
                return 1;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            if (bias == 0) {
                if (ca < cb) {
                    bias = -1;
                } else if (ca > cb) {
                    bias = 1;
                }
            }
            ++ia;
            ++ib;
        }
    }

    @Override
    public int compare(String a, String b) {
        int ia = 0;
        int ib = 0;
        int nza = 0;
        int nzb = 0;
        while (true) {
            int bias;
            nzb = 0;
            nza = 0;
            char ca = NaturalOrderComparator.charAt(a, ia);
            char cb = NaturalOrderComparator.charAt(b, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = NaturalOrderComparator.charAt(a, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = NaturalOrderComparator.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (bias = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return bias;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return NaturalOrderComparator.compareEqual(a, b, nza, nzb);
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }

    static boolean isDigit(char c) {
        return Character.isDigit(c) || c == '.' || c == ',';
    }

    static char charAt(String s, int i) {
        return i >= s.length() ? (char)'\u0000' : s.charAt(i);
    }

    static int compareEqual(String a, String b, int nza, int nzb) {
        if (nza - nzb != 0) {
            return nza - nzb;
        }
        if (a.length() == b.length()) {
            return a.compareTo(b);
        }
        return a.length() - b.length();
    }
}

