/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.settings;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

@JsonDeserialize(builder=FhirSettingsPOJOBuilder.class)
public class FhirSettingsPOJO {
    protected static final String TX_SERVER_PROD = "http://tx.fhir.org";
    protected static final String TX_SERVER_DEV = "http://tx-dev.fhir.org";
    protected static final String TX_SERVER_LOCAL = "http://local.fhir.org";
    private String fhirDirectory;
    private Map<String, String> apiKeys;
    private String npmPath;
    private String rubyPath;
    private String gemPath;
    private String fhirTestCasesPath;
    private String diffToolPath;
    private String tempPath;
    private String testIgsPath;
    private Boolean prohibitNetworkAccess;
    private String txFhirProduction;
    private String txFhirDevelopment;
    private String txFhirLocal;
    private Boolean ignoreDefaultPackageServers;
    private List<ServerDetailsPOJO> servers;
    private List<String> certificateSources;

    protected FhirSettingsPOJO() {
        this.apiKeys = null;
        this.npmPath = null;
        this.rubyPath = null;
        this.gemPath = null;
        this.fhirTestCasesPath = null;
        this.diffToolPath = null;
        this.tempPath = null;
        this.testIgsPath = null;
        this.txFhirProduction = TX_SERVER_PROD;
        this.txFhirDevelopment = TX_SERVER_DEV;
        this.txFhirLocal = TX_SERVER_LOCAL;
        this.servers = new ArrayList<ServerDetailsPOJO>();
        this.certificateSources = new ArrayList<String>();
    }

    public static FhirSettingsPOJOBuilder builder() {
        return new FhirSettingsPOJOBuilder();
    }

    public String getFhirDirectory() {
        return this.fhirDirectory;
    }

    public Map<String, String> getApiKeys() {
        return this.apiKeys;
    }

    public String getNpmPath() {
        return this.npmPath;
    }

    public String getRubyPath() {
        return this.rubyPath;
    }

    public String getGemPath() {
        return this.gemPath;
    }

    public String getFhirTestCasesPath() {
        return this.fhirTestCasesPath;
    }

    public String getDiffToolPath() {
        return this.diffToolPath;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public String getTestIgsPath() {
        return this.testIgsPath;
    }

    public Boolean getProhibitNetworkAccess() {
        return this.prohibitNetworkAccess;
    }

    public String getTxFhirProduction() {
        return this.txFhirProduction;
    }

    public String getTxFhirDevelopment() {
        return this.txFhirDevelopment;
    }

    public String getTxFhirLocal() {
        return this.txFhirLocal;
    }

    public Boolean getIgnoreDefaultPackageServers() {
        return this.ignoreDefaultPackageServers;
    }

    public List<ServerDetailsPOJO> getServers() {
        return this.servers;
    }

    public List<String> getCertificateSources() {
        return this.certificateSources;
    }

    public void setFhirDirectory(String fhirDirectory) {
        this.fhirDirectory = fhirDirectory;
    }

    public void setApiKeys(Map<String, String> apiKeys) {
        this.apiKeys = apiKeys;
    }

    public void setNpmPath(String npmPath) {
        this.npmPath = npmPath;
    }

    public void setRubyPath(String rubyPath) {
        this.rubyPath = rubyPath;
    }

    public void setGemPath(String gemPath) {
        this.gemPath = gemPath;
    }

    public void setFhirTestCasesPath(String fhirTestCasesPath) {
        this.fhirTestCasesPath = fhirTestCasesPath;
    }

    public void setDiffToolPath(String diffToolPath) {
        this.diffToolPath = diffToolPath;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }

    public void setTestIgsPath(String testIgsPath) {
        this.testIgsPath = testIgsPath;
    }

    public void setProhibitNetworkAccess(Boolean prohibitNetworkAccess) {
        this.prohibitNetworkAccess = prohibitNetworkAccess;
    }

    public void setTxFhirProduction(String txFhirProduction) {
        this.txFhirProduction = txFhirProduction;
    }

    public void setTxFhirDevelopment(String txFhirDevelopment) {
        this.txFhirDevelopment = txFhirDevelopment;
    }

    public void setTxFhirLocal(String txFhirLocal) {
        this.txFhirLocal = txFhirLocal;
    }

    public void setIgnoreDefaultPackageServers(Boolean ignoreDefaultPackageServers) {
        this.ignoreDefaultPackageServers = ignoreDefaultPackageServers;
    }

    public void setServers(List<ServerDetailsPOJO> servers) {
        this.servers = servers;
    }

    public void setCertificateSources(List<String> certificateSources) {
        this.certificateSources = certificateSources;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FhirSettingsPOJO)) {
            return false;
        }
        FhirSettingsPOJO other = (FhirSettingsPOJO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$prohibitNetworkAccess = this.getProhibitNetworkAccess();
        Boolean other$prohibitNetworkAccess = other.getProhibitNetworkAccess();
        if (this$prohibitNetworkAccess == null ? other$prohibitNetworkAccess != null : !((Object)this$prohibitNetworkAccess).equals(other$prohibitNetworkAccess)) {
            return false;
        }
        Boolean this$ignoreDefaultPackageServers = this.getIgnoreDefaultPackageServers();
        Boolean other$ignoreDefaultPackageServers = other.getIgnoreDefaultPackageServers();
        if (this$ignoreDefaultPackageServers == null ? other$ignoreDefaultPackageServers != null : !((Object)this$ignoreDefaultPackageServers).equals(other$ignoreDefaultPackageServers)) {
            return false;
        }
        String this$fhirDirectory = this.getFhirDirectory();
        String other$fhirDirectory = other.getFhirDirectory();
        if (this$fhirDirectory == null ? other$fhirDirectory != null : !this$fhirDirectory.equals(other$fhirDirectory)) {
            return false;
        }
        Map<String, String> this$apiKeys = this.getApiKeys();
        Map<String, String> other$apiKeys = other.getApiKeys();
        if (this$apiKeys == null ? other$apiKeys != null : !((Object)this$apiKeys).equals(other$apiKeys)) {
            return false;
        }
        String this$npmPath = this.getNpmPath();
        String other$npmPath = other.getNpmPath();
        if (this$npmPath == null ? other$npmPath != null : !this$npmPath.equals(other$npmPath)) {
            return false;
        }
        String this$rubyPath = this.getRubyPath();
        String other$rubyPath = other.getRubyPath();
        if (this$rubyPath == null ? other$rubyPath != null : !this$rubyPath.equals(other$rubyPath)) {
            return false;
        }
        String this$gemPath = this.getGemPath();
        String other$gemPath = other.getGemPath();
        if (this$gemPath == null ? other$gemPath != null : !this$gemPath.equals(other$gemPath)) {
            return false;
        }
        String this$fhirTestCasesPath = this.getFhirTestCasesPath();
        String other$fhirTestCasesPath = other.getFhirTestCasesPath();
        if (this$fhirTestCasesPath == null ? other$fhirTestCasesPath != null : !this$fhirTestCasesPath.equals(other$fhirTestCasesPath)) {
            return false;
        }
        String this$diffToolPath = this.getDiffToolPath();
        String other$diffToolPath = other.getDiffToolPath();
        if (this$diffToolPath == null ? other$diffToolPath != null : !this$diffToolPath.equals(other$diffToolPath)) {
            return false;
        }
        String this$tempPath = this.getTempPath();
        String other$tempPath = other.getTempPath();
        if (this$tempPath == null ? other$tempPath != null : !this$tempPath.equals(other$tempPath)) {
            return false;
        }
        String this$testIgsPath = this.getTestIgsPath();
        String other$testIgsPath = other.getTestIgsPath();
        if (this$testIgsPath == null ? other$testIgsPath != null : !this$testIgsPath.equals(other$testIgsPath)) {
            return false;
        }
        String this$txFhirProduction = this.getTxFhirProduction();
        String other$txFhirProduction = other.getTxFhirProduction();
        if (this$txFhirProduction == null ? other$txFhirProduction != null : !this$txFhirProduction.equals(other$txFhirProduction)) {
            return false;
        }
        String this$txFhirDevelopment = this.getTxFhirDevelopment();
        String other$txFhirDevelopment = other.getTxFhirDevelopment();
        if (this$txFhirDevelopment == null ? other$txFhirDevelopment != null : !this$txFhirDevelopment.equals(other$txFhirDevelopment)) {
            return false;
        }
        String this$txFhirLocal = this.getTxFhirLocal();
        String other$txFhirLocal = other.getTxFhirLocal();
        if (this$txFhirLocal == null ? other$txFhirLocal != null : !this$txFhirLocal.equals(other$txFhirLocal)) {
            return false;
        }
        List<ServerDetailsPOJO> this$servers = this.getServers();
        List<ServerDetailsPOJO> other$servers = other.getServers();
        if (this$servers == null ? other$servers != null : !((Object)this$servers).equals(other$servers)) {
            return false;
        }
        List<String> this$certificateSources = this.getCertificateSources();
        List<String> other$certificateSources = other.getCertificateSources();
        return !(this$certificateSources == null ? other$certificateSources != null : !((Object)this$certificateSources).equals(other$certificateSources));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FhirSettingsPOJO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $prohibitNetworkAccess = this.getProhibitNetworkAccess();
        result = result * 59 + ($prohibitNetworkAccess == null ? 43 : ((Object)$prohibitNetworkAccess).hashCode());
        Boolean $ignoreDefaultPackageServers = this.getIgnoreDefaultPackageServers();
        result = result * 59 + ($ignoreDefaultPackageServers == null ? 43 : ((Object)$ignoreDefaultPackageServers).hashCode());
        String $fhirDirectory = this.getFhirDirectory();
        result = result * 59 + ($fhirDirectory == null ? 43 : $fhirDirectory.hashCode());
        Map<String, String> $apiKeys = this.getApiKeys();
        result = result * 59 + ($apiKeys == null ? 43 : ((Object)$apiKeys).hashCode());
        String $npmPath = this.getNpmPath();
        result = result * 59 + ($npmPath == null ? 43 : $npmPath.hashCode());
        String $rubyPath = this.getRubyPath();
        result = result * 59 + ($rubyPath == null ? 43 : $rubyPath.hashCode());
        String $gemPath = this.getGemPath();
        result = result * 59 + ($gemPath == null ? 43 : $gemPath.hashCode());
        String $fhirTestCasesPath = this.getFhirTestCasesPath();
        result = result * 59 + ($fhirTestCasesPath == null ? 43 : $fhirTestCasesPath.hashCode());
        String $diffToolPath = this.getDiffToolPath();
        result = result * 59 + ($diffToolPath == null ? 43 : $diffToolPath.hashCode());
        String $tempPath = this.getTempPath();
        result = result * 59 + ($tempPath == null ? 43 : $tempPath.hashCode());
        String $testIgsPath = this.getTestIgsPath();
        result = result * 59 + ($testIgsPath == null ? 43 : $testIgsPath.hashCode());
        String $txFhirProduction = this.getTxFhirProduction();
        result = result * 59 + ($txFhirProduction == null ? 43 : $txFhirProduction.hashCode());
        String $txFhirDevelopment = this.getTxFhirDevelopment();
        result = result * 59 + ($txFhirDevelopment == null ? 43 : $txFhirDevelopment.hashCode());
        String $txFhirLocal = this.getTxFhirLocal();
        result = result * 59 + ($txFhirLocal == null ? 43 : $txFhirLocal.hashCode());
        List<ServerDetailsPOJO> $servers = this.getServers();
        result = result * 59 + ($servers == null ? 43 : ((Object)$servers).hashCode());
        List<String> $certificateSources = this.getCertificateSources();
        result = result * 59 + ($certificateSources == null ? 43 : ((Object)$certificateSources).hashCode());
        return result;
    }

    public String toString() {
        return "FhirSettingsPOJO(fhirDirectory=" + this.getFhirDirectory() + ", apiKeys=" + String.valueOf(this.getApiKeys()) + ", npmPath=" + this.getNpmPath() + ", rubyPath=" + this.getRubyPath() + ", gemPath=" + this.getGemPath() + ", fhirTestCasesPath=" + this.getFhirTestCasesPath() + ", diffToolPath=" + this.getDiffToolPath() + ", tempPath=" + this.getTempPath() + ", testIgsPath=" + this.getTestIgsPath() + ", prohibitNetworkAccess=" + this.getProhibitNetworkAccess() + ", txFhirProduction=" + this.getTxFhirProduction() + ", txFhirDevelopment=" + this.getTxFhirDevelopment() + ", txFhirLocal=" + this.getTxFhirLocal() + ", ignoreDefaultPackageServers=" + this.getIgnoreDefaultPackageServers() + ", servers=" + String.valueOf(this.getServers()) + ", certificateSources=" + String.valueOf(this.getCertificateSources()) + ")";
    }

    public FhirSettingsPOJO(String fhirDirectory, Map<String, String> apiKeys, String npmPath, String rubyPath, String gemPath, String fhirTestCasesPath, String diffToolPath, String tempPath, String testIgsPath, Boolean prohibitNetworkAccess, String txFhirProduction, String txFhirDevelopment, String txFhirLocal, Boolean ignoreDefaultPackageServers, List<ServerDetailsPOJO> servers, List<String> certificateSources) {
        this.fhirDirectory = fhirDirectory;
        this.apiKeys = apiKeys;
        this.npmPath = npmPath;
        this.rubyPath = rubyPath;
        this.gemPath = gemPath;
        this.fhirTestCasesPath = fhirTestCasesPath;
        this.diffToolPath = diffToolPath;
        this.tempPath = tempPath;
        this.testIgsPath = testIgsPath;
        this.prohibitNetworkAccess = prohibitNetworkAccess;
        this.txFhirProduction = txFhirProduction;
        this.txFhirDevelopment = txFhirDevelopment;
        this.txFhirLocal = txFhirLocal;
        this.ignoreDefaultPackageServers = ignoreDefaultPackageServers;
        this.servers = servers;
        this.certificateSources = certificateSources;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class FhirSettingsPOJOBuilder {
        private String fhirDirectory;
        private Map<String, String> apiKeys;
        private String npmPath;
        private String rubyPath;
        private String gemPath;
        private String fhirTestCasesPath;
        private String diffToolPath;
        private String tempPath;
        private String testIgsPath;
        private Boolean prohibitNetworkAccess;
        private String txFhirProduction;
        private String txFhirDevelopment;
        private String txFhirLocal;
        private Boolean ignoreDefaultPackageServers;
        private List<ServerDetailsPOJO> servers;
        private List<String> certificateSources;

        FhirSettingsPOJOBuilder() {
        }

        public FhirSettingsPOJOBuilder fhirDirectory(String fhirDirectory) {
            this.fhirDirectory = fhirDirectory;
            return this;
        }

        public FhirSettingsPOJOBuilder apiKeys(Map<String, String> apiKeys) {
            this.apiKeys = apiKeys;
            return this;
        }

        public FhirSettingsPOJOBuilder npmPath(String npmPath) {
            this.npmPath = npmPath;
            return this;
        }

        public FhirSettingsPOJOBuilder rubyPath(String rubyPath) {
            this.rubyPath = rubyPath;
            return this;
        }

        public FhirSettingsPOJOBuilder gemPath(String gemPath) {
            this.gemPath = gemPath;
            return this;
        }

        public FhirSettingsPOJOBuilder fhirTestCasesPath(String fhirTestCasesPath) {
            this.fhirTestCasesPath = fhirTestCasesPath;
            return this;
        }

        public FhirSettingsPOJOBuilder diffToolPath(String diffToolPath) {
            this.diffToolPath = diffToolPath;
            return this;
        }

        public FhirSettingsPOJOBuilder tempPath(String tempPath) {
            this.tempPath = tempPath;
            return this;
        }

        public FhirSettingsPOJOBuilder testIgsPath(String testIgsPath) {
            this.testIgsPath = testIgsPath;
            return this;
        }

        public FhirSettingsPOJOBuilder prohibitNetworkAccess(Boolean prohibitNetworkAccess) {
            this.prohibitNetworkAccess = prohibitNetworkAccess;
            return this;
        }

        public FhirSettingsPOJOBuilder txFhirProduction(String txFhirProduction) {
            this.txFhirProduction = txFhirProduction;
            return this;
        }

        public FhirSettingsPOJOBuilder txFhirDevelopment(String txFhirDevelopment) {
            this.txFhirDevelopment = txFhirDevelopment;
            return this;
        }

        public FhirSettingsPOJOBuilder txFhirLocal(String txFhirLocal) {
            this.txFhirLocal = txFhirLocal;
            return this;
        }

        public FhirSettingsPOJOBuilder ignoreDefaultPackageServers(Boolean ignoreDefaultPackageServers) {
            this.ignoreDefaultPackageServers = ignoreDefaultPackageServers;
            return this;
        }

        public FhirSettingsPOJOBuilder servers(List<ServerDetailsPOJO> servers) {
            this.servers = servers;
            return this;
        }

        public FhirSettingsPOJOBuilder certificateSources(List<String> certificateSources) {
            this.certificateSources = certificateSources;
            return this;
        }

        public FhirSettingsPOJO build() {
            return new FhirSettingsPOJO(this.fhirDirectory, this.apiKeys, this.npmPath, this.rubyPath, this.gemPath, this.fhirTestCasesPath, this.diffToolPath, this.tempPath, this.testIgsPath, this.prohibitNetworkAccess, this.txFhirProduction, this.txFhirDevelopment, this.txFhirLocal, this.ignoreDefaultPackageServers, this.servers, this.certificateSources);
        }

        public String toString() {
            return "FhirSettingsPOJO.FhirSettingsPOJOBuilder(fhirDirectory=" + this.fhirDirectory + ", apiKeys=" + String.valueOf(this.apiKeys) + ", npmPath=" + this.npmPath + ", rubyPath=" + this.rubyPath + ", gemPath=" + this.gemPath + ", fhirTestCasesPath=" + this.fhirTestCasesPath + ", diffToolPath=" + this.diffToolPath + ", tempPath=" + this.tempPath + ", testIgsPath=" + this.testIgsPath + ", prohibitNetworkAccess=" + this.prohibitNetworkAccess + ", txFhirProduction=" + this.txFhirProduction + ", txFhirDevelopment=" + this.txFhirDevelopment + ", txFhirLocal=" + this.txFhirLocal + ", ignoreDefaultPackageServers=" + this.ignoreDefaultPackageServers + ", servers=" + String.valueOf(this.servers) + ", certificateSources=" + String.valueOf(this.certificateSources) + ")";
        }
    }
}

