/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.UUIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.BasePackageCacheManager;
import org.hl7.fhir.utilities.npm.CIBuildClient;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManagerLocks;
import org.hl7.fhir.utilities.npm.IPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.utilities.npm.PackageClient;
import org.hl7.fhir.utilities.npm.PackageList;
import org.hl7.fhir.utilities.npm.PackageServer;
import org.hl7.fhir.utilities.settings.FhirSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemPackageCacheManager
extends BasePackageCacheManager
implements IPackageCacheManager {
    private static final Logger log = LoggerFactory.getLogger(FilesystemPackageCacheManager.class);
    private final FilesystemPackageCacheManagerLocks locks;
    private final FilesystemPackageCacheManagerLocks.LockParameters lockParameters;
    private static IPackageProvider packageProvider;
    public static final String PACKAGE_REGEX = "^[a-zA-Z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+$";
    public static final String PACKAGE_VERSION_REGEX = "^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+\\#[A-Za-z0-9\\-\\_\\$]+(\\.[A-Za-z0-9\\-\\_\\$]+)*$";
    public static final String PACKAGE_VERSION_REGEX_OPT = "^[A-Za-z][A-Za-z0-9\\_\\-]*(\\.[A-Za-z0-9\\_\\-]+)+(\\#[A-Za-z0-9\\-\\_]+(\\.[A-Za-z0-9\\-\\_]+)*)?$";
    private static final Logger ourLog;
    private static final String CACHE_VERSION = "3";
    private final CIBuildClient ciBuildClient;
    @Nonnull
    private final File cacheFolder;
    private final List<NpmPackage> temporaryPackages = new ArrayList<NpmPackage>();
    private boolean suppressErrors;
    private boolean minimalMemory;

    private FilesystemPackageCacheManager(@Nonnull File cacheFolder, @Nonnull List<PackageServer> packageServers, CIBuildClient ciBuildClient, @Nonnull FilesystemPackageCacheManagerLocks locks, @Nullable FilesystemPackageCacheManagerLocks.LockParameters lockParameters) throws IOException {
        super(packageServers);
        this.cacheFolder = cacheFolder;
        this.ciBuildClient = ciBuildClient;
        this.locks = locks;
        this.lockParameters = lockParameters;
        this.prepareCacheFolder();
    }

    protected void prepareCacheFolder() throws IOException {
        this.locks.getCacheLock().doWriteWithLock(() -> {
            if (!this.cacheFolder.exists()) {
                FileUtilities.createDirectory(this.cacheFolder.getAbsolutePath());
                this.createIniFile();
            } else {
                if (!this.iniFileExists()) {
                    this.createIniFile();
                }
                if (!this.isIniFileCurrentVersion()) {
                    this.clearCache();
                    this.createIniFile();
                }
                this.deleteOldTempDirectories();
                this.cleanUpCorruptPackages();
            }
            return null;
        });
    }

    protected void cleanUpCorruptPackages() throws IOException {
        for (File file : Objects.requireNonNull(this.cacheFolder.listFiles())) {
            if (!file.getName().endsWith(".lock") || !this.locks.getCacheLock().canLockFileBeHeldByThisProcess(file)) continue;
            String packageDirectoryName = file.getName().substring(0, file.getName().length() - 5);
            log.info("Detected potential incomplete package installed in cache: " + packageDirectoryName + ". Attempting to delete");
            File packageDirectory = ManagedFileAccess.file(Utilities.path(this.cacheFolder, packageDirectoryName));
            if (packageDirectory.exists()) {
                FileUtilities.clearDirectory(packageDirectory.getAbsolutePath(), new String[0]);
                packageDirectory.delete();
            }
            file.delete();
            log.info("Deleted potential incomplete package: " + packageDirectoryName);
        }
    }

    private boolean iniFileExists() throws IOException {
        String iniPath = this.getPackagesIniPath();
        File iniFile = ManagedFileAccess.file(iniPath);
        return iniFile.exists();
    }

    private boolean isIniFileCurrentVersion() throws IOException {
        String iniPath = this.getPackagesIniPath();
        IniFile ini = new IniFile(iniPath);
        String version = ini.getStringProperty("cache", "version");
        return CACHE_VERSION.equals(version);
    }

    private void deleteOldTempDirectories() throws IOException {
        for (File f : Objects.requireNonNull(this.cacheFolder.listFiles())) {
            if (!f.isDirectory() || !UUIDUtilities.isValidUUID(f.getName())) continue;
            FileUtilities.clearDirectory(f.getAbsolutePath(), new String[0]);
            f.delete();
        }
    }

    public String getFolder() {
        return this.cacheFolder.getAbsolutePath();
    }

    private NpmPackage loadPackageInfo(String path) throws IOException {
        return this.minimalMemory ? NpmPackage.fromFolderMinimal(path, false) : NpmPackage.fromFolder(path, false);
    }

    private void clearCache() throws IOException {
        for (File f : Objects.requireNonNull(this.cacheFolder.listFiles())) {
            if (f.isDirectory()) {
                FileUtilities.atomicDeleteDirectory(f.getAbsolutePath());
                continue;
            }
            if (f.getName().equals("packages.ini")) continue;
            FileUtils.forceDelete((File)f);
        }
    }

    private void createIniFile() throws IOException {
        IniFile ini = new IniFile(this.getPackagesIniPath());
        ini.setStringProperty("cache", "version", CACHE_VERSION, null);
        ini.save();
    }

    private String getPackagesIniPath() throws IOException {
        return Utilities.path(this.cacheFolder, "packages.ini");
    }

    private void checkValidVersionString(String version, String id) {
        if (Utilities.noString(version)) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - a version must be provided");
        }
        if (version.startsWith("file:")) {
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal in this context");
        }
        for (char ch : version.toCharArray()) {
            if (Character.isAlphabetic(ch) || Character.isDigit(ch) || Utilities.existsInList(ch, 46, 45, 36)) continue;
            throw new FHIRException("Cannot add package " + id + " to the package cache - the version '" + version + "' is illegal (ch '" + ch + "'");
        }
    }

    @Override
    protected BasePackageCacheManager.InputStreamWithSrc loadFromPackageServer(String id, String version) {
        BasePackageCacheManager.InputStreamWithSrc retVal = super.loadFromPackageServer(id, version);
        if (retVal != null) {
            return retVal;
        }
        retVal = super.loadFromPackageServer(id, VersionUtilities.getMajMin(version) + ".x");
        if (retVal != null) {
            return retVal;
        }
        return this.fetchTheOldWay(id, version);
    }

    public String getLatestVersion(String id) throws IOException {
        id = this.stripAlias(id);
        for (PackageServer nextPackageServer : this.getPackageServers()) {
            if (Utilities.existsInList(id, "hl7.fhir.pubpack", "hl7.terminology.r5") && "https://packages.fhir.org".equals(nextPackageServer.getUrl())) continue;
            PackageClient pc = new PackageClient(nextPackageServer);
            try {
                return pc.getLatestVersion(id);
            }
            catch (IOException e) {
                ourLog.info("Failed to determine latest version of package {} from server: {}", (Object)id, (Object)nextPackageServer.toString());
            }
        }
        try {
            return this.fetchVersionTheOldWay(id);
        }
        catch (Exception e) {
            ourLog.info("Failed to determine latest version of package {} from server: {}", (Object)id, (Object)"build.fhir.org");
            String version = this.getLatestVersionFromCache(id);
            if (version != null) {
                return version;
            }
            throw new FHIRException("Unable to find the last version for package " + id + ": no local copy, and no network access");
        }
    }

    public String getLatestVersionFromCache(String id) throws IOException {
        id = this.stripAlias(id);
        for (String f : Utilities.reverseSorted(this.cacheFolder.list())) {
            File cf = ManagedFileAccess.file(Utilities.path(this.cacheFolder, f));
            if (!cf.isDirectory() || !f.startsWith(id + "#")) continue;
            String ver = f.substring(f.indexOf("#") + 1);
            ourLog.info("Latest version of package {} found locally is {} - using that", (Object)id, (Object)ver);
            return ver;
        }
        return null;
    }

    private NpmPackage loadPackageFromFile(String id, String folder) throws IOException {
        File f = ManagedFileAccess.file(Utilities.path(folder, id));
        if (!f.exists()) {
            throw new FHIRException("Package '" + id + "  not found in folder " + folder);
        }
        if (!f.isDirectory()) {
            throw new FHIRException("File for '" + id + "  found in folder " + folder + ", not a folder");
        }
        File fp = ManagedFileAccess.file(Utilities.path(folder, id, "package", "package.json"));
        if (!fp.exists()) {
            throw new FHIRException("Package '" + id + "  found in folder " + folder + ", but does not contain a package.json file in /package");
        }
        return NpmPackage.fromFolder(f.getAbsolutePath());
    }

    public void clear() throws IOException {
        this.locks.getCacheLock().doWriteWithLock(() -> {
            this.clearCache();
            return null;
        });
    }

    public void removePackage(String id, String version) throws IOException {
        String sid = this.stripAlias(id);
        this.locks.getPackageLock(sid + "#" + version).doWriteWithLock(() -> {
            String f = Utilities.path(this.cacheFolder, sid + "#" + version);
            File ff = ManagedFileAccess.file(f);
            if (ff.exists()) {
                FileUtilities.atomicDeleteDirectory(f);
            }
            return null;
        }, this.lockParameters);
    }

    @Override
    public NpmPackage loadPackageFromCacheOnly(String id, @Nullable String version) throws IOException {
        NpmPackage foundPackage;
        id = this.stripAlias(id);
        if (!Utilities.noString(version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return p;
            }
            if (!p.name().equals(id) || !Utilities.noString(version)) continue;
            return p;
        }
        String foundPackageFolder = this.findPackageFolder(id, version);
        if (foundPackageFolder != null && (foundPackage = this.locks.getPackageLock(foundPackageFolder).doReadWithLock(() -> {
            String path = Utilities.path(this.cacheFolder, foundPackageFolder);
            File directory = ManagedFileAccess.file(path);
            if (!directory.exists()) {
                return null;
            }
            return this.loadPackageInfo(path);
        }, this.lockParameters)) != null) {
            if (foundPackage.isIndexed()) {
                return foundPackage;
            }
            return this.locks.getPackageLock(foundPackageFolder).doWriteWithLock(() -> {
                File directory = ManagedFileAccess.file(foundPackage.getPath());
                if (!directory.exists()) {
                    return null;
                }
                NpmPackage output = this.loadPackageInfo(foundPackage.getPath());
                if (output.isIndexed()) {
                    return output;
                }
                String path = Utilities.path(this.cacheFolder, foundPackageFolder);
                output.checkIndexed(path);
                return output;
            }, this.lockParameters);
        }
        if ("dev".equals(version)) {
            return this.loadPackageFromCacheOnly(id, "current");
        }
        return null;
    }

    private String findPackageFolder(String id, String version) throws IOException {
        String foundPackageFolder = null;
        String foundVersion = null;
        for (String currentPackageFolder : Utilities.reverseSorted(this.cacheFolder.list())) {
            String[] parts;
            File cf = ManagedFileAccess.file(Utilities.path(this.cacheFolder, currentPackageFolder));
            if (!cf.isDirectory()) continue;
            if (currentPackageFolder.equals(id + "#" + version) || Utilities.noString(version) && currentPackageFolder.startsWith(id + "#")) {
                return currentPackageFolder;
            }
            if (version == null || version.equals("current") || !version.endsWith(".x") && Utilities.charCount(version, '.') >= 2 || !currentPackageFolder.contains("#") || !(parts = currentPackageFolder.split("#"))[0].equals(id) || !VersionUtilities.isMajMinOrLaterPatch(foundVersion != null ? foundVersion : version, parts[1])) continue;
            foundVersion = parts[1];
            foundPackageFolder = currentPackageFolder;
        }
        return foundPackageFolder;
    }

    @Override
    public NpmPackage addPackageToCache(String id, String version, InputStream packageTgzInputStream, String sourceDesc) throws IOException {
        String sid = this.stripAlias(id);
        this.checkValidVersionString(version, sid);
        return this.locks.getPackageLock(sid + "#" + version).doWriteWithLock(() -> {
            NpmPackage npmPackage;
            String tempDir = Utilities.generateUniqueRandomUUIDPath(this.cacheFolder.getAbsolutePath());
            NpmPackage extractedNpm = NpmPackage.extractFromTgz(packageTgzInputStream, sourceDesc, tempDir, this.minimalMemory);
            log.info("");
            log.info("Installing " + sid + "#" + version);
            if (!(extractedNpm.name() == null || sid == null || sid.equalsIgnoreCase(extractedNpm.name()) || sid.equalsIgnoreCase(extractedNpm.name() + "." + VersionUtilities.getNameForVersion(extractedNpm.fhirVersion())) || this.suppressErrors || sid.equals("hl7.fhir.r5.core") || sid.equals("hl7.fhir.us.immds"))) {
                throw new IOException("Attempt to import a mis-identified package. Expected " + sid + ", got " + extractedNpm.name());
            }
            String packageRoot = Utilities.path(this.cacheFolder, sid + "#" + version);
            try {
                NpmPackage tempPackage;
                if (!sid.equals(extractedNpm.getNpm().asString("name")) || !version.equals(extractedNpm.getNpm().asString("version"))) {
                    if (!sid.equals(extractedNpm.getNpm().asString("name"))) {
                        extractedNpm.getNpm().add("original-name", extractedNpm.getNpm().asString("name"));
                        extractedNpm.getNpm().remove("name");
                        extractedNpm.getNpm().add("name", sid);
                    }
                    if (!version.equals(extractedNpm.getNpm().asString("version"))) {
                        extractedNpm.getNpm().add("original-version", extractedNpm.getNpm().asString("version"));
                        extractedNpm.getNpm().remove("version");
                        extractedNpm.getNpm().add("version", version);
                    }
                    FileUtilities.stringToFile(JsonParser.compose((JsonElement)extractedNpm.getNpm(), true), Utilities.path(tempDir, "package", "package.json"));
                }
                if ((tempPackage = this.loadPackageInfo(tempDir)) != null && !tempPackage.isIndexed()) {
                    tempPackage.checkIndexed(packageRoot);
                }
                if (!ManagedFileAccess.file(packageRoot).exists() || Utilities.existsInList(version, "current", "dev")) {
                    FileUtilities.createDirectory(packageRoot);
                    try {
                        FileUtilities.clearDirectory(packageRoot, new String[0]);
                    }
                    catch (Throwable t) {
                        log.info("Unable to clear directory: " + packageRoot + ": " + t.getMessage() + " - this may cause problems later");
                    }
                    FileUtilities.renameDirectory(tempDir, packageRoot);
                    npmPackage = this.loadPackageInfo(packageRoot);
                    log.info(" done.");
                } else {
                    FileUtilities.clearDirectory(tempDir, new String[0]);
                    ManagedFileAccess.file(tempDir).delete();
                }
                npmPackage = this.loadPackageInfo(packageRoot);
            }
            catch (Exception e) {
                try {
                    log.info("Clean up package " + packageRoot + " because installation failed: " + e.getMessage());
                    e.printStackTrace();
                    FileUtilities.clearDirectory(packageRoot, new String[0]);
                    ManagedFileAccess.file(packageRoot).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e;
            }
            return npmPackage;
        }, this.lockParameters);
    }

    @Override
    public String getPackageUrl(String packageId) throws IOException {
        String result = super.getPackageUrl(packageId = this.stripAlias(packageId));
        if (result == null) {
            result = this.ciBuildClient.getPackageUrl(packageId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFolder(String packagesFolder) throws IOException {
        assert (!this.minimalMemory);
        File[] files = ManagedFileAccess.file(packagesFolder).listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().endsWith(".tgz")) continue;
                try (FileInputStream fs = ManagedFileAccess.inStream(f);){
                    this.temporaryPackages.add(NpmPackage.fromPackage(fs));
                }
            }
        }
    }

    @Override
    public NpmPackage loadPackage(String id, String version) throws FHIRException, IOException {
        NpmPackage p;
        id = this.stripAlias(id);
        if (!Utilities.noString(version) && version.startsWith("file:")) {
            return this.loadPackageFromFile(id, version.substring(5));
        }
        if (version == null && id.contains("#")) {
            version = id.substring(id.indexOf("#") + 1);
            id = id.substring(0, id.indexOf("#"));
        }
        if (version == null) {
            try {
                version = this.getLatestVersion(id);
            }
            catch (Exception e) {
                version = null;
            }
        }
        if ((p = this.loadPackageFromCacheOnly(id, version)) != null) {
            if ("current".equals(version)) {
                p = this.nullIfNotCurrentPackage(id, p);
            }
            if (p != null) {
                return p;
            }
        }
        if ("dev".equals(version)) {
            p = this.loadPackageFromCacheOnly(id, "current");
            if ((p = this.nullIfNotCurrentPackage(id, p)) != null) {
                return p;
            }
            version = "current";
        }
        log.info("Installing " + id + "#" + (version == null ? "?" : version) + " to the package cache");
        log.info("  Fetching:");
        BasePackageCacheManager.InputStreamWithSrc source = Utilities.isAbsoluteUrl(version) ? this.fetchSourceFromUrlSpecific(version) : ("current".equals(version) || version != null && version.startsWith("current$") ? this.ciBuildClient.loadFromCIBuild(id, version.startsWith("current$") ? version.substring(8) : null) : this.loadFromPackageServer(id, version));
        if (source == null) {
            throw new FHIRException("Unable to find package " + id + "#" + version);
        }
        return this.addPackageToCache(id, source.version, source.stream, source.url);
    }

    private BasePackageCacheManager.InputStreamWithSrc fetchSourceFromUrlSpecific(String url) {
        return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(url, false), url, "current");
    }

    private InputStream fetchFromUrlSpecific(String source, boolean optional) throws FHIRException {
        try {
            HTTPResult res = ManagedWebAccess.get(Arrays.asList("web"), source);
            res.checkThrowException();
            return new ByteArrayInputStream(res.getContent());
        }
        catch (Exception e) {
            if (optional) {
                return null;
            }
            throw new FHIRException("Unable to fetch: " + e.getMessage(), e);
        }
    }

    @Override
    public String getPackageId(String canonicalUrl) throws IOException {
        String retVal = this.findCanonicalInLocalCache(canonicalUrl);
        if (retVal == null) {
            retVal = super.getPackageId(canonicalUrl);
        }
        if (retVal == null) {
            retVal = this.ciBuildClient.getPackageId(canonicalUrl);
        }
        return retVal;
    }

    public String findCanonicalInLocalCache(String canonicalUrl) {
        try {
            for (String pf : this.listPackages()) {
                JsonObject npm;
                if (!ManagedFileAccess.file(Utilities.path(this.cacheFolder, pf, "package", "package.json")).exists() || !canonicalUrl.equals((npm = JsonParser.parseObjectFromFile(Utilities.path(this.cacheFolder, pf, "package", "package.json"))).asString("canonical"))) continue;
                return npm.asString("name");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private NpmPackage nullIfNotCurrentPackage(String id, NpmPackage npmPackage) {
        try {
            return this.ciBuildClient.isCurrent(id, npmPackage) ? npmPackage : null;
        }
        catch (Exception e) {
            log.info("Unable to check package currency: " + id + ": " + id);
            return npmPackage;
        }
    }

    private BasePackageCacheManager.InputStreamWithSrc fetchTheOldWay(String id, String v) {
        PackageList pl;
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.ciBuildClient.getPackageUrl(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id + "#" + v);
        }
        if (url.contains("/ImplementationGuide/")) {
            url = url.substring(0, url.indexOf("/ImplementationGuide/"));
        }
        String pu = Utilities.pathURL(url, "package-list.json");
        try {
            pl = PackageList.fromUrl(pu);
        }
        catch (Exception e) {
            String pv = Utilities.pathURL(url, v, "package.tgz");
            try {
                return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(pv, false), pv, v);
            }
            catch (Exception e1) {
                throw new FHIRException("Error fetching package directly (" + pv + "), or fetching package list for " + id + " from " + pu + ": " + e1.getMessage(), e1);
            }
        }
        if (!id.equals(pl.pid())) {
            throw new FHIRException("Package ids do not match in " + pu + ": " + id + " vs " + pl.pid());
        }
        for (PackageList.PackageListEntry vo : pl.versions()) {
            if (!v.equals(vo.version())) continue;
            String u = Utilities.pathURL(vo.path(), "package.tgz");
            return new BasePackageCacheManager.InputStreamWithSrc(this.fetchFromUrlSpecific(u, true), u, v);
        }
        return null;
    }

    private String fetchVersionTheOldWay(String id) throws IOException {
        String url = this.getUrlForPackage(id);
        if (url == null) {
            try {
                url = this.ciBuildClient.getPackageUrl(id);
            }
            catch (Exception e) {
                url = null;
            }
        }
        if (url == null) {
            throw new FHIRException("Unable to resolve package id " + id);
        }
        PackageList pl = PackageList.fromUrl(Utilities.pathURL(url, "package-list.json"));
        if (!id.equals(pl.pid())) {
            throw new FHIRException("Package ids do not match in " + pl.source() + ": " + id + " vs " + pl.pid());
        }
        for (PackageList.PackageListEntry vo : pl.versions()) {
            if (!vo.current()) continue;
            return vo.version();
        }
        return null;
    }

    private String getUrlForPackage(String id) {
        if ("hl7.fhir.xver-extensions".equals(id)) {
            return "https://fhir.org/packages/hl7.fhir.xver-extensions";
        }
        return null;
    }

    public List<String> listPackages() {
        ArrayList<String> res = new ArrayList<String>();
        for (File f : this.cacheFolder.listFiles()) {
            if (!f.isDirectory() || !f.getName().contains("#")) continue;
            res.add(f.getName());
        }
        return res;
    }

    public boolean packageExists(String id, String ver) throws IOException {
        if (this.packageInstalled(id = this.stripAlias(id), ver)) {
            return true;
        }
        for (PackageServer s : this.getPackageServers()) {
            if (!new PackageClient(s).exists(id, ver)) continue;
            return true;
        }
        return false;
    }

    public boolean packageInstalled(String id, String version) {
        id = this.stripAlias(id);
        for (NpmPackage p : this.temporaryPackages) {
            if (p.name().equals(id) && ("current".equals(version) || "dev".equals(version) || p.version().equals(version))) {
                return true;
            }
            if (!p.name().equals(id) || !Utilities.noString(version)) continue;
            return true;
        }
        for (String f : Utilities.sorted(this.cacheFolder.list())) {
            if (!f.equals(id + "#" + version) && (!Utilities.noString(version) || !f.startsWith(id + "#"))) continue;
            return true;
        }
        if ("dev".equals(version)) {
            return this.packageInstalled(id, "current");
        }
        return false;
    }

    public boolean isSuppressErrors() {
        return this.suppressErrors;
    }

    public void setSuppressErrors(boolean suppressErrors) {
        this.suppressErrors = suppressErrors;
    }

    public static IPackageProvider getPackageProvider() {
        return packageProvider;
    }

    public static void setPackageProvider(IPackageProvider packageProvider) {
        FilesystemPackageCacheManager.packageProvider = packageProvider;
    }

    public CIBuildClient getCiBuildClient() {
        return this.ciBuildClient;
    }

    public void setMinimalMemory(boolean minimalMemory) {
        this.minimalMemory = minimalMemory;
    }

    public boolean isMinimalMemory() {
        return this.minimalMemory;
    }

    static {
        ourLog = LoggerFactory.getLogger(FilesystemPackageCacheManager.class);
    }

    public static interface CacheLockFunction<T> {
        public T get() throws IOException;
    }

    public static interface IPackageProvider {
        public boolean handlesPackage(String var1, String var2);

        public BasePackageCacheManager.InputStreamWithSrc provide(String var1, String var2) throws IOException;
    }

    public static class Builder {
        private final File cacheFolder;
        private final List<PackageServer> packageServers;
        private final CIBuildClient ciBuildClient;
        private final FilesystemPackageCacheManagerLocks.LockParameters lockParameters;

        public Builder() throws IOException {
            this.cacheFolder = this.getUserCacheFolder();
            this.packageServers = this.getPackageServersFromFHIRSettings();
            this.lockParameters = null;
            this.ciBuildClient = new CIBuildClient();
        }

        private Builder(File cacheFolder, List<PackageServer> packageServers, CIBuildClient ciBuildClient, FilesystemPackageCacheManagerLocks.LockParameters lockParameters) {
            this.cacheFolder = cacheFolder;
            this.packageServers = packageServers;
            this.ciBuildClient = ciBuildClient;
            this.lockParameters = lockParameters;
        }

        private File getUserCacheFolder() throws IOException {
            return ManagedFileAccess.file(Utilities.path(System.getProperty("user.home"), ".fhir", "packages"));
        }

        private List<PackageServer> getPackageServersFromFHIRSettings() {
            ArrayList<PackageServer> packageServers = new ArrayList<PackageServer>(this.getConfiguredServers());
            if (!this.isIgnoreDefaultPackageServers()) {
                packageServers.addAll(this.getDefaultServers());
            }
            return packageServers;
        }

        protected boolean isIgnoreDefaultPackageServers() {
            return FhirSettings.isIgnoreDefaultPackageServers();
        }

        @Nonnull
        protected List<PackageServer> getDefaultServers() {
            return PackageServer.defaultServers();
        }

        protected List<PackageServer> getConfiguredServers() {
            return PackageServer.getConfiguredServers();
        }

        public Builder withCacheFolder(String cacheFolderPath) throws IOException {
            File cacheFolder = ManagedFileAccess.file(cacheFolderPath);
            if (!cacheFolder.exists()) {
                throw new FHIRException("The folder '" + String.valueOf(cacheFolder) + "' could not be found");
            }
            return new Builder(cacheFolder, this.packageServers, this.ciBuildClient, this.lockParameters);
        }

        public Builder withSystemCacheFolder() throws IOException {
            File systemCacheFolder = Utilities.isWindows() ? ManagedFileAccess.file(Utilities.path(System.getenv("ProgramData"), ".fhir", "packages")) : ManagedFileAccess.file(Utilities.path("/var", "lib", ".fhir", "packages"));
            return new Builder(systemCacheFolder, this.packageServers, this.ciBuildClient, this.lockParameters);
        }

        public Builder withTestingCacheFolder() throws IOException {
            return new Builder(ManagedFileAccess.file(Utilities.path("[tmp]", ".fhir", "packages")), this.packageServers, this.ciBuildClient, this.lockParameters);
        }

        public FilesystemPackageCacheManager build() throws IOException {
            FilesystemPackageCacheManagerLocks locks;
            try {
                locks = FilesystemPackageCacheManagerLocks.getFilesystemPackageCacheManagerLocks(this.cacheFolder);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            return new FilesystemPackageCacheManager(this.cacheFolder, this.packageServers, this.ciBuildClient, locks, this.lockParameters);
        }

        public File getCacheFolder() {
            return this.cacheFolder;
        }

        public Builder withPackageServers(List<PackageServer> packageServers) {
            return this.packageServers == packageServers ? this : new Builder(this.cacheFolder, packageServers, this.ciBuildClient, this.lockParameters);
        }

        public List<PackageServer> getPackageServers() {
            return this.packageServers;
        }

        public Builder withCiBuildClient(CIBuildClient ciBuildClient) {
            return this.ciBuildClient == ciBuildClient ? this : new Builder(this.cacheFolder, this.packageServers, ciBuildClient, this.lockParameters);
        }

        public CIBuildClient getCiBuildClient() {
            return this.ciBuildClient;
        }

        public Builder withLockParameters(FilesystemPackageCacheManagerLocks.LockParameters lockParameters) {
            return this.lockParameters == lockParameters ? this : new Builder(this.cacheFolder, this.packageServers, this.ciBuildClient, lockParameters);
        }

        public FilesystemPackageCacheManagerLocks.LockParameters getLockParameters() {
            return this.lockParameters;
        }
    }
}

