/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.StringPair;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.DirectoryVisitor;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.i18n.POObject;
import org.hl7.fhir.utilities.i18n.POSource;

public class POGenerator {
    private int noTrans = 0;

    public static void main(String[] args) throws IOException {
        new POGenerator().execute(args[0], args[1], args[2]);
    }

    public void execute(String core, String igpub, String pascal) throws IOException {
        String source = Utilities.path(core, "/org.hl7.fhir.utilities/src/main/resources");
        if (this.checkState(source, core, igpub, pascal)) {
            IniFile ini = new IniFile(Utilities.path(source, "translations-control.ini"));
            this.generate(source, "rendering-phrases.properties", "rendering-phrases-en.po", null, 2);
            this.generate(source, "Messages.properties", "validator-messages-en.po", null, 2);
            for (String name : ini.getProperties("languages").keySet()) {
                this.generate(source, "rendering-phrases.properties", "rendering-phrases-" + name + ".po", "rendering-phrases_" + name + ".properties", ini.getIntegerProperty("languages", name));
                this.generate(source, "Messages.properties", "validator-messages-" + name + ".po", "Messages_" + name + ".properties", ini.getIntegerProperty("languages", name));
            }
            System.out.println("Finished");
        }
    }

    private boolean checkState(String source, String core, String igpub, String pascal) throws IOException {
        System.out.println("Checking...");
        List<PropertyValue> props = this.loadProperties(Utilities.path(source, "rendering-phrases.properties"), true);
        List<ConstantDefinition> consts = this.loadConstants(Utilities.path(core, "/org.hl7.fhir.utilities/src/main/java/org/hl7/fhir/utilities/i18n/RenderingI18nContext.java"));
        boolean ok = true;
        for (ConstantDefinition cd : consts) {
            boolean found = false;
            for (PropertyValue p : props) {
                String pn = p.getBaseName();
                if (!pn.equals(cd.sname) && !p.getName().equals(cd.sname)) continue;
                found = true;
                p.used = true;
            }
            cd.defined = found;
        }
        this.scanJavaSource(core, consts, "RenderingI18nContext", "RenderingContext");
        this.scanJavaSource(igpub, consts, "RenderingI18nContext", "RenderingContext");
        this.scanPascalSource(pascal, props);
        HashSet<String> pns = new HashSet<String>();
        for (PropertyValue p : props) {
            if (!p.used) {
                ok = false;
                System.out.println("Error: PV " + p.getName() + " provided but not used");
            }
            if (!pns.contains(p.getName())) {
                pns.add(p.getName());
            } else {
                System.out.println("Error: PV " + p.getName() + " duplicated");
            }
            if (!p.getValue().contains("\\n")) continue;
            System.out.println("Error: PV " + p.getName() + " has a \\n");
        }
        for (ConstantDefinition cd : consts) {
            if (!cd.defined && !cd.used) {
                System.out.println("Error: " + cd.name + " not defined or used");
                ok = false;
                continue;
            }
            if (!cd.defined) {
                ok = false;
                System.out.println("Error: msg for " + cd.name + " not found at " + cd.sname);
                continue;
            }
            if (cd.used) continue;
            System.out.println("Warning: const " + cd.name + " not used");
        }
        props = this.loadProperties(Utilities.path(source, "Messages.properties"), true);
        consts = this.loadConstants(Utilities.path(core, "/org.hl7.fhir.utilities/src/main/java/org/hl7/fhir/utilities/i18n/I18nConstants.java"));
        for (ConstantDefinition cd : consts) {
            boolean found = false;
            for (PropertyValue p : props) {
                String pn = p.getBaseName();
                if (!pn.equals(cd.sname) && !p.getName().equals(cd.sname)) continue;
                found = true;
                p.used = true;
            }
            cd.defined = found;
        }
        this.scanJavaSource(core, consts, "I18nConstants");
        this.scanJavaSource(igpub, consts, "I18nConstants");
        this.scanPascalSource(pascal, props);
        pns = new HashSet();
        for (PropertyValue p : props) {
            if (!p.used) {
                ok = false;
                System.out.println("Error: PV " + p.getName() + " provided but not used");
            }
            if (!pns.contains(p.getName())) {
                pns.add(p.getName());
            } else {
                System.out.println("Error: PV " + p.getName() + " duplicated");
            }
            if (!p.getValue().contains("\\n")) continue;
            System.out.println("Error: PV " + p.getName() + " has a \\n");
        }
        for (ConstantDefinition cd : consts) {
            if (!cd.defined && !cd.used) {
                System.out.println("Error: " + cd.name + " not defined or used");
                ok = false;
                continue;
            }
            if (!cd.defined) {
                ok = false;
                System.out.println("Error: msg for " + cd.name + " not found @ " + cd.sname);
                continue;
            }
            if (cd.used) continue;
            System.out.println("Warning: const " + cd.name + " not used");
        }
        if (ok) {
            System.out.println("No Errors Found");
        } else {
            System.out.println("Errors Found, so not continuing");
        }
        return ok;
    }

    private void scanJavaSource(String path, List<ConstantDefinition> consts, String ... names) throws FileNotFoundException, IOException {
        JavaScanner scanner = new JavaScanner();
        scanner.consts = consts;
        scanner.names = new ArrayList<String>();
        for (String s : names) {
            scanner.names.add(s);
        }
        DirectoryVisitor.visitDirectory((DirectoryVisitor.IDirectoryVisitorImplementation)scanner, path, "java");
    }

    private void scanPascalSource(String path, List<PropertyValue> defs) throws FileNotFoundException, IOException {
        PascalScanner scanner = new PascalScanner();
        scanner.defs = defs;
        DirectoryVisitor.visitDirectory((DirectoryVisitor.IDirectoryVisitorImplementation)scanner, path, "pas");
    }

    private List<ConstantDefinition> loadConstants(String path) throws FileNotFoundException, IOException {
        ArrayList<ConstantDefinition> res = new ArrayList<ConstantDefinition>();
        for (String line : FileUtilities.fileToLines(path)) {
            int i;
            String[] p;
            if (!line.contains("public static final String") || line.trim().startsWith("//") || (p = line.substring(i = line.indexOf("public static final String") + "public static final String".length()).split("\\=")).length != 2) continue;
            String n = p[0].trim();
            String v = p[1].trim().replace("\"", "").replace(";", "");
            ConstantDefinition cd = new ConstantDefinition();
            cd.name = n;
            cd.sname = v;
            res.add(cd);
        }
        return res;
    }

    private void generate(String source, String src, String dest, String tgt, int count) throws IOException {
        Integer c;
        String fn = Utilities.path(source, "source", dest);
        POSource objects = ManagedFileAccess.file(fn).exists() ? POSource.loadPOFile(fn) : new POSource();
        List<PropertyValue> props = this.loadProperties(Utilities.path(source, src), false);
        for (PropertyValue e : props) {
            String name = e.getName();
            int mode = 0;
            if (name.endsWith("_one")) {
                mode = 1;
                name = name.substring(0, name.length() - 4);
            } else if (name.endsWith("_other")) {
                mode = 2;
                name = name.substring(0, name.length() - 6);
            }
            POObject o2 = this.findObject(objects.getEntries(), name);
            if (o2 == null) {
                if (mode > 1) {
                    throw new Error("Not right");
                }
                o2 = new POObject();
                o2.setId(name);
                o2.setComment(name);
                objects.getEntries().add(o2);
                o2.setMsgid(e.getValue());
                o2.setOrphan(false);
                continue;
            }
            this.update(o2, mode, e.getValue());
        }
        objects.getEntries().removeIf(o -> o.isOrphan());
        Collections.sort(objects.getEntries(), new POObjectSorter());
        HashMap<String, Integer> sources = new HashMap<String, Integer>();
        HashSet<String> dups = new HashSet<String>();
        for (POObject o3 : objects.getEntries()) {
            if (sources.containsKey(o3.getMsgid())) {
                c = (Integer)sources.get(o3.getMsgid()) + 1;
                sources.put(o3.getMsgid(), c);
                dups.add(o3.getMsgid());
                continue;
            }
            sources.put(o3.getMsgid(), 1);
        }
        for (POObject o4 : objects.getEntries()) {
            c = (Integer)sources.get(o4.getMsgid());
            if (c <= 1) continue;
            o4.setDuplicate(true);
        }
        this.noTrans = objects.savePOFile(Utilities.path(source, "source", dest), count, this.noTrans);
        if (tgt != null) {
            this.savePropFile(Utilities.path(source, tgt), objects.getEntries());
        }
    }

    private Set<String> listIds(List<POObject> objects, String msgid) {
        HashSet<String> res = new HashSet<String>();
        for (POObject o : objects) {
            if (!o.getMsgid().equals(msgid)) continue;
            res.add(o.getId());
        }
        return res;
    }

    private void update(POObject o, int mode, String value) {
        o.setOrphan(false);
        if (o.getComment() == null) {
            o.setComment(o.getId());
        }
        if (mode == 0) {
            if (!value.equals(o.getMsgid())) {
                if (o.getOldMsgId() != null && !o.getMsgstr().isEmpty()) {
                    o.setOldMsgId(o.getMsgid());
                }
                o.setMsgid(value);
                for (int i = 0; i < o.getMsgstr().size(); ++i) {
                    if (Utilities.noString(o.getMsgstr().get(i))) continue;
                    o.getMsgstr().set(i, "!!" + o.getMsgstr().get(i));
                }
            } else {
                o.setOldMsgId(null);
            }
        } else if (mode == 1) {
            if (!value.equals(o.getMsgid())) {
                if (o.getOldMsgId() != null && !o.getMsgstr().isEmpty()) {
                    o.setOldMsgId(o.getMsgid());
                }
                o.setMsgid(value);
                if (o.getMsgstr().size() > 0 && !Utilities.noString(o.getMsgstr().get(0))) {
                    o.getMsgstr().set(0, "!!" + o.getMsgstr().get(0));
                }
            } else {
                o.setOldMsgId(null);
            }
        } else if (mode == 2) {
            if (!value.equals(o.getMsgidPlural())) {
                o.setMsgidPlural(value);
                if (o.getMsgstr().size() > 1 && !Utilities.noString(o.getMsgstr().get(1))) {
                    o.getMsgstr().set(1, "!!" + o.getMsgstr().get(1));
                }
            } else {
                o.setOldMsgId(null);
            }
        }
    }

    private POObject findObject(List<POObject> objects, String name) {
        for (POObject t : objects) {
            if (t.getId() == null || !t.getId().equals(name)) continue;
            return t;
        }
        return null;
    }

    private List<PropertyValue> loadProperties(String source, boolean checking) throws IOException {
        ArrayList<PropertyValue> res = new ArrayList<PropertyValue>();
        File src = ManagedFileAccess.file(source);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), StandardCharsets.UTF_8));
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("#") && line.contains("=")) {
                String n = line.substring(0, line.indexOf("=")).trim();
                String v = line.substring(line.indexOf("=") + 1).trim();
                if (checking || v.length() != 3 || !v.startsWith("{") || !v.endsWith("}")) {
                    res.add(new PropertyValue(n, v));
                }
            }
            line = reader.readLine();
        }
        return res;
    }

    private void savePropFile(String tgt, List<POObject> objects) throws IOException {
        String nameLine = FileUtilities.fileToLines(tgt).get(0);
        String[] parts = nameLine.substring(1).trim().split("\\=");
        String[] names = parts[1].split("\\,");
        StringBuilder b = new StringBuilder();
        b.append(nameLine + "\r\n");
        for (POObject o : objects) {
            if (o.getMsgidPlural() == null) {
                String v = o.getMsgstr().size() > 0 ? o.getMsgstr().get(0) : "";
                if (Utilities.noString(v)) continue;
                b.append(o.getId() + " = " + v + "\r\n");
                continue;
            }
            for (int i = 0; i < names.length; ++i) {
                String v;
                String string = v = o.getMsgstr().size() > i ? o.getMsgstr().get(i) : "";
                if (Utilities.noString(v)) continue;
                b.append(o.getId() + "_" + names[i].trim() + " = " + v + "\r\n");
            }
        }
        FileUtilities.stringToFile(b.toString(), tgt);
    }

    public class ConstantDefinition {
        private String name;
        private String sname;
        private boolean defined;
        private boolean used;
    }

    public class PropertyValue
    extends StringPair {
        private boolean used;

        public PropertyValue(String name, String value) {
            super(name, value);
        }

        public String getBaseName() {
            String res = this.getName();
            if (res.endsWith("_one")) {
                res = res.substring(0, res.length() - 4);
            } else if (res.endsWith("_other")) {
                res = res.substring(0, res.length() - 6);
            }
            return res;
        }
    }

    private class JavaScanner
    implements DirectoryVisitor.IDirectoryVisitorImplementation {
        List<ConstantDefinition> consts;
        List<String> names;

        private JavaScanner() {
        }

        @Override
        public boolean enterDirectory(File f) throws IOException {
            return !Utilities.existsInList(f.getName(), "model", "formats");
        }

        @Override
        public boolean visitFile(File file) throws IOException {
            String source = FileUtilities.fileToString(file);
            for (ConstantDefinition cd : this.consts) {
                if (cd.used) continue;
                boolean found = false;
                for (String n : this.names) {
                    if (source.contains(n + "." + cd.name + ",")) {
                        found = true;
                    }
                    if (source.contains(n + "." + cd.name + ")")) {
                        found = true;
                    }
                    if (source.contains(n + "." + cd.name + " :")) {
                        found = true;
                    }
                    if (!source.contains(n + "." + cd.name + ";")) continue;
                    found = true;
                }
                if (!found) continue;
                cd.used = true;
            }
            return true;
        }
    }

    private class PascalScanner
    implements DirectoryVisitor.IDirectoryVisitorImplementation {
        private List<PropertyValue> defs;

        private PascalScanner() {
        }

        @Override
        public boolean enterDirectory(File directory) throws IOException {
            return true;
        }

        @Override
        public boolean visitFile(File file) throws IOException {
            String source = FileUtilities.fileToString(file);
            for (PropertyValue pv : this.defs) {
                if (pv.used) continue;
                boolean found = false;
                String pn = pv.getBaseName();
                if (source.contains("'" + pn + "'")) {
                    found = true;
                }
                if (!found) continue;
                pv.used = true;
            }
            return true;
        }
    }

    public class POObjectSorter
    implements Comparator<POObject> {
        @Override
        public int compare(POObject o1, POObject o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

