/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;

public class AcceptLanguageHeader {
    private String source;
    private List<LanguagePreference> langs = new ArrayList<LanguagePreference>();
    private boolean doWildcard;

    public String getSource() {
        return this.source;
    }

    public List<LanguagePreference> getLangs() {
        return this.langs;
    }

    public AcceptLanguageHeader(String source, boolean doWildcard) {
        this.doWildcard = doWildcard;
        this.source = source == null ? "" : source;
        this.process(source, this.langs, doWildcard);
    }

    private void process(String src, List<LanguagePreference> list, boolean doWildcard) {
        list.clear();
        boolean wildcard = false;
        int offset = this.langs.size();
        if (!Utilities.noString(src)) {
            String[] parts = src.split("\\,");
            for (int i = 0; i < parts.length; ++i) {
                String lang = parts[i].trim();
                double weight = 1.0;
                if (lang.contains(";")) {
                    String w = lang.substring(lang.indexOf(";") + 1);
                    if (w.contains("=")) {
                        w = w.substring(w.indexOf("=") + 1);
                    }
                    lang = lang.substring(0, lang.indexOf(";"));
                    weight = Float.valueOf(w).floatValue();
                }
                if (Utilities.noString(lang)) continue;
                list.add(new LanguagePreference(i + offset, lang, weight, false));
                wildcard = wildcard || "*".equals(lang);
            }
        }
        if (!wildcard && doWildcard) {
            list.add(new LanguagePreference(100, "*", 0.01, true));
        }
        Collections.sort(list, new LanguageSorter());
    }

    public boolean hasChosen() {
        for (LanguagePreference lang : this.langs) {
            if (lang.value != 1.0) continue;
            return true;
        }
        return false;
    }

    public String getChosen() {
        for (LanguagePreference lang : this.langs) {
            if (lang.value != 1.0) continue;
            return lang.lang;
        }
        return null;
    }

    public void add(String language) {
        ArrayList<LanguagePreference> list = new ArrayList<LanguagePreference>();
        this.process(language, list, false);
        for (LanguagePreference lang : list) {
            LanguagePreference existing = this.getByLang(this.langs, lang.lang);
            if (existing == null) {
                this.langs.add(lang);
                continue;
            }
            existing.auto = false;
            existing.value = lang.value;
        }
        Collections.sort(this.langs, new LanguageSorter());
        this.source = this.toString();
    }

    private LanguagePreference getByLang(List<LanguagePreference> list, String lang) {
        for (LanguagePreference l : list) {
            if (!l.lang.equals(lang)) continue;
            return l;
        }
        return null;
    }

    public AcceptLanguageHeader copy() {
        return new AcceptLanguageHeader(this.toString(), this.doWildcard);
    }

    public String toString() {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (LanguagePreference lang : this.langs) {
            if (lang.isAuto()) continue;
            b.append(lang.toString());
        }
        return b.toString();
    }

    public boolean matches(String dispLang) {
        for (LanguagePreference lp : this.langs) {
            if (!lp.matches(dispLang)) continue;
            return true;
        }
        return false;
    }

    public class LanguagePreference {
        private int order;
        private String lang;
        private double value;
        private boolean auto;

        public String getLang() {
            return this.lang;
        }

        public double getValue() {
            return this.value;
        }

        public int getOrder() {
            return this.order;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public LanguagePreference(int order, String lang, double value, boolean auto) {
            this.order = order;
            this.lang = lang;
            this.value = value;
            this.auto = auto;
        }

        public String toString() {
            if (this.value == 1.0) {
                return this.lang;
            }
            return this.lang + "; q=" + String.format("%.6f", this.value).replaceAll("(\\.\\d+?)0*$", "$1");
        }

        public boolean matches(String dispLang) {
            return this.lang != null && this.lang.equals(dispLang);
        }
    }

    public class LanguageSorter
    implements Comparator<LanguagePreference> {
        @Override
        public int compare(LanguagePreference o1, LanguagePreference o2) {
            if (o1.getValue() == o2.getValue()) {
                return o1.getOrder() - o2.getOrder();
            }
            if (o1.getValue() > o2.getValue()) {
                return -1;
            }
            return 1;
        }
    }
}

