/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.http.HTTPAuthenticationMode;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPHeaderUtil;
import org.hl7.fhir.utilities.http.HTTPRequest;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccessUtils;
import org.hl7.fhir.utilities.http.ManagedWebAccessorBase;
import org.hl7.fhir.utilities.http.okhttpimpl.LoggingInterceptor;
import org.hl7.fhir.utilities.http.okhttpimpl.ProxyAuthenticator;
import org.hl7.fhir.utilities.http.okhttpimpl.RetryInterceptor;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public class ManagedFhirWebAccessor
extends ManagedWebAccessorBase<ManagedFhirWebAccessor> {
    private static OkHttpClient okHttpClient;
    private long timeout = 5000L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private int retries;
    private ToolingClientLogger logger;
    private LoggingInterceptor loggingInterceptor;

    public ManagedFhirWebAccessor withTimeout(long timeout, TimeUnit timeoutUnit) {
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        return this;
    }

    public ManagedFhirWebAccessor withRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public ManagedFhirWebAccessor withLogger(ToolingClientLogger logger) {
        this.logger = logger;
        this.loggingInterceptor = new LoggingInterceptor(logger);
        return this;
    }

    public ManagedFhirWebAccessor(String userAgent, List<ServerDetailsPOJO> serverAuthDetails) {
        super(Arrays.asList("fhir"), userAgent, serverAuthDetails);
    }

    protected HTTPRequest httpRequestWithDefaultHeaders(HTTPRequest request) {
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        if (HTTPHeaderUtil.getSingleHeader(request.getHeaders(), "User-Agent") == null && this.getUserAgent() != null) {
            headers.add(new HTTPHeader("User-Agent", this.getUserAgent()));
        }
        request.getHeaders().forEach(headers::add);
        return request.withHeaders(headers);
    }

    protected HTTPRequest requestWithManagedHeaders(HTTPRequest httpRequest) {
        HTTPRequest requestWithDefaultHeaders = this.httpRequestWithDefaultHeaders(httpRequest);
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        requestWithDefaultHeaders.getHeaders().forEach(headers::add);
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            headers.add(new HTTPHeader(entry.getKey(), entry.getValue()));
        }
        if (this.getAuthenticationMode() != null) {
            if (this.getAuthenticationMode() != HTTPAuthenticationMode.NONE) {
                switch (this.getAuthenticationMode()) {
                    case BASIC: {
                        String basicCredential = Credentials.basic((String)this.getUsername(), (String)this.getPassword());
                        headers.add(new HTTPHeader("Authorization", basicCredential));
                        break;
                    }
                    case TOKEN: {
                        String tokenCredential = "Bearer " + this.getToken();
                        headers.add(new HTTPHeader("Authorization", tokenCredential));
                        break;
                    }
                    case APIKEY: {
                        String apiKeyCredential = this.getToken();
                        headers.add(new HTTPHeader("Api-Key", apiKeyCredential));
                    }
                }
            }
        } else {
            ServerDetailsPOJO settings = ManagedWebAccessUtils.getServer(this.getServerTypes(), httpRequest.getUrl().toString(), this.getServerAuthDetails());
            if (settings != null) {
                switch (settings.getAuthenticationType()) {
                    case "basic": {
                        String basicCredential = Credentials.basic((String)settings.getUsername(), (String)settings.getPassword());
                        headers.add(new HTTPHeader("Authorization", basicCredential));
                        break;
                    }
                    case "token": {
                        String tokenCredential = "Bearer " + settings.getToken();
                        headers.add(new HTTPHeader("Authorization", tokenCredential));
                        break;
                    }
                    case "apikey": {
                        String apiKeyCredential = settings.getApikey();
                        headers.add(new HTTPHeader("Api-Key", apiKeyCredential));
                    }
                }
            }
        }
        return httpRequest.withHeaders(headers);
    }

    public HTTPResult httpCall(HTTPRequest httpRequest) throws IOException {
        switch (ManagedWebAccess.getAccessPolicy()) {
            case DIRECT: {
                HTTPRequest httpRequestWithDirectHeaders = this.requestWithManagedHeaders(httpRequest);
                assert (httpRequestWithDirectHeaders.getUrl() != null);
                RequestBody body = httpRequestWithDirectHeaders.getBody() == null ? null : RequestBody.create((byte[])httpRequestWithDirectHeaders.getBody());
                Request.Builder requestBuilder = new Request.Builder().url(httpRequestWithDirectHeaders.getUrl()).method(httpRequestWithDirectHeaders.getMethod().name(), body);
                for (HTTPHeader header : httpRequestWithDirectHeaders.getHeaders()) {
                    requestBuilder.addHeader(header.getName(), header.getValue());
                }
                OkHttpClient okHttpClient = this.getOkHttpClient();
                if (!ManagedWebAccess.inAllowedPaths(httpRequestWithDirectHeaders.getUrl().toString())) {
                    throw new IOException("The pathname '" + httpRequestWithDirectHeaders.getUrl().toString() + "' cannot be accessed by policy");
                }
                Response response = okHttpClient.newCall(requestBuilder.build()).execute();
                return this.getHTTPResult(response);
            }
            case MANAGED: {
                HTTPRequest httpRequestWithManagedHeaders = this.requestWithManagedHeaders(httpRequest);
                assert (httpRequestWithManagedHeaders.getUrl() != null);
                return ManagedWebAccess.getFhirWebAccessor().httpCall(httpRequestWithManagedHeaders);
            }
            case PROHIBITED: {
                throw new IOException("Access to the internet is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    private HTTPResult getHTTPResult(Response execute) throws IOException {
        return new HTTPResult(execute.request().url().toString(), execute.code(), execute.message(), execute.header("Content-Type"), execute.body() != null && execute.body().contentLength() != 0L ? execute.body().bytes() : null, this.getHeadersFromResponse(execute));
    }

    private Iterable<HTTPHeader> getHeadersFromResponse(Response response) {
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        for (String name : response.headers().names()) {
            headers.add(new HTTPHeader(name, response.header(name)));
        }
        return headers;
    }

    private OkHttpClient getOkHttpClient() {
        if (okHttpClient == null) {
            okHttpClient = new OkHttpClient();
        }
        OkHttpClient.Builder builder = okHttpClient.newBuilder();
        if (this.logger != null) {
            builder.addInterceptor((Interceptor)this.loggingInterceptor);
        }
        builder.addInterceptor((Interceptor)new RetryInterceptor(this.retries));
        builder.proxyAuthenticator((Authenticator)new ProxyAuthenticator());
        return builder.connectTimeout(this.timeout, this.timeoutUnit).writeTimeout(this.timeout, this.timeoutUnit).readTimeout(this.timeout, this.timeoutUnit).build();
    }
}

