/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hl7.fhir.utilities.http.HTTPHeader;

public class HTTPRequest {
    @Nullable
    private final URL url;
    private final HttpMethod method;
    @Nullable
    private final byte[] body;
    @Nullable
    private final String contentType;
    @Nonnull
    private final Iterable<HTTPHeader> headers;

    public HTTPRequest() {
        this.url = null;
        this.method = HttpMethod.GET;
        this.body = null;
        this.contentType = null;
        this.headers = Collections.emptyList();
    }

    public HTTPRequest withUrl(URL url) {
        return new HTTPRequest(url, this.method, this.body, this.contentType, this.headers);
    }

    public HTTPRequest withUrl(String url) {
        try {
            return this.withUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    public HTTPRequest(@Nullable URL url, HttpMethod method, @Nullable byte[] body, @Nullable String contentType, @Nonnull Iterable<HTTPHeader> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.url = url;
        this.method = method;
        this.body = body;
        this.contentType = contentType;
        this.headers = headers;
    }

    @Nullable
    public URL getUrl() {
        return this.url;
    }

    public HTTPRequest withMethod(HttpMethod method) {
        return this.method == method ? this : new HTTPRequest(this.url, method, this.body, this.contentType, this.headers);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HTTPRequest withBody(@Nullable byte[] body) {
        return this.body == body ? this : new HTTPRequest(this.url, this.method, body, this.contentType, this.headers);
    }

    @Nullable
    public byte[] getBody() {
        return this.body;
    }

    public HTTPRequest withContentType(@Nullable String contentType) {
        return this.contentType == contentType ? this : new HTTPRequest(this.url, this.method, this.body, contentType, this.headers);
    }

    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    public HTTPRequest withHeaders(@Nonnull Iterable<HTTPHeader> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        return this.headers == headers ? this : new HTTPRequest(this.url, this.method, this.body, this.contentType, headers);
    }

    @Nonnull
    public Iterable<HTTPHeader> getHeaders() {
        return this.headers;
    }

    public static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD,
        PATCH;

    }
}

