/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.CSFile;

public class ManagedFileAccess {
    private static FileAccessPolicy accessPolicy = FileAccessPolicy.DIRECT;
    private static List<String> allowedPaths = new ArrayList<String>();
    private static IFileAccessor accessor;

    public static FileAccessPolicy getAccessPolicy() {
        return accessPolicy;
    }

    public static void setAccessPolicy(FileAccessPolicy accessPolicy) {
        ManagedFileAccess.accessPolicy = accessPolicy;
    }

    private static boolean inAllowedPaths(String pathname) {
        if (allowedPaths.isEmpty()) {
            return true;
        }
        for (String s : allowedPaths) {
            if (!pathname.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static File file(String pathname) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(pathname)) {
                    throw new IOException("The pathname '" + pathname + "' cannot be accessed by policy");
                }
                return new File(pathname);
            }
            case MANAGED: {
                return accessor.file(pathname);
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static File file(String path, String filepath) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(path)) {
                    throw new IOException("The path '" + path + "' cannot be accessed by policy");
                }
                return new File(path, filepath);
            }
            case MANAGED: {
                return accessor.file(Utilities.path(path, filepath));
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static File file(File root, String filepath) throws IOException {
        return ManagedFileAccess.file(root.getAbsolutePath(), filepath);
    }

    public static FileInputStream inStream(String pathname) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(pathname)) {
                    throw new IOException("The pathname '" + pathname + "' cannot be accessed by policy");
                }
                return new FileInputStream(pathname);
            }
            case MANAGED: {
                return accessor.inStream(pathname);
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static FileInputStream inStream(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public static FileOutputStream outStream(String pathname) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(pathname)) {
                    throw new IOException("The pathname '" + pathname + "' cannot be accessed by policy");
                }
                return new FileOutputStream(pathname);
            }
            case MANAGED: {
                return accessor.outStream(pathname);
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static FileOutputStream outStream(File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    public static CSFile csfile(String pathname) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(pathname)) {
                    throw new IOException("The pathname '" + pathname + "' cannot be accessed by policy");
                }
                return new CSFile(pathname);
            }
            case MANAGED: {
                return accessor.csfile(pathname);
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static File fromPath(Path path) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(path.toString())) {
                    throw new IOException("The pathname '" + path.toString() + "' cannot be accessed by policy");
                }
                return path.toFile();
            }
            case MANAGED: {
                return accessor.file(path.toString());
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static File[] listFiles(File f) throws IOException {
        switch (accessPolicy) {
            case DIRECT: {
                if (!ManagedFileAccess.inAllowedPaths(f.getAbsolutePath())) {
                    throw new IOException("The pathname '" + f.getAbsolutePath() + "' cannot be accessed by policy");
                }
                return f.listFiles();
            }
            case MANAGED: {
                return accessor.listFiles(f);
            }
            case PROHIBITED: {
                throw new IOException("Access to files is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public static enum FileAccessPolicy {
        DIRECT,
        MANAGED,
        PROHIBITED;

    }

    public static interface IFileAccessor {
        public File file(String var1) throws IOException;

        public FileInputStream inStream(String var1);

        public FileOutputStream outStream(String var1);

        public CSFile csfile(String var1);

        public File[] listFiles(File var1) throws IOException;
    }
}

