/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.hl7.fhir.utilities.MyURIResolver;
import org.hl7.fhir.utilities.ZipURIResolver;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.xml.XMLUtil;

public class XsltUtilities {
    public static byte[] saxonTransform(Map<String, byte[]> files, byte[] source, byte[] xslt) throws TransformerException {
        TransformerFactoryImpl f = new TransformerFactoryImpl();
        f.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        StreamSource xsrc = new StreamSource(new ByteArrayInputStream(xslt));
        f.setURIResolver(new ZipURIResolver(files));
        Transformer t = f.newTransformer(xsrc);
        t.setURIResolver(new ZipURIResolver(files));
        StreamSource src = new StreamSource(new ByteArrayInputStream(source));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(out);
        t.transform(src, res);
        return out.toByteArray();
    }

    public static byte[] transform(Map<String, byte[]> files, byte[] source, byte[] xslt) throws TransformerException {
        TransformerFactory f = XMLUtil.newXXEProtectedTransformerFactory();
        f.setAttribute("http://saxon.sf.net/feature/version-warning", Boolean.FALSE);
        StreamSource xsrc = new StreamSource(new ByteArrayInputStream(xslt));
        f.setURIResolver(new ZipURIResolver(files));
        Transformer t = f.newTransformer(xsrc);
        t.setURIResolver(new ZipURIResolver(files));
        StreamSource src = new StreamSource(new ByteArrayInputStream(source));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(out);
        t.transform(src, res);
        return out.toByteArray();
    }

    public static String saxonTransform(String source, String xslt) throws TransformerException, IOException {
        TransformerFactoryImpl f = new TransformerFactoryImpl();
        f.setAttribute("http://saxon.sf.net/feature/version-warning", (Object)Boolean.FALSE);
        StreamSource xsrc = new StreamSource(ManagedFileAccess.inStream(xslt));
        Transformer t = f.newTransformer((Source)xsrc);
        StreamSource src = new StreamSource(ManagedFileAccess.inStream(source));
        StreamResult res = new StreamResult(new ByteArrayOutputStream());
        t.transform(src, res);
        return res.getOutputStream().toString();
    }

    public static void saxonTransform(String xsltDir, String source, String xslt, String dest, URIResolver alt) throws TransformerException, IOException {
        XsltUtilities.saxonTransform(xsltDir, source, xslt, dest, alt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saxonTransform(String xsltDir, String source, String xslt, String dest, URIResolver alt, Map<String, String> params) throws TransformerException, IOException {
        TransformerFactoryImpl f = new TransformerFactoryImpl();
        f.setAttribute("http://saxon.sf.net/feature/version-warning", (Object)Boolean.FALSE);
        StreamSource xsrc = new StreamSource(ManagedFileAccess.inStream(xslt));
        f.setURIResolver((URIResolver)new MyURIResolver(xsltDir, alt));
        Transformer t = f.newTransformer((Source)xsrc);
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                t.setParameter(entry.getKey(), entry.getValue());
            }
        }
        t.setURIResolver(new MyURIResolver(xsltDir, alt));
        FileInputStream fso = ManagedFileAccess.inStream(source);
        FileOutputStream fsr = ManagedFileAccess.outStream(dest);
        try {
            StreamSource src = new StreamSource(fso);
            StreamResult res = new StreamResult(fsr);
            t.transform(src, res);
        }
        finally {
            fso.close();
            fsr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(String xsltDir, String source, String xslt, String dest, URIResolver alt) throws TransformerException, IOException {
        TransformerFactory f = XMLUtil.newXXEProtectedTransformerFactory();
        StreamSource xsrc = new StreamSource(ManagedFileAccess.inStream(xslt));
        f.setURIResolver(new MyURIResolver(xsltDir, alt));
        Transformer t = f.newTransformer(xsrc);
        t.setURIResolver(new MyURIResolver(xsltDir, alt));
        FileInputStream fss = ManagedFileAccess.inStream(source);
        FileOutputStream fsr = ManagedFileAccess.outStream(dest);
        try {
            StreamSource src = new StreamSource(fss);
            StreamResult res = new StreamResult(fsr);
            t.transform(src, res);
        }
        finally {
            fss.close();
            fsr.close();
        }
    }
}

