/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Inflector;
import org.hl7.fhir.utilities.PathBuilder;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.settings.FhirSettings;

public class Utilities {
    static final String C_TEMP_DIR = "c:\\temp";
    public static final int ONE_MB = 1024;
    public static final String GB = "Gb";
    public static final String MB = "Mb";
    public static final String KB = "Kb";
    public static final String BT = "b";
    static final int[] illegalChars = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};

    public static String pluralizeMe(String word) {
        Inflector inf = new Inflector();
        return inf.pluralize(word);
    }

    public static String pluralize(String word, int count) {
        if (count == 1) {
            return word;
        }
        Inflector inf = new Inflector();
        return inf.pluralize(word);
    }

    public static String singularise(String word) {
        Inflector inf = new Inflector();
        return inf.singularize(word);
    }

    public static boolean isInteger(String string) {
        String value;
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        String string2 = value = string.startsWith("-") ? string.substring(1) : string;
        if (Utilities.noString(value)) {
            return false;
        }
        for (char next : value.toCharArray()) {
            if (Character.isDigit(next)) continue;
            return false;
        }
        if (value.length() > 10) {
            return false;
        }
        return !(string.startsWith("-") ? value.length() == 10 && string.compareTo("2147483648") > 0 : value.length() == 10 && string.compareTo("2147483647") > 0);
    }

    public static boolean isLong(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        String value = string.startsWith("-") ? string.substring(1) : string;
        for (char next : value.toCharArray()) {
            if (Character.isDigit(next)) continue;
            return false;
        }
        if (value.length() > 20) {
            return false;
        }
        return !(string.startsWith("-") ? value.length() == 20 && string.compareTo("9223372036854775808") > 0 : value.length() == 20 && string.compareTo("9223372036854775807") > 0);
    }

    public static boolean isHex(String string) {
        try {
            int i = Integer.parseInt(string, 16);
            return i != i + 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidId(String id) {
        return id.matches("[A-Za-z0-9\\-\\.]{1,64}");
    }

    public static boolean isDecimal(String value, boolean allowExponent, boolean allowLeadingZero) {
        DecimalStatus ds = Utilities.checkDecimal(value, allowExponent, true);
        return ds == DecimalStatus.OK || ds == DecimalStatus.RANGE;
    }

    public static boolean isDecimal(String value, boolean allowExponent) {
        DecimalStatus ds = Utilities.checkDecimal(value, allowExponent, false);
        return ds == DecimalStatus.OK || ds == DecimalStatus.RANGE;
    }

    public static DecimalStatus checkDecimal(String value, boolean allowExponent, boolean allowLeadingZero) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return DecimalStatus.BLANK;
        }
        if (!allowLeadingZero) {
            if (value.startsWith("0") && !"0".equals(value) && !value.startsWith("0.")) {
                return DecimalStatus.SYNTAX;
            }
            if (value.startsWith("-0") && !"-0".equals(value) && !value.startsWith("-0.")) {
                return DecimalStatus.SYNTAX;
            }
            if (value.startsWith("+0") && !"+0".equals(value) && !value.startsWith("+0.")) {
                return DecimalStatus.SYNTAX;
            }
        }
        if (value.endsWith(".")) {
            return DecimalStatus.SYNTAX;
        }
        boolean havePeriod = false;
        boolean haveExponent = false;
        boolean haveSign = false;
        boolean haveDigits = false;
        int preDecLength = 0;
        int postDecLength = 0;
        int exponentLength = 0;
        int length = 0;
        for (char next : value.toCharArray()) {
            if (next == '.') {
                if (!haveDigits || havePeriod || haveExponent) {
                    return DecimalStatus.SYNTAX;
                }
                havePeriod = true;
                preDecLength = length;
                length = 0;
                continue;
            }
            if (next == '-' || next == '+') {
                if (haveDigits || haveSign) {
                    return DecimalStatus.SYNTAX;
                }
                haveSign = true;
                continue;
            }
            if (next == 'e' || next == 'E') {
                if (!haveDigits || haveExponent || !allowExponent) {
                    return DecimalStatus.SYNTAX;
                }
                haveExponent = true;
                haveSign = false;
                haveDigits = false;
                if (havePeriod) {
                    postDecLength = length;
                } else {
                    preDecLength = length;
                }
                length = 0;
                continue;
            }
            if (!Character.isDigit(next)) {
                return DecimalStatus.SYNTAX;
            }
            haveDigits = true;
            ++length;
        }
        if (haveExponent && !haveDigits) {
            return DecimalStatus.SYNTAX;
        }
        if (haveExponent) {
            exponentLength = length;
        } else if (havePeriod) {
            postDecLength = length;
        } else {
            preDecLength = length;
        }
        if (exponentLength > 4) {
            return DecimalStatus.RANGE;
        }
        if (preDecLength + postDecLength > 18) {
            return DecimalStatus.RANGE;
        }
        return DecimalStatus.OK;
    }

    public static String camelCase(String value) {
        return new Inflector().camelCase(value.trim().replace(" ", "_"), false, new char[0]);
    }

    public static String upperCamelCase(String value) {
        return new Inflector().upperCamelCase(value.trim().replace(" ", "_"), new char[0]);
    }

    public static String escapeXml(String doco) {
        if (doco == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : doco.toCharArray()) {
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String escapeXmlText(String doco) {
        if (doco == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : doco.toCharArray()) {
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String titleize(String s) {
        StringBuilder b = new StringBuilder();
        boolean up = true;
        for (char c : s.toCharArray()) {
            if (up) {
                b.append(Character.toUpperCase(c));
            } else {
                b.append(c);
            }
            up = c == ' ';
        }
        return b.toString();
    }

    public static String capitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String asCSV(List<String> strings) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String n : strings) {
            if (!first) {
                s.append(",");
            }
            s.append(n);
            first = false;
        }
        return s.toString();
    }

    public static String asHtmlBr(String prefix, List<String> strings) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (String n : strings) {
            if (!first) {
                s.append("<br/>");
            }
            s.append(prefix);
            s.append(n);
            first = false;
        }
        return s.toString();
    }

    public static String generateUniqueRandomUUIDPath(String path) throws IOException {
        String randomUUIDPath = null;
        while (randomUUIDPath == null) {
            String uuid = UUID.randomUUID().toString().toLowerCase();
            String pathCandidate = Utilities.path(path, uuid);
            if (ManagedFileAccess.file(pathCandidate).exists()) continue;
            randomUUIDPath = pathCandidate;
        }
        return randomUUIDPath;
    }

    public static String cleanupTextString(String contents) {
        if (contents == null || contents.trim().equals("")) {
            return null;
        }
        return contents.trim();
    }

    public static boolean noString(String v) {
        return v == null || v.equals("");
    }

    public static String appendSlash(String definitions) {
        return definitions.endsWith(File.separator) ? definitions : definitions + File.separator;
    }

    public static String appendForwardSlash(String definitions) {
        if (definitions == null) {
            return "/";
        }
        return definitions.endsWith("/") ? definitions : definitions + "/";
    }

    public static String systemEol() {
        return System.getProperty("line.separator");
    }

    public static String normaliseEolns(String value) {
        return value.replace("\r\n", "\r").replace("\n", "\r").replace("\r", "\r\n");
    }

    public static String unescapeXml(String xml) throws FHIRException {
        if (xml == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < xml.length(); ++i) {
            if (xml.charAt(i) == '&') {
                StringBuilder e = new StringBuilder();
                ++i;
                while (xml.charAt(i) != ';') {
                    e.append(xml.charAt(i));
                    ++i;
                }
                if (e.toString().equals("lt")) {
                    b.append("<");
                    continue;
                }
                if (e.toString().equals("gt")) {
                    b.append(">");
                    continue;
                }
                if (e.toString().equals("amp")) {
                    b.append("&");
                    continue;
                }
                if (e.toString().equals("quot")) {
                    b.append("\"");
                    continue;
                }
                if (e.toString().equals("mu")) {
                    b.append('\u03bc');
                    continue;
                }
                throw new FHIRException("unknown XML entity \"" + e.toString() + "\"");
            }
            b.append(xml.charAt(i));
        }
        return b.toString();
    }

    public static String unescapeJson(String json) throws FHIRException {
        if (json == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < json.length(); ++i) {
            if (json.charAt(i) == '\\') {
                char ch = json.charAt(++i);
                switch (ch) {
                    case '\"': {
                        b.append('b');
                        break;
                    }
                    case '\\': {
                        b.append('\\');
                        break;
                    }
                    case '/': {
                        b.append('/');
                        break;
                    }
                    case 'b': {
                        b.append('\b');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case 'u': {
                        String hex = json.substring(i + 1, i + 5);
                        b.append(Character.toString(Integer.parseInt(hex, 16)));
                        break;
                    }
                    default: {
                        throw new FHIRException("Unknown JSON escape \\" + ch);
                    }
                }
                continue;
            }
            b.append(json.charAt(i));
        }
        return b.toString();
    }

    public static boolean isPlural(String word) {
        if ("restricts".equals(word = word.toLowerCase()) || "contains".equals(word) || "data".equals(word) || "specimen".equals(word) || "replaces".equals(word) || "addresses".equals(word) || "supplementalData".equals(word) || "instantiates".equals(word) || "imports".equals(word) || "covers".equals(word)) {
            return false;
        }
        Inflector inf = new Inflector();
        return !inf.singularize(word).equals(word);
    }

    public static String padRight(String src, char c, int len) {
        StringBuilder s = new StringBuilder();
        if (src != null) {
            s.append(src);
            for (int i = 0; i < len - src.length(); ++i) {
                s.append(c);
            }
        }
        return s.toString();
    }

    public static String padRight(int num, char c, int len) {
        return Utilities.padRight(Integer.toString(num), c, len);
    }

    public static String padLeft(String src, char c, int len) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < len - src.length(); ++i) {
            s.append(c);
        }
        s.append(src);
        return s.toString();
    }

    public static String path(String ... args) throws IOException {
        return PathBuilder.getPathBuilder().buildPath(args);
    }

    public static File pathFile(String ... args) throws IOException {
        return ManagedFileAccess.file(PathBuilder.getPathBuilder().buildPath(args));
    }

    public static String path(File f, String ... args) throws IOException {
        String[] a = new String[args.length + 1];
        a[0] = f.getAbsolutePath();
        for (int i = 0; i < args.length; ++i) {
            a[i + 1] = args[i];
        }
        return PathBuilder.getPathBuilder().buildPath(a);
    }

    public static String forcePath(String ... args) throws IOException {
        String path = Utilities.path(args);
        String folder = FileUtilities.getDirectoryForFile(path);
        FileUtilities.createDirectory(folder);
        return path;
    }

    @Deprecated
    public static String uncheckedPath(String ... args) throws IOException {
        return PathBuilder.getPathBuilder().withRequireNonRootFirstEntry(false).withRequireNonNullNonEmptyFirstEntry(false).withRequirePathIsChildOfTarget(false).buildPath(args);
    }

    public static String pathURL(String ... args) {
        StringBuilder s = new StringBuilder();
        boolean d = false;
        for (String arg : args) {
            if (arg == null) continue;
            if (!d) {
                d = !Utilities.noString(arg);
            } else if (!(s.toString() == null || s.toString().endsWith("/") || arg.startsWith("/") || arg.startsWith("?") || arg.startsWith("&"))) {
                s.append("/");
            }
            s.append(arg);
        }
        return s.toString();
    }

    public static String nmtokenize(String cs) {
        if (cs == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') {
                s.append(c);
                continue;
            }
            if (c == ' ') continue;
            s.append("." + Integer.toString(c));
        }
        return s.toString();
    }

    public static String javaTokenize(String cs, boolean capFirst) {
        if (cs == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        boolean upcase = capFirst;
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') {
                if (upcase) {
                    s.append(Character.toUpperCase(c));
                    upcase = false;
                    continue;
                }
                s.append(c);
                continue;
            }
            upcase = true;
        }
        String res = s.toString();
        if (Utilities.isJavaReservedWord(res)) {
            return "_" + res;
        }
        return res;
    }

    public static boolean isJavaReservedWord(String word) {
        if (word.equals("abstract")) {
            return true;
        }
        if (word.equals("assert")) {
            return true;
        }
        if (word.equals("boolean")) {
            return true;
        }
        if (word.equals("break")) {
            return true;
        }
        if (word.equals("byte")) {
            return true;
        }
        if (word.equals("case")) {
            return true;
        }
        if (word.equals("catch")) {
            return true;
        }
        if (word.equals("char")) {
            return true;
        }
        if (word.equals("class")) {
            return true;
        }
        if (word.equals("const")) {
            return true;
        }
        if (word.equals("continue")) {
            return true;
        }
        if (word.equals("default")) {
            return true;
        }
        if (word.equals("double")) {
            return true;
        }
        if (word.equals("do")) {
            return true;
        }
        if (word.equals("else")) {
            return true;
        }
        if (word.equals("enum")) {
            return true;
        }
        if (word.equals("extends")) {
            return true;
        }
        if (word.equals("false")) {
            return true;
        }
        if (word.equals("final")) {
            return true;
        }
        if (word.equals("finally")) {
            return true;
        }
        if (word.equals("float")) {
            return true;
        }
        if (word.equals("for")) {
            return true;
        }
        if (word.equals("goto")) {
            return true;
        }
        if (word.equals("if")) {
            return true;
        }
        if (word.equals("implements")) {
            return true;
        }
        if (word.equals("import")) {
            return true;
        }
        if (word.equals("instanceof")) {
            return true;
        }
        if (word.equals("int")) {
            return true;
        }
        if (word.equals("interface")) {
            return true;
        }
        if (word.equals("long")) {
            return true;
        }
        if (word.equals("native")) {
            return true;
        }
        if (word.equals("new")) {
            return true;
        }
        if (word.equals("null")) {
            return true;
        }
        if (word.equals("package")) {
            return true;
        }
        if (word.equals("private")) {
            return true;
        }
        if (word.equals("protected")) {
            return true;
        }
        if (word.equals("public")) {
            return true;
        }
        if (word.equals("return")) {
            return true;
        }
        if (word.equals("short")) {
            return true;
        }
        if (word.equals("static")) {
            return true;
        }
        if (word.equals("strictfp")) {
            return true;
        }
        if (word.equals("super")) {
            return true;
        }
        if (word.equals("switch")) {
            return true;
        }
        if (word.equals("synchronized")) {
            return true;
        }
        if (word.equals("this")) {
            return true;
        }
        if (word.equals("throw")) {
            return true;
        }
        if (word.equals("throws")) {
            return true;
        }
        if (word.equals("transient")) {
            return true;
        }
        if (word.equals("true")) {
            return true;
        }
        if (word.equals("try")) {
            return true;
        }
        if (word.equals("void")) {
            return true;
        }
        if (word.equals("volatile")) {
            return true;
        }
        if (word.equals("while")) {
            return true;
        }
        return word.equals("Exception");
    }

    public static boolean isToken(String tail) {
        if (tail == null || tail.length() == 0) {
            return false;
        }
        boolean result = Utilities.isAlphabetic(tail.charAt(0));
        for (int i = 1; i < tail.length(); ++i) {
            result = result && (Utilities.isAlphabetic(tail.charAt(i)) || Utilities.isDigit(tail.charAt(i)) || tail.charAt(i) == '_' || tail.charAt(i) == '[' || tail.charAt(i) == ']');
        }
        return result;
    }

    public static boolean isTokenChar(char ch) {
        return Utilities.isAlphabetic(ch) || ch == '_';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isAlphabetic(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String appendPeriod(String s) {
        if (Utilities.noString(s)) {
            return s;
        }
        if ((s = s.trim()).endsWith(".") || s.endsWith("?")) {
            return s;
        }
        return s + ".";
    }

    public static String removePeriod(String s) {
        if (Utilities.noString(s)) {
            return s;
        }
        if (s.endsWith(".")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String stripBOM(String string) {
        return string == null ? null : string.replace("\ufeff", "");
    }

    public static String escapeJava(String doco) {
        if (doco == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : doco.toCharArray()) {
            if (c == '\r') {
                b.append("\\r");
                continue;
            }
            if (c == '\n') {
                b.append("\\n");
                continue;
            }
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String[] splitByCamelCase(String name) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (i > 0 && Character.isUpperCase(name.charAt(i))) {
                parts.add(b.toString());
                b = new StringBuilder();
            }
            b.append(Character.toLowerCase(name.charAt(i)));
        }
        parts.add(b.toString());
        return parts.toArray(new String[0]);
    }

    @Deprecated
    public static String encodeUri(String string) {
        return Utilities.encodeUriParam(string);
    }

    public static String encodeUriParam(String key, String value) {
        new BasicNameValuePair(key, value);
        return URLEncodedUtils.format(Collections.singletonList(new BasicNameValuePair(key, value)), (Charset)StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String encodeUriParam(String param) {
        String dummyEncode = Utilities.encodeUriParam("dummy", param);
        return dummyEncode.substring("dummy=".length());
    }

    public static String normalize(String s) {
        return Utilities.normalize(s, true);
    }

    public static String normalize(String s, boolean lower) {
        if (Utilities.noString(s)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        boolean isWhitespace = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Utilities.isWhitespace(c)) {
                b.append(lower ? Character.toLowerCase(c) : c);
                isWhitespace = false;
                continue;
            }
            if (isWhitespace) continue;
            if (c == '\r' || c == '\n') {
                b.append('\n');
            } else {
                b.append(' ');
            }
            isWhitespace = true;
        }
        return b.toString().trim();
    }

    public static String normalizeSameCase(String s) {
        if (Utilities.noString(s)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        boolean isWhitespace = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                b.append(c);
                isWhitespace = false;
                continue;
            }
            if (isWhitespace) continue;
            b.append(' ');
            isWhitespace = true;
        }
        return b.toString().trim();
    }

    public static String URLEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }

    public static String URLDecode(String ref) {
        try {
            return URLDecoder.decode(ref, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e.getMessage());
        }
    }

    public static boolean charInSet(char value, char ... array) {
        for (char i : array) {
            if (value != i) continue;
            return true;
        }
        return false;
    }

    public static boolean charInRange(char ch, char a, char z) {
        return ch >= a && ch <= z;
    }

    public static boolean existsInList(String value, List<String> array) {
        if (value == null) {
            return false;
        }
        for (String s : array) {
            if (!value.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsInList(String value, String ... array) {
        if (value == null) {
            return false;
        }
        for (String s : array) {
            if (!value.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsInList(String value, String ... array) {
        if (value == null) {
            return false;
        }
        for (String s : array) {
            if (!value.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsInListTrimmed(String value, String ... array) {
        if (value == null) {
            return false;
        }
        for (String s : array) {
            if (!value.equals(s.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean existsInList(int value, int ... array) {
        for (int i : array) {
            if (value != i) continue;
            return true;
        }
        return false;
    }

    public static boolean existsInListNC(String value, String ... array) {
        for (String s : array) {
            if (!value.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static String stringJoin(String sep, String ... array) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(sep);
        for (String s : array) {
            if (Utilities.noString(s)) continue;
            b.append(s);
        }
        return b.toString();
    }

    public static String getFileNameForName(String name) {
        return name.toLowerCase();
    }

    public static boolean isAsciiChar(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static boolean isURL(String s) {
        boolean ok = s.matches("^http(s{0,1})://[a-zA-Z0-9_/\\-\\.]+\\.([A-Za-z/]{2,5})[a-zA-Z0-9_/\\&\\?\\=\\-\\.\\~\\%]*");
        return ok;
    }

    public static String escapeCSV(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == '\"') {
                b.append("\"\"");
                continue;
            }
            if (Utilities.isWhitespace(c)) {
                b.append(" ");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String escapeJson(String value) {
        return Utilities.escapeJson(value, true);
    }

    public static String escapeJson(String value, boolean escapeUnicodeWhitespace) {
        if (value == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (c == '\r') {
                b.append("\\r");
                continue;
            }
            if (c == '\n') {
                b.append("\\n");
                continue;
            }
            if (c == '\t') {
                b.append("\\t");
                continue;
            }
            if (c == '\"') {
                b.append("\\\"");
                continue;
            }
            if (c == '\\') {
                b.append("\\\\");
                continue;
            }
            if (c == ' ') {
                b.append(" ");
                continue;
            }
            if (c == '\r' || c == '\n' || Utilities.isWhitespace(c) && escapeUnicodeWhitespace) {
                b.append("\\u" + Utilities.padLeft(Integer.toHexString(c), '0', 4));
                continue;
            }
            if (c < ' ') {
                b.append("\\u" + Utilities.padLeft(Integer.toHexString(c), '0', 4));
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String humanize(String code) {
        StringBuilder b = new StringBuilder();
        boolean lastBreak = true;
        for (char c : code.toCharArray()) {
            if (Character.isLetter(c)) {
                if (lastBreak) {
                    b.append(Character.toUpperCase(c));
                } else {
                    if (Character.isUpperCase(c)) {
                        b.append(" ");
                    }
                    b.append(c);
                }
                lastBreak = false;
                continue;
            }
            b.append(" ");
            lastBreak = true;
        }
        if (b.length() == 0) {
            return code;
        }
        return b.toString();
    }

    public static String uncapitalize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toLowerCase();
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static int charCount(String s, char c) {
        int res = 0;
        for (char ch : s.toCharArray()) {
            if (ch != c) continue;
            ++res;
        }
        return res;
    }

    public static int startCharCount(String s, char c) {
        int res = 0;
        for (char ch : s.toCharArray()) {
            if (ch != c) break;
            ++res;
        }
        return res;
    }

    public static boolean equals(String one, String two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        return one.equals(two);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareIgnoreWhitespace(File f1, File f2) throws IOException {
        BufferedInputStream in1 = null;
        InputStream in2 = null;
        try {
            boolean bl;
            in1 = new BufferedInputStream(ManagedFileAccess.inStream(f1));
            in2 = new BufferedInputStream(ManagedFileAccess.inStream(f2));
            int expectedByte = ((InputStream)in1).read();
            while (expectedByte != -1) {
                boolean w1 = Character.isWhitespace(expectedByte);
                if (w1) {
                    while (Character.isWhitespace(expectedByte)) {
                        expectedByte = ((InputStream)in1).read();
                    }
                }
                int foundByte = in2.read();
                if (w1) {
                    if (!Character.isWhitespace(foundByte)) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    while (Character.isWhitespace(foundByte)) {
                        foundByte = in2.read();
                    }
                }
                if (expectedByte != foundByte) {
                    boolean bl3 = false;
                    return bl3;
                }
                expectedByte = ((InputStream)in1).read();
            }
            if (in2.read() != -1) {
                bl = false;
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            if (in1 != null) {
                try {
                    ((InputStream)in1).close();
                }
                catch (IOException iOException) {}
            }
            if (in2 != null) {
                try {
                    in2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean compareIgnoreWhitespace(String fn1, String fn2) throws IOException {
        return Utilities.compareIgnoreWhitespace(ManagedFileAccess.file(fn1), ManagedFileAccess.file(fn2));
    }

    public static boolean isAbsoluteUrl(String ref) {
        if (ref != null && ref.contains(":")) {
            String scheme = ref.substring(0, ref.indexOf(":"));
            String details = ref.substring(ref.indexOf(":") + 1);
            return (Utilities.existsInList(scheme, "http", "https", "urn", "file:") || Utilities.isToken(scheme) && scheme.equals(scheme.toLowerCase()) || Utilities.startsWithInList(ref, "urn:iso:", "urn:iso-iec:", "urn:iso-cie:", "urn:iso-astm:", "urn:iso-ieee:", "urn:iec:")) && details != null && details.length() > 0 && !details.contains(" ");
        }
        return false;
    }

    public static boolean isAbsoluteUrlLinkable(String ref) {
        if (ref != null && ref.contains(":")) {
            String scheme = ref.substring(0, ref.indexOf(":"));
            String details = ref.substring(ref.indexOf(":") + 1);
            return Utilities.existsInList(scheme, "http", "https", "ftp") && details != null && details.length() > 0 && !details.contains(" ");
        }
        return false;
    }

    public static boolean equivalent(String l, String r) {
        if (Utilities.noString(l) && Utilities.noString(r)) {
            return true;
        }
        if (Utilities.noString(l) || Utilities.noString(r)) {
            return false;
        }
        return l.toLowerCase().equals(r.toLowerCase());
    }

    public static boolean equivalentNumber(String l, String r) {
        if (Utilities.noString(l) && Utilities.noString(r)) {
            return true;
        }
        if (Utilities.noString(l) || Utilities.noString(r)) {
            return false;
        }
        if (!Utilities.isDecimal(l, true) || !Utilities.isDecimal(r, true)) {
            return false;
        }
        BigDecimal dl = new BigDecimal(l);
        BigDecimal dr = new BigDecimal(r);
        if (dl.scale() < dr.scale()) {
            dr = dr.setScale(dl.scale(), RoundingMode.HALF_UP);
        } else if (dl.scale() > dr.scale()) {
            dl = dl.setScale(dr.scale(), RoundingMode.HALF_UP);
        }
        return dl.equals(dr);
    }

    public static String getFileExtension(String fn) {
        return fn.contains(".") ? fn.substring(fn.lastIndexOf(".") + 1) : "";
    }

    public static String unCamelCaseKeepCapitals(String name) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (char c : name.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!first) {
                    b.append(" ");
                }
                b.append(c);
            } else {
                b.append(c);
            }
            first = false;
        }
        return b.toString();
    }

    public static String unCamelCase(String name) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (char c : name.toCharArray()) {
            if (Character.isUpperCase(c)) {
                if (!first) {
                    b.append(" ");
                }
                b.append(Character.toLowerCase(c));
            } else {
                b.append(c);
            }
            first = false;
        }
        return b.toString();
    }

    public static boolean isAbsoluteFileName(String source) {
        if (Utilities.isWindows()) {
            return source.length() > 2 && source.charAt(1) == ':' || source.startsWith("\\\\");
        }
        return source.startsWith("//");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static String splitLineForLength(String line, int prefixLength, int indent, int allowedLength) {
        ArrayList<String> list = new ArrayList<String>();
        while (prefixLength + line.length() > allowedLength) {
            int i;
            for (i = allowedLength - (list.size() == 0 ? prefixLength : indent); i > 0 && line.charAt(i) != ' '; --i) {
            }
            if (i == 0) break;
            list.add(line.substring(0, i));
            line = line.substring(i + 1);
        }
        list.add(line);
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (first) {
                first = false;
            } else {
                b.append("\r\n" + Utilities.padLeft("", ' ', indent));
            }
            b.append(s);
        }
        return b.toString();
    }

    public static String makeId(String name) {
        StringBuilder b = new StringBuilder();
        for (char ch : name.toCharArray()) {
            if (ch >= 'a' && ch <= 'z') {
                b.append(ch);
                continue;
            }
            if (ch >= 'A' && ch <= 'Z') {
                b.append(ch);
                continue;
            }
            if (ch >= '0' && ch <= '9') {
                b.append(ch);
                continue;
            }
            if (ch != '-' && ch != '.') continue;
            b.append(ch);
        }
        return b.toString();
    }

    public static String extractBaseUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("/")) {
            return url.substring(0, url.lastIndexOf("/"));
        }
        return url;
    }

    public static String listCanonicalUrls(Set<String> keys) {
        return keys.toString();
    }

    public static List<String> sortedCaseInsensitive(Collection<String> set) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s == null) continue;
            list.add(s);
        }
        Collections.sort(list, new CaseInsensitiveSorter());
        return list;
    }

    public static List<String> sorted(Collection<String> set) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s == null) continue;
            list.add(s);
        }
        Collections.sort(list);
        return list;
    }

    public static List<String> sortedReverse(Collection<String> set) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s == null) continue;
            list.add(s);
        }
        Collections.sort(list);
        ArrayList<String> rlist = new ArrayList<String>();
        for (int i = list.size() - 1; i >= 0; --i) {
            rlist.add((String)list.get(i));
        }
        return rlist;
    }

    public static List<String> sorted(String[] set) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s == null) continue;
            list.add(s);
        }
        Collections.sort(list);
        return list;
    }

    public static List<String> reverseSorted(Collection<String> set) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s == null) continue;
            list.add(s);
        }
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    public static List<String> reverseSorted(String[] set) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : set) {
            if (s == null) continue;
            list.add(s);
        }
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    public static void analyseStringDiffs(Set<String> source, Set<String> target, Set<String> missed, Set<String> extra) {
        for (String s : source) {
            if (target.contains(s)) continue;
            missed.add(s);
        }
        for (String s : target) {
            if (source.contains(s)) continue;
            extra.add(s);
        }
    }

    public static String fhirPathToXPath(String path) {
        String[] p = path.split("\\.");
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(".");
        for (int i = 0; i < p.length; ++i) {
            Object s = p[i];
            if (((String)s).contains("[")) {
                String si = ((String)s).substring(((String)s).indexOf("[") + 1, ((String)s).length() - 1);
                if (!Utilities.isInteger(si)) {
                    throw new FHIRException("The FHIRPath expression '" + path + "' is not valid");
                }
                s = ((String)s).substring(0, ((String)s).indexOf("[")) + "[" + Integer.toString(Integer.parseInt(si) + 1) + "]";
            }
            if (i < p.length - 1 && p[i + 1].startsWith(".ofType(")) {
                s = (String)s + Utilities.capitalize(p[++i].substring(8, p.length - 1));
            }
            b.append((String)s);
        }
        return b.toString();
    }

    public static String describeDuration(Duration d) {
        if (d.toDays() > 2L) {
            return String.format("%s days", d.toDays());
        }
        if (d.toHours() > 2L) {
            return String.format("%s hours", d.toHours());
        }
        if (d.toMinutes() > 2L) {
            return String.format("%s mins", d.toMinutes());
        }
        return String.format("%s ms", d.toMillis());
    }

    public static String describeDuration(long ms) {
        long days = ms / 86400000L;
        long hours = ms / 3600000L % 24L;
        long mins = ms / 60000L % 60L;
        long secs = ms / 1000L % 60L;
        ms %= 1000L;
        if (days > 0L) {
            return days + "d " + Utilities.pad(hours, 2) + ":" + Utilities.pad(mins, 2) + ":" + Utilities.pad(secs, 2) + "." + ms;
        }
        return Utilities.pad(hours, 2) + ":" + Utilities.pad(mins, 2) + ":" + Utilities.pad(secs, 2) + "." + ms;
    }

    private static String pad(long v, int i) {
        return Utilities.padLeft(Long.toString(v), '0', i);
    }

    public static boolean startsWithInList(String s, String ... list) {
        if (s == null) {
            return false;
        }
        for (String l : list) {
            if (l == null || !s.startsWith(l)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithInList(String s, Collection<String> list) {
        if (s == null || list == null) {
            return false;
        }
        for (String l : list) {
            if (!s.startsWith(l)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithInList(String s, String ... list) {
        if (s == null) {
            return false;
        }
        for (String l : list) {
            if (!s.endsWith(l)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithInList(String s, Collection<String> list) {
        if (s == null) {
            return false;
        }
        for (String l : list) {
            if (!s.endsWith(l)) continue;
            return true;
        }
        return false;
    }

    public static String describeSize(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("File length of < 0  passed in...");
        }
        if ((double)length > Math.pow(1024.0, 3.0)) {
            return (long)length / (long)Math.pow(1024.0, 3.0) + GB;
        }
        if ((double)length > Math.pow(1024.0, 2.0)) {
            return (long)length / (long)Math.pow(1024.0, 2.0) + MB;
        }
        if (length > 1024) {
            return length / 1024 + KB;
        }
        return length + BT;
    }

    public static String describeSize(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("File length of < 0  passed in...");
        }
        if ((double)length > Math.pow(1024.0, 3.0)) {
            return length / (long)Math.pow(1024.0, 3.0) + GB;
        }
        if ((double)length > Math.pow(1024.0, 2.0)) {
            return length / (long)Math.pow(1024.0, 2.0) + MB;
        }
        if (length > 1024L) {
            return length / 1024L + KB;
        }
        return length + BT;
    }

    public static List<byte[]> splitBytes(byte[] array, byte[] delimiter) {
        LinkedList<byte[]> byteArrays = new LinkedList<byte[]>();
        if (delimiter.length == 0) {
            return byteArrays;
        }
        int begin = 0;
        block0: for (int i = 0; i < array.length - delimiter.length + 1; ++i) {
            for (int j = 0; j < delimiter.length; ++j) {
                if (array[i + j] != delimiter[j]) continue block0;
            }
            if (begin < i) {
                byteArrays.add(Arrays.copyOfRange(array, begin, i));
            }
            begin = i + delimiter.length;
        }
        if (begin != array.length) {
            byteArrays.add(Arrays.copyOfRange(array, begin, array.length));
        }
        return byteArrays;
    }

    public static int findinList(String[] list, String val) {
        for (int i = 0; i < list.length; ++i) {
            if (!val.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    public static String toString(String[] expected) {
        return "['" + String.join((CharSequence)"' | '", expected) + "']";
    }

    public static String lowBoundaryForDecimal(String value, int precision) {
        String e;
        if (Utilities.noString(value)) {
            throw new FHIRException("Unable to calculate lowBoundary for a null decimal string");
        }
        String string = e = value.contains("e") ? value.substring(value.indexOf("e") + 1) : null;
        if (value.contains("e")) {
            value = value.substring(0, value.indexOf("e"));
        }
        if (Utilities.isZero(value)) {
            return Utilities.applyPrecision("-0.5000000000000000000000000", precision, true);
        }
        if (value.startsWith("-")) {
            return "-" + Utilities.highBoundaryForDecimal(value.substring(1), precision) + (e == null ? "" : e);
        }
        if (value.contains(".")) {
            return Utilities.applyPrecision(Utilities.minusOne(value) + "50000000000000000000000000000", precision, true) + (e == null ? "" : e);
        }
        return Utilities.applyPrecision(Utilities.minusOne(value) + ".50000000000000000000000000000", precision, true) + (e == null ? "" : e);
    }

    private static String applyPrecision(String v, int p, boolean down) {
        Object nv = v;
        int dp = -1;
        if (((String)nv).contains(".")) {
            dp = ((String)nv).indexOf(".");
            nv = ((String)nv).substring(0, dp) + ((String)nv).substring(dp + 1);
        }
        Object s = null;
        int d = p - Utilities.getDecimalPrecision(v);
        if (d == 0) {
            s = nv;
        } else if (d > 0) {
            s = (String)nv + Utilities.padLeft("", '0', d);
        } else {
            int l = v.length();
            int ld = l + d;
            if (dp > -1) {
                --ld;
            }
            s = ((String)nv).charAt(ld) >= '5' && !down ? ((String)nv).substring(0, ld - 1) + (char)(((String)nv).charAt(ld - 1) + '\u0001') : ((String)nv).substring(0, ld);
        }
        if (((String)s).endsWith(".")) {
            s = ((String)s).substring(0, ((String)s).length() - 1);
        }
        return dp == -1 || dp >= ((String)s).length() ? s : ((String)s).substring(0, dp) + "." + ((String)s).substring(dp);
    }

    private static String minusOne(String value) {
        StringBuffer s = new StringBuffer(value);
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '0') {
                s.setCharAt(i, '9');
                continue;
            }
            if (s.charAt(i) == '.') continue;
            s.setCharAt(i, (char)(s.charAt(i) - '\u0001'));
            break;
        }
        return s.toString();
    }

    public static String highBoundaryForDecimal(String value, int precision) {
        String e;
        if (Utilities.noString(value)) {
            throw new FHIRException("Unable to calculate highBoundary for a null decimal string");
        }
        String string = e = value.contains("e") ? value.substring(value.indexOf("e") + 1) : null;
        if (value.contains("e")) {
            value = value.substring(0, value.indexOf("e"));
        }
        if (Utilities.isZero(value)) {
            return Utilities.applyPrecision("0.50000000000000000000000000000", precision, false);
        }
        if (value.startsWith("-")) {
            return "-" + Utilities.lowBoundaryForDecimal(value.substring(1), precision) + (e == null ? "" : e);
        }
        if (value.contains(".")) {
            return Utilities.applyPrecision(value + "50000000000000000000000000000", precision, false) + (e == null ? "" : e);
        }
        return Utilities.applyPrecision(value + ".50000000000000000000000000000", precision, false) + (e == null ? "" : e);
    }

    private static boolean isZero(String value) {
        return value.replace(".", "").replace("-", "").replace("0", "").length() == 0;
    }

    public static Integer getDecimalPrecision(String value) {
        if (value.contains("e")) {
            value = value.substring(0, value.indexOf("e"));
        }
        if (value.contains(".")) {
            return value.split("\\.")[1].length();
        }
        return 0;
    }

    public static String padInt(int i, int len) {
        return Utilities.padLeft(Integer.toString(i), ' ', len);
    }

    public static String padInt(long i, int len) {
        return Utilities.padLeft(Long.toString(i), ' ', len);
    }

    public static Object makeSingleLine(String text) {
        text = text.replace("\r", " ");
        text = text.replace("\n", " ");
        while (text.contains("  ")) {
            text = text.replace("  ", " ");
        }
        return text;
    }

    public static int parseInt(String value, int def) {
        if (Utilities.isInteger(value)) {
            return Integer.parseInt(value);
        }
        return def;
    }

    public static String appendDerivedTextToBase(@Nullable String baseText, String derivedText) {
        if (baseText == null) {
            return derivedText.substring(3);
        }
        return baseText + "\r\n" + derivedText.substring(3);
    }

    public static String getRelativeUrlPath(String root, String path) {
        String res = path.substring(root.length());
        if (res.startsWith("/")) {
            res = res.substring(1);
        }
        return res;
    }

    public static boolean isValidCRName(String name) {
        return name != null && name.matches("[A-Z]([A-Za-z0-9_]){1,254}");
    }

    public static boolean isAllWhitespace(String s) {
        if (Utilities.noString(s)) {
            return true;
        }
        for (char ch : s.toCharArray()) {
            if (Utilities.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public static String trimWS(String s) {
        int end;
        int start;
        if (Utilities.noString(s)) {
            return s;
        }
        for (start = 0; start < s.length() && Utilities.isWhitespace(s.charAt(start)); ++start) {
        }
        if (start == s.length()) {
            return "";
        }
        for (end = s.length() - 1; end >= 0 && Utilities.isWhitespace(s.charAt(end)); --end) {
        }
        if (start > end) {
            return "";
        }
        return s.substring(start, end + 1);
    }

    public static boolean isWhitespace(int ch) {
        return Utilities.existsInList(ch, 9, 10, 11, 12, 13, 32, 133, 160, 5760, 8192, 8193, 8194, 8195, 8196, 8197, 8198, 8199, 8200, 8201, 8202, 8232, 8233, 8239, 8287, 12288);
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static String tail(String url) {
        int i;
        for (i = url.length() - 1; i >= 0 && (Utilities.isTokenChar(url.charAt(i)) || Utilities.isDigit(url.charAt(i))); --i) {
        }
        if (i < 0) {
            return url;
        }
        return url.substring(i + 1);
    }

    public static List<String> strings(String ... members) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String m : members) {
            ret.add(m);
        }
        return ret;
    }

    public static Set<String> stringSet(String ... members) {
        HashSet<String> ret = new HashSet<String>();
        for (String m : members) {
            ret.add(m);
        }
        return ret;
    }

    public static List<String> splitStrings(String src, String regex) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String m : src.split(regex)) {
            ret.add(m);
        }
        return ret;
    }

    public static String stripPara(String p) {
        if (Utilities.noString(p)) {
            return "";
        }
        if ((p = p.trim()).startsWith("<p>")) {
            p = p.substring(3);
        }
        if (p.endsWith("</p>")) {
            p = p.substring(0, p.length() - 4);
        }
        return p;
    }

    public static String stripAllPara(String p) {
        if (Utilities.noString(p)) {
            return "";
        }
        if ((p = p.trim()).startsWith("<p>")) {
            p = p.substring(3);
        }
        if (p.endsWith("</p>")) {
            p = p.substring(0, p.length() - 4);
        }
        p = p.replace("</p>", " ");
        p = p.replace("<p>", "");
        while (p.contains("<p ")) {
            int start;
            int end;
            for (end = start = p.indexOf("<p "); end < p.length() && p.charAt(end) != '>'; ++end) {
            }
            p = p.substring(start, end);
        }
        return p;
    }

    public static boolean isTxFhirOrgServer(String s) {
        return Utilities.startsWithInList(s.replace("https://", "http://"), FhirSettings.getTxFhirProduction(), FhirSettings.getTxFhirDevelopment(), FhirSettings.getTxFhirLocal());
    }

    public static String[] splitLines(String txt) {
        return txt.split("\\r?\\n|\\r");
    }

    public static String rightTrim(String s) {
        int i;
        for (i = s.length() - 1; i > 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return i == 0 ? "" : s.substring(0, i + 1);
    }

    public static String urlTail(String url) {
        if (url == null) {
            return null;
        }
        return url.contains("/") ? url.substring(url.lastIndexOf("/") + 1) : url;
    }

    public static String escapeSql(String s) {
        return s.replace("'", "''");
    }

    public static String[] simpleSplit(String cnt, String div) {
        if (cnt == null) {
            return new String[0];
        }
        ArrayList<String> parts = new ArrayList<String>();
        int cursor = 0;
        int last = 0;
        while (cursor < cnt.length()) {
            if (Utilities.matches(cnt, div, cursor)) {
                parts.add(cnt.substring(last, cursor));
                last = cursor += div.length();
                continue;
            }
            ++cursor;
        }
        parts.add(cnt.substring(last, cursor));
        return parts.toArray(new String[0]);
    }

    private static boolean matches(String cnt, String div, int cursor) {
        if (div.length() + cursor > cnt.length()) {
            return false;
        }
        for (int i = 0; i < div.length(); ++i) {
            if (cnt.charAt(cursor + i) == div.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String stripEoln(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("\r\n", " ").replace("\n", " ").replace("\r", " ");
    }

    public static String extractDomain(String source) {
        try {
            URI uri = URI.create(source);
            return uri.getHost();
        }
        catch (Exception e) {
            return "??";
        }
    }

    public static boolean isValidHtmlAnchorChar(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case '!': 
            case '$': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '@': 
            case '_': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public static boolean listValueStartsWith(String s, Set<String> list) {
        if (s == null || list == null) {
            return false;
        }
        for (String l : list) {
            if (!l.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static String extractByRegex(String input, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            result.append(matcher.group(1));
        }
        return result.length() == 0 ? null : result.toString();
    }

    public static String getDirectoryForURL(String url) {
        return url.contains("/") && url.lastIndexOf("/") > 10 ? url.substring(0, url.lastIndexOf("/")) : url;
    }

    public static List<String> copyAdd(List<String> oldList, String newItem) {
        ArrayList<String> newList = new ArrayList<String>(oldList);
        newList.add(newItem);
        return newList;
    }

    public static String limitString(String text, int length) {
        if ((text = text.trim()).length() > length) {
            return text.substring(0, length - 1) + "...";
        }
        return text;
    }

    static {
        Arrays.sort(illegalChars);
    }

    public static enum DecimalStatus {
        BLANK,
        SYNTAX,
        RANGE,
        OK;

    }

    public static class CaseInsensitiveSorter
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

