/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.settings.FhirSettings;

public class PathBuilder {
    private final String requiredTarget;
    private final boolean requireNonNullNonEmptyFirstEntry;
    private final boolean requireNonRootFirstEntry;
    private final boolean requirePathIsChildOfTarget;

    public static PathBuilder getPathBuilder() {
        return new PathBuilder(null, true, true, true);
    }

    public String buildPath(String ... args) throws IOException {
        this.checkNonNullNonEmptyFirstEntry(args);
        this.checkNonRootFirstEntry(args);
        StringBuilder stringBuilder = new StringBuilder();
        boolean argIsNotEmptyOrNull = false;
        boolean first = true;
        for (String arg : args) {
            if (first && arg == null) continue;
            first = false;
            if (!argIsNotEmptyOrNull) {
                argIsNotEmptyOrNull = !Utilities.noString(arg);
            } else if (!stringBuilder.toString().endsWith(File.separator)) {
                stringBuilder.append(File.separator);
            }
            String a = arg;
            if (stringBuilder.length() == 0) {
                a = this.replaceVariables(a);
            }
            a = a.replace("\\", File.separator);
            a = a.replace("/", File.separator);
            if (stringBuilder.length() > 0 && a.startsWith(File.separator)) {
                a = a.substring(File.separator.length());
            }
            while (a.startsWith(".." + File.separator)) {
                String p;
                stringBuilder = stringBuilder.length() == 0 ? new StringBuilder(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString()) : (!(p = stringBuilder.toString().substring(0, stringBuilder.length() - 1)).contains(File.separator) ? new StringBuilder() : new StringBuilder(p.substring(0, p.lastIndexOf(File.separator)) + File.separator));
                a = a.substring(3);
            }
            if ("..".equals(a)) {
                int i = stringBuilder.substring(0, stringBuilder.length() - 1).lastIndexOf(File.separator);
                stringBuilder = new StringBuilder(stringBuilder.substring(0, i + 1));
                continue;
            }
            stringBuilder.append(a);
        }
        this.checkPathIsChildOfTarget(stringBuilder.toString(), args);
        return stringBuilder.toString();
    }

    private void checkPathIsChildOfTarget(String path, String[] args) throws IOException {
        String target;
        if (!this.requirePathIsChildOfTarget) {
            return;
        }
        String string = target = this.requiredTarget != null ? this.requiredTarget : args[0];
        if (!Path.of(path, new String[0]).normalize().startsWith(Path.of(this.replaceVariables(target), new String[0]).normalize())) {
            throw new RuntimeException("Computed path does not start with first element: " + String.join((CharSequence)", ", args));
        }
    }

    private void checkNonRootFirstEntry(String[] args) {
        if (!this.requireNonRootFirstEntry) {
            return;
        }
        if (PathBuilder.isPathRoot(args[0])) {
            throw new RuntimeException("First entry in file path cannot be root: " + args[0] + ", full path = " + String.join((CharSequence)", ", args));
        }
    }

    private void checkNonNullNonEmptyFirstEntry(String[] args) {
        if (!this.requireNonNullNonEmptyFirstEntry) {
            return;
        }
        if (args[0] == null || Utilities.noString(args[0].trim())) {
            throw new RuntimeException("First entry in file path cannot be null or empty, full path = " + String.join((CharSequence)", ", args));
        }
    }

    private String replaceVariables(String a) throws IOException {
        if ("[tmp]".equals(a)) {
            return this.getTempDir();
        }
        if (a.startsWith("[tmp]")) {
            return this.getTempDir() + a.substring(5);
        }
        if ("[user]".equals(a)) {
            return System.getProperty("user.home");
        }
        return a;
    }

    private String getTempDir() throws IOException {
        if (PathBuilder.hasCTempDir()) {
            return "c:\\temp";
        }
        if (FhirSettings.hasTempPath()) {
            return FhirSettings.getTempPath();
        }
        return System.getProperty("java.io.tmpdir");
    }

    protected static boolean hasCTempDir() throws IOException {
        if (!System.getProperty("os.name").toLowerCase().contains("win")) {
            return false;
        }
        File tmp = ManagedFileAccess.file("c:\\temp");
        return tmp.exists() && tmp.isDirectory() && tmp.canWrite();
    }

    protected static boolean isPathRoot(String pathString) {
        Path path = Path.of(pathString, new String[0]);
        Path normalizedPath = path.normalize();
        boolean actual = normalizedPath.equals(path.getRoot());
        return actual;
    }

    private PathBuilder(String requiredTarget, boolean requireNonNullNonEmptyFirstEntry, boolean requireNonRootFirstEntry, boolean requirePathIsChildOfTarget) {
        this.requiredTarget = requiredTarget;
        this.requireNonNullNonEmptyFirstEntry = requireNonNullNonEmptyFirstEntry;
        this.requireNonRootFirstEntry = requireNonRootFirstEntry;
        this.requirePathIsChildOfTarget = requirePathIsChildOfTarget;
    }

    public PathBuilder withRequiredTarget(String requiredTarget) {
        return this.requiredTarget == requiredTarget ? this : new PathBuilder(requiredTarget, this.requireNonNullNonEmptyFirstEntry, this.requireNonRootFirstEntry, this.requirePathIsChildOfTarget);
    }

    public PathBuilder withRequireNonNullNonEmptyFirstEntry(boolean requireNonNullNonEmptyFirstEntry) {
        return this.requireNonNullNonEmptyFirstEntry == requireNonNullNonEmptyFirstEntry ? this : new PathBuilder(this.requiredTarget, requireNonNullNonEmptyFirstEntry, this.requireNonRootFirstEntry, this.requirePathIsChildOfTarget);
    }

    public PathBuilder withRequireNonRootFirstEntry(boolean requireNonRootFirstEntry) {
        return this.requireNonRootFirstEntry == requireNonRootFirstEntry ? this : new PathBuilder(this.requiredTarget, this.requireNonNullNonEmptyFirstEntry, requireNonRootFirstEntry, this.requirePathIsChildOfTarget);
    }

    public PathBuilder withRequirePathIsChildOfTarget(boolean requirePathIsChildOfTarget) {
        return this.requirePathIsChildOfTarget == requirePathIsChildOfTarget ? this : new PathBuilder(this.requiredTarget, this.requireNonNullNonEmptyFirstEntry, this.requireNonRootFirstEntry, requirePathIsChildOfTarget);
    }
}

