/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.hl7.fhir.utilities.filesystem.CSFile;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;

public final class IniFile {
    private String mstrDateFmt = "yyyy-MM-dd";
    private String mstrTimeStampFmt = "yyyy-MM-dd HH:mm:ss";
    private boolean fileSuccessfullyLoaded = false;
    private String filepath;
    private LinkedHashMap<String, INISection> iniSections;
    private Properties mpropEnv = this.getEnvVars();

    public IniFile(String pathname) {
        this.iniSections = new LinkedHashMap();
        this.filepath = pathname;
        if (this.checkFile(pathname)) {
            this.loadFile();
        }
    }

    public IniFile(InputStream stream) {
        this.iniSections = new LinkedHashMap();
        this.filepath = null;
        this.loadStream(stream);
    }

    public String getFileName() {
        return this.filepath;
    }

    public String getStringProperty(String pstrSection, String pstrProp) {
        String strRet = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            if (objProp != null) {
                strRet = objProp.getPropValue();
                objProp = null;
            }
            objSec = null;
        }
        return strRet;
    }

    public Boolean getBooleanProperty(String pstrSection, String pstrProp) {
        boolean blnRet = false;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            if (objProp != null) {
                strVal = objProp.getPropValue().toUpperCase();
                if (strVal.equals("YES") || strVal.equals("TRUE") || strVal.equals("1")) {
                    blnRet = true;
                }
                objProp = null;
            }
            objSec = null;
        }
        return new Boolean(blnRet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIntegerProperty(String pstrSection, String pstrProp) {
        Integer intRet = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                    intRet = new Integer(strVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return intRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLongProperty(String pstrSection, String pstrProp) {
        Long lngRet = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                    lngRet = new Long(strVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return lngRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getDoubleProperty(String pstrSection, String pstrProp) {
        Double dblRet = null;
        String strVal = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null && (strVal = objProp.getPropValue()) != null) {
                    dblRet = new Double(strVal);
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return dblRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDateProperty(String pstrSection, String pstrProp) {
        Date dtRet = null;
        String strVal = null;
        SimpleDateFormat dtFmt = null;
        INIProperty objProp = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objProp = objSec.getProperty(pstrProp);
            try {
                if (objProp != null) {
                    strVal = objProp.getPropValue();
                }
                if (strVal != null) {
                    dtFmt = new SimpleDateFormat(this.mstrDateFmt);
                    dtRet = dtFmt.parse(strVal);
                }
            }
            catch (ParseException parseException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            finally {
                if (objProp != null) {
                    objProp = null;
                }
            }
            objSec = null;
        }
        return dtRet;
    }

    public Date getTimestampProperty(String iniSectionName, String propertyKey) {
        Date dateToReturn = null;
        INISection iniSection = this.iniSections.get(iniSectionName);
        if (iniSection != null) {
            INIProperty objProp = iniSection.getProperty(propertyKey);
            try {
                String propertyStringValue = null;
                if (objProp != null) {
                    propertyStringValue = objProp.getPropValue();
                }
                if (propertyStringValue != null) {
                    DateTimeFormatter dtFmt = DateTimeFormatter.ofPattern(this.mstrTimeStampFmt).withZone(ZoneId.systemDefault());
                    ZonedDateTime zonedDateTime = ZonedDateTime.parse(propertyStringValue, dtFmt);
                    dateToReturn = Date.from(zonedDateTime.toInstant());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return dateToReturn;
    }

    public void addSection(String pstrSection, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        objSec.setSecComments(this.delRemChars(pstrComments));
        objSec = null;
    }

    public void setStringProperty(String pstrSection, String pstrProp, String pstrVal, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        objSec.setProperty(pstrProp, pstrVal, pstrComments);
    }

    public void setBooleanProperty(String pstrSection, String pstrProp, boolean pblnVal, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        if (pblnVal) {
            objSec.setProperty(pstrProp, "TRUE", pstrComments);
        } else {
            objSec.setProperty(pstrProp, "FALSE", pstrComments);
        }
    }

    public void setIntegerProperty(String pstrSection, String pstrProp, int pintVal, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        objSec.setProperty(pstrProp, Integer.toString(pintVal), pstrComments);
    }

    public void setLongProperty(String pstrSection, String pstrProp, long plngVal, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        objSec.setProperty(pstrProp, Long.toString(plngVal), pstrComments);
    }

    public void setDoubleProperty(String pstrSection, String pstrProp, double pdblVal, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        objSec.setProperty(pstrProp, Double.toString(pdblVal), pstrComments);
    }

    public void setDateProperty(String pstrSection, String pstrProp, Date pdtVal, String pstrComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec == null) {
            objSec = new INISection(pstrSection);
            this.iniSections.put(pstrSection, objSec);
        }
        objSec.setProperty(pstrProp, this.utilDateToStr(pdtVal, this.mstrDateFmt), pstrComments);
    }

    public void setTimestampProperty(String iniSection, String propertyKey, ZonedDateTime propertyValue, String propertyComments) {
        INISection objSec = null;
        objSec = this.iniSections.get(iniSection);
        if (objSec == null) {
            objSec = new INISection(iniSection);
            this.iniSections.put(iniSection, objSec);
        }
        objSec.setProperty(propertyKey, this.timeToString(propertyValue, this.mstrTimeStampFmt), propertyComments);
    }

    public void setDateFormat(String pstrDtFmt) throws IllegalArgumentException {
        if (!this.checkDateTimeFormat(pstrDtFmt)) {
            throw new IllegalArgumentException("The specified date pattern is invalid!");
        }
        this.mstrDateFmt = pstrDtFmt;
    }

    public void setTimeStampFormat(String pstrTSFmt) {
        if (!this.checkDateTimeFormat(pstrTSFmt)) {
            throw new IllegalArgumentException("The specified timestamp pattern is invalid!");
        }
        this.mstrTimeStampFmt = pstrTSFmt;
    }

    public int getTotalSections() {
        return this.iniSections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllSectionNames() {
        int iCntr = 0;
        Iterator<String> iter = null;
        String[] arrRet = null;
        try {
            if (this.iniSections.size() > 0) {
                arrRet = new String[this.iniSections.size()];
                iter = this.iniSections.keySet().iterator();
                while (true) {
                    arrRet[iCntr] = iter.next();
                    ++iCntr;
                    iter.hasNext();
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            if (iter != null) {
                iter = null;
            }
        }
        return arrRet;
    }

    public String[] getPropertyNames(String pstrSection) {
        String[] arrRet = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            arrRet = objSec.getPropNames();
            objSec = null;
        }
        return arrRet;
    }

    public Map<String, INIProperty> getProperties(String pstrSection) {
        Map<String, INIProperty> hmRet = null;
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            hmRet = objSec.getProperties();
            objSec = null;
        }
        return hmRet;
    }

    public void removeProperty(String pstrSection, String pstrProp) {
        INISection objSec = null;
        objSec = this.iniSections.get(pstrSection);
        if (objSec != null) {
            objSec.removeProperty(pstrProp);
            objSec = null;
        }
    }

    public void removeSection(String pstrSection) {
        if (this.iniSections.containsKey(pstrSection)) {
            this.iniSections.remove(pstrSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean save() {
        boolean blnRet;
        block20: {
            FileWriter objWriter;
            INISection objSec;
            Iterator<String> itrSec;
            String strTemp;
            String strName;
            CSFile objFile;
            block19: {
                blnRet = false;
                objFile = null;
                strName = null;
                strTemp = null;
                itrSec = null;
                objSec = null;
                objWriter = null;
                if (this.iniSections.size() != 0) break block19;
                boolean bl = false;
                if (objWriter != null) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                }
                if (objFile != null) {
                    objFile = null;
                }
                if (itrSec != null) {
                    itrSec = null;
                }
                return bl;
            }
            try {
                objFile = ManagedFileAccess.csfile(this.filepath);
                if (objFile.exists()) {
                    objFile.delete();
                }
                objWriter = new FileWriter(objFile);
                itrSec = this.iniSections.keySet().iterator();
                while (itrSec.hasNext()) {
                    strName = itrSec.next();
                    objSec = this.iniSections.get(strName);
                    strTemp = objSec.toString();
                    objWriter.write(strTemp);
                    objWriter.write("\r\n");
                    objSec = null;
                }
                blnRet = true;
                if (objWriter != null) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                }
                if (objFile != null) {
                    objFile = null;
                }
                if (itrSec != null) {
                    itrSec = null;
                }
            }
            catch (IOException iOException) {
                if (objWriter != null) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                }
                if (objFile != null) {
                    objFile = null;
                }
                if (itrSec != null) {
                    itrSec = null;
                }
                break block20;
                catch (Throwable throwable) {
                    if (objWriter != null) {
                        this.closeWriter(objWriter);
                        objWriter = null;
                    }
                    if (objFile != null) {
                        objFile = null;
                    }
                    if (itrSec != null) {
                        itrSec = null;
                    }
                    throw throwable;
                }
            }
        }
        return blnRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean save(OutputStream stream) {
        boolean blnRet;
        block15: {
            OutputStreamWriter objWriter;
            INISection objSec;
            Iterator<String> itrSec;
            String strTemp;
            String strName;
            block14: {
                blnRet = false;
                strName = null;
                strTemp = null;
                itrSec = null;
                objSec = null;
                objWriter = null;
                if (this.iniSections.size() != 0) break block14;
                boolean bl = false;
                if (objWriter != null) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                }
                if (itrSec != null) {
                    itrSec = null;
                }
                return bl;
            }
            try {
                objWriter = new OutputStreamWriter(stream, "UTF-8");
                itrSec = this.iniSections.keySet().iterator();
                while (itrSec.hasNext()) {
                    strName = itrSec.next();
                    objSec = this.iniSections.get(strName);
                    strTemp = objSec.toString();
                    objWriter.write(strTemp);
                    objWriter.write("\r\n");
                    objSec = null;
                }
                blnRet = true;
                if (objWriter != null) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                }
                if (itrSec != null) {
                    itrSec = null;
                }
            }
            catch (IOException iOException) {
                if (objWriter != null) {
                    this.closeWriter(objWriter);
                    objWriter = null;
                }
                if (itrSec != null) {
                    itrSec = null;
                }
                break block15;
                catch (Throwable throwable) {
                    if (objWriter != null) {
                        this.closeWriter(objWriter);
                        objWriter = null;
                    }
                    if (itrSec != null) {
                        itrSec = null;
                    }
                    throw throwable;
                }
            }
        }
        return blnRet;
    }

    private Properties getEnvVars() {
        Process p = null;
        Properties envVars = new Properties();
        try {
            String line;
            Runtime r = Runtime.getRuntime();
            String OS = System.getProperty("os.name").toLowerCase();
            p = OS.indexOf("windows 9") > -1 ? r.exec("command.com /c set") : (OS.indexOf("nt") > -1 || OS.indexOf("windows 2000") > -1 || OS.indexOf("windows xp") > -1 ? r.exec("cmd.exe /c set") : r.exec("env"));
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                int idx = line.indexOf(61);
                String key = line.substring(0, idx);
                String value = line.substring(idx + 1);
                envVars.setProperty(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return envVars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDateTimeFormat(String pstrDtFmt) {
        boolean blnRet = false;
        SimpleDateFormat objFmt = null;
        try {
            objFmt = new SimpleDateFormat(pstrDtFmt);
            blnRet = true;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        finally {
            if (objFmt != null) {
                objFmt = null;
            }
        }
        return blnRet;
    }

    /*
     * Exception decompiling
     */
    private void loadStream(InputStream stream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void loadFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeReader(Reader pobjRdr) {
        if (pobjRdr == null) {
            return;
        }
        try {
            pobjRdr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeWriter(Writer pobjWriter) {
        if (pobjWriter == null) {
            return;
        }
        try {
            pobjWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFile(String pathName) {
        boolean blnRet = false;
        CSFile objFile = null;
        try {
            objFile = ManagedFileAccess.csfile(pathName);
            blnRet = objFile.exists() && objFile.isFile();
        }
        catch (Exception e) {
            blnRet = false;
        }
        finally {
            if (objFile != null) {
                objFile = null;
            }
        }
        return blnRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String utilDateToStr(Date date, String dateFormat) {
        String strRet = null;
        SimpleDateFormat dtFmt = null;
        try {
            dtFmt = new SimpleDateFormat(dateFormat);
            strRet = dtFmt.format(date);
        }
        catch (Exception e) {
            strRet = null;
        }
        finally {
            if (dtFmt != null) {
                dtFmt = null;
            }
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String timeToString(ZonedDateTime zonedDateTime, String timeFormat) {
        String stringValue = null;
        DateTimeFormatter dateTimeFormatter = null;
        try {
            dateTimeFormatter = DateTimeFormatter.ofPattern(timeFormat);
            stringValue = dateTimeFormatter.format(zonedDateTime);
        }
        catch (IllegalArgumentException iae) {
            stringValue = "";
        }
        catch (NullPointerException npe) {
            stringValue = "";
        }
        finally {
            if (dateTimeFormatter != null) {
                dateTimeFormatter = null;
            }
        }
        return stringValue;
    }

    private String delRemChars(String pstrSrc) {
        int intPos = 0;
        if (pstrSrc == null) {
            return null;
        }
        while ((intPos = ((String)pstrSrc).indexOf(";")) >= 0) {
            if (intPos == 0) {
                pstrSrc = ((String)pstrSrc).substring(intPos + 1);
                continue;
            }
            if (intPos <= 0) continue;
            pstrSrc = ((String)pstrSrc).substring(0, intPos) + ((String)pstrSrc).substring(intPos + 1);
        }
        return pstrSrc;
    }

    private String addRemChars(String pstrSrc) {
        int intLen = 2;
        int intPos = 0;
        int intPrev = 0;
        String strLeft = null;
        String strRight = null;
        if (pstrSrc == null) {
            return null;
        }
        while (intPos >= 0) {
            intLen = 2;
            intPos = ((String)pstrSrc).indexOf("\r\n", intPrev);
            if (intPos < 0) {
                intLen = 1;
                intPos = ((String)pstrSrc).indexOf("\n", intPrev);
                if (intPos < 0) {
                    intPos = ((String)pstrSrc).indexOf("\r", intPrev);
                }
            }
            if (intPos == 0) {
                pstrSrc = ";\r\n" + ((String)pstrSrc).substring(intPos + intLen);
                intPrev = intPos + intLen + 1;
                continue;
            }
            if (intPos <= 0) continue;
            strLeft = ((String)pstrSrc).substring(0, intPos);
            strRight = ((String)pstrSrc).substring(intPos + intLen);
            pstrSrc = strRight == null ? strLeft : (strRight.length() == 0 ? strLeft : strLeft + "\r\n;" + strRight);
            intPrev = intPos + intLen + 1;
        }
        if (!((String)pstrSrc).substring(0, 1).equals(";")) {
            pstrSrc = ";" + (String)pstrSrc;
        }
        pstrSrc = (String)pstrSrc + "\r\n";
        return pstrSrc;
    }

    public static void main(String[] pstrArgs) {
        IniFile objINI = null;
        String strFile = null;
        if (pstrArgs.length == 0) {
            return;
        }
        strFile = pstrArgs[0];
        objINI = new IniFile(strFile);
        objINI.setStringProperty("Folders", "folder1", "G:\\Temp", null);
        objINI.setStringProperty("Folders", "folder2", "G:\\Temp\\Backup", null);
        objINI.save();
        objINI = null;
    }

    public boolean hasSection(String sectionName) {
        if (this.getAllSectionNames() != null) {
            for (String s : this.getAllSectionNames()) {
                if (!s.equalsIgnoreCase(sectionName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasProperty(String section, String name) {
        return this.getStringProperty(section, name) != null;
    }

    private class INISection {
        private String mstrComment;
        private String mstrName;
        private LinkedHashMap<String, INIProperty> mhmapProps;

        public INISection(String pstrSection) {
            this.mstrName = pstrSection;
            this.mhmapProps = new LinkedHashMap();
        }

        public INISection(String pstrSection, String pstrComments) {
            this.mstrName = pstrSection;
            this.mstrComment = IniFile.this.delRemChars(pstrComments);
            this.mhmapProps = new LinkedHashMap();
        }

        public void setSecComments(String pstrComments) {
            this.mstrComment = IniFile.this.delRemChars(pstrComments);
        }

        public void removeProperty(String pstrProp) {
            if (this.mhmapProps.containsKey(pstrProp)) {
                this.mhmapProps.remove(pstrProp);
            }
        }

        public void setProperty(String pstrProp, String pstrValue, String pstrComments) {
            this.mhmapProps.put(pstrProp, new INIProperty(pstrProp, pstrValue, pstrComments));
        }

        public Map<String, INIProperty> getProperties() {
            return Collections.unmodifiableMap(this.mhmapProps);
        }

        public String[] getPropNames() {
            int iCntr = 0;
            String[] arrRet = null;
            Iterator<String> iter = null;
            try {
                if (this.mhmapProps.size() > 0) {
                    arrRet = new String[this.mhmapProps.size()];
                    iter = this.mhmapProps.keySet().iterator();
                    while (iter.hasNext()) {
                        arrRet[iCntr] = iter.next();
                        ++iCntr;
                    }
                }
            }
            catch (NoSuchElementException NSEExIgnore) {
                arrRet = null;
            }
            return arrRet;
        }

        public INIProperty getProperty(String pstrProp) {
            INIProperty objRet = null;
            if (this.mhmapProps.containsKey(pstrProp)) {
                objRet = this.mhmapProps.get(pstrProp);
            }
            return objRet;
        }

        public String toString() {
            Set<String> colKeys = null;
            String strRet = "";
            Iterator<String> iter = null;
            INIProperty objProp = null;
            StringBuffer objBuf = new StringBuffer();
            if (this.mstrComment != null) {
                objBuf.append(IniFile.this.addRemChars(this.mstrComment));
            }
            objBuf.append("[" + this.mstrName + "]\r\n");
            colKeys = this.mhmapProps.keySet();
            if (colKeys != null && (iter = colKeys.iterator()) != null) {
                while (iter.hasNext()) {
                    objProp = this.mhmapProps.get(iter.next());
                    objBuf.append(objProp.toString());
                    objBuf.append("\r\n");
                    objProp = null;
                }
            }
            strRet = objBuf.toString();
            objBuf = null;
            iter = null;
            colKeys = null;
            return strRet;
        }
    }

    private class INIProperty {
        private String mstrName;
        private String mstrValue;
        private String mstrComments;

        public INIProperty(String pstrName, String pstrValue, String pstrComments) {
            this.mstrName = pstrName;
            this.mstrValue = pstrValue;
            this.mstrComments = IniFile.this.delRemChars(pstrComments);
        }

        public String getPropValue() {
            int intStart = 0;
            int intEnd = 0;
            String strVal = null;
            String strVar = null;
            Object strRet = null;
            strRet = this.mstrValue;
            intStart = ((String)strRet).indexOf("%");
            if (intStart >= 0 && (strVal = IniFile.this.mpropEnv.getProperty(strVar = ((String)strRet).substring(intStart + 1, intEnd = ((String)strRet).indexOf("%", intStart + 1)))) != null) {
                strRet = ((String)strRet).substring(0, intStart) + strVal + ((String)strRet).substring(intEnd + 1);
            }
            return strRet;
        }

        public String toString() {
            Object strRet = "";
            if (this.mstrComments != null) {
                strRet = IniFile.this.addRemChars(this.mstrComments);
            }
            strRet = (String)strRet + this.mstrName + " = " + this.mstrValue;
            return strRet;
        }
    }
}

