/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class PackageGenerator {
    private OutputStream stream;
    private JsonObject object;

    public PackageGenerator() {
        this.object = new JsonObject();
    }

    public PackageGenerator(OutputStream stream) {
        this.stream = stream;
        this.object = new JsonObject();
    }

    public PackageGenerator(OutputStream stream, InputStream template) throws IOException {
        this.stream = stream;
        this.object = JsonParser.parseObject(FileUtilities.streamToString(template));
    }

    public JsonObject getRootJsonObject() {
        return this.object;
    }

    public void commit() throws IOException {
        String json = JsonParser.compose((JsonElement)this.object, true);
        OutputStreamWriter sw = new OutputStreamWriter(this.stream, "UTF-8");
        sw.write(65279);
        sw.write(json);
        sw.flush();
        sw.close();
    }

    public PackageGenerator name(String value) {
        this.object.add("name", value);
        return this;
    }

    public PackageGenerator version(String value) {
        this.object.add("version", value);
        return this;
    }

    public PackageGenerator toolsVersion(int value) {
        this.object.add("tools-version", value);
        return this;
    }

    public PackageGenerator fhirVersions(List<String> versions) {
        JsonArray fhirVersionsArray = new JsonArray();
        for (String version : versions) {
            fhirVersionsArray.add(version);
        }
        this.object.add("fhirVersions", fhirVersionsArray);
        return this;
    }

    public PackageGenerator description(String value) {
        this.object.add("description", value);
        return this;
    }

    public PackageGenerator license(String value) {
        this.object.add("license", value);
        return this;
    }

    public PackageGenerator homepage(String value) {
        this.object.add("homepage", value);
        return this;
    }

    public PackageGenerator bugs(String value) {
        this.object.add("bugs", value);
        return this;
    }

    public PackageGenerator author(String name, String email, String url) {
        JsonObject person = new JsonObject();
        person.add("name", name);
        if (!Utilities.noString(email)) {
            person.add("email", email);
        }
        if (!Utilities.noString(url)) {
            person.add("url", url);
        }
        this.object.add("author", person);
        return this;
    }

    public PackageGenerator contributor(String name, String email, String url) {
        JsonArray c;
        JsonObject person = new JsonObject();
        person.add("name", name);
        if (!Utilities.noString(email)) {
            person.add("email", email);
        }
        if (!Utilities.noString(url)) {
            person.add("url", url);
        }
        if ((c = this.object.getJsonArray("contributors")) == null) {
            c = new JsonArray();
            this.object.add("contributors", c);
        }
        c.add(person);
        return this;
    }

    public PackageGenerator dependency(String name, String version) {
        JsonObject dep = this.object.getJsonObject("dependencies");
        if (dep == null) {
            dep = new JsonObject();
            this.object.add("dependencies", dep);
        }
        dep.add(name, version);
        return this;
    }

    public PackageGenerator file(String name) {
        JsonArray files = this.object.forceArray("files");
        files.add(name);
        return this;
    }

    public PackageGenerator kind(PackageType kind) {
        this.object.add("type", kind.getCode());
        return this;
    }

    public static enum PackageType {
        CONFORMANCE,
        IG,
        CORE,
        EXAMPLES,
        GROUP,
        TOOL,
        IG_TEMPLATE;


        public String getCode() {
            switch (this) {
                case CONFORMANCE: {
                    return "Conformance";
                }
                case IG: {
                    return "IG";
                }
                case CORE: {
                    return "Core";
                }
                case EXAMPLES: {
                    return "Examples";
                }
                case GROUP: {
                    return "Group";
                }
                case TOOL: {
                    return "Tool";
                }
                case IG_TEMPLATE: {
                    return "IG-Template";
                }
            }
            throw new Error("Unknown Type");
        }

        String getOldCode() {
            switch (this) {
                case CONFORMANCE: {
                    return "xxx";
                }
                case IG: {
                    return "fhir.ig";
                }
                case CORE: {
                    return "fhir.core";
                }
                case EXAMPLES: {
                    return "fhir.examples";
                }
                case GROUP: {
                    return "fhir.group";
                }
                case TOOL: {
                    return "fhir.tool";
                }
                case IG_TEMPLATE: {
                    return "fhir.template";
                }
            }
            throw new Error("Unknown Type");
        }
    }
}

