/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.subtag.LanguageSubtagRegistry;

public class LanguageTag {
    private String code;
    private String language;
    private String script;
    private String region;
    private String variant;
    private String extension;
    private List<String> extLang;
    private List<String> privateUse;
    private LanguageSubtagRegistry registry;

    public LanguageTag(LanguageSubtagRegistry registry, String code) {
        this.registry = registry;
        this.code = code;
        if (!Utilities.noString(code)) {
            String[] parts = code.split("\\-");
            int c = 0;
            int t = parts.length;
            if (!registry.hasLanguage(parts[c])) {
                throw new FHIRException("Invalid Language code '" + parts[c] + "\"");
            }
            this.language = parts[c];
            ++c;
            for (int i = 1; i <= 3; ++i) {
                if (c >= t || !registry.hasExtLanguage(parts[c])) continue;
                if (this.extLang == null) {
                    this.extLang = new ArrayList<String>();
                }
                this.extLang.add(parts[c]);
                ++c;
            }
            if (c < t && registry.hasScript(parts[c])) {
                this.script = parts[c];
                ++c;
            }
            if (c < t && registry.hasRegion(parts[c])) {
                this.region = parts[c];
                ++c;
            }
            if (c < t && registry.hasVariant(parts[c])) {
                this.variant = parts[c];
                ++c;
            }
            while (c < t && parts[c].startsWith("x")) {
                if (this.privateUse == null) {
                    this.privateUse = new ArrayList<String>();
                }
                this.privateUse.add(parts[c]);
                ++c;
            }
            if (c < t) {
                throw new FHIRException("Unable to recognise part " + (c + 1) + " ('" + parts[c] + "') as a valid language part");
            }
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public String getRegion() {
        return this.region;
    }

    public String getVariant() {
        return this.variant;
    }

    public String getExtension() {
        return this.extension;
    }

    public List<String> getExtLang() {
        return this.extLang;
    }

    public List<String> getPrivateUse() {
        return this.privateUse;
    }

    public String present() {
        StringBuilder b = new StringBuilder();
        b.append(this.registry.getLanguage(this.language).getDisplay());
        if (this.region != null) {
            b.append("/");
            b.append(this.registry.getRegion(this.region).getDisplay());
        }
        if (this.script != null || this.variant != null) {
            CommaSeparatedStringBuilder cb = new CommaSeparatedStringBuilder();
            if (this.script != null) {
                cb.append("Script=" + this.registry.getScript(this.script).getDisplay());
                if (this.variant != null) {
                    cb.append("Variant=" + this.registry.getVariant(this.variant).getDisplay());
                }
                b.append(" (");
                b.append(cb.toString());
                b.append(")");
            }
        }
        return b.toString();
    }
}

