/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.i18n.LanguageFileProducer;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class JsonLangFileProducer
extends LanguageFileProducer {
    public JsonLangFileProducer(String rootFolder, String folderName, boolean useLangFolder) {
        super(rootFolder, folderName, useLangFolder);
    }

    public JsonLangFileProducer() {
    }

    @Override
    public LanguageFileProducer.LanguageProducerSession startSession(String id, String baseLang) throws IOException {
        return new JsonLangProducerSession(id, baseLang);
    }

    @Override
    public void finish() {
    }

    @Override
    public List<LanguageFileProducer.TranslationUnit> loadSource(InputStream source) throws IOException {
        ArrayList<LanguageFileProducer.TranslationUnit> list = new ArrayList<LanguageFileProducer.TranslationUnit>();
        JsonObject json = JsonParser.parseObject(source);
        for (JsonObject lang : json.forceArray("languages").asJsonObjects()) {
            for (JsonObject entry : lang.forceArray("entries").asJsonObjects()) {
                list.add(new LanguageFileProducer.TranslationUnit(lang.asString("targetLang"), entry.asString("id"), entry.asString("context"), entry.asString("source"), entry.asString("target")));
            }
        }
        return list;
    }

    private String getFileName(String id, String baseLang) throws IOException {
        return Utilities.path(this.getRootFolder(), this.getFolderName(), id + "-" + baseLang + ".json");
    }

    @Override
    public int fileCount() {
        return 1;
    }

    @Override
    public void produce(String id, String baseLang, String targetLang, List<LanguageFileProducer.TranslationUnit> translations, String filename) throws IOException {
        JsonObject json = new JsonObject();
        json.add("id", id);
        json.add("baseLang", baseLang);
        JsonObject lj = new JsonObject();
        json.forceArray("languages").add(lj);
        lj.add("targetLang", targetLang);
        for (LanguageFileProducer.TranslationUnit tu : translations) {
            JsonObject entry = new JsonObject();
            lj.forceArray("entries").add(entry);
            entry.add("id", tu.getId());
            if (tu.getContext() != null) {
                entry.add("context", tu.getContext());
            }
            if (tu.getOriginal() != null) {
                entry.add("original", tu.getOriginal());
            }
            entry.add("source", tu.getSrcText());
            entry.add("target", tu.getTgtText());
        }
        FileUtilities.stringToFile(JsonParser.compose((JsonElement)json, true), this.getTargetFileName(targetLang, filename));
    }

    public class JsonLangLanguageProducerLanguageSession
    extends LanguageFileProducer.LanguageProducerLanguageSession {
        private JsonObject json;

        public JsonLangLanguageProducerLanguageSession(String id, String baseLang, String targetLang, JsonObject parent) {
            super(JsonLangFileProducer.this, id, baseLang, targetLang);
            this.json = new JsonObject();
            parent.forceArray("languages").add(this.json);
            this.json.add("targetLang", targetLang);
        }

        @Override
        public void finish() throws IOException {
        }

        @Override
        public void entry(LanguageFileProducer.TextUnit unit) {
            JsonObject entry = new JsonObject();
            this.json.forceArray("entries").add(entry);
            entry.add("id", unit.getId());
            if (unit.getContext() != null) {
                entry.add("context", unit.getContext());
            }
            entry.add("source", unit.getSrcText());
            entry.add("target", unit.getTgtText());
        }
    }

    public class JsonLangProducerSession
    extends LanguageFileProducer.LanguageProducerSession {
        JsonObject json;

        public JsonLangProducerSession(String id, String baseLang) {
            super(JsonLangFileProducer.this, id, baseLang);
            this.json = new JsonObject();
            this.json.add("id", id);
            this.json.add("baseLang", baseLang);
        }

        @Override
        public LanguageFileProducer.LanguageProducerLanguageSession forLang(String targetLang) {
            return new JsonLangLanguageProducerLanguageSession(this.id, this.baseLang, targetLang, this.json);
        }

        @Override
        public void finish() throws IOException {
            try (FileOutputStream fs = ManagedFileAccess.outStream(JsonLangFileProducer.this.getFileName(this.id, this.baseLang));){
                JsonParser.compose((JsonElement)this.json, fs);
            }
        }
    }
}

