/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import com.ibm.icu.text.PluralRules;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class I18nBase {
    public static final String PLURAL_SUFFIX = "PLURAL";
    public static final String KEY_DELIMITER = "_";
    protected Locale locale;
    private ResourceBundle messages;
    private PluralRules pluralRules;
    private boolean warnAboutMissingMessages = true;

    public Locale getLocale() {
        if (Objects.nonNull(this.locale)) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setValidationMessageLanguage(this.getLocale());
    }

    private void checkResourceBundleIsLoaded() {
        if (this.messages == null) {
            this.setValidationMessageLanguage(this.getLocale());
        }
    }

    private void checkPluralRulesAreLoaded() {
        if (this.pluralRules == null) {
            this.setPluralRules(this.getLocale());
        }
    }

    private boolean messageExistsForLocale(String message, boolean hasArgs) {
        this.checkResourceBundleIsLoaded();
        if (!(this.messageKeyExistsForLocale(message) || message.contains(" ") || !this.warnAboutMissingMessages || !hasArgs && message.contains(" "))) {
            System.out.println("Attempting to localize " + this.typeOfString() + " " + message + ", but no such equivalent message exists for the locale " + this.getLocale());
        }
        return this.messageKeyExistsForLocale(message);
    }

    protected String typeOfString() {
        return "message";
    }

    protected boolean messageKeyExistsForLocale(String message) {
        return this.messages.containsKey(message);
    }

    public String formatMessage(String theMessage, Object ... theMessageArguments) {
        return this.formatMessageForLocale(theMessage, theMessageArguments);
    }

    protected String getPluralKey(Integer number, String baseKey) {
        return baseKey + KEY_DELIMITER + this.pluralRules.select((double)number.intValue());
    }

    protected Set<String> getPluralKeys(String baseKey) {
        return this.pluralRules.getKeywords().stream().map(entry -> baseKey + KEY_DELIMITER + entry).collect(Collectors.toSet());
    }

    protected Set<String> getPluralSuffixes() {
        return Collections.unmodifiableSet(this.pluralRules.getKeywords());
    }

    protected String getRootKeyFromPlural(@Nonnull String pluralKey) {
        this.checkPluralRulesAreLoaded();
        for (String keyword : this.pluralRules.getKeywords()) {
            String suffix = KEY_DELIMITER + keyword;
            if (!pluralKey.endsWith(suffix)) continue;
            return pluralKey.substring(0, pluralKey.length() - suffix.length());
        }
        return null;
    }

    private String formatMessageForLocale(String theMessage, Object ... theMessageArguments) {
        String message = theMessage;
        if (this.messageExistsForLocale(theMessage, theMessageArguments != null && theMessageArguments.length > 0)) {
            message = Objects.nonNull(theMessageArguments) && theMessageArguments.length > 0 ? MessageFormat.format(this.messages.getString(theMessage).trim(), theMessageArguments) : MessageFormat.format(this.messages.getString(theMessage).trim(), new Object[]{null});
        }
        return message;
    }

    public String formatMessagePlural(Integer plural, String theMessage, Object ... theMessageArguments) {
        Object[] args = new Object[theMessageArguments.length + 1];
        args[0] = plural;
        for (int i = 0; i < theMessageArguments.length; ++i) {
            args[i + 1] = theMessageArguments[i];
        }
        this.checkPluralRulesAreLoaded();
        String pluralKey = this.getPluralKey(plural, theMessage);
        return this.formatMessageForLocale(pluralKey, args);
    }

    public void setValidationMessageLanguage(Locale locale) {
        this.messages = ResourceBundle.getBundle(this.getMessagesSourceFileName(), locale);
    }

    protected String getMessagesSourceFileName() {
        return "Messages";
    }

    public void setPluralRules(Locale locale) {
        this.pluralRules = PluralRules.forLocale((Locale)locale);
    }

    public boolean isWarnAboutMissingMessages() {
        return this.warnAboutMissingMessages;
    }

    public void setWarnAboutMissingMessages(boolean warnAboutMissingMessages) {
        this.warnAboutMissingMessages = warnAboutMissingMessages;
    }
}

