/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

public class OIDUtilities {
    private static final String OID_REGEX = "[0-2](\\.(0|[1-9][0-9]*))+";

    public static String getUriForOid(String r) {
        if (r == null) {
            return null;
        }
        if (r.equals("2.16.840.1.113883.6.96")) {
            return "http://snomed.info/sct";
        }
        if (r.equals("2.16.840.1.113883.6.1")) {
            return "http://loinc.org";
        }
        if (r.equals("2.16.840.1.113883.6.8")) {
            return "http://unitsofmeasure.org";
        }
        if (r.equals("2.16.840.1.113883.6.3")) {
            return "http://hl7.org/fhir/sid/icd-10";
        }
        if (r.equals("2.16.840.1.113883.6.42")) {
            return "http://hl7.org/fhir/sid/icd-9";
        }
        if (r.equals("2.16.840.1.113883.6.104")) {
            return "http://hl7.org/fhir/sid/icd-9";
        }
        if (r.equals("2.16.840.1.113883.6.103")) {
            return "http://hl7.org/fhir/sid/icd-9";
        }
        if (r.equals("2.16.840.1.113883.6.73")) {
            return "http://www.whocc.no/atc";
        }
        if (r.equals("2.16.840.1.113883.3.26.1.1")) {
            return "http://ncimeta.nci.nih.gov";
        }
        if (r.equals("2.16.840.1.113883.3.26.1.1.1")) {
            return "http://ncimeta.nci.nih.gov";
        }
        if (r.equals("2.16.840.1.113883.6.88")) {
            return "http://www.nlm.nih.gov/research/umls/rxnorm";
        }
        if (r.equals("2.16.840.1.113883.6.59")) {
            return "http://hl7.org/fhir/sid/cvx";
        }
        if (r.equals("2.16.840.1.113883.12.292")) {
            return "http://hl7.org/fhir/sid/cvx";
        }
        if (r.equals("2.16.840.1.113883.6.12")) {
            return "http://www.ama-assn.org/go/cpt";
        }
        return null;
    }

    public static String oidTail(String id) {
        if (id == null || !id.contains(".")) {
            return id;
        }
        return id.substring(id.lastIndexOf(".") + 1);
    }

    public static String oidRoot(String id) {
        if (id == null || !id.contains(".")) {
            return id;
        }
        return id.substring(0, id.indexOf("."));
    }

    public static boolean isValidOID(String oid) {
        return oid.matches(OID_REGEX);
    }
}

