/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.commonmark.renderer.text.TextContentRenderer;
import org.hl7.fhir.utilities.Utilities;

public class MarkDownProcessor {
    private Dialect dialect;

    public MarkDownProcessor(Dialect dialect) {
        this.dialect = dialect;
    }

    public String process(String source, String context) {
        if (source == null) {
            return null;
        }
        if ("".equals(source)) {
            return "";
        }
        switch (this.dialect) {
            case DARING_FIREBALL: {
                return Processor.process((String)source, (Configuration)Configuration.builder().enableSafeMode().enablePanicMode().build());
            }
            case COMMON_MARK: {
                return this.processCommonMark(MarkDownProcessor.preProcess(source));
            }
        }
        throw new Error("Unknown Markdown Dialect: " + this.dialect.toString() + " at " + context);
    }

    public boolean isProbablyMarkdown(String content, boolean mdIfParagrapghs) {
        String[] lines;
        if (content == null) {
            return false;
        }
        if (mdIfParagrapghs && content.contains("\n")) {
            return true;
        }
        for (String s : lines = content.split("\\r?\\n")) {
            if (s.startsWith("* ") || this.isHeading(s) || s.startsWith("1. ") || s.startsWith("    ")) {
                return true;
            }
            if (s.contains("```") || s.contains("~~~") || s.contains("[[[")) {
                return true;
            }
            if (this.hasLink(s)) {
                return true;
            }
            if (!this.hasTextSpecial(s, '*') && !this.hasTextSpecial(s, '_')) continue;
            return true;
        }
        return false;
    }

    private boolean isHeading(String s) {
        if (s.length() > 7 && s.startsWith("###### ") && !Character.isWhitespace(s.charAt(7))) {
            return true;
        }
        if (s.length() > 6 && s.startsWith("##### ") && !Character.isWhitespace(s.charAt(6))) {
            return true;
        }
        if (s.length() > 5 && s.startsWith("#### ") && !Character.isWhitespace(s.charAt(5))) {
            return true;
        }
        if (s.length() > 4 && s.startsWith("### ") && !Character.isWhitespace(s.charAt(4))) {
            return true;
        }
        return s.length() > 3 && s.startsWith("## ") && !Character.isWhitespace(s.charAt(3));
    }

    private boolean hasLink(String s) {
        int left = -1;
        int mid = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                mid = -1;
                left = i;
                continue;
            }
            if (left > -1 && i < s.length() - 1 && c == ']' && s.charAt(i + 1) == '(') {
                mid = i;
                continue;
            }
            if (left > -1 && c == ']') {
                left = -1;
                continue;
            }
            if (left > -1 && mid > -1 && c == ')') {
                return true;
            }
            if ((mid <= -1 || c != '[') && c != ']' && (c != '(' || i <= mid + 1)) continue;
            left = -1;
            mid = -1;
        }
        Pattern autolinkPattern = Pattern.compile("<[a-z]+:[^\\s]+>");
        Matcher autolinkMatcher = autolinkPattern.matcher(s);
        return autolinkMatcher.find();
    }

    private boolean hasTextSpecial(String s, char c) {
        boolean second = false;
        for (int i = 0; i < s.length(); ++i) {
            char next;
            char prev = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char c2 = next = i < s.length() - 1 ? (char)s.charAt(i + 1) : (char)' ';
            if (s.charAt(i) != c) continue;
            if (second) {
                if (Character.isWhitespace(next) && (this.isPunctation(prev) || Character.isLetterOrDigit(prev))) {
                    return true;
                }
                second = false;
                continue;
            }
            if (!Character.isWhitespace(prev) || !this.isPunctation(next) && !Character.isLetterOrDigit(next)) continue;
            second = true;
        }
        return false;
    }

    private boolean isPunctation(char ch) {
        return Utilities.existsInList(ch, 46, 44, 33, 63);
    }

    public static String preProcess(String source) {
        String processed = source.replaceAll("(?<!\\\\)<(\\/)?([A-Za-z][A-Za-z0-9-]*[\\s>])", "\\\\<$1$2");
        processed = processed.replaceAll("<(!|\\?)", "\\\\<$1");
        return processed;
    }

    private String processCommonMark(String source) {
        Set<Extension> extensions = Collections.singleton(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(source);
        HtmlRenderer renderer = HtmlRenderer.builder().escapeHtml(true).extensions(extensions).build();
        String html = renderer.render(document);
        html = html.replace("<table>", "<table class=\"grid\">");
        return html;
    }

    public static boolean isSimpleMarkdown(String description) {
        return !description.contains("\n");
    }

    public static String makeStringSafeAsMarkdown(String content) {
        StringBuilder b = new StringBuilder();
        for (char c : content.toCharArray()) {
            if (MarkDownProcessor.isEscableMarkdownChar(c)) {
                b.append('\\');
            }
            b.append(c);
        }
        return b.toString();
    }

    private static boolean isEscableMarkdownChar(char c) {
        switch (c) {
            case '#': 
            case '&': 
            case '*': 
            case '<': 
            case '>': 
            case '[': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    public static String makeMarkdownForString(String content) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\\' && i != content.length() - 1 && MarkDownProcessor.isEscableMarkdownChar(content.charAt(i + 1))) continue;
            b.append(c);
        }
        return b.toString();
    }

    public static String markdownToPlainText(String source) {
        if (source == null) {
            return "";
        }
        Set<Extension> extensions = Collections.singleton(TablesExtension.create());
        Parser parser = Parser.builder().extensions(extensions).build();
        Node document = parser.parse(source);
        TextContentRenderer renderer = TextContentRenderer.builder().stripNewlines(true).extensions(extensions).build();
        String text = renderer.render(document);
        return text;
    }

    public static enum Dialect {
        DARING_FIREBALL,
        COMMON_MARK;

    }
}

