/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;

public class JsonNumber
extends JsonPrimitive {
    private String value;

    public JsonNumber(String value) {
        this.value = value;
    }

    public JsonNumber(int value) {
        this.value = Integer.toString(value);
    }

    public JsonNumber(long value) {
        this.value = Long.toString(value);
    }

    private JsonNumber() {
    }

    @Override
    public JsonElementType type() {
        return JsonElementType.NUMBER;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public Integer getInteger() {
        if (Utilities.isInteger(this.value)) {
            return Integer.parseInt(this.value);
        }
        return null;
    }

    @Override
    protected JsonElement copy(JsonElement other) {
        this.value = ((JsonNumber)other).value;
        return this;
    }

    @Override
    protected JsonElement make() {
        return new JsonNumber();
    }
}

