/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.util.ArrayList;
import java.util.List;

public class PackageServer {
    private String url;
    private PackageServerAuthenticationMode mode;
    private String username;
    private String password;
    public static final String PRIMARY_SERVER = "http://packages.fhir.org";
    public static final String SECONDARY_SERVER = "https://packages2.fhir.org/packages";

    public PackageServer(String url) {
        this.url = url;
        this.mode = PackageServerAuthenticationMode.NONE;
    }

    public String getUrl() {
        return this.url;
    }

    public PackageServerAuthenticationMode getMode() {
        return this.mode;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static PackageServer primaryServer() {
        return new PackageServer(PRIMARY_SERVER);
    }

    public static PackageServer secondaryServer() {
        return new PackageServer(SECONDARY_SERVER);
    }

    public static List<PackageServer> publicServers() {
        ArrayList<PackageServer> servers = new ArrayList<PackageServer>();
        servers.add(PackageServer.primaryServer());
        servers.add(PackageServer.secondaryServer());
        return servers;
    }

    public static enum PackageServerAuthenticationMode {
        NONE;

    }
}

