/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.client.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.utils.OperationOutcomeUtilities;
import org.hl7.fhir.r5.utils.ResourceUtilities;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.client.ResourceFormat;
import org.hl7.fhir.r5.utils.client.network.ResourceRequest;
import org.hl7.fhir.utilities.MimeType;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPHeaderUtil;
import org.hl7.fhir.utilities.http.HTTPRequest;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedFhirWebAccessor;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.xhtml.XhtmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirRequestBuilder {
    private static final Logger log = LoggerFactory.getLogger(FhirRequestBuilder.class);
    protected static final String LOCATION_HEADER = "location";
    protected static final String CONTENT_LOCATION_HEADER = "content-location";
    protected static final String DEFAULT_CHARSET = "UTF-8";
    private final HTTPRequest httpRequest;
    private String resourceFormat = null;
    private Iterable<HTTPHeader> headers = null;
    private String message = null;
    private int retryCount = 1;
    private long timeout = 5000L;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private ToolingClientLogger logger = null;
    private String source;

    public FhirRequestBuilder(HTTPRequest httpRequest, String source) {
        this.source = source;
        this.httpRequest = httpRequest;
    }

    protected static HTTPRequest formatHeaders(HTTPRequest request, String format, Iterable<HTTPHeader> headers) {
        ArrayList allHeaders = new ArrayList();
        request.getHeaders().forEach(allHeaders::add);
        if (format != null) {
            FhirRequestBuilder.getResourceFormatHeaders(request, format).forEach(allHeaders::add);
        }
        if (headers != null) {
            headers.forEach(allHeaders::add);
        }
        return request.withHeaders(allHeaders);
    }

    protected static Iterable<HTTPHeader> getResourceFormatHeaders(HTTPRequest httpRequest, String format) {
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>();
        headers.add(new HTTPHeader("Accept", format));
        if (httpRequest.getMethod() == HTTPRequest.HttpMethod.PUT || httpRequest.getMethod() == HTTPRequest.HttpMethod.POST || httpRequest.getMethod() == HTTPRequest.HttpMethod.PATCH) {
            headers.add(new HTTPHeader("Content-Type", format + ";charset=UTF-8"));
        }
        return headers;
    }

    protected static boolean hasError(OperationOutcome oo) {
        return oo.getIssue().stream().anyMatch(issue -> issue.getSeverity() == OperationOutcome.IssueSeverity.ERROR || issue.getSeverity() == OperationOutcome.IssueSeverity.FATAL);
    }

    protected static String getLocationHeader(Iterable<HTTPHeader> headers) {
        String locationHeader = HTTPHeaderUtil.getSingleHeader(headers, (String)LOCATION_HEADER);
        if (locationHeader != null) {
            return locationHeader;
        }
        return HTTPHeaderUtil.getSingleHeader(headers, (String)CONTENT_LOCATION_HEADER);
    }

    protected ManagedFhirWebAccessor getManagedWebAccessor() {
        return ManagedWebAccess.fhirAccessor().withRetries(this.retryCount).withTimeout(this.timeout, this.timeoutUnit).withLogger(this.logger);
    }

    public FhirRequestBuilder withResourceFormat(String resourceFormat) {
        this.resourceFormat = resourceFormat;
        return this;
    }

    public FhirRequestBuilder withHeaders(Iterable<HTTPHeader> headers) {
        this.headers = headers;
        return this;
    }

    public FhirRequestBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    public FhirRequestBuilder withRetryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public FhirRequestBuilder withLogger(ToolingClientLogger logger) {
        this.logger = logger;
        return this;
    }

    public FhirRequestBuilder withTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    public <T extends Resource> ResourceRequest<T> execute() throws IOException {
        HTTPRequest requestWithHeaders = FhirRequestBuilder.formatHeaders(this.httpRequest, this.resourceFormat, this.headers);
        HTTPResult response = this.getManagedWebAccessor().httpCall(requestWithHeaders);
        T resource = this.unmarshalReference(response, this.resourceFormat, null);
        return new ResourceRequest<T>(resource, response.getCode(), FhirRequestBuilder.getLocationHeader(response.getHeaders()));
    }

    public Bundle executeAsBatch() throws IOException {
        HTTPRequest requestWithHeaders = FhirRequestBuilder.formatHeaders(this.httpRequest, this.resourceFormat, null);
        HTTPResult response = this.getManagedWebAccessor().httpCall(requestWithHeaders);
        return this.unmarshalFeed(response, this.resourceFormat);
    }

    protected <T extends Resource> T unmarshalReference(HTTPResult response, String format, String resourceType) {
        String body;
        boolean ok;
        int code = response.getCode();
        boolean bl = ok = code >= 200 && code < 300;
        if (response.getContent() == null) {
            if (!ok) {
                if (Utilities.noString((String)response.getMessage())) {
                    throw new EFhirClientException(code, response.getMessagefromCode());
                }
                throw new EFhirClientException(code, response.getMessage());
            }
            return null;
        }
        Resource resource = null;
        try {
            body = response.getContentAsString();
            String contentType = HTTPHeaderUtil.getSingleHeader((Iterable)response.getHeaders(), (String)"Content-Type");
            if (contentType == null) {
                if (ok) {
                    resource = this.getParser(format).parse(body);
                } else {
                    log.warn("Got error response with no Content-Type from " + this.source + " with status " + code);
                    log.warn(body);
                    resource = OperationOutcomeUtilities.outcomeFromTextError(body);
                }
            } else {
                if (contentType.contains(";")) {
                    contentType = contentType.substring(0, contentType.indexOf(";"));
                }
                switch (contentType) {
                    case "application/json": 
                    case "application/fhir+json": {
                        if (!format.contains("json")) {
                            log.warn("Got json response expecting " + format + " from " + this.source + " with status " + code);
                        }
                        resource = this.getParser(ResourceFormat.RESOURCE_JSON.getHeader()).parse(body);
                        break;
                    }
                    case "application/xml": 
                    case "application/fhir+xml": 
                    case "text/xml": {
                        if (!format.contains("xml")) {
                            log.warn("Got xml response expecting " + format + " from " + this.source + " with status " + code);
                        }
                        resource = this.getParser(ResourceFormat.RESOURCE_XML.getHeader()).parse(body);
                        break;
                    }
                    case "text/plain": {
                        resource = OperationOutcomeUtilities.outcomeFromTextError(body);
                        break;
                    }
                    case "text/html": {
                        resource = OperationOutcomeUtilities.outcomeFromTextError(XhtmlUtils.convertHtmlToText((String)response.getContentAsString(), (String)this.source));
                        break;
                    }
                    default: {
                        log.warn("Got content-type '" + contentType + "' from " + this.source);
                        log.warn(body);
                        resource = OperationOutcomeUtilities.outcomeFromTextError(body);
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new EFhirClientException(code, "Error reading Http Response from " + this.source + ":" + ioe.getMessage(), ioe);
        }
        catch (Exception e) {
            throw new EFhirClientException(code, "Error parsing response message from " + this.source + ": " + e.getMessage(), e);
        }
        if (!(!(resource instanceof OperationOutcome) || "OperationOutcome".equals(resourceType) && ok)) {
            OperationOutcome error = (OperationOutcome)resource;
            if (FhirRequestBuilder.hasError((OperationOutcome)resource)) {
                throw new EFhirClientException(code, "Error from " + this.source + ": " + ResourceUtilities.getErrorDescription(error), error);
            }
            log.warn("Got OperationOutcome with no error from " + this.source + " with status " + code);
            log.warn(body);
            return null;
        }
        if (resource == null) {
            log.error("No resource from " + this.source + " with status " + code);
            log.error(body);
            return null;
        }
        if (resourceType != null && !resource.fhirType().equals(resourceType)) {
            throw new EFhirClientException(0, "Error parsing response message from " + this.source + ": Found an " + resource.fhirType() + " looking for a " + resourceType);
        }
        return (T)resource;
    }

    protected Bundle unmarshalFeed(HTTPResult response, String format) {
        return (Bundle)this.unmarshalReference(response, format, "Bundle");
    }

    protected IParser getParser(String format) {
        MimeType mt;
        if (StringUtils.isBlank((CharSequence)format)) {
            format = ResourceFormat.RESOURCE_XML.getHeader();
        }
        if ((mt = new MimeType(format)).getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_JSON.getHeader())) {
            return new JsonParser();
        }
        if (mt.getBase().equalsIgnoreCase(ResourceFormat.RESOURCE_XML.getHeader())) {
            return new XmlParser();
        }
        throw new EFhirClientException(0, "Invalid format: " + format);
    }

    public ToolingClientLogger getLogger() {
        return this.logger;
    }

    public void setLogger(ToolingClientLogger logger) {
        this.logger = logger;
    }
}

