/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.tools;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="TestCases")
public class TestCases
extends Resource
implements ICompositeType {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for these tests, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify test tests.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the test set (semver)", formalDefinition="The identifier that is used to identify this version of these tests. Version must use SemVer")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for these tests", formalDefinition="A natural language name identifying the tests. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="description", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="General Description of these tests", formalDefinition="General description of these teats.")
    protected MarkdownType description;
    @Child(name="runner", type={UrlType.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="URL Documentation for a runner that executes these tests", formalDefinition="URL of documentation that explains how a runner would read these tests, and use them to actually test out a tool.")
    protected UrlType runner;
    @Child(name="mode", type={Base.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A mode that can be passed to runner - affects test content", formalDefinition="A mode that can be passed to a runner running these these tests, that affects test content and influences how the tests are executed or evaulated (or even if they run)")
    protected List<TestCasesModeComponent> modeList;
    @Child(name="suite", type={Base.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A suite of tests that share a common set up", formalDefinition="A suite of tests that all share a common set up, and can be executed as a group")
    protected List<TestCasesSuiteComponent> suiteList;
    private static final long serialVersionUID = -1998407452L;

    public TestCases() {
    }

    public TestCases(String runner) {
        this.setRunner(runner);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestCases.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public TestCases setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public TestCases setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestCases.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public TestCases setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public TestCases setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestCases.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public TestCases setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public TestCases setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestCases.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public TestCases setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public TestCases setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public UrlType getRunnerElement() {
        if (this.runner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TestCases.runner");
            }
            if (Configuration.doAutoCreate()) {
                this.runner = new UrlType();
            }
        }
        return this.runner;
    }

    public boolean hasRunnerElement() {
        return this.runner != null && !this.runner.isEmpty();
    }

    public boolean hasRunner() {
        return this.runner != null && !this.runner.isEmpty();
    }

    public TestCases setRunnerElement(UrlType value) {
        this.runner = value;
        return this;
    }

    public String getRunner() {
        return this.runner == null ? null : (String)this.runner.getValue();
    }

    public TestCases setRunner(String value) {
        if (this.runner == null) {
            this.runner = new UrlType();
        }
        this.runner.setValue(value);
        return this;
    }

    public List<TestCasesModeComponent> getModeList() {
        if (this.modeList == null) {
            this.modeList = new ArrayList<TestCasesModeComponent>();
        }
        return this.modeList;
    }

    public TestCases setModeList(List<TestCasesModeComponent> theMode) {
        this.modeList = theMode;
        return this;
    }

    public boolean hasMode() {
        if (this.modeList == null) {
            return false;
        }
        for (TestCasesModeComponent item : this.modeList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestCases addMode(TestCasesModeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.modeList == null) {
            this.modeList = new ArrayList<TestCasesModeComponent>();
        }
        this.modeList.add(t);
        return this;
    }

    public List<TestCasesSuiteComponent> getSuiteList() {
        if (this.suiteList == null) {
            this.suiteList = new ArrayList<TestCasesSuiteComponent>();
        }
        return this.suiteList;
    }

    public TestCases setSuiteList(List<TestCasesSuiteComponent> theSuite) {
        this.suiteList = theSuite;
        return this;
    }

    public boolean hasSuite() {
        if (this.suiteList == null) {
            return false;
        }
        for (TestCasesSuiteComponent item : this.suiteList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TestCases addSuite(TestCasesSuiteComponent t) {
        if (t == null) {
            return this;
        }
        if (this.suiteList == null) {
            this.suiteList = new ArrayList<TestCasesSuiteComponent>();
        }
        this.suiteList.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("url", "uri", "An absolute URI that is used to identify test tests.", 0, 1, this.url));
        children.add(new Property("version", "string", "The identifier that is used to identify this version of these tests. Version must use SemVer", 0, 1, this.version));
        children.add(new Property("name", "string", "A natural language name identifying the tests. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property("description", "markdown", "General description of these teats.", 0, 1, this.description));
        children.add(new Property("runner", "url", "URL of documentation that explains how a runner would read these tests, and use them to actually test out a tool.", 0, 1, this.runner));
        children.add(new Property("mode", "Base", "A mode that can be passed to a runner running these these tests, that affects test content and influences how the tests are executed or evaulated (or even if they run)", 0, Integer.MAX_VALUE, this.modeList));
        children.add(new Property("suite", "Base", "A suite of tests that all share a common set up, and can be executed as a group", 0, Integer.MAX_VALUE, this.suiteList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property("url", "uri", "An absolute URI that is used to identify test tests.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property("version", "string", "The identifier that is used to identify this version of these tests. Version must use SemVer", 0, 1, this.version);
            }
            case 3373707: {
                return new Property("name", "string", "A natural language name identifying the tests. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -1724546052: {
                return new Property("description", "markdown", "General description of these teats.", 0, 1, this.description);
            }
            case -919806160: {
                return new Property("runner", "url", "URL of documentation that explains how a runner would read these tests, and use them to actually test out a tool.", 0, 1, this.runner);
            }
            case 0x3339A3: {
                return new Property("mode", "Base", "A mode that can be passed to a runner running these these tests, that affects test content and influences how the tests are executed or evaulated (or even if they run)", 0, Integer.MAX_VALUE, this.modeList);
            }
            case 109795064: {
                return new Property("suite", "Base", "A suite of tests that all share a common set up, and can be executed as a group", 0, Integer.MAX_VALUE, this.suiteList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.description;
                }
                return baseArray;
            }
            case -919806160: {
                Base[] baseArray;
                if (this.runner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.runner;
                }
                return baseArray;
            }
            case 0x3339A3: {
                return this.modeList == null ? new Base[]{} : this.modeList.toArray(new Base[this.modeList.size()]);
            }
            case 109795064: {
                return this.suiteList == null ? new Base[]{} : this.suiteList.toArray(new Base[this.suiteList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -919806160: {
                this.runner = TypeConvertor.castToUrl(value);
                return value;
            }
            case 0x3339A3: {
                this.getModeList().add((TestCasesModeComponent)value);
                return value;
            }
            case 109795064: {
                this.getSuiteList().add((TestCasesSuiteComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("runner")) {
            this.runner = TypeConvertor.castToUrl(value);
        } else if (name.equals("mode")) {
            this.getModeList().add((TestCasesModeComponent)value);
        } else if (name.equals("suite")) {
            this.getSuiteList().add((TestCasesSuiteComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -919806160: {
                return this.getRunnerElement();
            }
            case 0x3339A3: {
                throw new Error("Unable to make an instance of the abstract property 'mode'");
            }
            case 109795064: {
                throw new Error("Unable to make an instance of the abstract property 'suite'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -919806160: {
                return new String[]{"url"};
            }
            case 0x3339A3: {
                return new String[]{"Base"};
            }
            case 109795064: {
                return new String[]{"Base"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a singleton property TestCases.url");
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a singleton property TestCases.version");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property TestCases.name");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property TestCases.description");
        }
        if (name.equals("runner")) {
            throw new FHIRException("Cannot call addChild on a singleton property TestCases.runner");
        }
        if (name.equals("mode")) {
            throw new FHIRException("Cannot call addChild on an abstract type TestCases.mode");
        }
        if (name.equals("suite")) {
            throw new FHIRException("Cannot call addChild on an abstract type TestCases.suite");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TestCases";
    }

    @Override
    public TestCases copy() {
        TestCases dst = new TestCases();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TestCases dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.description = this.description == null ? null : this.description.copy();
        UrlType urlType = dst.runner = this.runner == null ? null : this.runner.copy();
        if (this.modeList != null) {
            dst.modeList = new ArrayList<TestCasesModeComponent>();
            for (TestCasesModeComponent testCasesModeComponent : this.modeList) {
                dst.modeList.add(testCasesModeComponent.copy());
            }
        }
        if (this.suiteList != null) {
            dst.suiteList = new ArrayList<TestCasesSuiteComponent>();
            for (TestCasesSuiteComponent testCasesSuiteComponent : this.suiteList) {
                dst.suiteList.add(testCasesSuiteComponent.copy());
            }
        }
    }

    protected TestCases typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TestCases)) {
            return false;
        }
        TestCases o = (TestCases)other_;
        return TestCases.compareDeep(this.url, o.url, true) && TestCases.compareDeep(this.version, o.version, true) && TestCases.compareDeep(this.name, o.name, true) && TestCases.compareDeep(this.description, o.description, true) && TestCases.compareDeep(this.runner, o.runner, true) && TestCases.compareDeep(this.modeList, o.modeList, true) && TestCases.compareDeep(this.suiteList, o.suiteList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TestCases)) {
            return false;
        }
        TestCases o = (TestCases)other_;
        return TestCases.compareValues(this.url, o.url, true) && TestCases.compareValues(this.version, o.version, true) && TestCases.compareValues(this.name, o.name, true) && TestCases.compareValues(this.description, o.description, true) && TestCases.compareValues(this.runner, o.runner, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.version, this.name, this.description, this.runner, this.modeList, this.suiteList});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Custom;
    }

    public String getCustomResourceName() {
        return "TestCases";
    }

    @Block
    public static class TestCasesModeComponent
    extends LogicalBase {
        @Child(name="code", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The code that identifies the mode", formalDefinition="The code by which the mode is identified when passed to runner")
        protected StringType code;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of what this mode exists / why it was defined", formalDefinition="Description of what this mode does / why it was defined. This should explain to a tester when they should use the mode")
        protected StringType description;
        private static final long serialVersionUID = 1295492279L;

        public TestCasesModeComponent() {
        }

        public TestCasesModeComponent(String code) {
            this.setCode(code);
        }

        public StringType getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesModeComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new StringType();
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public TestCasesModeComponent setCodeElement(StringType value) {
            this.code = value;
            return this;
        }

        public String getCode() {
            return this.code == null ? null : (String)this.code.getValue();
        }

        public TestCasesModeComponent setCode(String value) {
            if (this.code == null) {
                this.code = new StringType();
            }
            this.code.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesModeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestCasesModeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestCasesModeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "string", "The code by which the mode is identified when passed to runner", 0, 1, this.code));
            children.add(new Property("description", "string", "Description of what this mode does / why it was defined. This should explain to a tester when they should use the mode", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "string", "The code by which the mode is identified when passed to runner", 0, 1, this.code);
                }
                case -1724546052: {
                    return new Property("description", "string", "Description of what this mode does / why it was defined. This should explain to a tester when they should use the mode", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.mode.code");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.mode.description");
            }
            return super.addChild(name);
        }

        @Override
        public TestCasesModeComponent copy() {
            TestCasesModeComponent dst = new TestCasesModeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestCasesModeComponent dst) {
            super.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.description = this.description == null ? null : this.description.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesModeComponent)) {
                return false;
            }
            TestCasesModeComponent o = (TestCasesModeComponent)other_;
            return TestCasesModeComponent.compareDeep(this.code, o.code, true) && TestCasesModeComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesModeComponent)) {
                return false;
            }
            TestCasesModeComponent o = (TestCasesModeComponent)other_;
            return TestCasesModeComponent.compareValues(this.code, o.code, true) && TestCasesModeComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.description});
        }

        @Override
        public String fhirType() {
            return "TestCases.mode";
        }
    }

    @Block
    public static class TestCasesSuiteComponent
    extends LogicalBase {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of this suite - unique in the TestCases resource", formalDefinition="The name by which this suite is known by in the test system. The name must be unique in the amongst the suites")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of what this suite does / why it was defined", formalDefinition="Description of what this suite does / why it was defined. This should explain to a tester what they should know when deciding which tests to run")
        protected StringType description;
        @Child(name="mode", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mode required to run this suite", formalDefinition="If this mode is not passed to the runner, then this suite will not be run")
        protected CodeType mode;
        @Child(name="resource", type={Base.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resources used in the tests in this suite", formalDefinition="The resources used in the tests in this suite. How exactly they are used depends on the definition of the runner")
        protected List<TestCasesSuiteResourceComponent> resourceList;
        @Child(name="parameter", type={Base.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Parameter passed to the runner", formalDefinition="A parameter passed to the runner when executing tests. Which parameters are valid, and how exactly the parameter is used are used depends on the definition of the runner")
        protected List<TestCasesSuiteParameterComponent> parameterList;
        @Child(name="test", type={Base.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A test in the test suite", formalDefinition="An actual test in the test suite")
        protected List<TestCasesSuiteTestComponent> testList;
        private static final long serialVersionUID = 622063903L;

        public TestCasesSuiteComponent() {
        }

        public TestCasesSuiteComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestCasesSuiteComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestCasesSuiteComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestCasesSuiteComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestCasesSuiteComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeType getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeType();
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public TestCasesSuiteComponent setModeElement(CodeType value) {
            this.mode = value;
            return this;
        }

        public String getMode() {
            return this.mode == null ? null : (String)this.mode.getValue();
        }

        public TestCasesSuiteComponent setMode(String value) {
            if (Utilities.noString((String)value)) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new CodeType();
                }
                this.mode.setValue(value);
            }
            return this;
        }

        public List<TestCasesSuiteResourceComponent> getResourceList() {
            if (this.resourceList == null) {
                this.resourceList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            return this.resourceList;
        }

        public TestCasesSuiteComponent setResourceList(List<TestCasesSuiteResourceComponent> theResource) {
            this.resourceList = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resourceList == null) {
                return false;
            }
            for (TestCasesSuiteResourceComponent item : this.resourceList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCasesSuiteComponent addResource(TestCasesSuiteResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resourceList == null) {
                this.resourceList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            this.resourceList.add(t);
            return this;
        }

        public List<TestCasesSuiteParameterComponent> getParameterList() {
            if (this.parameterList == null) {
                this.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
            }
            return this.parameterList;
        }

        public TestCasesSuiteComponent setParameterList(List<TestCasesSuiteParameterComponent> theParameter) {
            this.parameterList = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameterList == null) {
                return false;
            }
            for (TestCasesSuiteParameterComponent item : this.parameterList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCasesSuiteComponent addParameter(TestCasesSuiteParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameterList == null) {
                this.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
            }
            this.parameterList.add(t);
            return this;
        }

        public List<TestCasesSuiteTestComponent> getTestList() {
            if (this.testList == null) {
                this.testList = new ArrayList<TestCasesSuiteTestComponent>();
            }
            return this.testList;
        }

        public TestCasesSuiteComponent setTestList(List<TestCasesSuiteTestComponent> theTest) {
            this.testList = theTest;
            return this;
        }

        public boolean hasTest() {
            if (this.testList == null) {
                return false;
            }
            for (TestCasesSuiteTestComponent item : this.testList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCasesSuiteComponent addTest(TestCasesSuiteTestComponent t) {
            if (t == null) {
                return this;
            }
            if (this.testList == null) {
                this.testList = new ArrayList<TestCasesSuiteTestComponent>();
            }
            this.testList.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name by which this suite is known by in the test system. The name must be unique in the amongst the suites", 0, 1, this.name));
            children.add(new Property("description", "string", "Description of what this suite does / why it was defined. This should explain to a tester what they should know when deciding which tests to run", 0, 1, this.description));
            children.add(new Property("mode", "code", "If this mode is not passed to the runner, then this suite will not be run", 0, 1, this.mode));
            children.add(new Property("resource", "Base", "The resources used in the tests in this suite. How exactly they are used depends on the definition of the runner", 0, Integer.MAX_VALUE, this.resourceList));
            children.add(new Property("parameter", "Base", "A parameter passed to the runner when executing tests. Which parameters are valid, and how exactly the parameter is used are used depends on the definition of the runner", 0, Integer.MAX_VALUE, this.parameterList));
            children.add(new Property("test", "Base", "An actual test in the test suite", 0, Integer.MAX_VALUE, this.testList));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name by which this suite is known by in the test system. The name must be unique in the amongst the suites", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "Description of what this suite does / why it was defined. This should explain to a tester what they should know when deciding which tests to run", 0, 1, this.description);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "If this mode is not passed to the runner, then this suite will not be run", 0, 1, this.mode);
                }
                case -341064690: {
                    return new Property("resource", "Base", "The resources used in the tests in this suite. How exactly they are used depends on the definition of the runner", 0, Integer.MAX_VALUE, this.resourceList);
                }
                case 1954460585: {
                    return new Property("parameter", "Base", "A parameter passed to the runner when executing tests. Which parameters are valid, and how exactly the parameter is used are used depends on the definition of the runner", 0, Integer.MAX_VALUE, this.parameterList);
                }
                case 3556498: {
                    return new Property("test", "Base", "An actual test in the test suite", 0, Integer.MAX_VALUE, this.testList);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.mode;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resourceList == null ? new Base[]{} : this.resourceList.toArray(new Base[this.resourceList.size()]);
                }
                case 1954460585: {
                    return this.parameterList == null ? new Base[]{} : this.parameterList.toArray(new Base[this.parameterList.size()]);
                }
                case 3556498: {
                    return this.testList == null ? new Base[]{} : this.testList.toArray(new Base[this.testList.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToCode(value);
                    return value;
                }
                case -341064690: {
                    this.getResourceList().add((TestCasesSuiteResourceComponent)value);
                    return value;
                }
                case 1954460585: {
                    this.getParameterList().add((TestCasesSuiteParameterComponent)value);
                    return value;
                }
                case 3556498: {
                    this.getTestList().add((TestCasesSuiteTestComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("mode")) {
                this.mode = TypeConvertor.castToCode(value);
            } else if (name.equals("resource")) {
                this.getResourceList().add((TestCasesSuiteResourceComponent)value);
            } else if (name.equals("parameter")) {
                this.getParameterList().add((TestCasesSuiteParameterComponent)value);
            } else if (name.equals("test")) {
                this.getTestList().add((TestCasesSuiteTestComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case -341064690: {
                    throw new Error("Unable to make an instance of the abstract property 'resource'");
                }
                case 1954460585: {
                    throw new Error("Unable to make an instance of the abstract property 'parameter'");
                }
                case 3556498: {
                    throw new Error("Unable to make an instance of the abstract property 'test'");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case -341064690: {
                    return new String[]{"Base"};
                }
                case 1954460585: {
                    return new String[]{"Base"};
                }
                case 3556498: {
                    return new String[]{"Base"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.description");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.mode");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type TestCases.suite.resource");
            }
            if (name.equals("parameter")) {
                throw new FHIRException("Cannot call addChild on an abstract type TestCases.suite.parameter");
            }
            if (name.equals("test")) {
                throw new FHIRException("Cannot call addChild on an abstract type TestCases.suite.test");
            }
            return super.addChild(name);
        }

        @Override
        public TestCasesSuiteComponent copy() {
            TestCasesSuiteComponent dst = new TestCasesSuiteComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestCasesSuiteComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            CodeType codeType = dst.mode = this.mode == null ? null : this.mode.copy();
            if (this.resourceList != null) {
                dst.resourceList = new ArrayList<TestCasesSuiteResourceComponent>();
                for (TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : this.resourceList) {
                    dst.resourceList.add(testCasesSuiteResourceComponent.copy());
                }
            }
            if (this.parameterList != null) {
                dst.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
                for (TestCasesSuiteParameterComponent testCasesSuiteParameterComponent : this.parameterList) {
                    dst.parameterList.add(testCasesSuiteParameterComponent.copy());
                }
            }
            if (this.testList != null) {
                dst.testList = new ArrayList<TestCasesSuiteTestComponent>();
                for (TestCasesSuiteTestComponent testCasesSuiteTestComponent : this.testList) {
                    dst.testList.add(testCasesSuiteTestComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteComponent)) {
                return false;
            }
            TestCasesSuiteComponent o = (TestCasesSuiteComponent)other_;
            return TestCasesSuiteComponent.compareDeep(this.name, o.name, true) && TestCasesSuiteComponent.compareDeep(this.description, o.description, true) && TestCasesSuiteComponent.compareDeep(this.mode, o.mode, true) && TestCasesSuiteComponent.compareDeep(this.resourceList, o.resourceList, true) && TestCasesSuiteComponent.compareDeep(this.parameterList, o.parameterList, true) && TestCasesSuiteComponent.compareDeep(this.testList, o.testList, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteComponent)) {
                return false;
            }
            TestCasesSuiteComponent o = (TestCasesSuiteComponent)other_;
            return TestCasesSuiteComponent.compareValues(this.name, o.name, true) && TestCasesSuiteComponent.compareValues(this.description, o.description, true) && TestCasesSuiteComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.description, this.mode, this.resourceList, this.parameterList, this.testList});
        }

        @Override
        public String fhirType() {
            return "TestCases.suite";
        }
    }

    @Block
    public static class TestCasesSuiteTestComponent
    extends LogicalBase {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The name of this test - unique in the suite", formalDefinition="The name by which this test is known by in the test system. The name must be unique in the suite")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of what this test does / why it was defined", formalDefinition="Description of what this test does / why it was defined. This should explain to a tester what they should know when looking at failing test results")
        protected StringType description;
        @Child(name="operation", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Operation that is executed during this test (per definition of runner)", formalDefinition="A code that identifies the operation executed for this test. One of the codes defined in the definition of the runner")
        protected CodeType operation;
        @Child(name="mode", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="mode required to run this test", formalDefinition="If this mode is not passed to the runner, then this test will not be run")
        protected StringType mode;
        @Child(name="parameter", type={TestCasesSuiteParameterComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="", formalDefinition="")
        protected List<TestCasesSuiteParameterComponent> parameterList;
        @Child(name="input", type={TestCasesSuiteResourceComponent.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resources used when executing this test (per runner definition)", formalDefinition="The resources used when executing this test. How exactly they are used depends on the definition of the runner.")
        protected List<TestCasesSuiteResourceComponent> inputList;
        @Child(name="output", type={TestCasesSuiteResourceComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Resources expected as output from this test (per runner definition, often Matchetypes)", formalDefinition="Resources expected as output from this test. Often, but not always, these resources are Matchetype resources. How exactly it is used depends on the definition of the runner")
        protected List<TestCasesSuiteResourceComponent> outputList;
        private static final long serialVersionUID = 330781544L;

        public TestCasesSuiteTestComponent() {
        }

        public TestCasesSuiteTestComponent(String name) {
            this.setName(name);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteTestComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestCasesSuiteTestComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestCasesSuiteTestComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteTestComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TestCasesSuiteTestComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TestCasesSuiteTestComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeType getOperationElement() {
            if (this.operation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteTestComponent.operation");
                }
                if (Configuration.doAutoCreate()) {
                    this.operation = new CodeType();
                }
            }
            return this.operation;
        }

        public boolean hasOperationElement() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public boolean hasOperation() {
            return this.operation != null && !this.operation.isEmpty();
        }

        public TestCasesSuiteTestComponent setOperationElement(CodeType value) {
            this.operation = value;
            return this;
        }

        public String getOperation() {
            return this.operation == null ? null : (String)this.operation.getValue();
        }

        public TestCasesSuiteTestComponent setOperation(String value) {
            if (Utilities.noString((String)value)) {
                this.operation = null;
            } else {
                if (this.operation == null) {
                    this.operation = new CodeType();
                }
                this.operation.setValue(value);
            }
            return this;
        }

        public StringType getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteTestComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new StringType();
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public TestCasesSuiteTestComponent setModeElement(StringType value) {
            this.mode = value;
            return this;
        }

        public String getMode() {
            return this.mode == null ? null : (String)this.mode.getValue();
        }

        public TestCasesSuiteTestComponent setMode(String value) {
            if (Utilities.noString((String)value)) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new StringType();
                }
                this.mode.setValue(value);
            }
            return this;
        }

        public List<TestCasesSuiteParameterComponent> getParameterList() {
            if (this.parameterList == null) {
                this.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
            }
            return this.parameterList;
        }

        public TestCasesSuiteTestComponent setParameterList(List<TestCasesSuiteParameterComponent> theParameter) {
            this.parameterList = theParameter;
            return this;
        }

        public boolean hasParameter() {
            if (this.parameterList == null) {
                return false;
            }
            for (TestCasesSuiteParameterComponent item : this.parameterList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCasesSuiteParameterComponent addParameter() {
            TestCasesSuiteParameterComponent t = new TestCasesSuiteParameterComponent();
            if (this.parameterList == null) {
                this.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
            }
            this.parameterList.add(t);
            return t;
        }

        public TestCasesSuiteTestComponent addParameter(TestCasesSuiteParameterComponent t) {
            if (t == null) {
                return this;
            }
            if (this.parameterList == null) {
                this.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
            }
            this.parameterList.add(t);
            return this;
        }

        public TestCasesSuiteParameterComponent getParameterFirstRep() {
            if (this.getParameterList().isEmpty()) {
                this.addParameter();
            }
            return this.getParameterList().get(0);
        }

        public List<TestCasesSuiteResourceComponent> getInputList() {
            if (this.inputList == null) {
                this.inputList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            return this.inputList;
        }

        public TestCasesSuiteTestComponent setInputList(List<TestCasesSuiteResourceComponent> theInput) {
            this.inputList = theInput;
            return this;
        }

        public boolean hasInput() {
            if (this.inputList == null) {
                return false;
            }
            for (TestCasesSuiteResourceComponent item : this.inputList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCasesSuiteResourceComponent addInput() {
            TestCasesSuiteResourceComponent t = new TestCasesSuiteResourceComponent();
            if (this.inputList == null) {
                this.inputList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            this.inputList.add(t);
            return t;
        }

        public TestCasesSuiteTestComponent addInput(TestCasesSuiteResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.inputList == null) {
                this.inputList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            this.inputList.add(t);
            return this;
        }

        public TestCasesSuiteResourceComponent getInputFirstRep() {
            if (this.getInputList().isEmpty()) {
                this.addInput();
            }
            return this.getInputList().get(0);
        }

        public List<TestCasesSuiteResourceComponent> getOutputList() {
            if (this.outputList == null) {
                this.outputList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            return this.outputList;
        }

        public TestCasesSuiteTestComponent setOutputList(List<TestCasesSuiteResourceComponent> theOutput) {
            this.outputList = theOutput;
            return this;
        }

        public boolean hasOutput() {
            if (this.outputList == null) {
                return false;
            }
            for (TestCasesSuiteResourceComponent item : this.outputList) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TestCasesSuiteResourceComponent addOutput() {
            TestCasesSuiteResourceComponent t = new TestCasesSuiteResourceComponent();
            if (this.outputList == null) {
                this.outputList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            this.outputList.add(t);
            return t;
        }

        public TestCasesSuiteTestComponent addOutput(TestCasesSuiteResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.outputList == null) {
                this.outputList = new ArrayList<TestCasesSuiteResourceComponent>();
            }
            this.outputList.add(t);
            return this;
        }

        public TestCasesSuiteResourceComponent getOutputFirstRep() {
            if (this.getOutputList().isEmpty()) {
                this.addOutput();
            }
            return this.getOutputList().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "The name by which this test is known by in the test system. The name must be unique in the suite", 0, 1, this.name));
            children.add(new Property("description", "string", "Description of what this test does / why it was defined. This should explain to a tester what they should know when looking at failing test results", 0, 1, this.description));
            children.add(new Property("operation", "code", "A code that identifies the operation executed for this test. One of the codes defined in the definition of the runner", 0, 1, this.operation));
            children.add(new Property("mode", "string", "If this mode is not passed to the runner, then this test will not be run", 0, 1, this.mode));
            children.add(new Property("parameter", "http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.parameter", "", 0, Integer.MAX_VALUE, this.parameterList));
            children.add(new Property("input", "http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.resource", "The resources used when executing this test. How exactly they are used depends on the definition of the runner.", 0, Integer.MAX_VALUE, this.inputList));
            children.add(new Property("output", "http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.resource", "Resources expected as output from this test. Often, but not always, these resources are Matchetype resources. How exactly it is used depends on the definition of the runner", 0, Integer.MAX_VALUE, this.outputList));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "The name by which this test is known by in the test system. The name must be unique in the suite", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property("description", "string", "Description of what this test does / why it was defined. This should explain to a tester what they should know when looking at failing test results", 0, 1, this.description);
                }
                case 1662702951: {
                    return new Property("operation", "code", "A code that identifies the operation executed for this test. One of the codes defined in the definition of the runner", 0, 1, this.operation);
                }
                case 0x3339A3: {
                    return new Property("mode", "string", "If this mode is not passed to the runner, then this test will not be run", 0, 1, this.mode);
                }
                case 1954460585: {
                    return new Property("parameter", "http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.parameter", "", 0, Integer.MAX_VALUE, this.parameterList);
                }
                case 100358090: {
                    return new Property("input", "http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.resource", "The resources used when executing this test. How exactly they are used depends on the definition of the runner.", 0, Integer.MAX_VALUE, this.inputList);
                }
                case -1005512447: {
                    return new Property("output", "http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.resource", "Resources expected as output from this test. Often, but not always, these resources are Matchetype resources. How exactly it is used depends on the definition of the runner", 0, Integer.MAX_VALUE, this.outputList);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case 1662702951: {
                    Base[] baseArray;
                    if (this.operation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.operation;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.mode;
                    }
                    return baseArray;
                }
                case 1954460585: {
                    return this.parameterList == null ? new Base[]{} : this.parameterList.toArray(new Base[this.parameterList.size()]);
                }
                case 100358090: {
                    return this.inputList == null ? new Base[]{} : this.inputList.toArray(new Base[this.inputList.size()]);
                }
                case -1005512447: {
                    return this.outputList == null ? new Base[]{} : this.outputList.toArray(new Base[this.outputList.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 1662702951: {
                    this.operation = TypeConvertor.castToCode(value);
                    return value;
                }
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToString(value);
                    return value;
                }
                case 1954460585: {
                    this.getParameterList().add((TestCasesSuiteParameterComponent)value);
                    return value;
                }
                case 100358090: {
                    this.getInputList().add((TestCasesSuiteResourceComponent)value);
                    return value;
                }
                case -1005512447: {
                    this.getOutputList().add((TestCasesSuiteResourceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("operation")) {
                this.operation = TypeConvertor.castToCode(value);
            } else if (name.equals("mode")) {
                this.mode = TypeConvertor.castToString(value);
            } else if (name.equals("parameter")) {
                this.getParameterList().add((TestCasesSuiteParameterComponent)value);
            } else if (name.equals("input")) {
                this.getInputList().add((TestCasesSuiteResourceComponent)value);
            } else if (name.equals("output")) {
                this.getOutputList().add((TestCasesSuiteResourceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 1662702951: {
                    return this.getOperationElement();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 1954460585: {
                    return this.addParameter();
                }
                case 100358090: {
                    return this.addInput();
                }
                case -1005512447: {
                    return this.addOutput();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 1662702951: {
                    return new String[]{"code"};
                }
                case 0x3339A3: {
                    return new String[]{"string"};
                }
                case 1954460585: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.parameter"};
                }
                case 100358090: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.resource"};
                }
                case -1005512447: {
                    return new String[]{"http://hl7.org/fhir/tools/StructureDefinition/TestCases@TestCases.suite.resource"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.test.name");
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.test.description");
            }
            if (name.equals("operation")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.test.operation");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.test.mode");
            }
            if (name.equals("parameter")) {
                return this.addParameter();
            }
            if (name.equals("input")) {
                return this.addInput();
            }
            if (name.equals("output")) {
                return this.addOutput();
            }
            return super.addChild(name);
        }

        @Override
        public TestCasesSuiteTestComponent copy() {
            TestCasesSuiteTestComponent dst = new TestCasesSuiteTestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestCasesSuiteTestComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.operation = this.operation == null ? null : this.operation.copy();
            StringType stringType = dst.mode = this.mode == null ? null : this.mode.copy();
            if (this.parameterList != null) {
                dst.parameterList = new ArrayList<TestCasesSuiteParameterComponent>();
                for (TestCasesSuiteParameterComponent testCasesSuiteParameterComponent : this.parameterList) {
                    dst.parameterList.add(testCasesSuiteParameterComponent.copy());
                }
            }
            if (this.inputList != null) {
                dst.inputList = new ArrayList<TestCasesSuiteResourceComponent>();
                for (TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : this.inputList) {
                    dst.inputList.add(testCasesSuiteResourceComponent.copy());
                }
            }
            if (this.outputList != null) {
                dst.outputList = new ArrayList<TestCasesSuiteResourceComponent>();
                for (TestCasesSuiteResourceComponent testCasesSuiteResourceComponent : this.outputList) {
                    dst.outputList.add(testCasesSuiteResourceComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteTestComponent)) {
                return false;
            }
            TestCasesSuiteTestComponent o = (TestCasesSuiteTestComponent)other_;
            return TestCasesSuiteTestComponent.compareDeep(this.name, o.name, true) && TestCasesSuiteTestComponent.compareDeep(this.description, o.description, true) && TestCasesSuiteTestComponent.compareDeep(this.operation, o.operation, true) && TestCasesSuiteTestComponent.compareDeep(this.mode, o.mode, true) && TestCasesSuiteTestComponent.compareDeep(this.parameterList, o.parameterList, true) && TestCasesSuiteTestComponent.compareDeep(this.inputList, o.inputList, true) && TestCasesSuiteTestComponent.compareDeep(this.outputList, o.outputList, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteTestComponent)) {
                return false;
            }
            TestCasesSuiteTestComponent o = (TestCasesSuiteTestComponent)other_;
            return TestCasesSuiteTestComponent.compareValues(this.name, o.name, true) && TestCasesSuiteTestComponent.compareValues(this.description, o.description, true) && TestCasesSuiteTestComponent.compareValues(this.operation, o.operation, true) && TestCasesSuiteTestComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.description, this.operation, this.mode, this.parameterList, this.inputList, this.outputList});
        }

        @Override
        public String fhirType() {
            return "TestCases.suite.test";
        }

        public String getParameterStr(String name) {
            for (TestCasesSuiteParameterComponent p : this.getParameterList()) {
                if (!name.equals(p.getName())) continue;
                return p.getValue().primitiveValue();
            }
            return null;
        }

        public DataType getParameter(String name) {
            for (TestCasesSuiteParameterComponent p : this.getParameterList()) {
                if (!name.equals(p.getName())) continue;
                return p.getValue();
            }
            return null;
        }

        public TestCasesSuiteResourceComponent getInput(String name) {
            for (TestCasesSuiteResourceComponent input : this.getInputList()) {
                if (!name.equals(input.getName())) continue;
                return input;
            }
            return null;
        }
    }

    @Block
    public static class TestCasesSuiteParameterComponent
    extends LogicalBase {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name of parameter", formalDefinition="Name of parameter")
        protected StringType name;
        @Child(name="value", type={StringType.class, BooleanType.class, IntegerType.class, DecimalType.class, DateTimeType.class, UriType.class, Coding.class, Quantity.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Value of this parameter", formalDefinition="The value of the parameter")
        protected DataType value;
        @Child(name="mode", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A mode that must be true for this parameter to be used", formalDefinition="If this mode is not passed to the runner, then this parameter will not be used")
        protected CodeType mode;
        private static final long serialVersionUID = -410765611L;

        public TestCasesSuiteParameterComponent() {
        }

        public TestCasesSuiteParameterComponent(String name, DataType value) {
            this.setName(name);
            this.setValue(value);
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteParameterComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestCasesSuiteParameterComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestCasesSuiteParameterComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public StringType getValueStringType() throws FHIRException {
            if (this.value == null) {
                this.value = new StringType();
            }
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (this.value == null) {
                this.value = new IntegerType();
            }
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (this.value == null) {
                this.value = new DecimalType();
            }
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this.value instanceof DecimalType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateTimeType();
            }
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (this.value == null) {
                this.value = new UriType();
            }
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this.value instanceof UriType;
        }

        public Coding getValueCoding() throws FHIRException {
            if (this.value == null) {
                this.value = new Coding();
            }
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public TestCasesSuiteParameterComponent setValue(DataType value) {
            if (!(value == null || value instanceof StringType || value instanceof BooleanType || value instanceof IntegerType || value instanceof DecimalType || value instanceof DateTimeType || value instanceof UriType || value instanceof Coding || value instanceof Quantity)) {
                throw new FHIRException("Not the right type for TestCases.suite.parameter.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        public CodeType getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteParameterComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeType();
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public TestCasesSuiteParameterComponent setModeElement(CodeType value) {
            this.mode = value;
            return this;
        }

        public String getMode() {
            return this.mode == null ? null : (String)this.mode.getValue();
        }

        public TestCasesSuiteParameterComponent setMode(String value) {
            if (Utilities.noString((String)value)) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new CodeType();
                }
                this.mode.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "Name of parameter", 0, 1, this.name));
            children.add(new Property("value[x]", "string|boolean|integer|decimal|dateTime|uri|Coding|Quantity", "The value of the parameter", 0, 1, this.value));
            children.add(new Property("mode", "code", "If this mode is not passed to the runner, then this parameter will not be used", 0, 1, this.mode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "Name of parameter", 0, 1, this.name);
                }
                case -1410166417: {
                    return new Property("value[x]", "string|boolean|integer|decimal|dateTime|uri|Coding|Quantity", "The value of the parameter", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "string|boolean|integer|decimal|dateTime|uri|Coding|Quantity", "The value of the parameter", 0, 1, this.value);
                }
                case -1424603934: {
                    return new Property("value[x]", "string", "The value of the parameter", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "The value of the parameter", 0, 1, this.value);
                }
                case -1668204915: {
                    return new Property("value[x]", "integer", "The value of the parameter", 0, 1, this.value);
                }
                case -2083993440: {
                    return new Property("value[x]", "decimal", "The value of the parameter", 0, 1, this.value);
                }
                case 1047929900: {
                    return new Property("value[x]", "dateTime", "The value of the parameter", 0, 1, this.value);
                }
                case -1410172357: {
                    return new Property("value[x]", "uri", "The value of the parameter", 0, 1, this.value);
                }
                case -1887705029: {
                    return new Property("value[x]", "Coding", "The value of the parameter", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "The value of the parameter", 0, 1, this.value);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "If this mode is not passed to the runner, then this parameter will not be used", 0, 1, this.mode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.mode;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToCode(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else if (name.equals("mode")) {
                this.mode = TypeConvertor.castToCode(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 111972721: {
                    return new String[]{"string", "boolean", "integer", "decimal", "dateTime", "uri", "Coding", "Quantity"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.parameter.name");
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.parameter.mode");
            }
            return super.addChild(name);
        }

        @Override
        public TestCasesSuiteParameterComponent copy() {
            TestCasesSuiteParameterComponent dst = new TestCasesSuiteParameterComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestCasesSuiteParameterComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.value = this.value == null ? null : this.value.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteParameterComponent)) {
                return false;
            }
            TestCasesSuiteParameterComponent o = (TestCasesSuiteParameterComponent)other_;
            return TestCasesSuiteParameterComponent.compareDeep(this.name, o.name, true) && TestCasesSuiteParameterComponent.compareDeep(this.value, o.value, true) && TestCasesSuiteParameterComponent.compareDeep(this.mode, o.mode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteParameterComponent)) {
                return false;
            }
            TestCasesSuiteParameterComponent o = (TestCasesSuiteParameterComponent)other_;
            return TestCasesSuiteParameterComponent.compareValues(this.name, o.name, true) && TestCasesSuiteParameterComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.value, this.mode});
        }

        @Override
        public String fhirType() {
            return "TestCases.suite.parameter";
        }
    }

    @Block
    public static class TestCasesSuiteResourceComponent
    extends LogicalBase {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name for this resource (per runner definition)", formalDefinition="A name that identifies this resource. The runner definition defines whether there must be a name, and what names there are")
        protected StringType name;
        @Child(name="file", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A file containing a resource used in the tests", formalDefinition="A file containing a resource used in the tests")
        protected StringType file;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="An inline resource used in the tests", formalDefinition="An inline resource used in the tests. How exactly it is used depends on the definition of the runner.")
        protected Resource resource;
        @Child(name="mode", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A mode that must be true for this resource to be used", formalDefinition="If this mode is not passed to the runner, then this resource will not be used")
        protected CodeType mode;
        private static final long serialVersionUID = 1036724891L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteResourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TestCasesSuiteResourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TestCasesSuiteResourceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getFileElement() {
            if (this.file == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteResourceComponent.file");
                }
                if (Configuration.doAutoCreate()) {
                    this.file = new StringType();
                }
            }
            return this.file;
        }

        public boolean hasFileElement() {
            return this.file != null && !this.file.isEmpty();
        }

        public boolean hasFile() {
            return this.file != null && !this.file.isEmpty();
        }

        public TestCasesSuiteResourceComponent setFileElement(StringType value) {
            this.file = value;
            return this;
        }

        public String getFile() {
            return this.file == null ? null : (String)this.file.getValue();
        }

        public TestCasesSuiteResourceComponent setFile(String value) {
            if (Utilities.noString((String)value)) {
                this.file = null;
            } else {
                if (this.file == null) {
                    this.file = new StringType();
                }
                this.file.setValue(value);
            }
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public TestCasesSuiteResourceComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public CodeType getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TestCasesSuiteResourceComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new CodeType();
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public TestCasesSuiteResourceComponent setModeElement(CodeType value) {
            this.mode = value;
            return this;
        }

        public String getMode() {
            return this.mode == null ? null : (String)this.mode.getValue();
        }

        public TestCasesSuiteResourceComponent setMode(String value) {
            if (Utilities.noString((String)value)) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new CodeType();
                }
                this.mode.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "A name that identifies this resource. The runner definition defines whether there must be a name, and what names there are", 0, 1, this.name));
            children.add(new Property("file", "string", "A file containing a resource used in the tests", 0, 1, this.file));
            children.add(new Property("resource", "Resource", "An inline resource used in the tests. How exactly it is used depends on the definition of the runner.", 0, 1, this.resource));
            children.add(new Property("mode", "code", "If this mode is not passed to the runner, then this resource will not be used", 0, 1, this.mode));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "A name that identifies this resource. The runner definition defines whether there must be a name, and what names there are", 0, 1, this.name);
                }
                case 3143036: {
                    return new Property("file", "string", "A file containing a resource used in the tests", 0, 1, this.file);
                }
                case -341064690: {
                    return new Property("resource", "Resource", "An inline resource used in the tests. How exactly it is used depends on the definition of the runner.", 0, 1, this.resource);
                }
                case 0x3339A3: {
                    return new Property("mode", "code", "If this mode is not passed to the runner, then this resource will not be used", 0, 1, this.mode);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 3143036: {
                    Base[] baseArray;
                    if (this.file == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.file;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.resource;
                    }
                    return baseArray;
                }
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.mode;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = TypeConvertor.castToString(value);
                    return value;
                }
                case 3143036: {
                    this.file = TypeConvertor.castToString(value);
                    return value;
                }
                case -341064690: {
                    this.resource = (Resource)value;
                    return value;
                }
                case 0x3339A3: {
                    this.mode = TypeConvertor.castToCode(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = TypeConvertor.castToString(value);
            } else if (name.equals("file")) {
                this.file = TypeConvertor.castToString(value);
            } else if (name.equals("resource")) {
                this.resource = (Resource)value;
            } else if (name.equals("mode")) {
                this.mode = TypeConvertor.castToCode(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 3143036: {
                    return this.getFileElement();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case 0x3339A3: {
                    return this.getModeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 3143036: {
                    return new String[]{"string"};
                }
                case -341064690: {
                    return new String[]{"Resource"};
                }
                case 0x3339A3: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.resource.name");
            }
            if (name.equals("file")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.resource.file");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type TestCases.suite.resource.resource");
            }
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property TestCases.suite.resource.mode");
            }
            return super.addChild(name);
        }

        @Override
        public TestCasesSuiteResourceComponent copy() {
            TestCasesSuiteResourceComponent dst = new TestCasesSuiteResourceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TestCasesSuiteResourceComponent dst) {
            super.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.file = this.file == null ? null : this.file.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.mode = this.mode == null ? null : this.mode.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteResourceComponent)) {
                return false;
            }
            TestCasesSuiteResourceComponent o = (TestCasesSuiteResourceComponent)other_;
            return TestCasesSuiteResourceComponent.compareDeep(this.name, o.name, true) && TestCasesSuiteResourceComponent.compareDeep(this.file, o.file, true) && TestCasesSuiteResourceComponent.compareDeep(this.resource, o.resource, true) && TestCasesSuiteResourceComponent.compareDeep(this.mode, o.mode, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TestCasesSuiteResourceComponent)) {
                return false;
            }
            TestCasesSuiteResourceComponent o = (TestCasesSuiteResourceComponent)other_;
            return TestCasesSuiteResourceComponent.compareValues(this.name, o.name, true) && TestCasesSuiteResourceComponent.compareValues(this.file, o.file, true) && TestCasesSuiteResourceComponent.compareValues(this.mode, o.mode, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.name, this.file, this.resource, this.mode});
        }

        @Override
        public String fhirType() {
            return "TestCases.suite.resource";
        }
    }
}

