/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.terminologies;

import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;

@MarkedToMoveToAdjunctPackage
public class ImplicitValueSets {
    public static ValueSet build(String url) {
        if (Utilities.noString((String)url)) {
            return null;
        }
        if (url.startsWith("http://snomed.info/sct")) {
            return ImplicitValueSets.buildSnomedValueSet(url);
        }
        if (url.startsWith("http://loinc.org/vs")) {
            return ImplicitValueSets.buildLoincValueSet(url);
        }
        if (url.equals("http://unitsofmeasure.org/vs")) {
            return ImplicitValueSets.allUcumValueSet();
        }
        return null;
    }

    private static ValueSet buildSnomedValueSet(String url) {
        return null;
    }

    private static ValueSet buildLoincValueSet(String url) {
        if (url.startsWith("http://loinc.org/vs/LL")) {
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setName("LoincVS" + url.substring("http://loinc.org/vs/".length()).replace("-", ""));
            vs.setTitle("Loinc Implicit ValueSet for " + url.substring("http://loinc.org/vs/".length()));
            return vs;
        }
        if (url.equals("http://loinc.org/vs")) {
            ValueSet vs = new ValueSet();
            vs.setUrl(url);
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setName("LoincVSAll");
            vs.setTitle("Loinc Implicit ValueSet : all codes");
            return vs;
        }
        return null;
    }

    private static ValueSet allUcumValueSet() {
        ValueSet vs = new ValueSet();
        vs.setUrl("http://unitsofmeasure.org/vs");
        vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        vs.setName("AllUcumCodes");
        vs.setTitle("All Ucum Codes");
        vs.getCompose().addInclude().setSystem("http://unitsofmeasure.org");
        return vs;
    }
}

