/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.sql.Column;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ViewDefinitionRenderer
extends ResourceRenderer {
    public ViewDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public boolean renderingUsesValidation() {
        return true;
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper vd) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        HierarchicalTableGenerator gen;
        this.renderResourceTechDetails(vd, x);
        this.genSummaryTable(status, x, vd);
        XhtmlNode p = x.para();
        p.tx("This view acts on the " + vd.primitiveValue("resource") + " resource");
        List<ResourceWrapper> vers = vd.children("fhirVersion");
        for (int i = 0; i < vers.size(); ++i) {
            if (i == 0) {
                p.tx(" for version" + (vers.size() == 1 ? "" : "s") + " ");
            } else if (i == vers.size() - 1) {
                p.tx(" and ");
            } else {
                p.tx(", ");
            }
            String ver = vers.get(i).primitiveValue();
            p.ah(VersionUtilities.getSpecUrl((String)ver)).tx(VersionUtilities.getNameForVersion((String)ver));
        }
        if (vd.has("resourceProfile")) {
            p.tx(" using profile ?");
        }
        if (vd.has("name")) {
            p.tx(" to produce a table named \"");
            p.code().tx(vd.primitiveValue("name"));
            p.tx("\"");
        } else {
            p.tx(" to produce a unnamed table");
        }
        if (vd.has("where")) {
            List<ResourceWrapper> wheres = vd.children("where");
            if (wheres.size() == 1) {
                p.tx(" where ");
                p.code().tx(wheres.get(0).primitiveValue("path"));
                if (wheres.get(0).has("description")) {
                    p.tx(" (" + wheres.get(0).primitiveValue("description") + ")");
                }
                p.tx(".");
            } else {
                p.tx(" where:");
                XhtmlNode ul = x.ul();
                for (ResourceWrapper resourceWrapper : wheres) {
                    XhtmlNode li = ul.li();
                    li.code().tx(wheres.get(0).primitiveValue("path"));
                    if (!wheres.get(0).has("description")) continue;
                    li.tx(" (" + wheres.get(0).primitiveValue("description") + ")");
                }
            }
        } else {
            p.tx(".");
        }
        if (vd.hasUserData("columns")) {
            x.para().tx("The table contains the following columns:");
            List cols = (List)vd.getUserData("columns");
            boolean hasNotes = false;
            for (Column column : cols) {
                hasNotes = hasNotes || !Utilities.noString((String)column.getNotes());
            }
            XhtmlNode t2 = x.table("grid", false);
            XhtmlNode xhtmlNode = t2.tr();
            xhtmlNode.th().tx("Name");
            xhtmlNode.th().tx("Fhir Type");
            xhtmlNode.th().tx("SQL Type");
            xhtmlNode.th().tx("Collection");
            if (hasNotes) {
                xhtmlNode.th().tx("Notes");
            }
            for (Column col : cols) {
                XhtmlNode xhtmlNode2 = t2.tr();
                xhtmlNode2.td().tx(col.getName());
                xhtmlNode2.td().tx(col.getType());
                xhtmlNode2.td().tx(col.getKind().name());
                xhtmlNode2.td().tx(col.isColl() == null ? "" : (col.isColl() != false ? "Y" : "N"));
                if (!hasNotes) continue;
                xhtmlNode2.td().tx(col.getNotes());
            }
        }
        if (vd.has("constant")) {
            x.para().tx("Constants:");
            XhtmlNode t2 = x.table("grid", false);
            XhtmlNode tr = t2.tr();
            tr.th().tx("Name");
            tr.th().tx("Value");
            for (ResourceWrapper resourceWrapper : vd.children("constant")) {
                tr = t2.tr();
                tr.td().tx(resourceWrapper.primitiveValue("name"));
                tr.td().tx(resourceWrapper.primitiveValue("value"));
            }
        }
        x.para().tx("Selection Rules:");
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator((RenderingI18nContext)this.context, this.context.getDestDir(), this.context.isInlineGraphics(), true, "");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, "vd=" + vd.getId(), this.context.getRules() == RenderingContext.GenerationRules.IG_PUBLISHER);
        model.setAlternating(true);
        if (this.context.getRules() == RenderingContext.GenerationRules.VALID_RESOURCE || this.context.isInlineGraphics()) {
            model.setDocoImg(HierarchicalTableGenerator.help16AsData());
        } else {
            model.setDocoImg(Utilities.pathURL((String[])new String[]{this.context.getLink(RenderingContext.KnownLinkType.SPEC, true), "help16.png"}));
        }
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, model.getDocoRef(), "Item", this.context.formatPhrase("QUEST_LINK", new Object[0]), null, 0));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, model.getDocoRef(), "Coll", this.context.formatPhrase("QUEST_TEXTFOR", new Object[0]), null, 0));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, model.getDocoRef(), "Type", this.context.formatPhrase("QUEST_TIMES", new Object[0]), null, 0));
        List list4 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator5);
        list4.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator5, null, model.getDocoRef(), "Description", this.context.formatPhrase("QUEST_TYPE_ITEM", new Object[0]), null, 0));
        HierarchicalTableGenerator.Row row = this.addViewRoot(gen, model.getRows(), vd);
        for (ResourceWrapper select : vd.children("select")) {
            this.renderSelect(status, gen, row.getSubRows(), vd, select);
        }
        XhtmlNode xhtmlNode = gen.generate(model, this.context.getLocalPrefix(), 1, null);
        x.addChildNode(xhtmlNode);
    }

    private void renderSelect(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper vd, ResourceWrapper select) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_select.png", "Select");
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c1 = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, "Select", null, null);
        r.getCells().add(c1);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, null, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, null, null, null));
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null);
        if (select.has("forEach")) {
            this.addFHIRPath((HierarchicalTableGenerator.Piece)cell.getPieces().get(0), "for each ", select.primitiveValue("forEach"), null);
        } else if (select.has("forEachOrNull")) {
            this.addFHIRPath((HierarchicalTableGenerator.Piece)cell.getPieces().get(0), "for each ", select.primitiveValue("forEachOrNull"), ", or null");
        }
        r.getCells().add(cell);
        for (ResourceWrapper column : select.children("column")) {
            this.renderColumn(status, gen, r.getSubRows(), vd, select, column);
        }
        for (ResourceWrapper child : select.children("select")) {
            this.renderSelect(status, gen, r.getSubRows(), vd, child);
        }
    }

    private void renderColumn(Renderer.RenderingStatus status, HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper vd, ResourceWrapper select, ResourceWrapper column) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_col.png", "Column");
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.Cell c1 = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, column.primitiveValue("name"), null, null);
        r.getCells().add(c1);
        String coll = column.has("collection") ? ("true".equals(column.primitiveValue("collection")) ? "Y" : "N") : "";
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, coll, null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, column.primitiveValue("type"), null, null));
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        HierarchicalTableGenerator.Cell cell = new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, null, null, null);
        this.addFHIRPath((HierarchicalTableGenerator.Piece)cell.getPieces().get(0), null, column.primitiveValue("path"), null);
        if (column.has("description")) {
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator5, "br"));
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator6, null, column.primitiveValue("description"), null));
        }
        for (ResourceWrapper tag : column.children("tag")) {
            HierarchicalTableGenerator hierarchicalTableGenerator7 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator7);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator7, "br"));
            HierarchicalTableGenerator hierarchicalTableGenerator8 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator8);
            cell.addPiece(new HierarchicalTableGenerator.Piece(hierarchicalTableGenerator8, null, tag.primitiveValue("name") + "=" + tag.primitiveValue("value"), null));
        }
        r.getCells().add(cell);
    }

    private void addFHIRPath(HierarchicalTableGenerator.Piece p, String pfx, String expr, String sfx) {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "span").style("font-size: 11px");
        p.addHtml(x);
        if (pfx != null) {
            x.tx(pfx);
        }
        x.code(expr);
        if (sfx != null) {
            x.tx(sfx);
        }
    }

    private HierarchicalTableGenerator.Row addViewRoot(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, ResourceWrapper vd) throws IOException {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        r.setIcon("icon_vd_view.png", this.context.formatPhrase("QUEST_ROOT", new Object[0]));
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, vd.primitiveValue("name"), null, null));
        List list2 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, "", null, null));
        List list3 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, vd.primitiveValue("resource"), null, null));
        List list4 = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, vd.primitiveValue("description"), null, null));
        return r;
    }
}

