/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.RendererFactory;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class RequirementsRenderer
extends ResourceRenderer {
    public RequirementsRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper req) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        XhtmlNode ul;
        this.renderResourceTechDetails(req, x);
        this.genSummaryTable(status, x, (CanonicalResource)req.getResourceNative());
        if (req.has("actor")) {
            List<ResourceWrapper> actors = req.children("actor");
            if (actors.size() == 1) {
                ActorDefinition acd = this.context.getWorker().fetchResource(ActorDefinition.class, actors.get(0).primitiveValue(), req.getResourceNative());
                XhtmlNode p = x.para();
                p.tx(this.context.formatPhrase("REQ_ACTOR", new Object[0]) + " ");
                this.renderCanonical(status, p, ActorDefinition.class, actors.get(0));
            } else {
                x.para().tx(this.context.formatPhrase("REQ_FOLLOWING_ACTOR", new Object[0]) + " ");
                ul = x.ul();
                for (ResourceWrapper a : actors) {
                    this.renderCanonical(status, ul.li(), ActorDefinition.class, a);
                }
            }
        }
        if (req.has("derivedFrom")) {
            List<ResourceWrapper> list = req.children("derivedFrom");
            if (list.size() == 1) {
                XhtmlNode p = x.para();
                p.tx(this.context.formatPhrase("REQ_DERIVE", new Object[0]) + " ");
                this.renderCanonical(status, p, Requirements.class, list.get(0));
            } else {
                x.para().tx(this.context.formatPhrase("REQ_FOLLOWING_REQ", new Object[0]) + " ");
                ul = x.ul();
                for (ResourceWrapper a : list) {
                    this.renderCanonical(status, ul.li(), Requirements.class, a);
                }
            }
        }
        if (req.has("reference")) {
            XhtmlNode p = x.para();
            p.tx(this.context.formatPhrase("GENERAL_REFS", new Object[0]) + " ");
            int i = 0;
            for (ResourceWrapper c : req.children("reference")) {
                String url;
                if (++i > 1) {
                    p.tx(", ");
                }
                if ((url = c.primitiveValue()).contains("#")) {
                    url = url.substring(0, url.indexOf("#"));
                }
                p.ah(this.context.prefixLocalHref(c.primitiveValue())).tx(url);
            }
        }
        XhtmlNode tbl = x.table("grid", false);
        for (ResourceWrapper stmt : req.children("statement")) {
            Resource r;
            String url;
            XhtmlNode li;
            XhtmlNode tr = tbl.tr();
            String lbl = stmt.has("label") ? stmt.primitiveValue("label") : stmt.primitiveValue("key");
            XhtmlNode td = tr.td();
            td.b().an(this.context.prefixAnchor(stmt.primitiveValue("key")));
            td.tx(lbl);
            td = tr.td();
            boolean first = true;
            CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://hl7.org/fhir/conformance-expectation");
            for (ResourceWrapper t : stmt.children("conformance")) {
                if (first) {
                    first = false;
                } else {
                    td.tx(", ");
                }
                if (cs != null) {
                    td.ah(this.context.prefixLocalHref(cs.getWebPath() + "#conformance-expectation-" + t.primitiveValue())).tx(t.primitiveValue().toUpperCase());
                    continue;
                }
                td.tx(t.primitiveValue().toUpperCase());
            }
            td = tr.td();
            this.addMarkdown(td, stmt.primitiveValue("requirement"));
            if (!stmt.has("derivedFrom") && !stmt.has("satisfiedBy") && !stmt.has("reference") && !stmt.has("source")) continue;
            td.para().tx(this.context.formatPhrase("REQ_LINKS", new Object[0]) + " ");
            XhtmlNode ul2 = td.ul();
            if (stmt.has("derivedFrom")) {
                Requirements reqr;
                String string;
                li = ul2.li();
                li.tx(this.context.formatPhrase("REQ_DERIVED", new Object[0]) + " ");
                Object url2 = stmt.primitiveValue("derivedFrom");
                String string2 = string = ((String)url2).contains("#") ? ((String)url2).substring(((String)url2).indexOf("#") + 1) : "";
                if (((String)url2).contains("#")) {
                    url2 = ((String)url2).substring(0, ((String)url2).indexOf("#"));
                }
                if ((reqr = this.context.getWorker().fetchResource(Requirements.class, (String)url2, req.getResourceNative())) != null) {
                    Requirements.RequirementsStatementComponent stmtr = reqr.findStatement(string);
                    if (stmtr != null) {
                        li.ah(this.context.prefixLocalHref(reqr.getWebPath() + "#" + string)).tx(reqr.present() + " # " + (stmt.has("label") ? stmt.primitiveValue("label") : stmt.primitiveValue("key")));
                    } else {
                        li.ah(this.context.prefixLocalHref(reqr.getWebPath() + "#" + string)).tx(reqr.present() + " # " + string);
                    }
                } else {
                    li.code(stmt.primitiveValue("derivedFrom"));
                }
            }
            if (stmt.has("satisfiedBy")) {
                li = ul2.li();
                li.tx(this.context.formatPhrase("REQ_SATISFIED", new Object[0]) + " ");
                first = true;
                for (ResourceWrapper resourceWrapper : stmt.children("satisfiedBy")) {
                    if (first) {
                        first = false;
                    } else {
                        li.tx(", ");
                    }
                    url = resourceWrapper.primitiveValue();
                    if (url.contains("#")) {
                        url = url.substring(0, url.indexOf("#"));
                    }
                    if ((r = this.context.getWorker().fetchResource(Resource.class, url, req.getResourceNative())) != null) {
                        String desc = this.getResourceDescription(r, null);
                        li.ah(this.context.prefixLocalHref(resourceWrapper.primitiveValue())).tx(desc);
                        continue;
                    }
                    li.ah(this.context.prefixLocalHref(resourceWrapper.primitiveValue())).tx(url);
                }
            }
            if (stmt.has("reference")) {
                li = ul2.li();
                li.tx(this.context.formatPhrase("GENERAL_REFS", new Object[0]) + " ");
                int i = 0;
                for (ResourceWrapper c2 : stmt.children("reference")) {
                    String url3;
                    if (++i > 1) {
                        li.tx(", ");
                    }
                    if ((url3 = c2.primitiveValue()).contains("#")) {
                        url3 = url3.substring(0, url3.indexOf("#"));
                    }
                    li.ah(this.context.prefixLocalHref(c2.primitiveValue())).tx(url3);
                }
            }
            if (!stmt.has("source")) continue;
            li = ul2.li();
            li.tx(this.context.formatPhrase("GENERAL_SRC", new Object[0]) + " ");
            first = true;
            for (ResourceWrapper resourceWrapper : stmt.children("source")) {
                if (first) {
                    first = false;
                } else {
                    li.tx(", ");
                }
                if (resourceWrapper.has("reference")) {
                    String desc;
                    url = resourceWrapper.primitiveValue("reference");
                    if (url.contains("#")) {
                        url = url.substring(0, url.indexOf("#"));
                    }
                    r = this.context.getWorker().fetchResource(Resource.class, url, req.getResourceNative());
                    Resolver.ResourceWithReference t = null;
                    if (r == null && this.context.getResolver() != null) {
                        t = this.context.getResolver().resolve(this.context, url, null);
                    }
                    if (r != null) {
                        desc = this.getResourceDescription(r, resourceWrapper.primitiveValue("display"));
                        li.ah(this.context.prefixLocalHref(resourceWrapper.primitiveValue("reference"))).tx(desc);
                        continue;
                    }
                    if (t != null) {
                        desc = this.getResourceDescription(t, resourceWrapper.primitiveValue("display"));
                        li.ah(this.context.prefixLocalHref(t.getWebPath())).tx(desc);
                        continue;
                    }
                    li.ah(this.context.prefixLocalHref(resourceWrapper.primitiveValue("reference"))).tx(url);
                    continue;
                }
                if (resourceWrapper.has("display")) {
                    li.tx(resourceWrapper.primitiveValue("display"));
                    continue;
                }
                li.tx("??");
            }
        }
    }

    private String getResourceDescription(Resolver.ResourceWithReference res, String display) throws UnsupportedEncodingException, IOException {
        if (!Utilities.noString((String)display)) {
            return display;
        }
        return RendererFactory.factory(res.getResource(), this.context.forContained()).buildSummary(res.getResource());
    }

    private String getResourceDescription(Resource res, String display) throws UnsupportedEncodingException, IOException {
        if (!Utilities.noString((String)display)) {
            return display;
        }
        if (res instanceof CanonicalResource) {
            return ((CanonicalResource)res).present();
        }
        return RendererFactory.factory(res, this.context.forContained()).buildSummary(this.wrap(res));
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }
}

