/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class OperationOutcomeRenderer
extends ResourceRenderer {
    public OperationOutcomeRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        List<ResourceWrapper> issues = r.children("issue");
        int hint = 0;
        int warn = 0;
        int err = 0;
        for (ResourceWrapper issue : issues) {
            switch (issue.primitiveValue("severity")) {
                case "information": {
                    ++hint;
                    break;
                }
                case "warning": {
                    ++warn;
                    break;
                }
                case "error": 
                case "fatal": {
                    ++err;
                }
            }
        }
        if (hint + warn + err == 0) {
            return this.context.formatPhrase("OP_OUT_SUMM_ALL_OK", new Object[0]);
        }
        if (hint == 0) {
            return this.context.formatPhrase("OP_OUT_SUMM_NOHINT", new Object[]{err, warn});
        }
        return this.context.formatPhrase("OP_OUT_SUMM", new Object[]{err, warn, hint});
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper op) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(op, x);
        boolean hasSource = false;
        boolean success = true;
        for (ResourceWrapper i : op.children("issue")) {
            success = success && "information".equals(i.primitiveValue("severity"));
            hasSource = hasSource || i.hasExtension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        }
        if (success) {
            x.para().tx(this.context.formatPhrase("OP_OUT_OK", new Object[0]));
        }
        if (op.has("issue")) {
            XhtmlNode tbl = x.table("grid", false);
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx(this.context.formatPhrase("OP_OUT_SEV", new Object[0]));
            tr.td().b().tx(this.context.formatPhrase("GENERAL_LOCATION", new Object[0]));
            tr.td().b().tx(this.context.formatPhrase("GENERAL_CODE", new Object[0]));
            tr.td().b().tx(this.context.formatPhrase("GENERAL_DETAILS", new Object[0]));
            tr.td().b().tx(this.context.formatPhrase("OP_OUT_DIAG", new Object[0]));
            if (hasSource) {
                tr.td().b().tx(this.context.formatPhrase("OP_OUT_SRC", new Object[0]));
            }
            for (ResourceWrapper i : op.children("issue")) {
                tr = tbl.tr();
                tr.td().addText(this.getTranslatedCode(i.child("severity")));
                XhtmlNode td = tr.td();
                boolean d = false;
                for (ResourceWrapper s : i.has("expression") ? i.children("expression") : i.children("location")) {
                    if (d) {
                        td.tx(", ");
                    } else {
                        d = true;
                    }
                    td.addText(s.primitiveValue());
                }
                tr.td().addText(this.getTranslatedCode(i.child("code")));
                if (i.has("details")) {
                    tr.td().addText(i.child("details").primitiveValue("text"));
                }
                this.smartAddText(tr.td(), i.primitiveValue("diagnostics"));
                if (!hasSource) continue;
                ResourceWrapper ext = i.extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
                tr.td().addText(ext == null || !ext.has("value") ? "" : this.displayDataType(ext.child("value")));
            }
        }
    }

    public void describe(XhtmlNode x, OperationOutcome oo) {
        x.tx(this.display(oo));
    }

    public String display(OperationOutcome oo) {
        return this.context.formatPhrase("GENERAL_TODO", new Object[0]);
    }

    public static String toString(OperationOutcome oo) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            b.append(issue.getSeverity().toCode() + ": " + issue.getDetails().getText());
        }
        return b.toString();
    }
}

