/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.utilities.FileUtilities;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class BinaryRenderer {
    private String folder;
    private List<String> filenames = new ArrayList<String>();
    private Map<String, String> scriptMappings;

    public BinaryRenderer(String folder, Map<String, String> scriptMappings) {
        this.folder = folder;
        this.scriptMappings = scriptMappings;
    }

    public String getFolder() {
        return this.folder;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public static String getBinContentAsString(byte[] bin) {
        return new String(bin, StandardCharsets.UTF_8);
    }

    public String display(Binary bin) throws IOException {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        this.render(div, bin);
        return new XhtmlComposer(false, true).compose(div);
    }

    public String display(Element bin) throws IOException {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        this.render(div, bin);
        return new XhtmlComposer(false, true).compose(div);
    }

    public String display(String id, String ct, byte[] cnt) throws IOException {
        XhtmlNode div = new XhtmlNode(NodeType.Element, "div");
        this.render(div, id, ct, cnt);
        return new XhtmlComposer(false, true).compose(div);
    }

    public void render(XhtmlNode x, Binary bin) throws IOException {
        String ct = bin.getContentType();
        byte[] cnt = bin.getContent();
        this.render(x, bin.getId(), ct, cnt);
    }

    public void render(XhtmlNode x, Element bin) throws IOException {
        String ct = bin.getNamedChildValue("contentType");
        String id = bin.getNamedChildValue("id");
        byte[] cnt = Base64.getMimeDecoder().decode(bin.getNamedChildValue("data"));
        this.render(x, id, ct, cnt);
    }

    public void render(XhtmlNode x, String id, String ct, byte[] cnt) throws IOException {
        this.filenames.clear();
        if (ct == null) {
            this.error(x, "No Content Type");
        } else if (ct.startsWith("image/")) {
            this.image(x, id, ct, cnt);
        } else if (this.isXml(ct)) {
            this.xml(x, cnt);
        } else if (this.isJson(ct)) {
            this.json(x, cnt);
        } else if (this.isTtl(ct)) {
            this.ttl(x, cnt);
        } else if (this.isText(ct)) {
            this.text(x, cnt, this.codeForMimeType(ct));
        } else {
            this.error(x, "The Content Type '" + ct + "' is not rendered in this context");
        }
    }

    private String codeForMimeType(String ct) {
        switch (ct) {
            case "text/x-gherkin": {
                return "gherkin language-gherkin";
            }
        }
        return this.scriptMappings.get(ct);
    }

    private void image(XhtmlNode x, String id, String ct, byte[] cnt) throws IOException {
        String ext = null;
        if (ct.startsWith("image/png")) {
            ext = ".png";
        } else if (ct.startsWith("image/jpeg")) {
            ext = ".jpg";
        } else if (ct.startsWith("image/gif")) {
            ext = ".gif";
        } else if (ct.startsWith("image/svg")) {
            ext = ".svg";
        }
        if (ext == null) {
            this.error(x, "The Image Type '" + ct + "' is not rendered in this context");
        } else {
            String fn = "Binary-Native-" + id + ext;
            FileUtilities.bytesToFile((byte[])cnt, (String)Utilities.path((String[])new String[]{this.folder, fn}));
            this.filenames.add(fn);
            x.img("Binary-Native-" + id + ext, "binary");
        }
    }

    private void error(XhtmlNode x, String message) {
        x.tx("[" + message + "]");
    }

    private boolean isXml(String ct) {
        return ct.startsWith("text/xml") || ct.startsWith("application/xml") || ct.contains("+xml");
    }

    private void xml(XhtmlNode x, byte[] cnt) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(cnt);
        XhtmlNode pre = x.pre("xml");
        pre.code(content);
    }

    private boolean isJson(String ct) {
        return ct.startsWith("text/json") || ct.startsWith("application/json") || ct.contains("+json");
    }

    private void json(XhtmlNode x, byte[] cnt) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(cnt);
        XhtmlNode pre = x.pre("json");
        pre.code(content);
    }

    private boolean isTtl(String ct) {
        return ct.startsWith("text/rdf") || ct.contains("+turtle");
    }

    private void ttl(XhtmlNode x, byte[] cnt) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(cnt);
        XhtmlNode pre = x.pre("rdf language-turtle");
        pre.code(content);
    }

    private boolean isText(String ct) {
        return ct.startsWith("text/");
    }

    private void text(XhtmlNode x, byte[] cnt, String code) {
        String content = "\r\n" + BinaryRenderer.getBinContentAsString(cnt);
        XhtmlNode pre = x.pre(code);
        pre.code(content);
    }
}

