/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.renderers.Renderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.ResourceWrapper;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.utilities.MarkedToMoveToAdjunctPackage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

@MarkedToMoveToAdjunctPackage
public class ActorDefinitionRenderer
extends ResourceRenderer {
    public ActorDefinitionRenderer(RenderingContext context) {
        super(context);
    }

    @Override
    public void buildNarrative(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        this.renderResourceTechDetails(r, x);
        boolean summ = this.genSummaryTable(status, x, r);
        this.render(status, x, r, summ);
    }

    @Override
    public String buildSummary(ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return this.canonicalTitle(r);
    }

    public void render(Renderer.RenderingStatus status, XhtmlNode x, ResourceWrapper acd, boolean summ) throws FHIRFormatError, DefinitionException, IOException {
        boolean first;
        XhtmlNode tbl = x.table("grid", false);
        XhtmlNode tr = tbl.tr();
        XhtmlNode td = null;
        if (!summ) {
            this.xlinkNarrative(tr.td(), acd.child("name")).b().tx(this.context.formatPhrase("ACTOR_DEF_ACT", new Object[]{this.context.getTranslated(acd.child("name"))}) + " ");
            this.xlinkNarrative(tr.td(), acd.child("title")).tx(this.context.getTranslated(acd.child("title")));
            this.xlinkNarrative(tr.td(), acd.child("type")).tx(this.context.formatPhrase("ACTOR_DEF_TYP", new Object[]{acd.primitiveValue("type")}) + " ");
            tr = tbl.tr();
            td = tr.td().colspan("3");
            this.xlinkNarrative(td, acd.child("documentation"));
            this.addMarkdown(td, this.context.getTranslated(acd.child("documentation")));
            if (acd.has("baseDefinition")) {
                this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("ACTOR_DERIVED_FROM", new Object[0]));
                td = tr.td().colspan("2");
                first = true;
                for (ResourceWrapper t : acd.children("reference")) {
                    if (first) {
                        first = false;
                    } else {
                        x.br();
                    }
                    this.renderUri(status, this.spanIfTracking(td, t), t);
                }
            }
        } else {
            this.xlinkNarrative(tr.td(), acd.child("type")).tx(this.context.formatPhrase("ACTOR_DEF_TYP", new Object[]{acd.primitiveValue("type")}) + " ");
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("ACTOR_DERIVED_FROM", new Object[0]));
            td = tr.td();
            if (acd.has("baseDefinition")) {
                first = true;
                for (ResourceWrapper t : acd.children("reference")) {
                    if (first) {
                        first = false;
                    } else {
                        x.br();
                    }
                    this.renderUri(status, this.spanIfTracking(td, t), t);
                }
            } else {
                this.markGenerated(td).style("opaque: 0.6").tx(this.context.formatPhrase("ACTOR_DERIVED_FROM_NONE", new Object[0]));
            }
        }
        if (acd.has("reference")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("GENERAL_REFS", new Object[0]));
            td = tr.td().colspan("2");
            first = true;
            for (ResourceWrapper t : acd.children("reference")) {
                if (first) {
                    first = false;
                } else {
                    x.br();
                }
                this.renderUri(status, this.spanIfTracking(td, t), t);
            }
        }
        if (acd.has("capabilities")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("ACTOR_DEF_CAP", new Object[0]));
            td = tr.td().colspan("2");
            this.renderCanonical(status, this.xlinkNarrative(td, acd.child("capabilities")), acd.child("capabilities"));
        }
        if (acd.has("derivedFrom")) {
            tr = tbl.tr();
            this.markBoilerplate(tr.td()).tx(this.context.formatPhrase("ACTOR_DEF_DER", new Object[0]));
            td = tr.td().colspan("2");
            first = true;
            for (ResourceWrapper t : acd.children("derivedFrom")) {
                if (first) {
                    first = false;
                } else {
                    x.br();
                }
                this.renderUri(status, this.spanIfTracking(td, t), t);
            }
        }
    }

    public void describe(XhtmlNode x, Library lib) {
        x.tx(this.display(lib));
    }

    public String display(Library lib) {
        return lib.present();
    }
}

