/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEType;

public class PEDefinitionSubExtension
extends PEDefinition {
    private ElementDefinition eed;
    private ElementDefinition ved;
    private ElementDefinition ued;

    public PEDefinitionSubExtension(PEBuilder builder, StructureDefinition profile, ElementDefinition definition, String ppath) {
        super(builder, definition.getSliceName(), profile, definition, ppath);
        List<ElementDefinition> childDefs = builder.getChildren(profile, definition);
        this.eed = this.getElementByName(childDefs, "extension");
        this.ved = this.getElementByName(childDefs, "value[x]");
        this.ued = this.getElementByName(childDefs, "url");
    }

    @Override
    public void listTypes(List<PEType> types) {
        if (this.ved.isRequired() || this.eed.isProhibited()) {
            for (ElementDefinition.TypeRefComponent t : this.ved.getType()) {
                if (t.hasProfile()) {
                    for (CanonicalType u : t.getProfile()) {
                        types.add(this.builder.makeType(t, u));
                    }
                    continue;
                }
                types.add(this.builder.makeType(t.getWorkingCode()));
            }
        } else {
            types.add(this.builder.makeType("Extension"));
        }
    }

    private ElementDefinition getElementByName(List<ElementDefinition> children, String name) {
        for (ElementDefinition ed : children) {
            if (!name.equals(ed.getName())) continue;
            return ed;
        }
        return null;
    }

    @Override
    public List<PEDefinition> directChildren(boolean allFixed) {
        ArrayList<PEDefinition> children = new ArrayList<PEDefinition>();
        children.addAll(this.builder.listChildren(allFixed, this, this.profile, this.definition, "http://hl7.org/fhir/StructureDefinition/Extension", new String[0]));
        return children;
    }

    @Override
    protected void makeChildren(String typeUrl, List<PEDefinition> children, boolean allFixed) {
        if (this.ved.isRequired() || this.eed.isProhibited()) {
            children.addAll(this.builder.listChildren(allFixed, this, this.profile, this.ved, typeUrl, new String[0]));
        } else {
            if (this.eed.getSlicing().getRules() != ElementDefinition.SlicingRules.CLOSED) {
                children.addAll(this.builder.listChildren(allFixed, this, this.profile, this.eed, "http://hl7.org/fhir/StructureDefinition/Extension", "value[x]", "url"));
            }
            children.addAll(this.builder.listSlices(this.profile, this.eed, this));
        }
    }

    @Override
    public String fhirpath() {
        if (this.ved.isRequired() || this.eed.isProhibited()) {
            return "extension('" + this.ued.getFixed().primitiveValue() + "').value";
        }
        return "extension('" + this.ued.getFixed().primitiveValue() + "')";
    }

    @Override
    public PEDefinition.PEDefinitionElementMode mode() {
        return PEDefinition.PEDefinitionElementMode.Extension;
    }

    @Override
    public boolean isExtension() {
        return true;
    }

    @Override
    public String getExtensionUrl() {
        return this.ued.getFixed().primitiveValue();
    }
}

