/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.patterns;

import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.patterns.PatternBase;

public interface Event
extends PatternBase {
    public List<Identifier> getIdentifier() throws FHIRException;

    public Event setIdentifier(List<Identifier> var1) throws FHIRException;

    public boolean hasIdentifier();

    public int getIdentifierMin();

    public int getIdentifierMax();

    public Identifier addIdentifier() throws FHIRException;

    public Event addIdentifier(Identifier var1) throws FHIRException;

    public Identifier getIdentifierFirstRep() throws FHIRException;

    public List<CanonicalType> getInstantiatesCanonical() throws FHIRException;

    public Event setInstantiatesCanonical(List<CanonicalType> var1) throws FHIRException;

    public boolean hasInstantiatesCanonical();

    public int getInstantiatesCanonicalMin();

    public int getInstantiatesCanonicalMax();

    public CanonicalType addInstantiatesCanonicalElement() throws FHIRException;

    public Event addInstantiatesCanonical(String var1) throws FHIRException;

    public boolean hasInstantiatesCanonical(String var1) throws FHIRException;

    public List<UriType> getInstantiatesUri() throws FHIRException;

    public Event setInstantiatesUri(List<UriType> var1) throws FHIRException;

    public boolean hasInstantiatesUri();

    public int getInstantiatesUriMin();

    public int getInstantiatesUriMax();

    public UriType addInstantiatesUriElement() throws FHIRException;

    public Event addInstantiatesUri(String var1) throws FHIRException;

    public boolean hasInstantiatesUri(String var1) throws FHIRException;

    public List<Reference> getBasedOn() throws FHIRException;

    public Event setBasedOn(List<Reference> var1) throws FHIRException;

    public boolean hasBasedOn();

    public int getBasedOnMin();

    public int getBasedOnMax();

    public Reference addBasedOn() throws FHIRException;

    public Event addBasedOn(Reference var1) throws FHIRException;

    public Reference getBasedOnFirstRep() throws FHIRException;

    public List<Reference> getPartOf() throws FHIRException;

    public Event setPartOf(List<Reference> var1) throws FHIRException;

    public boolean hasPartOf();

    public int getPartOfMin();

    public int getPartOfMax();

    public Reference addPartOf() throws FHIRException;

    public Event addPartOf(Reference var1) throws FHIRException;

    public Reference getPartOfFirstRep() throws FHIRException;

    public List<Reference> getResearchStudy() throws FHIRException;

    public Event setResearchStudy(List<Reference> var1) throws FHIRException;

    public boolean hasResearchStudy();

    public int getResearchStudyMin();

    public int getResearchStudyMax();

    public Reference addResearchStudy() throws FHIRException;

    public Event addResearchStudy(Reference var1) throws FHIRException;

    public Reference getResearchStudyFirstRep() throws FHIRException;

    public Enumeration<EventStatus> getStatusElement() throws FHIRException;

    public boolean hasStatus();

    public int getStatusMin() throws FHIRException;

    public int getStatusMax() throws FHIRException;

    public boolean hasStatusElement();

    public Event setStatusElement(Enumeration<EventStatus> var1) throws FHIRException;

    public EventStatus getStatus() throws FHIRException;

    public Event setStatus(EventStatus var1) throws FHIRException;

    public CodeableConcept getStatusReason() throws FHIRException;

    public boolean hasStatusReason();

    public int getStatusReasonMin();

    public int getStatusReasonMax();

    public Event setStatusReason(CodeableConcept var1) throws FHIRException;

    public CodeableConcept getCode() throws FHIRException;

    public boolean hasCode();

    public int getCodeMin();

    public int getCodeMax();

    public Event setCode(CodeableConcept var1) throws FHIRException;

    public Reference getSubject() throws FHIRException;

    public boolean hasSubject();

    public int getSubjectMin();

    public int getSubjectMax();

    public Event setSubject(Reference var1) throws FHIRException;

    public Reference getEncounter() throws FHIRException;

    public boolean hasEncounter();

    public int getEncounterMin();

    public int getEncounterMax();

    public Event setEncounter(Reference var1) throws FHIRException;

    public DataType getOccurrence() throws FHIRException;

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException;

    public boolean hasOccurrenceDateTimeType();

    public Period getOccurrencePeriod() throws FHIRException;

    public boolean hasOccurrencePeriod();

    public Timing getOccurrenceTiming() throws FHIRException;

    public boolean hasOccurrenceTiming();

    public boolean hasOccurrence();

    public int getOccurrenceMin();

    public int getOccurrenceMax();

    public Event setOccurrence(DataType var1) throws FHIRException;

    public DateTimeType getRecordedElement() throws FHIRException;

    public boolean hasRecorded();

    public int getRecordedMin() throws FHIRException;

    public int getRecordedMax() throws FHIRException;

    public boolean hasRecordedElement();

    public Event setRecordedElement(DateTimeType var1) throws FHIRException;

    public Date getRecorded() throws FHIRException;

    public Event setRecorded(Date var1) throws FHIRException;

    public DataType getReported() throws FHIRException;

    public BooleanType getReportedBooleanType() throws FHIRException;

    public boolean hasReportedBooleanType();

    public Reference getReportedReference() throws FHIRException;

    public boolean hasReportedReference();

    public boolean hasReported();

    public int getReportedMin();

    public int getReportedMax();

    public Event setReported(DataType var1) throws FHIRException;

    public List<EventPerformerComponent> getPerformer() throws FHIRException;

    public Event setPerformer(List<EventPerformerComponent> var1) throws FHIRException;

    public boolean hasPerformer();

    public int getPerformerMin();

    public int getPerformerMax();

    public EventPerformerComponent addPerformer() throws FHIRException;

    public Event addPerformer(EventPerformerComponent var1) throws FHIRException;

    public EventPerformerComponent getPerformerFirstRep() throws FHIRException;

    public Reference getLocation() throws FHIRException;

    public boolean hasLocation();

    public int getLocationMin();

    public int getLocationMax();

    public Event setLocation(Reference var1) throws FHIRException;

    public List<CodeableConcept> getReasonCode() throws FHIRException;

    public Event setReasonCode(List<CodeableConcept> var1) throws FHIRException;

    public boolean hasReasonCode();

    public int getReasonCodeMin();

    public int getReasonCodeMax();

    public CodeableConcept addReasonCode() throws FHIRException;

    public Event addReasonCode(CodeableConcept var1) throws FHIRException;

    public CodeableConcept getReasonCodeFirstRep() throws FHIRException;

    public List<Reference> getReasonReference() throws FHIRException;

    public Event setReasonReference(List<Reference> var1) throws FHIRException;

    public boolean hasReasonReference();

    public int getReasonReferenceMin();

    public int getReasonReferenceMax();

    public Reference addReasonReference() throws FHIRException;

    public Event addReasonReference(Reference var1) throws FHIRException;

    public Reference getReasonReferenceFirstRep() throws FHIRException;

    public List<Annotation> getNote() throws FHIRException;

    public Event setNote(List<Annotation> var1) throws FHIRException;

    public boolean hasNote();

    public int getNoteMin();

    public int getNoteMax();

    public Annotation addNote() throws FHIRException;

    public Event addNote(Annotation var1) throws FHIRException;

    public Annotation getNoteFirstRep() throws FHIRException;

    public String fhirType();

    public static interface EventPerformerComponent
    extends PatternBase {
        public CodeableConcept getFunction() throws FHIRException;

        public boolean hasFunction();

        public int getFunctionMin();

        public int getFunctionMax();

        public EventPerformerComponent setFunction(CodeableConcept var1) throws FHIRException;

        public Reference getActor() throws FHIRException;

        public boolean hasActor();

        public int getActorMin();

        public int getActorMax();

        public EventPerformerComponent setActor(Reference var1) throws FHIRException;
    }

    public static class EventStatusEnumFactory
    implements EnumFactory<EventStatus> {
        @Override
        public EventStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return EventStatus.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return EventStatus.INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return EventStatus.NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return EventStatus.ONHOLD;
            }
            if ("stopped".equals(codeString)) {
                return EventStatus.STOPPED;
            }
            if ("completed".equals(codeString)) {
                return EventStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return EventStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return EventStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown EventStatus code '" + codeString + "'");
        }

        public Enumeration<EventStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EventStatus>(this, EventStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.NULL, code);
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.PREPARATION, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.INPROGRESS, code);
            }
            if ("not-done".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.NOTDONE, code);
            }
            if ("on-hold".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.ONHOLD, code);
            }
            if ("stopped".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.STOPPED, code);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.COMPLETED, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.ENTEREDINERROR, code);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<EventStatus>(this, EventStatus.UNKNOWN, code);
            }
            throw new FHIRException("Unknown EventStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EventStatus code) {
            if (code == EventStatus.NULL) {
                return null;
            }
            if (code == EventStatus.PREPARATION) {
                return "preparation";
            }
            if (code == EventStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == EventStatus.NOTDONE) {
                return "not-done";
            }
            if (code == EventStatus.ONHOLD) {
                return "on-hold";
            }
            if (code == EventStatus.STOPPED) {
                return "stopped";
            }
            if (code == EventStatus.COMPLETED) {
                return "completed";
            }
            if (code == EventStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == EventStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(EventStatus code) {
            return code.getSystem();
        }
    }

    public static enum EventStatus {
        PREPARATION,
        INPROGRESS,
        NOTDONE,
        ONHOLD,
        STOPPED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static EventStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("not-done".equals(codeString)) {
                return NOTDONE;
            }
            if ("on-hold".equals(codeString)) {
                return ONHOLD;
            }
            if ("stopped".equals(codeString)) {
                return STOPPED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EventStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case NOTDONE: {
                    return "not-done";
                }
                case ONHOLD: {
                    return "on-hold";
                }
                case STOPPED: {
                    return "stopped";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/event-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NOTDONE: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/event-status";
                }
                case STOPPED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
                }
                case INPROGRESS: {
                    return "The event is currently occurring.";
                }
                case NOTDONE: {
                    return "The event was terminated prior to any activity beyond preparation.  I.e. The 'main' activity has not yet begun.  The boundary between preparatory and the 'main' activity is context-specific.";
                }
                case ONHOLD: {
                    return "The event has been temporarily stopped but is expected to resume in the future.";
                }
                case STOPPED: {
                    return "The event was terminated prior to the full completion of the intended activity but after at least some of the 'main' activity (beyond preparation) has occurred.";
                }
                case COMPLETED: {
                    return "The event has now concluded.";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The authoring/source system does not know which of the status values currently applies for this event.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply,  but the authoring/source system does not know which.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case NOTDONE: {
                    return "Not Done";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case STOPPED: {
                    return "Stopped";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

