/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.Annotations;
import org.hl7.fhir.r5.openehr.TranslatedString;
import org.hl7.fhir.r5.openehr.WebTemplateInput;
import org.hl7.fhir.r5.openehr.WebTemplateTermBinding;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="WebTemplateItem")
public class WebTemplateItem
extends LogicalBase
implements ICompositeType {
    @Child(name="id", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Node ID (this ID is needed when input data is converted to a composition)", formalDefinition="")
    protected StringType id;
    @Child(name="depth", type={IntegerType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected IntegerType depth;
    @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Default node name", formalDefinition="")
    protected StringType name;
    @Child(name="localizedName", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Node name in the default language", formalDefinition="")
    protected StringType localizedName;
    @Child(name="rmType", type={CodeType.class}, order=4, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference Model class name for this node", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-item-rmtype")
    protected CodeType rmType;
    @Child(name="nodeId", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Archetype node id as either a full openEHR-EHR-xxxxx archetype id or just an at-code", formalDefinition="")
    protected StringType nodeId;
    @Child(name="min", type={StringType.class}, order=6, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Minimal value of occurrences for this node (this node has to appear at least this many times)", formalDefinition="")
    protected StringType min;
    @Child(name="max", type={StringType.class}, order=7, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Maximal value of occurrences for this node or -1 if unlimited. When converting to a composition this node should not appear more than this many times.", formalDefinition="")
    protected StringType max;
    @Child(name="dependsOn", type={StringType.class}, order=8, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType dependsOn;
    @Child(name="localizedNames", type={TranslatedString.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Map with labels in additional languages", formalDefinition="")
    protected List<TranslatedString> localizedNamesList;
    @Child(name="localizedDescriptions", type={TranslatedString.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Map with element descriptions", formalDefinition="")
    protected List<TranslatedString> localizedDescriptionsList;
    @Child(name="annotations", type={Annotations.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected Annotations annotations;
    @Child(name="archetype_id", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType archetype_id;
    @Child(name="aqlPath", type={StringType.class}, order=13, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="AQL (or RM) path to this node. Such paths can be used in AQLs", formalDefinition="")
    protected StringType aqlPath;
    @Child(name="custodian_namespace", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType custodian_namespace;
    @Child(name="custodian_organisation", type={StringType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType custodian_organisation;
    @Child(name="lifecycleState", type={CodeType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-item-lifecyclestate")
    protected CodeType lifecycleState;
    @Child(name="original_namespace", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType original_namespace;
    @Child(name="original_publisher", type={StringType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType original_publisher;
    @Child(name="proportionTypes", type={CodeType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    @Binding(valueSet="https://specifications.openehr.org/fhir/valueset-item-proportiontype")
    protected CodeType proportionTypes;
    @Child(name="revision", type={StringType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType revision;
    @Child(name="inContext", type={BooleanType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected BooleanType inContext;
    @Child(name="inputs", type={WebTemplateInput.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Used for creating input fields. the inputs are determined by the attributes for a particular datatype", formalDefinition="")
    protected List<WebTemplateInput> inputsList;
    @Child(name="termBindings", type={WebTemplateTermBinding.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected List<WebTemplateTermBinding> termBindingsList;
    @Child(name="children", type={WebTemplateItem.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected List<WebTemplateItem> childrenList;
    private static final long serialVersionUID = -1765598574L;

    public WebTemplateItem() {
    }

    public WebTemplateItem(String id, String rmType, String min, String max, String dependsOn, String aqlPath) {
        this.setId(id);
        this.setRmType(rmType);
        this.setMin(min);
        this.setMax(max);
        this.setDependsOn(dependsOn);
        this.setAqlPath(aqlPath);
    }

    public StringType getIdElement() {
        if (this.id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.id");
            }
            if (Configuration.doAutoCreate()) {
                this.id = new StringType();
            }
        }
        return this.id;
    }

    public boolean hasIdElement() {
        return this.id != null && !this.id.isEmpty();
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public WebTemplateItem setIdElement(StringType value) {
        this.id = value;
        return this;
    }

    public String getId() {
        return this.id == null ? null : (String)this.id.getValue();
    }

    public WebTemplateItem setId(String value) {
        if (this.id == null) {
            this.id = new StringType();
        }
        this.id.setValue(value);
        return this;
    }

    public IntegerType getDepthElement() {
        if (this.depth == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.depth");
            }
            if (Configuration.doAutoCreate()) {
                this.depth = new IntegerType();
            }
        }
        return this.depth;
    }

    public boolean hasDepthElement() {
        return this.depth != null && !this.depth.isEmpty();
    }

    public boolean hasDepth() {
        return this.depth != null && !this.depth.isEmpty();
    }

    public WebTemplateItem setDepthElement(IntegerType value) {
        this.depth = value;
        return this;
    }

    public int getDepth() {
        return this.depth == null || this.depth.isEmpty() ? 0 : (Integer)this.depth.getValue();
    }

    public WebTemplateItem setDepth(int value) {
        if (this.depth == null) {
            this.depth = new IntegerType();
        }
        this.depth.setValue((Object)value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public WebTemplateItem setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public WebTemplateItem setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getLocalizedNameElement() {
        if (this.localizedName == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.localizedName");
            }
            if (Configuration.doAutoCreate()) {
                this.localizedName = new StringType();
            }
        }
        return this.localizedName;
    }

    public boolean hasLocalizedNameElement() {
        return this.localizedName != null && !this.localizedName.isEmpty();
    }

    public boolean hasLocalizedName() {
        return this.localizedName != null && !this.localizedName.isEmpty();
    }

    public WebTemplateItem setLocalizedNameElement(StringType value) {
        this.localizedName = value;
        return this;
    }

    public String getLocalizedName() {
        return this.localizedName == null ? null : (String)this.localizedName.getValue();
    }

    public WebTemplateItem setLocalizedName(String value) {
        if (Utilities.noString((String)value)) {
            this.localizedName = null;
        } else {
            if (this.localizedName == null) {
                this.localizedName = new StringType();
            }
            this.localizedName.setValue(value);
        }
        return this;
    }

    public CodeType getRmTypeElement() {
        if (this.rmType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.rmType");
            }
            if (Configuration.doAutoCreate()) {
                this.rmType = new CodeType();
            }
        }
        return this.rmType;
    }

    public boolean hasRmTypeElement() {
        return this.rmType != null && !this.rmType.isEmpty();
    }

    public boolean hasRmType() {
        return this.rmType != null && !this.rmType.isEmpty();
    }

    public WebTemplateItem setRmTypeElement(CodeType value) {
        this.rmType = value;
        return this;
    }

    public String getRmType() {
        return this.rmType == null ? null : (String)this.rmType.getValue();
    }

    public WebTemplateItem setRmType(String value) {
        if (this.rmType == null) {
            this.rmType = new CodeType();
        }
        this.rmType.setValue(value);
        return this;
    }

    public StringType getNodeIdElement() {
        if (this.nodeId == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.nodeId");
            }
            if (Configuration.doAutoCreate()) {
                this.nodeId = new StringType();
            }
        }
        return this.nodeId;
    }

    public boolean hasNodeIdElement() {
        return this.nodeId != null && !this.nodeId.isEmpty();
    }

    public boolean hasNodeId() {
        return this.nodeId != null && !this.nodeId.isEmpty();
    }

    public WebTemplateItem setNodeIdElement(StringType value) {
        this.nodeId = value;
        return this;
    }

    public String getNodeId() {
        return this.nodeId == null ? null : (String)this.nodeId.getValue();
    }

    public WebTemplateItem setNodeId(String value) {
        if (Utilities.noString((String)value)) {
            this.nodeId = null;
        } else {
            if (this.nodeId == null) {
                this.nodeId = new StringType();
            }
            this.nodeId.setValue(value);
        }
        return this;
    }

    public StringType getMinElement() {
        if (this.min == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.min");
            }
            if (Configuration.doAutoCreate()) {
                this.min = new StringType();
            }
        }
        return this.min;
    }

    public boolean hasMinElement() {
        return this.min != null && !this.min.isEmpty();
    }

    public boolean hasMin() {
        return this.min != null && !this.min.isEmpty();
    }

    public WebTemplateItem setMinElement(StringType value) {
        this.min = value;
        return this;
    }

    public String getMin() {
        return this.min == null ? null : (String)this.min.getValue();
    }

    public WebTemplateItem setMin(String value) {
        if (this.min == null) {
            this.min = new StringType();
        }
        this.min.setValue(value);
        return this;
    }

    public StringType getMaxElement() {
        if (this.max == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.max");
            }
            if (Configuration.doAutoCreate()) {
                this.max = new StringType();
            }
        }
        return this.max;
    }

    public boolean hasMaxElement() {
        return this.max != null && !this.max.isEmpty();
    }

    public boolean hasMax() {
        return this.max != null && !this.max.isEmpty();
    }

    public WebTemplateItem setMaxElement(StringType value) {
        this.max = value;
        return this;
    }

    public String getMax() {
        return this.max == null ? null : (String)this.max.getValue();
    }

    public WebTemplateItem setMax(String value) {
        if (this.max == null) {
            this.max = new StringType();
        }
        this.max.setValue(value);
        return this;
    }

    public StringType getDependsOnElement() {
        if (this.dependsOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.dependsOn");
            }
            if (Configuration.doAutoCreate()) {
                this.dependsOn = new StringType();
            }
        }
        return this.dependsOn;
    }

    public boolean hasDependsOnElement() {
        return this.dependsOn != null && !this.dependsOn.isEmpty();
    }

    public boolean hasDependsOn() {
        return this.dependsOn != null && !this.dependsOn.isEmpty();
    }

    public WebTemplateItem setDependsOnElement(StringType value) {
        this.dependsOn = value;
        return this;
    }

    public String getDependsOn() {
        return this.dependsOn == null ? null : (String)this.dependsOn.getValue();
    }

    public WebTemplateItem setDependsOn(String value) {
        if (this.dependsOn == null) {
            this.dependsOn = new StringType();
        }
        this.dependsOn.setValue(value);
        return this;
    }

    public List<TranslatedString> getLocalizedNamesList() {
        if (this.localizedNamesList == null) {
            this.localizedNamesList = new ArrayList<TranslatedString>();
        }
        return this.localizedNamesList;
    }

    public WebTemplateItem setLocalizedNamesList(List<TranslatedString> theLocalizedNames) {
        this.localizedNamesList = theLocalizedNames;
        return this;
    }

    public boolean hasLocalizedNames() {
        if (this.localizedNamesList == null) {
            return false;
        }
        for (TranslatedString item : this.localizedNamesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TranslatedString addLocalizedNames() {
        TranslatedString t = new TranslatedString();
        if (this.localizedNamesList == null) {
            this.localizedNamesList = new ArrayList<TranslatedString>();
        }
        this.localizedNamesList.add(t);
        return t;
    }

    public WebTemplateItem addLocalizedNames(TranslatedString t) {
        if (t == null) {
            return this;
        }
        if (this.localizedNamesList == null) {
            this.localizedNamesList = new ArrayList<TranslatedString>();
        }
        this.localizedNamesList.add(t);
        return this;
    }

    public TranslatedString getLocalizedNamesFirstRep() {
        if (this.getLocalizedNamesList().isEmpty()) {
            this.addLocalizedNames();
        }
        return this.getLocalizedNamesList().get(0);
    }

    public List<TranslatedString> getLocalizedDescriptionsList() {
        if (this.localizedDescriptionsList == null) {
            this.localizedDescriptionsList = new ArrayList<TranslatedString>();
        }
        return this.localizedDescriptionsList;
    }

    public WebTemplateItem setLocalizedDescriptionsList(List<TranslatedString> theLocalizedDescriptions) {
        this.localizedDescriptionsList = theLocalizedDescriptions;
        return this;
    }

    public boolean hasLocalizedDescriptions() {
        if (this.localizedDescriptionsList == null) {
            return false;
        }
        for (TranslatedString item : this.localizedDescriptionsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TranslatedString addLocalizedDescriptions() {
        TranslatedString t = new TranslatedString();
        if (this.localizedDescriptionsList == null) {
            this.localizedDescriptionsList = new ArrayList<TranslatedString>();
        }
        this.localizedDescriptionsList.add(t);
        return t;
    }

    public WebTemplateItem addLocalizedDescriptions(TranslatedString t) {
        if (t == null) {
            return this;
        }
        if (this.localizedDescriptionsList == null) {
            this.localizedDescriptionsList = new ArrayList<TranslatedString>();
        }
        this.localizedDescriptionsList.add(t);
        return this;
    }

    public TranslatedString getLocalizedDescriptionsFirstRep() {
        if (this.getLocalizedDescriptionsList().isEmpty()) {
            this.addLocalizedDescriptions();
        }
        return this.getLocalizedDescriptionsList().get(0);
    }

    public Annotations getAnnotations() {
        if (this.annotations == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.annotations");
            }
            if (Configuration.doAutoCreate()) {
                this.annotations = new Annotations();
            }
        }
        return this.annotations;
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public WebTemplateItem setAnnotations(Annotations value) {
        this.annotations = value;
        return this;
    }

    public StringType getArchetype_idElement() {
        if (this.archetype_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.archetype_id");
            }
            if (Configuration.doAutoCreate()) {
                this.archetype_id = new StringType();
            }
        }
        return this.archetype_id;
    }

    public boolean hasArchetype_idElement() {
        return this.archetype_id != null && !this.archetype_id.isEmpty();
    }

    public boolean hasArchetype_id() {
        return this.archetype_id != null && !this.archetype_id.isEmpty();
    }

    public WebTemplateItem setArchetype_idElement(StringType value) {
        this.archetype_id = value;
        return this;
    }

    public String getArchetype_id() {
        return this.archetype_id == null ? null : (String)this.archetype_id.getValue();
    }

    public WebTemplateItem setArchetype_id(String value) {
        if (Utilities.noString((String)value)) {
            this.archetype_id = null;
        } else {
            if (this.archetype_id == null) {
                this.archetype_id = new StringType();
            }
            this.archetype_id.setValue(value);
        }
        return this;
    }

    public StringType getAqlPathElement() {
        if (this.aqlPath == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.aqlPath");
            }
            if (Configuration.doAutoCreate()) {
                this.aqlPath = new StringType();
            }
        }
        return this.aqlPath;
    }

    public boolean hasAqlPathElement() {
        return this.aqlPath != null && !this.aqlPath.isEmpty();
    }

    public boolean hasAqlPath() {
        return this.aqlPath != null && !this.aqlPath.isEmpty();
    }

    public WebTemplateItem setAqlPathElement(StringType value) {
        this.aqlPath = value;
        return this;
    }

    public String getAqlPath() {
        return this.aqlPath == null ? null : (String)this.aqlPath.getValue();
    }

    public WebTemplateItem setAqlPath(String value) {
        if (this.aqlPath == null) {
            this.aqlPath = new StringType();
        }
        this.aqlPath.setValue(value);
        return this;
    }

    public StringType getCustodian_namespaceElement() {
        if (this.custodian_namespace == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.custodian_namespace");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian_namespace = new StringType();
            }
        }
        return this.custodian_namespace;
    }

    public boolean hasCustodian_namespaceElement() {
        return this.custodian_namespace != null && !this.custodian_namespace.isEmpty();
    }

    public boolean hasCustodian_namespace() {
        return this.custodian_namespace != null && !this.custodian_namespace.isEmpty();
    }

    public WebTemplateItem setCustodian_namespaceElement(StringType value) {
        this.custodian_namespace = value;
        return this;
    }

    public String getCustodian_namespace() {
        return this.custodian_namespace == null ? null : (String)this.custodian_namespace.getValue();
    }

    public WebTemplateItem setCustodian_namespace(String value) {
        if (Utilities.noString((String)value)) {
            this.custodian_namespace = null;
        } else {
            if (this.custodian_namespace == null) {
                this.custodian_namespace = new StringType();
            }
            this.custodian_namespace.setValue(value);
        }
        return this;
    }

    public StringType getCustodian_organisationElement() {
        if (this.custodian_organisation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.custodian_organisation");
            }
            if (Configuration.doAutoCreate()) {
                this.custodian_organisation = new StringType();
            }
        }
        return this.custodian_organisation;
    }

    public boolean hasCustodian_organisationElement() {
        return this.custodian_organisation != null && !this.custodian_organisation.isEmpty();
    }

    public boolean hasCustodian_organisation() {
        return this.custodian_organisation != null && !this.custodian_organisation.isEmpty();
    }

    public WebTemplateItem setCustodian_organisationElement(StringType value) {
        this.custodian_organisation = value;
        return this;
    }

    public String getCustodian_organisation() {
        return this.custodian_organisation == null ? null : (String)this.custodian_organisation.getValue();
    }

    public WebTemplateItem setCustodian_organisation(String value) {
        if (Utilities.noString((String)value)) {
            this.custodian_organisation = null;
        } else {
            if (this.custodian_organisation == null) {
                this.custodian_organisation = new StringType();
            }
            this.custodian_organisation.setValue(value);
        }
        return this;
    }

    public CodeType getLifecycleStateElement() {
        if (this.lifecycleState == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.lifecycleState");
            }
            if (Configuration.doAutoCreate()) {
                this.lifecycleState = new CodeType();
            }
        }
        return this.lifecycleState;
    }

    public boolean hasLifecycleStateElement() {
        return this.lifecycleState != null && !this.lifecycleState.isEmpty();
    }

    public boolean hasLifecycleState() {
        return this.lifecycleState != null && !this.lifecycleState.isEmpty();
    }

    public WebTemplateItem setLifecycleStateElement(CodeType value) {
        this.lifecycleState = value;
        return this;
    }

    public String getLifecycleState() {
        return this.lifecycleState == null ? null : (String)this.lifecycleState.getValue();
    }

    public WebTemplateItem setLifecycleState(String value) {
        if (Utilities.noString((String)value)) {
            this.lifecycleState = null;
        } else {
            if (this.lifecycleState == null) {
                this.lifecycleState = new CodeType();
            }
            this.lifecycleState.setValue(value);
        }
        return this;
    }

    public StringType getOriginal_namespaceElement() {
        if (this.original_namespace == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.original_namespace");
            }
            if (Configuration.doAutoCreate()) {
                this.original_namespace = new StringType();
            }
        }
        return this.original_namespace;
    }

    public boolean hasOriginal_namespaceElement() {
        return this.original_namespace != null && !this.original_namespace.isEmpty();
    }

    public boolean hasOriginal_namespace() {
        return this.original_namespace != null && !this.original_namespace.isEmpty();
    }

    public WebTemplateItem setOriginal_namespaceElement(StringType value) {
        this.original_namespace = value;
        return this;
    }

    public String getOriginal_namespace() {
        return this.original_namespace == null ? null : (String)this.original_namespace.getValue();
    }

    public WebTemplateItem setOriginal_namespace(String value) {
        if (Utilities.noString((String)value)) {
            this.original_namespace = null;
        } else {
            if (this.original_namespace == null) {
                this.original_namespace = new StringType();
            }
            this.original_namespace.setValue(value);
        }
        return this;
    }

    public StringType getOriginal_publisherElement() {
        if (this.original_publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.original_publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.original_publisher = new StringType();
            }
        }
        return this.original_publisher;
    }

    public boolean hasOriginal_publisherElement() {
        return this.original_publisher != null && !this.original_publisher.isEmpty();
    }

    public boolean hasOriginal_publisher() {
        return this.original_publisher != null && !this.original_publisher.isEmpty();
    }

    public WebTemplateItem setOriginal_publisherElement(StringType value) {
        this.original_publisher = value;
        return this;
    }

    public String getOriginal_publisher() {
        return this.original_publisher == null ? null : (String)this.original_publisher.getValue();
    }

    public WebTemplateItem setOriginal_publisher(String value) {
        if (Utilities.noString((String)value)) {
            this.original_publisher = null;
        } else {
            if (this.original_publisher == null) {
                this.original_publisher = new StringType();
            }
            this.original_publisher.setValue(value);
        }
        return this;
    }

    public CodeType getProportionTypesElement() {
        if (this.proportionTypes == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.proportionTypes");
            }
            if (Configuration.doAutoCreate()) {
                this.proportionTypes = new CodeType();
            }
        }
        return this.proportionTypes;
    }

    public boolean hasProportionTypesElement() {
        return this.proportionTypes != null && !this.proportionTypes.isEmpty();
    }

    public boolean hasProportionTypes() {
        return this.proportionTypes != null && !this.proportionTypes.isEmpty();
    }

    public WebTemplateItem setProportionTypesElement(CodeType value) {
        this.proportionTypes = value;
        return this;
    }

    public String getProportionTypes() {
        return this.proportionTypes == null ? null : (String)this.proportionTypes.getValue();
    }

    public WebTemplateItem setProportionTypes(String value) {
        if (Utilities.noString((String)value)) {
            this.proportionTypes = null;
        } else {
            if (this.proportionTypes == null) {
                this.proportionTypes = new CodeType();
            }
            this.proportionTypes.setValue(value);
        }
        return this;
    }

    public StringType getRevisionElement() {
        if (this.revision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.revision");
            }
            if (Configuration.doAutoCreate()) {
                this.revision = new StringType();
            }
        }
        return this.revision;
    }

    public boolean hasRevisionElement() {
        return this.revision != null && !this.revision.isEmpty();
    }

    public boolean hasRevision() {
        return this.revision != null && !this.revision.isEmpty();
    }

    public WebTemplateItem setRevisionElement(StringType value) {
        this.revision = value;
        return this;
    }

    public String getRevision() {
        return this.revision == null ? null : (String)this.revision.getValue();
    }

    public WebTemplateItem setRevision(String value) {
        if (Utilities.noString((String)value)) {
            this.revision = null;
        } else {
            if (this.revision == null) {
                this.revision = new StringType();
            }
            this.revision.setValue(value);
        }
        return this;
    }

    public BooleanType getInContextElement() {
        if (this.inContext == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateItem.inContext");
            }
            if (Configuration.doAutoCreate()) {
                this.inContext = new BooleanType();
            }
        }
        return this.inContext;
    }

    public boolean hasInContextElement() {
        return this.inContext != null && !this.inContext.isEmpty();
    }

    public boolean hasInContext() {
        return this.inContext != null && !this.inContext.isEmpty();
    }

    public WebTemplateItem setInContextElement(BooleanType value) {
        this.inContext = value;
        return this;
    }

    public boolean getInContext() {
        return this.inContext == null || this.inContext.isEmpty() ? false : (Boolean)this.inContext.getValue();
    }

    public WebTemplateItem setInContext(boolean value) {
        if (this.inContext == null) {
            this.inContext = new BooleanType();
        }
        this.inContext.setValue((Object)value);
        return this;
    }

    public List<WebTemplateInput> getInputsList() {
        if (this.inputsList == null) {
            this.inputsList = new ArrayList<WebTemplateInput>();
        }
        return this.inputsList;
    }

    public WebTemplateItem setInputsList(List<WebTemplateInput> theInputs) {
        this.inputsList = theInputs;
        return this;
    }

    public boolean hasInputs() {
        if (this.inputsList == null) {
            return false;
        }
        for (WebTemplateInput item : this.inputsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public WebTemplateInput addInputs() {
        WebTemplateInput t = new WebTemplateInput();
        if (this.inputsList == null) {
            this.inputsList = new ArrayList<WebTemplateInput>();
        }
        this.inputsList.add(t);
        return t;
    }

    public WebTemplateItem addInputs(WebTemplateInput t) {
        if (t == null) {
            return this;
        }
        if (this.inputsList == null) {
            this.inputsList = new ArrayList<WebTemplateInput>();
        }
        this.inputsList.add(t);
        return this;
    }

    public WebTemplateInput getInputsFirstRep() {
        if (this.getInputsList().isEmpty()) {
            this.addInputs();
        }
        return this.getInputsList().get(0);
    }

    public List<WebTemplateTermBinding> getTermBindingsList() {
        if (this.termBindingsList == null) {
            this.termBindingsList = new ArrayList<WebTemplateTermBinding>();
        }
        return this.termBindingsList;
    }

    public WebTemplateItem setTermBindingsList(List<WebTemplateTermBinding> theTermBindings) {
        this.termBindingsList = theTermBindings;
        return this;
    }

    public boolean hasTermBindings() {
        if (this.termBindingsList == null) {
            return false;
        }
        for (WebTemplateTermBinding item : this.termBindingsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public WebTemplateTermBinding addTermBindings() {
        WebTemplateTermBinding t = new WebTemplateTermBinding();
        if (this.termBindingsList == null) {
            this.termBindingsList = new ArrayList<WebTemplateTermBinding>();
        }
        this.termBindingsList.add(t);
        return t;
    }

    public WebTemplateItem addTermBindings(WebTemplateTermBinding t) {
        if (t == null) {
            return this;
        }
        if (this.termBindingsList == null) {
            this.termBindingsList = new ArrayList<WebTemplateTermBinding>();
        }
        this.termBindingsList.add(t);
        return this;
    }

    public WebTemplateTermBinding getTermBindingsFirstRep() {
        if (this.getTermBindingsList().isEmpty()) {
            this.addTermBindings();
        }
        return this.getTermBindingsList().get(0);
    }

    public List<WebTemplateItem> getChildrenList() {
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<WebTemplateItem>();
        }
        return this.childrenList;
    }

    public WebTemplateItem setChildrenList(List<WebTemplateItem> theChildren) {
        this.childrenList = theChildren;
        return this;
    }

    public boolean hasChildren() {
        if (this.childrenList == null) {
            return false;
        }
        for (WebTemplateItem item : this.childrenList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public WebTemplateItem addChildren() {
        WebTemplateItem t = new WebTemplateItem();
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<WebTemplateItem>();
        }
        this.childrenList.add(t);
        return t;
    }

    public WebTemplateItem addChildren(WebTemplateItem t) {
        if (t == null) {
            return this;
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<WebTemplateItem>();
        }
        this.childrenList.add(t);
        return this;
    }

    public WebTemplateItem getChildrenFirstRep() {
        if (this.getChildrenList().isEmpty()) {
            this.addChildren();
        }
        return this.getChildrenList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("id", "string", "", 0, 1, this.id));
        children.add(new Property("depth", "integer", "", 0, 1, this.depth));
        children.add(new Property("name", "string", "", 0, 1, this.name));
        children.add(new Property("localizedName", "string", "", 0, 1, this.localizedName));
        children.add(new Property("rmType", "code", "", 0, 1, this.rmType));
        children.add(new Property("nodeId", "string", "", 0, 1, this.nodeId));
        children.add(new Property("min", "string", "", 0, 1, this.min));
        children.add(new Property("max", "string", "", 0, 1, this.max));
        children.add(new Property("dependsOn", "string", "", 0, 1, this.dependsOn));
        children.add(new Property("localizedNames", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedNamesList));
        children.add(new Property("localizedDescriptions", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedDescriptionsList));
        children.add(new Property("annotations", "http://openehr.org/fhir/StructureDefinition/Annotations", "", 0, 1, this.annotations));
        children.add(new Property("archetype_id", "string", "", 0, 1, this.archetype_id));
        children.add(new Property("aqlPath", "string", "", 0, 1, this.aqlPath));
        children.add(new Property("custodian_namespace", "string", "", 0, 1, this.custodian_namespace));
        children.add(new Property("custodian_organisation", "string", "", 0, 1, this.custodian_organisation));
        children.add(new Property("lifecycleState", "code", "", 0, 1, this.lifecycleState));
        children.add(new Property("original_namespace", "string", "", 0, 1, this.original_namespace));
        children.add(new Property("original_publisher", "string", "", 0, 1, this.original_publisher));
        children.add(new Property("proportionTypes", "code", "", 0, 1, this.proportionTypes));
        children.add(new Property("revision", "string", "", 0, 1, this.revision));
        children.add(new Property("inContext", "boolean", "", 0, 1, this.inContext));
        children.add(new Property("inputs", "http://openehr.org/fhir/StructureDefinition/WebTemplateInput", "", 0, Integer.MAX_VALUE, this.inputsList));
        children.add(new Property("termBindings", "http://openehr.org/fhir/StructureDefinition/WebTemplateTermBinding", "", 0, Integer.MAX_VALUE, this.termBindingsList));
        children.add(new Property("children", "http://openehr.org/fhir/StructureDefinition/WebTemplateItem", "", 0, Integer.MAX_VALUE, this.childrenList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3355: {
                return new Property("id", "string", "", 0, 1, this.id);
            }
            case 95472323: {
                return new Property("depth", "integer", "", 0, 1, this.depth);
            }
            case 3373707: {
                return new Property("name", "string", "", 0, 1, this.name);
            }
            case 696548518: {
                return new Property("localizedName", "string", "", 0, 1, this.localizedName);
            }
            case -927957995: {
                return new Property("rmType", "code", "", 0, 1, this.rmType);
            }
            case -1040171331: {
                return new Property("nodeId", "string", "", 0, 1, this.nodeId);
            }
            case 108114: {
                return new Property("min", "string", "", 0, 1, this.min);
            }
            case 107876: {
                return new Property("max", "string", "", 0, 1, this.max);
            }
            case -1109214266: {
                return new Property("dependsOn", "string", "", 0, 1, this.dependsOn);
            }
            case 118167693: {
                return new Property("localizedNames", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedNamesList);
            }
            case 31568658: {
                return new Property("localizedDescriptions", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedDescriptionsList);
            }
            case -961709276: {
                return new Property("annotations", "http://openehr.org/fhir/StructureDefinition/Annotations", "", 0, 1, this.annotations);
            }
            case -1252479343: {
                return new Property("archetype_id", "string", "", 0, 1, this.archetype_id);
            }
            case -769141631: {
                return new Property("aqlPath", "string", "", 0, 1, this.aqlPath);
            }
            case -1393315766: {
                return new Property("custodian_namespace", "string", "", 0, 1, this.custodian_namespace);
            }
            case 525929355: {
                return new Property("custodian_organisation", "string", "", 0, 1, this.custodian_organisation);
            }
            case -1486422201: {
                return new Property("lifecycleState", "code", "", 0, 1, this.lifecycleState);
            }
            case -1611298707: {
                return new Property("original_namespace", "string", "", 0, 1, this.original_namespace);
            }
            case -1416112882: {
                return new Property("original_publisher", "string", "", 0, 1, this.original_publisher);
            }
            case 2145858559: {
                return new Property("proportionTypes", "code", "", 0, 1, this.proportionTypes);
            }
            case -260786213: {
                return new Property("revision", "string", "", 0, 1, this.revision);
            }
            case 247635146: {
                return new Property("inContext", "boolean", "", 0, 1, this.inContext);
            }
            case -1183866391: {
                return new Property("inputs", "http://openehr.org/fhir/StructureDefinition/WebTemplateInput", "", 0, Integer.MAX_VALUE, this.inputsList);
            }
            case 1618255642: {
                return new Property("termBindings", "http://openehr.org/fhir/StructureDefinition/WebTemplateTermBinding", "", 0, Integer.MAX_VALUE, this.termBindingsList);
            }
            case 1659526655: {
                return new Property("children", "http://openehr.org/fhir/StructureDefinition/WebTemplateItem", "", 0, Integer.MAX_VALUE, this.childrenList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3355: {
                Base[] baseArray;
                if (this.id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.id;
                }
                return baseArray;
            }
            case 95472323: {
                Base[] baseArray;
                if (this.depth == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.depth;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 696548518: {
                Base[] baseArray;
                if (this.localizedName == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.localizedName;
                }
                return baseArray;
            }
            case -927957995: {
                Base[] baseArray;
                if (this.rmType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.rmType;
                }
                return baseArray;
            }
            case -1040171331: {
                Base[] baseArray;
                if (this.nodeId == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.nodeId;
                }
                return baseArray;
            }
            case 108114: {
                Base[] baseArray;
                if (this.min == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.min;
                }
                return baseArray;
            }
            case 107876: {
                Base[] baseArray;
                if (this.max == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.max;
                }
                return baseArray;
            }
            case -1109214266: {
                Base[] baseArray;
                if (this.dependsOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.dependsOn;
                }
                return baseArray;
            }
            case 118167693: {
                return this.localizedNamesList == null ? new Base[]{} : this.localizedNamesList.toArray(new Base[this.localizedNamesList.size()]);
            }
            case 31568658: {
                return this.localizedDescriptionsList == null ? new Base[]{} : this.localizedDescriptionsList.toArray(new Base[this.localizedDescriptionsList.size()]);
            }
            case -961709276: {
                Base[] baseArray;
                if (this.annotations == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.annotations;
                }
                return baseArray;
            }
            case -1252479343: {
                Base[] baseArray;
                if (this.archetype_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.archetype_id;
                }
                return baseArray;
            }
            case -769141631: {
                Base[] baseArray;
                if (this.aqlPath == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.aqlPath;
                }
                return baseArray;
            }
            case -1393315766: {
                Base[] baseArray;
                if (this.custodian_namespace == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.custodian_namespace;
                }
                return baseArray;
            }
            case 525929355: {
                Base[] baseArray;
                if (this.custodian_organisation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.custodian_organisation;
                }
                return baseArray;
            }
            case -1486422201: {
                Base[] baseArray;
                if (this.lifecycleState == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.lifecycleState;
                }
                return baseArray;
            }
            case -1611298707: {
                Base[] baseArray;
                if (this.original_namespace == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.original_namespace;
                }
                return baseArray;
            }
            case -1416112882: {
                Base[] baseArray;
                if (this.original_publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.original_publisher;
                }
                return baseArray;
            }
            case 2145858559: {
                Base[] baseArray;
                if (this.proportionTypes == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.proportionTypes;
                }
                return baseArray;
            }
            case -260786213: {
                Base[] baseArray;
                if (this.revision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.revision;
                }
                return baseArray;
            }
            case 247635146: {
                Base[] baseArray;
                if (this.inContext == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.inContext;
                }
                return baseArray;
            }
            case -1183866391: {
                return this.inputsList == null ? new Base[]{} : this.inputsList.toArray(new Base[this.inputsList.size()]);
            }
            case 1618255642: {
                return this.termBindingsList == null ? new Base[]{} : this.termBindingsList.toArray(new Base[this.termBindingsList.size()]);
            }
            case 1659526655: {
                return this.childrenList == null ? new Base[]{} : this.childrenList.toArray(new Base[this.childrenList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3355: {
                this.id = TypeConvertor.castToString(value);
                return value;
            }
            case 95472323: {
                this.depth = TypeConvertor.castToInteger(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 696548518: {
                this.localizedName = TypeConvertor.castToString(value);
                return value;
            }
            case -927957995: {
                this.rmType = TypeConvertor.castToCode(value);
                return value;
            }
            case -1040171331: {
                this.nodeId = TypeConvertor.castToString(value);
                return value;
            }
            case 108114: {
                this.min = TypeConvertor.castToString(value);
                return value;
            }
            case 107876: {
                this.max = TypeConvertor.castToString(value);
                return value;
            }
            case -1109214266: {
                this.dependsOn = TypeConvertor.castToString(value);
                return value;
            }
            case 118167693: {
                this.getLocalizedNamesList().add((TranslatedString)value);
                return value;
            }
            case 31568658: {
                this.getLocalizedDescriptionsList().add((TranslatedString)value);
                return value;
            }
            case -961709276: {
                this.annotations = (Annotations)value;
                return value;
            }
            case -1252479343: {
                this.archetype_id = TypeConvertor.castToString(value);
                return value;
            }
            case -769141631: {
                this.aqlPath = TypeConvertor.castToString(value);
                return value;
            }
            case -1393315766: {
                this.custodian_namespace = TypeConvertor.castToString(value);
                return value;
            }
            case 525929355: {
                this.custodian_organisation = TypeConvertor.castToString(value);
                return value;
            }
            case -1486422201: {
                this.lifecycleState = TypeConvertor.castToCode(value);
                return value;
            }
            case -1611298707: {
                this.original_namespace = TypeConvertor.castToString(value);
                return value;
            }
            case -1416112882: {
                this.original_publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 2145858559: {
                this.proportionTypes = TypeConvertor.castToCode(value);
                return value;
            }
            case -260786213: {
                this.revision = TypeConvertor.castToString(value);
                return value;
            }
            case 247635146: {
                this.inContext = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1183866391: {
                this.getInputsList().add((WebTemplateInput)value);
                return value;
            }
            case 1618255642: {
                this.getTermBindingsList().add((WebTemplateTermBinding)value);
                return value;
            }
            case 1659526655: {
                this.getChildrenList().add((WebTemplateItem)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("id")) {
            this.id = TypeConvertor.castToString(value);
        } else if (name.equals("depth")) {
            this.depth = TypeConvertor.castToInteger(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("localizedName")) {
            this.localizedName = TypeConvertor.castToString(value);
        } else if (name.equals("rmType")) {
            this.rmType = TypeConvertor.castToCode(value);
        } else if (name.equals("nodeId")) {
            this.nodeId = TypeConvertor.castToString(value);
        } else if (name.equals("min")) {
            this.min = TypeConvertor.castToString(value);
        } else if (name.equals("max")) {
            this.max = TypeConvertor.castToString(value);
        } else if (name.equals("dependsOn")) {
            this.dependsOn = TypeConvertor.castToString(value);
        } else if (name.equals("localizedNames")) {
            this.getLocalizedNamesList().add((TranslatedString)value);
        } else if (name.equals("localizedDescriptions")) {
            this.getLocalizedDescriptionsList().add((TranslatedString)value);
        } else if (name.equals("annotations")) {
            this.annotations = (Annotations)value;
        } else if (name.equals("archetype_id")) {
            this.archetype_id = TypeConvertor.castToString(value);
        } else if (name.equals("aqlPath")) {
            this.aqlPath = TypeConvertor.castToString(value);
        } else if (name.equals("custodian_namespace")) {
            this.custodian_namespace = TypeConvertor.castToString(value);
        } else if (name.equals("custodian_organisation")) {
            this.custodian_organisation = TypeConvertor.castToString(value);
        } else if (name.equals("lifecycleState")) {
            this.lifecycleState = TypeConvertor.castToCode(value);
        } else if (name.equals("original_namespace")) {
            this.original_namespace = TypeConvertor.castToString(value);
        } else if (name.equals("original_publisher")) {
            this.original_publisher = TypeConvertor.castToString(value);
        } else if (name.equals("proportionTypes")) {
            this.proportionTypes = TypeConvertor.castToCode(value);
        } else if (name.equals("revision")) {
            this.revision = TypeConvertor.castToString(value);
        } else if (name.equals("inContext")) {
            this.inContext = TypeConvertor.castToBoolean(value);
        } else if (name.equals("inputs")) {
            this.getInputsList().add((WebTemplateInput)value);
        } else if (name.equals("termBindings")) {
            this.getTermBindingsList().add((WebTemplateTermBinding)value);
        } else if (name.equals("children")) {
            this.getChildrenList().add((WebTemplateItem)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3355: {
                return this.getIdElement();
            }
            case 95472323: {
                return this.getDepthElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 696548518: {
                return this.getLocalizedNameElement();
            }
            case -927957995: {
                return this.getRmTypeElement();
            }
            case -1040171331: {
                return this.getNodeIdElement();
            }
            case 108114: {
                return this.getMinElement();
            }
            case 107876: {
                return this.getMaxElement();
            }
            case -1109214266: {
                return this.getDependsOnElement();
            }
            case 118167693: {
                return this.addLocalizedNames();
            }
            case 31568658: {
                return this.addLocalizedDescriptions();
            }
            case -961709276: {
                return this.getAnnotations();
            }
            case -1252479343: {
                return this.getArchetype_idElement();
            }
            case -769141631: {
                return this.getAqlPathElement();
            }
            case -1393315766: {
                return this.getCustodian_namespaceElement();
            }
            case 525929355: {
                return this.getCustodian_organisationElement();
            }
            case -1486422201: {
                return this.getLifecycleStateElement();
            }
            case -1611298707: {
                return this.getOriginal_namespaceElement();
            }
            case -1416112882: {
                return this.getOriginal_publisherElement();
            }
            case 2145858559: {
                return this.getProportionTypesElement();
            }
            case -260786213: {
                return this.getRevisionElement();
            }
            case 247635146: {
                return this.getInContextElement();
            }
            case -1183866391: {
                return this.addInputs();
            }
            case 1618255642: {
                return this.addTermBindings();
            }
            case 1659526655: {
                return this.addChildren();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3355: {
                return new String[]{"string"};
            }
            case 95472323: {
                return new String[]{"integer"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 696548518: {
                return new String[]{"string"};
            }
            case -927957995: {
                return new String[]{"code"};
            }
            case -1040171331: {
                return new String[]{"string"};
            }
            case 108114: {
                return new String[]{"string"};
            }
            case 107876: {
                return new String[]{"string"};
            }
            case -1109214266: {
                return new String[]{"string"};
            }
            case 118167693: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TranslatedString"};
            }
            case 31568658: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TranslatedString"};
            }
            case -961709276: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/Annotations"};
            }
            case -1252479343: {
                return new String[]{"string"};
            }
            case -769141631: {
                return new String[]{"string"};
            }
            case -1393315766: {
                return new String[]{"string"};
            }
            case 525929355: {
                return new String[]{"string"};
            }
            case -1486422201: {
                return new String[]{"code"};
            }
            case -1611298707: {
                return new String[]{"string"};
            }
            case -1416112882: {
                return new String[]{"string"};
            }
            case 2145858559: {
                return new String[]{"code"};
            }
            case -260786213: {
                return new String[]{"string"};
            }
            case 247635146: {
                return new String[]{"boolean"};
            }
            case -1183866391: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateInput"};
            }
            case 1618255642: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateTermBinding"};
            }
            case 1659526655: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateItem"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.id");
        }
        if (name.equals("depth")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.depth");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.name");
        }
        if (name.equals("localizedName")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.localizedName");
        }
        if (name.equals("rmType")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.rmType");
        }
        if (name.equals("nodeId")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.nodeId");
        }
        if (name.equals("min")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.min");
        }
        if (name.equals("max")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.max");
        }
        if (name.equals("dependsOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.dependsOn");
        }
        if (name.equals("localizedNames")) {
            return this.addLocalizedNames();
        }
        if (name.equals("localizedDescriptions")) {
            return this.addLocalizedDescriptions();
        }
        if (name.equals("annotations")) {
            this.annotations = new Annotations();
            return this.annotations;
        }
        if (name.equals("archetype_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.archetype_id");
        }
        if (name.equals("aqlPath")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.aqlPath");
        }
        if (name.equals("custodian_namespace")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.custodian_namespace");
        }
        if (name.equals("custodian_organisation")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.custodian_organisation");
        }
        if (name.equals("lifecycleState")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.lifecycleState");
        }
        if (name.equals("original_namespace")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.original_namespace");
        }
        if (name.equals("original_publisher")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.original_publisher");
        }
        if (name.equals("proportionTypes")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.proportionTypes");
        }
        if (name.equals("revision")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.revision");
        }
        if (name.equals("inContext")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateItem.inContext");
        }
        if (name.equals("inputs")) {
            return this.addInputs();
        }
        if (name.equals("termBindings")) {
            return this.addTermBindings();
        }
        if (name.equals("children")) {
            return this.addChildren();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplateItem";
    }

    @Override
    public WebTemplateItem copy() {
        WebTemplateItem dst = new WebTemplateItem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplateItem dst) {
        super.copyValues(dst);
        dst.id = this.id == null ? null : this.id.copy();
        dst.depth = this.depth == null ? null : this.depth.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.localizedName = this.localizedName == null ? null : this.localizedName.copy();
        dst.rmType = this.rmType == null ? null : this.rmType.copy();
        dst.nodeId = this.nodeId == null ? null : this.nodeId.copy();
        dst.min = this.min == null ? null : this.min.copy();
        dst.max = this.max == null ? null : this.max.copy();
        StringType stringType = dst.dependsOn = this.dependsOn == null ? null : this.dependsOn.copy();
        if (this.localizedNamesList != null) {
            dst.localizedNamesList = new ArrayList<TranslatedString>();
            for (TranslatedString translatedString : this.localizedNamesList) {
                dst.localizedNamesList.add(translatedString.copy());
            }
        }
        if (this.localizedDescriptionsList != null) {
            dst.localizedDescriptionsList = new ArrayList<TranslatedString>();
            for (TranslatedString translatedString : this.localizedDescriptionsList) {
                dst.localizedDescriptionsList.add(translatedString.copy());
            }
        }
        dst.annotations = this.annotations == null ? null : this.annotations.copy();
        dst.archetype_id = this.archetype_id == null ? null : this.archetype_id.copy();
        dst.aqlPath = this.aqlPath == null ? null : this.aqlPath.copy();
        dst.custodian_namespace = this.custodian_namespace == null ? null : this.custodian_namespace.copy();
        dst.custodian_organisation = this.custodian_organisation == null ? null : this.custodian_organisation.copy();
        dst.lifecycleState = this.lifecycleState == null ? null : this.lifecycleState.copy();
        dst.original_namespace = this.original_namespace == null ? null : this.original_namespace.copy();
        dst.original_publisher = this.original_publisher == null ? null : this.original_publisher.copy();
        dst.proportionTypes = this.proportionTypes == null ? null : this.proportionTypes.copy();
        dst.revision = this.revision == null ? null : this.revision.copy();
        BooleanType booleanType = dst.inContext = this.inContext == null ? null : this.inContext.copy();
        if (this.inputsList != null) {
            dst.inputsList = new ArrayList<WebTemplateInput>();
            for (WebTemplateInput webTemplateInput : this.inputsList) {
                dst.inputsList.add(webTemplateInput.copy());
            }
        }
        if (this.termBindingsList != null) {
            dst.termBindingsList = new ArrayList<WebTemplateTermBinding>();
            for (WebTemplateTermBinding webTemplateTermBinding : this.termBindingsList) {
                dst.termBindingsList.add(webTemplateTermBinding.copy());
            }
        }
        if (this.childrenList != null) {
            dst.childrenList = new ArrayList<WebTemplateItem>();
            for (WebTemplateItem webTemplateItem : this.childrenList) {
                dst.childrenList.add(webTemplateItem.copy());
            }
        }
    }

    protected WebTemplateItem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateItem)) {
            return false;
        }
        WebTemplateItem o = (WebTemplateItem)other_;
        return WebTemplateItem.compareDeep(this.id, o.id, true) && WebTemplateItem.compareDeep(this.depth, o.depth, true) && WebTemplateItem.compareDeep(this.name, o.name, true) && WebTemplateItem.compareDeep(this.localizedName, o.localizedName, true) && WebTemplateItem.compareDeep(this.rmType, o.rmType, true) && WebTemplateItem.compareDeep(this.nodeId, o.nodeId, true) && WebTemplateItem.compareDeep(this.min, o.min, true) && WebTemplateItem.compareDeep(this.max, o.max, true) && WebTemplateItem.compareDeep(this.dependsOn, o.dependsOn, true) && WebTemplateItem.compareDeep(this.localizedNamesList, o.localizedNamesList, true) && WebTemplateItem.compareDeep(this.localizedDescriptionsList, o.localizedDescriptionsList, true) && WebTemplateItem.compareDeep(this.annotations, o.annotations, true) && WebTemplateItem.compareDeep(this.archetype_id, o.archetype_id, true) && WebTemplateItem.compareDeep(this.aqlPath, o.aqlPath, true) && WebTemplateItem.compareDeep(this.custodian_namespace, o.custodian_namespace, true) && WebTemplateItem.compareDeep(this.custodian_organisation, o.custodian_organisation, true) && WebTemplateItem.compareDeep(this.lifecycleState, o.lifecycleState, true) && WebTemplateItem.compareDeep(this.original_namespace, o.original_namespace, true) && WebTemplateItem.compareDeep(this.original_publisher, o.original_publisher, true) && WebTemplateItem.compareDeep(this.proportionTypes, o.proportionTypes, true) && WebTemplateItem.compareDeep(this.revision, o.revision, true) && WebTemplateItem.compareDeep(this.inContext, o.inContext, true) && WebTemplateItem.compareDeep(this.inputsList, o.inputsList, true) && WebTemplateItem.compareDeep(this.termBindingsList, o.termBindingsList, true) && WebTemplateItem.compareDeep(this.childrenList, o.childrenList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateItem)) {
            return false;
        }
        WebTemplateItem o = (WebTemplateItem)other_;
        return WebTemplateItem.compareValues(this.id, o.id, true) && WebTemplateItem.compareValues(this.depth, o.depth, true) && WebTemplateItem.compareValues(this.name, o.name, true) && WebTemplateItem.compareValues(this.localizedName, o.localizedName, true) && WebTemplateItem.compareValues(this.rmType, o.rmType, true) && WebTemplateItem.compareValues(this.nodeId, o.nodeId, true) && WebTemplateItem.compareValues(this.min, o.min, true) && WebTemplateItem.compareValues(this.max, o.max, true) && WebTemplateItem.compareValues(this.dependsOn, o.dependsOn, true) && WebTemplateItem.compareValues(this.archetype_id, o.archetype_id, true) && WebTemplateItem.compareValues(this.aqlPath, o.aqlPath, true) && WebTemplateItem.compareValues(this.custodian_namespace, o.custodian_namespace, true) && WebTemplateItem.compareValues(this.custodian_organisation, o.custodian_organisation, true) && WebTemplateItem.compareValues(this.lifecycleState, o.lifecycleState, true) && WebTemplateItem.compareValues(this.original_namespace, o.original_namespace, true) && WebTemplateItem.compareValues(this.original_publisher, o.original_publisher, true) && WebTemplateItem.compareValues(this.proportionTypes, o.proportionTypes, true) && WebTemplateItem.compareValues(this.revision, o.revision, true) && WebTemplateItem.compareValues(this.inContext, o.inContext, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.id, this.depth, this.name, this.localizedName, this.rmType, this.nodeId, this.min, this.max, this.dependsOn, this.localizedNamesList, this.localizedDescriptionsList, this.annotations, this.archetype_id, this.aqlPath, this.custodian_namespace, this.custodian_organisation, this.lifecycleState, this.original_namespace, this.original_publisher, this.proportionTypes, this.revision, this.inContext, this.inputsList, this.termBindingsList, this.childrenList});
    }
}

