/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.TranslatedString;
import org.hl7.fhir.r5.openehr.WebTemplateTermBinding;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="WebTemplateInputListItem")
public class WebTemplateInputListItem
extends LogicalBase
implements ICompositeType {
    @Child(name="value", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="at-code of the specified item", formalDefinition="")
    protected CodeType value;
    @Child(name="label", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="label of the item in the default language", formalDefinition="")
    protected StringType label;
    @Child(name="ordinal", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType ordinal;
    @Child(name="localizedLabels", type={TranslatedString.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="labels in all specified languages", formalDefinition="")
    protected List<TranslatedString> localizedLabelsList;
    @Child(name="localizedDescriptions", type={TranslatedString.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected List<TranslatedString> localizedDescriptionsList;
    @Child(name="currentStates", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType currentStates;
    @Child(name="range", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType range;
    @Child(name="precision", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType precision;
    @Child(name="termBindings", type={WebTemplateTermBinding.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected List<WebTemplateTermBinding> termBindingsList;
    private static final long serialVersionUID = 598072749L;

    public WebTemplateInputListItem() {
    }

    public WebTemplateInputListItem(String value) {
        this.setValue(value);
    }

    public CodeType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputListItem.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new CodeType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public WebTemplateInputListItem setValueElement(CodeType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public WebTemplateInputListItem setValue(String value) {
        if (this.value == null) {
            this.value = new CodeType();
        }
        this.value.setValue(value);
        return this;
    }

    public StringType getLabelElement() {
        if (this.label == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputListItem.label");
            }
            if (Configuration.doAutoCreate()) {
                this.label = new StringType();
            }
        }
        return this.label;
    }

    public boolean hasLabelElement() {
        return this.label != null && !this.label.isEmpty();
    }

    public boolean hasLabel() {
        return this.label != null && !this.label.isEmpty();
    }

    public WebTemplateInputListItem setLabelElement(StringType value) {
        this.label = value;
        return this;
    }

    public String getLabel() {
        return this.label == null ? null : (String)this.label.getValue();
    }

    public WebTemplateInputListItem setLabel(String value) {
        if (Utilities.noString((String)value)) {
            this.label = null;
        } else {
            if (this.label == null) {
                this.label = new StringType();
            }
            this.label.setValue(value);
        }
        return this;
    }

    public StringType getOrdinalElement() {
        if (this.ordinal == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputListItem.ordinal");
            }
            if (Configuration.doAutoCreate()) {
                this.ordinal = new StringType();
            }
        }
        return this.ordinal;
    }

    public boolean hasOrdinalElement() {
        return this.ordinal != null && !this.ordinal.isEmpty();
    }

    public boolean hasOrdinal() {
        return this.ordinal != null && !this.ordinal.isEmpty();
    }

    public WebTemplateInputListItem setOrdinalElement(StringType value) {
        this.ordinal = value;
        return this;
    }

    public String getOrdinal() {
        return this.ordinal == null ? null : (String)this.ordinal.getValue();
    }

    public WebTemplateInputListItem setOrdinal(String value) {
        if (Utilities.noString((String)value)) {
            this.ordinal = null;
        } else {
            if (this.ordinal == null) {
                this.ordinal = new StringType();
            }
            this.ordinal.setValue(value);
        }
        return this;
    }

    public List<TranslatedString> getLocalizedLabelsList() {
        if (this.localizedLabelsList == null) {
            this.localizedLabelsList = new ArrayList<TranslatedString>();
        }
        return this.localizedLabelsList;
    }

    public WebTemplateInputListItem setLocalizedLabelsList(List<TranslatedString> theLocalizedLabels) {
        this.localizedLabelsList = theLocalizedLabels;
        return this;
    }

    public boolean hasLocalizedLabels() {
        if (this.localizedLabelsList == null) {
            return false;
        }
        for (TranslatedString item : this.localizedLabelsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TranslatedString addLocalizedLabels() {
        TranslatedString t = new TranslatedString();
        if (this.localizedLabelsList == null) {
            this.localizedLabelsList = new ArrayList<TranslatedString>();
        }
        this.localizedLabelsList.add(t);
        return t;
    }

    public WebTemplateInputListItem addLocalizedLabels(TranslatedString t) {
        if (t == null) {
            return this;
        }
        if (this.localizedLabelsList == null) {
            this.localizedLabelsList = new ArrayList<TranslatedString>();
        }
        this.localizedLabelsList.add(t);
        return this;
    }

    public TranslatedString getLocalizedLabelsFirstRep() {
        if (this.getLocalizedLabelsList().isEmpty()) {
            this.addLocalizedLabels();
        }
        return this.getLocalizedLabelsList().get(0);
    }

    public List<TranslatedString> getLocalizedDescriptionsList() {
        if (this.localizedDescriptionsList == null) {
            this.localizedDescriptionsList = new ArrayList<TranslatedString>();
        }
        return this.localizedDescriptionsList;
    }

    public WebTemplateInputListItem setLocalizedDescriptionsList(List<TranslatedString> theLocalizedDescriptions) {
        this.localizedDescriptionsList = theLocalizedDescriptions;
        return this;
    }

    public boolean hasLocalizedDescriptions() {
        if (this.localizedDescriptionsList == null) {
            return false;
        }
        for (TranslatedString item : this.localizedDescriptionsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TranslatedString addLocalizedDescriptions() {
        TranslatedString t = new TranslatedString();
        if (this.localizedDescriptionsList == null) {
            this.localizedDescriptionsList = new ArrayList<TranslatedString>();
        }
        this.localizedDescriptionsList.add(t);
        return t;
    }

    public WebTemplateInputListItem addLocalizedDescriptions(TranslatedString t) {
        if (t == null) {
            return this;
        }
        if (this.localizedDescriptionsList == null) {
            this.localizedDescriptionsList = new ArrayList<TranslatedString>();
        }
        this.localizedDescriptionsList.add(t);
        return this;
    }

    public TranslatedString getLocalizedDescriptionsFirstRep() {
        if (this.getLocalizedDescriptionsList().isEmpty()) {
            this.addLocalizedDescriptions();
        }
        return this.getLocalizedDescriptionsList().get(0);
    }

    public StringType getCurrentStatesElement() {
        if (this.currentStates == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputListItem.currentStates");
            }
            if (Configuration.doAutoCreate()) {
                this.currentStates = new StringType();
            }
        }
        return this.currentStates;
    }

    public boolean hasCurrentStatesElement() {
        return this.currentStates != null && !this.currentStates.isEmpty();
    }

    public boolean hasCurrentStates() {
        return this.currentStates != null && !this.currentStates.isEmpty();
    }

    public WebTemplateInputListItem setCurrentStatesElement(StringType value) {
        this.currentStates = value;
        return this;
    }

    public String getCurrentStates() {
        return this.currentStates == null ? null : (String)this.currentStates.getValue();
    }

    public WebTemplateInputListItem setCurrentStates(String value) {
        if (Utilities.noString((String)value)) {
            this.currentStates = null;
        } else {
            if (this.currentStates == null) {
                this.currentStates = new StringType();
            }
            this.currentStates.setValue(value);
        }
        return this;
    }

    public StringType getRangeElement() {
        if (this.range == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputListItem.range");
            }
            if (Configuration.doAutoCreate()) {
                this.range = new StringType();
            }
        }
        return this.range;
    }

    public boolean hasRangeElement() {
        return this.range != null && !this.range.isEmpty();
    }

    public boolean hasRange() {
        return this.range != null && !this.range.isEmpty();
    }

    public WebTemplateInputListItem setRangeElement(StringType value) {
        this.range = value;
        return this;
    }

    public String getRange() {
        return this.range == null ? null : (String)this.range.getValue();
    }

    public WebTemplateInputListItem setRange(String value) {
        if (Utilities.noString((String)value)) {
            this.range = null;
        } else {
            if (this.range == null) {
                this.range = new StringType();
            }
            this.range.setValue(value);
        }
        return this;
    }

    public StringType getPrecisionElement() {
        if (this.precision == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create WebTemplateInputListItem.precision");
            }
            if (Configuration.doAutoCreate()) {
                this.precision = new StringType();
            }
        }
        return this.precision;
    }

    public boolean hasPrecisionElement() {
        return this.precision != null && !this.precision.isEmpty();
    }

    public boolean hasPrecision() {
        return this.precision != null && !this.precision.isEmpty();
    }

    public WebTemplateInputListItem setPrecisionElement(StringType value) {
        this.precision = value;
        return this;
    }

    public String getPrecision() {
        return this.precision == null ? null : (String)this.precision.getValue();
    }

    public WebTemplateInputListItem setPrecision(String value) {
        if (Utilities.noString((String)value)) {
            this.precision = null;
        } else {
            if (this.precision == null) {
                this.precision = new StringType();
            }
            this.precision.setValue(value);
        }
        return this;
    }

    public List<WebTemplateTermBinding> getTermBindingsList() {
        if (this.termBindingsList == null) {
            this.termBindingsList = new ArrayList<WebTemplateTermBinding>();
        }
        return this.termBindingsList;
    }

    public WebTemplateInputListItem setTermBindingsList(List<WebTemplateTermBinding> theTermBindings) {
        this.termBindingsList = theTermBindings;
        return this;
    }

    public boolean hasTermBindings() {
        if (this.termBindingsList == null) {
            return false;
        }
        for (WebTemplateTermBinding item : this.termBindingsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public WebTemplateTermBinding addTermBindings() {
        WebTemplateTermBinding t = new WebTemplateTermBinding();
        if (this.termBindingsList == null) {
            this.termBindingsList = new ArrayList<WebTemplateTermBinding>();
        }
        this.termBindingsList.add(t);
        return t;
    }

    public WebTemplateInputListItem addTermBindings(WebTemplateTermBinding t) {
        if (t == null) {
            return this;
        }
        if (this.termBindingsList == null) {
            this.termBindingsList = new ArrayList<WebTemplateTermBinding>();
        }
        this.termBindingsList.add(t);
        return this;
    }

    public WebTemplateTermBinding getTermBindingsFirstRep() {
        if (this.getTermBindingsList().isEmpty()) {
            this.addTermBindings();
        }
        return this.getTermBindingsList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "code", "", 0, 1, this.value));
        children.add(new Property("label", "string", "", 0, 1, this.label));
        children.add(new Property("ordinal", "string", "", 0, 1, this.ordinal));
        children.add(new Property("localizedLabels", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedLabelsList));
        children.add(new Property("localizedDescriptions", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedDescriptionsList));
        children.add(new Property("currentStates", "string", "", 0, 1, this.currentStates));
        children.add(new Property("range", "string", "", 0, 1, this.range));
        children.add(new Property("precision", "string", "", 0, 1, this.precision));
        children.add(new Property("termBindings", "http://openehr.org/fhir/StructureDefinition/WebTemplateTermBinding", "", 0, Integer.MAX_VALUE, this.termBindingsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "code", "", 0, 1, this.value);
            }
            case 102727412: {
                return new Property("label", "string", "", 0, 1, this.label);
            }
            case -1206994319: {
                return new Property("ordinal", "string", "", 0, 1, this.ordinal);
            }
            case -689354918: {
                return new Property("localizedLabels", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedLabelsList);
            }
            case 31568658: {
                return new Property("localizedDescriptions", "http://openehr.org/fhir/StructureDefinition/TranslatedString", "", 0, Integer.MAX_VALUE, this.localizedDescriptionsList);
            }
            case -2052146981: {
                return new Property("currentStates", "string", "", 0, 1, this.currentStates);
            }
            case 108280125: {
                return new Property("range", "string", "", 0, 1, this.range);
            }
            case -1376177026: {
                return new Property("precision", "string", "", 0, 1, this.precision);
            }
            case 1618255642: {
                return new Property("termBindings", "http://openehr.org/fhir/StructureDefinition/WebTemplateTermBinding", "", 0, Integer.MAX_VALUE, this.termBindingsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case 102727412: {
                Base[] baseArray;
                if (this.label == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.label;
                }
                return baseArray;
            }
            case -1206994319: {
                Base[] baseArray;
                if (this.ordinal == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.ordinal;
                }
                return baseArray;
            }
            case -689354918: {
                return this.localizedLabelsList == null ? new Base[]{} : this.localizedLabelsList.toArray(new Base[this.localizedLabelsList.size()]);
            }
            case 31568658: {
                return this.localizedDescriptionsList == null ? new Base[]{} : this.localizedDescriptionsList.toArray(new Base[this.localizedDescriptionsList.size()]);
            }
            case -2052146981: {
                Base[] baseArray;
                if (this.currentStates == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.currentStates;
                }
                return baseArray;
            }
            case 108280125: {
                Base[] baseArray;
                if (this.range == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.range;
                }
                return baseArray;
            }
            case -1376177026: {
                Base[] baseArray;
                if (this.precision == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.precision;
                }
                return baseArray;
            }
            case 1618255642: {
                return this.termBindingsList == null ? new Base[]{} : this.termBindingsList.toArray(new Base[this.termBindingsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = TypeConvertor.castToCode(value);
                return value;
            }
            case 102727412: {
                this.label = TypeConvertor.castToString(value);
                return value;
            }
            case -1206994319: {
                this.ordinal = TypeConvertor.castToString(value);
                return value;
            }
            case -689354918: {
                this.getLocalizedLabelsList().add((TranslatedString)value);
                return value;
            }
            case 31568658: {
                this.getLocalizedDescriptionsList().add((TranslatedString)value);
                return value;
            }
            case -2052146981: {
                this.currentStates = TypeConvertor.castToString(value);
                return value;
            }
            case 108280125: {
                this.range = TypeConvertor.castToString(value);
                return value;
            }
            case -1376177026: {
                this.precision = TypeConvertor.castToString(value);
                return value;
            }
            case 1618255642: {
                this.getTermBindingsList().add((WebTemplateTermBinding)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = TypeConvertor.castToCode(value);
        } else if (name.equals("label")) {
            this.label = TypeConvertor.castToString(value);
        } else if (name.equals("ordinal")) {
            this.ordinal = TypeConvertor.castToString(value);
        } else if (name.equals("localizedLabels")) {
            this.getLocalizedLabelsList().add((TranslatedString)value);
        } else if (name.equals("localizedDescriptions")) {
            this.getLocalizedDescriptionsList().add((TranslatedString)value);
        } else if (name.equals("currentStates")) {
            this.currentStates = TypeConvertor.castToString(value);
        } else if (name.equals("range")) {
            this.range = TypeConvertor.castToString(value);
        } else if (name.equals("precision")) {
            this.precision = TypeConvertor.castToString(value);
        } else if (name.equals("termBindings")) {
            this.getTermBindingsList().add((WebTemplateTermBinding)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValueElement();
            }
            case 102727412: {
                return this.getLabelElement();
            }
            case -1206994319: {
                return this.getOrdinalElement();
            }
            case -689354918: {
                return this.addLocalizedLabels();
            }
            case 31568658: {
                return this.addLocalizedDescriptions();
            }
            case -2052146981: {
                return this.getCurrentStatesElement();
            }
            case 108280125: {
                return this.getRangeElement();
            }
            case -1376177026: {
                return this.getPrecisionElement();
            }
            case 1618255642: {
                return this.addTermBindings();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"code"};
            }
            case 102727412: {
                return new String[]{"string"};
            }
            case -1206994319: {
                return new String[]{"string"};
            }
            case -689354918: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TranslatedString"};
            }
            case 31568658: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/TranslatedString"};
            }
            case -2052146981: {
                return new String[]{"string"};
            }
            case 108280125: {
                return new String[]{"string"};
            }
            case -1376177026: {
                return new String[]{"string"};
            }
            case 1618255642: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/WebTemplateTermBinding"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputListItem.value");
        }
        if (name.equals("label")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputListItem.label");
        }
        if (name.equals("ordinal")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputListItem.ordinal");
        }
        if (name.equals("localizedLabels")) {
            return this.addLocalizedLabels();
        }
        if (name.equals("localizedDescriptions")) {
            return this.addLocalizedDescriptions();
        }
        if (name.equals("currentStates")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputListItem.currentStates");
        }
        if (name.equals("range")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputListItem.range");
        }
        if (name.equals("precision")) {
            throw new FHIRException("Cannot call addChild on a singleton property WebTemplateInputListItem.precision");
        }
        if (name.equals("termBindings")) {
            return this.addTermBindings();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "WebTemplateInputListItem";
    }

    @Override
    public WebTemplateInputListItem copy() {
        WebTemplateInputListItem dst = new WebTemplateInputListItem();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(WebTemplateInputListItem dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.label = this.label == null ? null : this.label.copy();
        StringType stringType = dst.ordinal = this.ordinal == null ? null : this.ordinal.copy();
        if (this.localizedLabelsList != null) {
            dst.localizedLabelsList = new ArrayList<TranslatedString>();
            for (TranslatedString translatedString : this.localizedLabelsList) {
                dst.localizedLabelsList.add(translatedString.copy());
            }
        }
        if (this.localizedDescriptionsList != null) {
            dst.localizedDescriptionsList = new ArrayList<TranslatedString>();
            for (TranslatedString translatedString : this.localizedDescriptionsList) {
                dst.localizedDescriptionsList.add(translatedString.copy());
            }
        }
        dst.currentStates = this.currentStates == null ? null : this.currentStates.copy();
        dst.range = this.range == null ? null : this.range.copy();
        StringType stringType2 = dst.precision = this.precision == null ? null : this.precision.copy();
        if (this.termBindingsList != null) {
            dst.termBindingsList = new ArrayList<WebTemplateTermBinding>();
            for (WebTemplateTermBinding webTemplateTermBinding : this.termBindingsList) {
                dst.termBindingsList.add(webTemplateTermBinding.copy());
            }
        }
    }

    protected WebTemplateInputListItem typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateInputListItem)) {
            return false;
        }
        WebTemplateInputListItem o = (WebTemplateInputListItem)other_;
        return WebTemplateInputListItem.compareDeep(this.value, o.value, true) && WebTemplateInputListItem.compareDeep(this.label, o.label, true) && WebTemplateInputListItem.compareDeep(this.ordinal, o.ordinal, true) && WebTemplateInputListItem.compareDeep(this.localizedLabelsList, o.localizedLabelsList, true) && WebTemplateInputListItem.compareDeep(this.localizedDescriptionsList, o.localizedDescriptionsList, true) && WebTemplateInputListItem.compareDeep(this.currentStates, o.currentStates, true) && WebTemplateInputListItem.compareDeep(this.range, o.range, true) && WebTemplateInputListItem.compareDeep(this.precision, o.precision, true) && WebTemplateInputListItem.compareDeep(this.termBindingsList, o.termBindingsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof WebTemplateInputListItem)) {
            return false;
        }
        WebTemplateInputListItem o = (WebTemplateInputListItem)other_;
        return WebTemplateInputListItem.compareValues(this.value, o.value, true) && WebTemplateInputListItem.compareValues(this.label, o.label, true) && WebTemplateInputListItem.compareValues(this.ordinal, o.ordinal, true) && WebTemplateInputListItem.compareValues(this.currentStates, o.currentStates, true) && WebTemplateInputListItem.compareValues(this.range, o.range, true) && WebTemplateInputListItem.compareValues(this.precision, o.precision, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.value, this.label, this.ordinal, this.localizedLabelsList, this.localizedDescriptionsList, this.currentStates, this.range, this.precision, this.termBindingsList});
    }
}

