/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_DATE_TIME;
import org.hl7.fhir.r5.openehr.HIER_OBJECT_ID;
import org.hl7.fhir.r5.openehr.OBJECT_REF;

@DatatypeDef(name="VERSIONED_OBJECT")
public class VERSIONED_OBJECT
extends LogicalBase
implements ICompositeType {
    @Child(name="uid", type={HIER_OBJECT_ID.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Unique identifier of this version container in the form of a UID with no extension", formalDefinition="Unique identifier of this version container in the form of a UID with no extension. This id will be the same in all instances of the same container in a distributed environment, meaning that it can be understood as the uid of the virtual version tree.")
    protected HIER_OBJECT_ID uid;
    @Child(name="owner_id", type={OBJECT_REF.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to object to which this version container belongs, e.g. the id of the containing EHR or other relevant owning entity", formalDefinition="Reference to object to which this version container belongs, e.g. the id of the containing EHR or other relevant owning entity.")
    protected OBJECT_REF owner_id;
    @Child(name="time_created", type={DV_DATE_TIME.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Time of initial creation of this versioned object", formalDefinition="Time of initial creation of this versioned object.")
    protected DV_DATE_TIME time_created;
    private static final long serialVersionUID = 615162631L;

    public VERSIONED_OBJECT() {
    }

    public VERSIONED_OBJECT(HIER_OBJECT_ID uid, OBJECT_REF owner_id, DV_DATE_TIME time_created) {
        this.setUid(uid);
        this.setOwner_id(owner_id);
        this.setTime_created(time_created);
    }

    public HIER_OBJECT_ID getUid() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VERSIONED_OBJECT.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new HIER_OBJECT_ID();
            }
        }
        return this.uid;
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public VERSIONED_OBJECT setUid(HIER_OBJECT_ID value) {
        this.uid = value;
        return this;
    }

    public OBJECT_REF getOwner_id() {
        if (this.owner_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VERSIONED_OBJECT.owner_id");
            }
            if (Configuration.doAutoCreate()) {
                this.owner_id = new OBJECT_REF();
            }
        }
        return this.owner_id;
    }

    public boolean hasOwner_id() {
        return this.owner_id != null && !this.owner_id.isEmpty();
    }

    public VERSIONED_OBJECT setOwner_id(OBJECT_REF value) {
        this.owner_id = value;
        return this;
    }

    public DV_DATE_TIME getTime_created() {
        if (this.time_created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create VERSIONED_OBJECT.time_created");
            }
            if (Configuration.doAutoCreate()) {
                this.time_created = new DV_DATE_TIME();
            }
        }
        return this.time_created;
    }

    public boolean hasTime_created() {
        return this.time_created != null && !this.time_created.isEmpty();
    }

    public VERSIONED_OBJECT setTime_created(DV_DATE_TIME value) {
        this.time_created = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("uid", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "Unique identifier of this version container in the form of a UID with no extension. This id will be the same in all instances of the same container in a distributed environment, meaning that it can be understood as the uid of the virtual version tree.", 0, 1, this.uid));
        children.add(new Property("owner_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Reference to object to which this version container belongs, e.g. the id of the containing EHR or other relevant owning entity.", 0, 1, this.owner_id));
        children.add(new Property("time_created", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of initial creation of this versioned object.", 0, 1, this.time_created));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 115792: {
                return new Property("uid", "http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID", "Unique identifier of this version container in the form of a UID with no extension. This id will be the same in all instances of the same container in a distributed environment, meaning that it can be understood as the uid of the virtual version tree.", 0, 1, this.uid);
            }
            case 1663147559: {
                return new Property("owner_id", "http://openehr.org/fhir/StructureDefinition/OBJECT-REF", "Reference to object to which this version container belongs, e.g. the id of the containing EHR or other relevant owning entity.", 0, 1, this.owner_id);
            }
            case -630236298: {
                return new Property("time_created", "http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME", "Time of initial creation of this versioned object.", 0, 1, this.time_created);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case 1663147559: {
                Base[] baseArray;
                if (this.owner_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.owner_id;
                }
                return baseArray;
            }
            case -630236298: {
                Base[] baseArray;
                if (this.time_created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.time_created;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = (HIER_OBJECT_ID)value;
                return value;
            }
            case 1663147559: {
                this.owner_id = (OBJECT_REF)value;
                return value;
            }
            case -630236298: {
                this.time_created = (DV_DATE_TIME)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = (HIER_OBJECT_ID)value;
        } else if (name.equals("owner_id")) {
            this.owner_id = (OBJECT_REF)value;
        } else if (name.equals("time_created")) {
            this.time_created = (DV_DATE_TIME)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return this.getUid();
            }
            case 1663147559: {
                return this.getOwner_id();
            }
            case -630236298: {
                return this.getTime_created();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/HIER-OBJECT-ID"};
            }
            case 1663147559: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-REF"};
            }
            case -630236298: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-DATE-TIME"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("uid")) {
            this.uid = new HIER_OBJECT_ID();
            return this.uid;
        }
        if (name.equals("owner_id")) {
            this.owner_id = new OBJECT_REF();
            return this.owner_id;
        }
        if (name.equals("time_created")) {
            this.time_created = new DV_DATE_TIME();
            return this.time_created;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "VERSIONED_OBJECT";
    }

    @Override
    public VERSIONED_OBJECT copy() {
        VERSIONED_OBJECT dst = new VERSIONED_OBJECT();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(VERSIONED_OBJECT dst) {
        super.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        dst.owner_id = this.owner_id == null ? null : this.owner_id.copy();
        dst.time_created = this.time_created == null ? null : this.time_created.copy();
    }

    protected VERSIONED_OBJECT typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof VERSIONED_OBJECT)) {
            return false;
        }
        VERSIONED_OBJECT o = (VERSIONED_OBJECT)other_;
        return VERSIONED_OBJECT.compareDeep(this.uid, o.uid, true) && VERSIONED_OBJECT.compareDeep(this.owner_id, o.owner_id, true) && VERSIONED_OBJECT.compareDeep(this.time_created, o.time_created, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof VERSIONED_OBJECT)) {
            return false;
        }
        VERSIONED_OBJECT o = (VERSIONED_OBJECT)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.uid, this.owner_id, this.time_created});
    }
}

