/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="TranslatedString")
public class TranslatedString
extends LogicalBase
implements ICompositeType {
    @Child(name="language", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected CodeType language;
    @Child(name="value", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="todo", formalDefinition="")
    protected StringType value;
    private static final long serialVersionUID = 499908337L;

    public TranslatedString() {
    }

    public TranslatedString(String language, String value) {
        this.setLanguage(language);
        this.setValue(value);
    }

    public CodeType getLanguageElement() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TranslatedString.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CodeType();
            }
        }
        return this.language;
    }

    public boolean hasLanguageElement() {
        return this.language != null && !this.language.isEmpty();
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public TranslatedString setLanguageElement(CodeType value) {
        this.language = value;
        return this;
    }

    public String getLanguage() {
        return this.language == null ? null : (String)this.language.getValue();
    }

    public TranslatedString setLanguage(String value) {
        if (this.language == null) {
            this.language = new CodeType();
        }
        this.language.setValue(value);
        return this;
    }

    public StringType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TranslatedString.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new StringType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public TranslatedString setValueElement(StringType value) {
        this.value = value;
        return this;
    }

    public String getValue() {
        return this.value == null ? null : (String)this.value.getValue();
    }

    public TranslatedString setValue(String value) {
        if (this.value == null) {
            this.value = new StringType();
        }
        this.value.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("language", "code", "", 0, 1, this.language));
        children.add(new Property("value", "string", "", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1613589672: {
                return new Property("language", "code", "", 0, 1, this.language);
            }
            case 111972721: {
                return new Property("value", "string", "", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.language;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                this.language = TypeConvertor.castToCode(value);
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("language")) {
            this.language = TypeConvertor.castToCode(value);
        } else if (name.equals("value")) {
            this.value = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return this.getLanguageElement();
            }
            case 111972721: {
                return this.getValueElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return new String[]{"code"};
            }
            case 111972721: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("language")) {
            throw new FHIRException("Cannot call addChild on a singleton property TranslatedString.language");
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property TranslatedString.value");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TranslatedString";
    }

    @Override
    public TranslatedString copy() {
        TranslatedString dst = new TranslatedString();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TranslatedString dst) {
        super.copyValues(dst);
        dst.language = this.language == null ? null : this.language.copy();
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected TranslatedString typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TranslatedString)) {
            return false;
        }
        TranslatedString o = (TranslatedString)other_;
        return TranslatedString.compareDeep(this.language, o.language, true) && TranslatedString.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TranslatedString)) {
            return false;
        }
        TranslatedString o = (TranslatedString)other_;
        return TranslatedString.compareValues(this.language, o.language, true) && TranslatedString.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.value});
    }
}

