/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;

@DatatypeDef(name="TRANSLATION_DETAILS")
public class TRANSLATION_DETAILS
extends LogicalBase
implements ICompositeType {
    @Child(name="language", type={CODE_PHRASE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Language of the translation", formalDefinition="Language of the translation.")
    protected CODE_PHRASE language;
    @Child(name="author", type={StringType.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Translator name and other demographic details", formalDefinition="Translator name and other demographic details.")
    protected List<StringType> authorList;
    @Child(name="accreditation", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Accreditation of translator, usually a national translator\u2019s registration or association membership id", formalDefinition="Accreditation of translator, usually a national translator\u2019s registration or association membership id.")
    protected StringType accreditation;
    @Child(name="other_details", type={StringType.class}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Any other meta-data", formalDefinition="Any other meta-data.")
    protected List<StringType> other_detailsList;
    private static final long serialVersionUID = -1093734482L;

    public TRANSLATION_DETAILS() {
    }

    public TRANSLATION_DETAILS(CODE_PHRASE language, String accreditation) {
        this.setLanguage(language);
        this.setAccreditation(accreditation);
    }

    public CODE_PHRASE getLanguage() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TRANSLATION_DETAILS.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CODE_PHRASE();
            }
        }
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public TRANSLATION_DETAILS setLanguage(CODE_PHRASE value) {
        this.language = value;
        return this;
    }

    public List<StringType> getAuthorList() {
        if (this.authorList == null) {
            this.authorList = new ArrayList<StringType>();
        }
        return this.authorList;
    }

    public TRANSLATION_DETAILS setAuthorList(List<StringType> theAuthor) {
        this.authorList = theAuthor;
        return this;
    }

    public boolean hasAuthor() {
        if (this.authorList == null) {
            return false;
        }
        for (StringType item : this.authorList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addAuthorElement() {
        StringType t = new StringType();
        if (this.authorList == null) {
            this.authorList = new ArrayList<StringType>();
        }
        this.authorList.add(t);
        return t;
    }

    public TRANSLATION_DETAILS addAuthor(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.authorList == null) {
            this.authorList = new ArrayList<StringType>();
        }
        this.authorList.add(t);
        return this;
    }

    public boolean hasAuthor(String value) {
        if (this.authorList == null) {
            return false;
        }
        for (StringType v : this.authorList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getAccreditationElement() {
        if (this.accreditation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create TRANSLATION_DETAILS.accreditation");
            }
            if (Configuration.doAutoCreate()) {
                this.accreditation = new StringType();
            }
        }
        return this.accreditation;
    }

    public boolean hasAccreditationElement() {
        return this.accreditation != null && !this.accreditation.isEmpty();
    }

    public boolean hasAccreditation() {
        return this.accreditation != null && !this.accreditation.isEmpty();
    }

    public TRANSLATION_DETAILS setAccreditationElement(StringType value) {
        this.accreditation = value;
        return this;
    }

    public String getAccreditation() {
        return this.accreditation == null ? null : (String)this.accreditation.getValue();
    }

    public TRANSLATION_DETAILS setAccreditation(String value) {
        if (this.accreditation == null) {
            this.accreditation = new StringType();
        }
        this.accreditation.setValue(value);
        return this;
    }

    public List<StringType> getOther_detailsList() {
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<StringType>();
        }
        return this.other_detailsList;
    }

    public TRANSLATION_DETAILS setOther_detailsList(List<StringType> theOther_details) {
        this.other_detailsList = theOther_details;
        return this;
    }

    public boolean hasOther_details() {
        if (this.other_detailsList == null) {
            return false;
        }
        for (StringType item : this.other_detailsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addOther_detailsElement() {
        StringType t = new StringType();
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<StringType>();
        }
        this.other_detailsList.add(t);
        return t;
    }

    public TRANSLATION_DETAILS addOther_details(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<StringType>();
        }
        this.other_detailsList.add(t);
        return this;
    }

    public boolean hasOther_details(String value) {
        if (this.other_detailsList == null) {
            return false;
        }
        for (StringType v : this.other_detailsList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Language of the translation.", 0, 1, this.language));
        children.add(new Property("author", "string", "Translator name and other demographic details.", 0, Integer.MAX_VALUE, this.authorList));
        children.add(new Property("accreditation", "string", "Accreditation of translator, usually a national translator\u2019s registration or association membership id.", 0, 1, this.accreditation));
        children.add(new Property("other_details", "string", "Any other meta-data.", 0, Integer.MAX_VALUE, this.other_detailsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1613589672: {
                return new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "Language of the translation.", 0, 1, this.language);
            }
            case -1406328437: {
                return new Property("author", "string", "Translator name and other demographic details.", 0, Integer.MAX_VALUE, this.authorList);
            }
            case 1197534778: {
                return new Property("accreditation", "string", "Accreditation of translator, usually a national translator\u2019s registration or association membership id.", 0, 1, this.accreditation);
            }
            case -1257043949: {
                return new Property("other_details", "string", "Any other meta-data.", 0, Integer.MAX_VALUE, this.other_detailsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.language;
                }
                return baseArray;
            }
            case -1406328437: {
                return this.authorList == null ? new Base[]{} : this.authorList.toArray(new Base[this.authorList.size()]);
            }
            case 1197534778: {
                Base[] baseArray;
                if (this.accreditation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.accreditation;
                }
                return baseArray;
            }
            case -1257043949: {
                return this.other_detailsList == null ? new Base[]{} : this.other_detailsList.toArray(new Base[this.other_detailsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                this.language = (CODE_PHRASE)value;
                return value;
            }
            case -1406328437: {
                this.getAuthorList().add(TypeConvertor.castToString(value));
                return value;
            }
            case 1197534778: {
                this.accreditation = TypeConvertor.castToString(value);
                return value;
            }
            case -1257043949: {
                this.getOther_detailsList().add(TypeConvertor.castToString(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("language")) {
            this.language = (CODE_PHRASE)value;
        } else if (name.equals("author")) {
            this.getAuthorList().add(TypeConvertor.castToString(value));
        } else if (name.equals("accreditation")) {
            this.accreditation = TypeConvertor.castToString(value);
        } else if (name.equals("other_details")) {
            this.getOther_detailsList().add(TypeConvertor.castToString(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return this.getLanguage();
            }
            case -1406328437: {
                return this.addAuthorElement();
            }
            case 1197534778: {
                return this.getAccreditationElement();
            }
            case -1257043949: {
                return this.addOther_detailsElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case -1406328437: {
                return new String[]{"string"};
            }
            case 1197534778: {
                return new String[]{"string"};
            }
            case -1257043949: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("language")) {
            this.language = new CODE_PHRASE();
            return this.language;
        }
        if (name.equals("author")) {
            throw new FHIRException("Cannot call addChild on a singleton property TRANSLATION_DETAILS.author");
        }
        if (name.equals("accreditation")) {
            throw new FHIRException("Cannot call addChild on a singleton property TRANSLATION_DETAILS.accreditation");
        }
        if (name.equals("other_details")) {
            throw new FHIRException("Cannot call addChild on a singleton property TRANSLATION_DETAILS.other_details");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "TRANSLATION_DETAILS";
    }

    @Override
    public TRANSLATION_DETAILS copy() {
        TRANSLATION_DETAILS dst = new TRANSLATION_DETAILS();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(TRANSLATION_DETAILS dst) {
        super.copyValues(dst);
        CODE_PHRASE cODE_PHRASE = dst.language = this.language == null ? null : this.language.copy();
        if (this.authorList != null) {
            dst.authorList = new ArrayList<StringType>();
            for (StringType i : this.authorList) {
                dst.authorList.add(i.copy());
            }
        }
        StringType stringType = dst.accreditation = this.accreditation == null ? null : this.accreditation.copy();
        if (this.other_detailsList != null) {
            dst.other_detailsList = new ArrayList<StringType>();
            for (StringType i : this.other_detailsList) {
                dst.other_detailsList.add(i.copy());
            }
        }
    }

    protected TRANSLATION_DETAILS typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof TRANSLATION_DETAILS)) {
            return false;
        }
        TRANSLATION_DETAILS o = (TRANSLATION_DETAILS)other_;
        return TRANSLATION_DETAILS.compareDeep(this.language, o.language, true) && TRANSLATION_DETAILS.compareDeep(this.authorList, o.authorList, true) && TRANSLATION_DETAILS.compareDeep(this.accreditation, o.accreditation, true) && TRANSLATION_DETAILS.compareDeep(this.other_detailsList, o.other_detailsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof TRANSLATION_DETAILS)) {
            return false;
        }
        TRANSLATION_DETAILS o = (TRANSLATION_DETAILS)other_;
        return TRANSLATION_DETAILS.compareValues(this.authorList, o.authorList, true) && TRANSLATION_DETAILS.compareValues(this.accreditation, o.accreditation, true) && TRANSLATION_DETAILS.compareValues(this.other_detailsList, o.other_detailsList, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.language, this.authorList, this.accreditation, this.other_detailsList});
    }
}

