/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.CAPABILITY;
import org.hl7.fhir.r5.openehr.DV_INTERVAL;
import org.hl7.fhir.r5.openehr.PARTY;
import org.hl7.fhir.r5.openehr.PARTY_REF;

@DatatypeDef(name="ROLE")
public class ROLE
extends PARTY
implements ICompositeType {
    @Child(name="time_validity", type={DV_INTERVAL.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identities used by the ROLE to identify itself, such as legal name, stage names, aliases, nicknames and so on", formalDefinition="Identities used by the ROLE to identify itself, such as legal name, stage names, aliases, nicknames and so on.")
    protected DV_INTERVAL time_validity;
    @Child(name="performer", type={PARTY_REF.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Contacts for this ROLE", formalDefinition="Contacts for this ROLE.")
    protected PARTY_REF performer;
    @Child(name="capabilities", type={CAPABILITY.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="All other details for this ROLE", formalDefinition="All other details for this ROLE.")
    protected List<CAPABILITY> capabilitiesList;
    private static final long serialVersionUID = 1286378228L;

    public ROLE() {
    }

    public ROLE(PARTY_REF performer) {
        this.setPerformer(performer);
    }

    public DV_INTERVAL getTime_validity() {
        if (this.time_validity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ROLE.time_validity");
            }
            if (Configuration.doAutoCreate()) {
                this.time_validity = new DV_INTERVAL();
            }
        }
        return this.time_validity;
    }

    public boolean hasTime_validity() {
        return this.time_validity != null && !this.time_validity.isEmpty();
    }

    public ROLE setTime_validity(DV_INTERVAL value) {
        this.time_validity = value;
        return this;
    }

    public PARTY_REF getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ROLE.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new PARTY_REF();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public ROLE setPerformer(PARTY_REF value) {
        this.performer = value;
        return this;
    }

    public List<CAPABILITY> getCapabilitiesList() {
        if (this.capabilitiesList == null) {
            this.capabilitiesList = new ArrayList<CAPABILITY>();
        }
        return this.capabilitiesList;
    }

    public ROLE setCapabilitiesList(List<CAPABILITY> theCapabilities) {
        this.capabilitiesList = theCapabilities;
        return this;
    }

    public boolean hasCapabilities() {
        if (this.capabilitiesList == null) {
            return false;
        }
        for (CAPABILITY item : this.capabilitiesList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CAPABILITY addCapabilities() {
        CAPABILITY t = new CAPABILITY();
        if (this.capabilitiesList == null) {
            this.capabilitiesList = new ArrayList<CAPABILITY>();
        }
        this.capabilitiesList.add(t);
        return t;
    }

    public ROLE addCapabilities(CAPABILITY t) {
        if (t == null) {
            return this;
        }
        if (this.capabilitiesList == null) {
            this.capabilitiesList = new ArrayList<CAPABILITY>();
        }
        this.capabilitiesList.add(t);
        return this;
    }

    public CAPABILITY getCapabilitiesFirstRep() {
        if (this.getCapabilitiesList().isEmpty()) {
            this.addCapabilities();
        }
        return this.getCapabilitiesList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Identities used by the ROLE to identify itself, such as legal name, stage names, aliases, nicknames and so on.", 0, 1, this.time_validity));
        children.add(new Property("performer", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Contacts for this ROLE.", 0, 1, this.performer));
        children.add(new Property("capabilities", "http://openehr.org/fhir/StructureDefinition/CAPABILITY", "All other details for this ROLE.", 0, Integer.MAX_VALUE, this.capabilitiesList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1304171420: {
                return new Property("time_validity", "http://openehr.org/fhir/StructureDefinition/DV-INTERVAL", "Identities used by the ROLE to identify itself, such as legal name, stage names, aliases, nicknames and so on.", 0, 1, this.time_validity);
            }
            case 481140686: {
                return new Property("performer", "http://openehr.org/fhir/StructureDefinition/PARTY-REF", "Contacts for this ROLE.", 0, 1, this.performer);
            }
            case -1487597642: {
                return new Property("capabilities", "http://openehr.org/fhir/StructureDefinition/CAPABILITY", "All other details for this ROLE.", 0, Integer.MAX_VALUE, this.capabilitiesList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1304171420: {
                Base[] baseArray;
                if (this.time_validity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.time_validity;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.performer;
                }
                return baseArray;
            }
            case -1487597642: {
                return this.capabilitiesList == null ? new Base[]{} : this.capabilitiesList.toArray(new Base[this.capabilitiesList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1304171420: {
                this.time_validity = (DV_INTERVAL)value;
                return value;
            }
            case 481140686: {
                this.performer = (PARTY_REF)value;
                return value;
            }
            case -1487597642: {
                this.getCapabilitiesList().add((CAPABILITY)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("time_validity")) {
            this.time_validity = (DV_INTERVAL)value;
        } else if (name.equals("performer")) {
            this.performer = (PARTY_REF)value;
        } else if (name.equals("capabilities")) {
            this.getCapabilitiesList().add((CAPABILITY)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1304171420: {
                return this.getTime_validity();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -1487597642: {
                return this.addCapabilities();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1304171420: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-INTERVAL"};
            }
            case 481140686: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-REF"};
            }
            case -1487597642: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CAPABILITY"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("time_validity")) {
            this.time_validity = new DV_INTERVAL();
            return this.time_validity;
        }
        if (name.equals("performer")) {
            this.performer = new PARTY_REF();
            return this.performer;
        }
        if (name.equals("capabilities")) {
            return this.addCapabilities();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ROLE";
    }

    @Override
    public ROLE copy() {
        ROLE dst = new ROLE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ROLE dst) {
        super.copyValues(dst);
        dst.time_validity = this.time_validity == null ? null : this.time_validity.copy();
        PARTY_REF pARTY_REF = dst.performer = this.performer == null ? null : this.performer.copy();
        if (this.capabilitiesList != null) {
            dst.capabilitiesList = new ArrayList<CAPABILITY>();
            for (CAPABILITY i : this.capabilitiesList) {
                dst.capabilitiesList.add(i.copy());
            }
        }
    }

    protected ROLE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ROLE)) {
            return false;
        }
        ROLE o = (ROLE)other_;
        return ROLE.compareDeep(this.time_validity, o.time_validity, true) && ROLE.compareDeep(this.performer, o.performer, true) && ROLE.compareDeep(this.capabilitiesList, o.capabilitiesList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ROLE)) {
            return false;
        }
        ROLE o = (ROLE)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.time_validity, this.performer, this.capabilitiesList});
    }
}

