/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="REVISION_HISTORY")
public class REVISION_HISTORY
extends LogicalBase
implements ICompositeType {
    @Child(name="most_recent_version", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The version id of the most recent item, as a String", formalDefinition="The version id of the most recent item, as a String.")
    protected StringType most_recent_version;
    @Child(name="most_recent_version_time_committed", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The commit date/time of the most recent item, as a String", formalDefinition="The commit date/time of the most recent item, as a String.")
    protected StringType most_recent_version_time_committed;
    private static final long serialVersionUID = 213309767L;

    public REVISION_HISTORY() {
    }

    public REVISION_HISTORY(String most_recent_version, String most_recent_version_time_committed) {
        this.setMost_recent_version(most_recent_version);
        this.setMost_recent_version_time_committed(most_recent_version_time_committed);
    }

    public StringType getMost_recent_versionElement() {
        if (this.most_recent_version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create REVISION_HISTORY.most_recent_version");
            }
            if (Configuration.doAutoCreate()) {
                this.most_recent_version = new StringType();
            }
        }
        return this.most_recent_version;
    }

    public boolean hasMost_recent_versionElement() {
        return this.most_recent_version != null && !this.most_recent_version.isEmpty();
    }

    public boolean hasMost_recent_version() {
        return this.most_recent_version != null && !this.most_recent_version.isEmpty();
    }

    public REVISION_HISTORY setMost_recent_versionElement(StringType value) {
        this.most_recent_version = value;
        return this;
    }

    public String getMost_recent_version() {
        return this.most_recent_version == null ? null : (String)this.most_recent_version.getValue();
    }

    public REVISION_HISTORY setMost_recent_version(String value) {
        if (this.most_recent_version == null) {
            this.most_recent_version = new StringType();
        }
        this.most_recent_version.setValue(value);
        return this;
    }

    public StringType getMost_recent_version_time_committedElement() {
        if (this.most_recent_version_time_committed == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create REVISION_HISTORY.most_recent_version_time_committed");
            }
            if (Configuration.doAutoCreate()) {
                this.most_recent_version_time_committed = new StringType();
            }
        }
        return this.most_recent_version_time_committed;
    }

    public boolean hasMost_recent_version_time_committedElement() {
        return this.most_recent_version_time_committed != null && !this.most_recent_version_time_committed.isEmpty();
    }

    public boolean hasMost_recent_version_time_committed() {
        return this.most_recent_version_time_committed != null && !this.most_recent_version_time_committed.isEmpty();
    }

    public REVISION_HISTORY setMost_recent_version_time_committedElement(StringType value) {
        this.most_recent_version_time_committed = value;
        return this;
    }

    public String getMost_recent_version_time_committed() {
        return this.most_recent_version_time_committed == null ? null : (String)this.most_recent_version_time_committed.getValue();
    }

    public REVISION_HISTORY setMost_recent_version_time_committed(String value) {
        if (this.most_recent_version_time_committed == null) {
            this.most_recent_version_time_committed = new StringType();
        }
        this.most_recent_version_time_committed.setValue(value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("most_recent_version", "string", "The version id of the most recent item, as a String.", 0, 1, this.most_recent_version));
        children.add(new Property("most_recent_version_time_committed", "string", "The commit date/time of the most recent item, as a String.", 0, 1, this.most_recent_version_time_committed));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -971449552: {
                return new Property("most_recent_version", "string", "The version id of the most recent item, as a String.", 0, 1, this.most_recent_version);
            }
            case 855029113: {
                return new Property("most_recent_version_time_committed", "string", "The commit date/time of the most recent item, as a String.", 0, 1, this.most_recent_version_time_committed);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -971449552: {
                Base[] baseArray;
                if (this.most_recent_version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.most_recent_version;
                }
                return baseArray;
            }
            case 855029113: {
                Base[] baseArray;
                if (this.most_recent_version_time_committed == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.most_recent_version_time_committed;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -971449552: {
                this.most_recent_version = TypeConvertor.castToString(value);
                return value;
            }
            case 855029113: {
                this.most_recent_version_time_committed = TypeConvertor.castToString(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("most_recent_version")) {
            this.most_recent_version = TypeConvertor.castToString(value);
        } else if (name.equals("most_recent_version_time_committed")) {
            this.most_recent_version_time_committed = TypeConvertor.castToString(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -971449552: {
                return this.getMost_recent_versionElement();
            }
            case 855029113: {
                return this.getMost_recent_version_time_committedElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -971449552: {
                return new String[]{"string"};
            }
            case 855029113: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("most_recent_version")) {
            throw new FHIRException("Cannot call addChild on a singleton property REVISION_HISTORY.most_recent_version");
        }
        if (name.equals("most_recent_version_time_committed")) {
            throw new FHIRException("Cannot call addChild on a singleton property REVISION_HISTORY.most_recent_version_time_committed");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "REVISION_HISTORY";
    }

    @Override
    public REVISION_HISTORY copy() {
        REVISION_HISTORY dst = new REVISION_HISTORY();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(REVISION_HISTORY dst) {
        super.copyValues(dst);
        dst.most_recent_version = this.most_recent_version == null ? null : this.most_recent_version.copy();
        dst.most_recent_version_time_committed = this.most_recent_version_time_committed == null ? null : this.most_recent_version_time_committed.copy();
    }

    protected REVISION_HISTORY typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof REVISION_HISTORY)) {
            return false;
        }
        REVISION_HISTORY o = (REVISION_HISTORY)other_;
        return REVISION_HISTORY.compareDeep(this.most_recent_version, o.most_recent_version, true) && REVISION_HISTORY.compareDeep(this.most_recent_version_time_committed, o.most_recent_version_time_committed, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof REVISION_HISTORY)) {
            return false;
        }
        REVISION_HISTORY o = (REVISION_HISTORY)other_;
        return REVISION_HISTORY.compareValues(this.most_recent_version, o.most_recent_version, true) && REVISION_HISTORY.compareValues(this.most_recent_version_time_committed, o.most_recent_version_time_committed, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.most_recent_version, this.most_recent_version_time_committed});
    }
}

