/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.CODE_PHRASE;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="RESOURCE_DESCRIPTION_ITEM")
public class RESOURCE_DESCRIPTION_ITEM
extends LogicalBase
implements ICompositeType {
    @Child(name="language", type={CODE_PHRASE.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The localised language in which the items in this description item are written", formalDefinition="The localised language in which the items in this description item are written. Coded from openEHR code set languages.")
    protected CODE_PHRASE language;
    @Child(name="purpose", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Purpose of the resource", formalDefinition="Purpose of the resource.")
    protected StringType purpose;
    @Child(name="keywords", type={StringType.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Keywords which characterise this resource, used e.g. for indexing and searching", formalDefinition="Keywords which characterise this resource, used e.g. for indexing and searching.")
    protected List<StringType> keywordsList;
    @Child(name="use", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of the uses of the resource, i.e. contexts in which it could be used", formalDefinition="Description of the uses of the resource, i.e. contexts in which it could be used.")
    protected StringType use;
    @Child(name="misuse", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Description of any misuses of the resource, i.e. contexts in which it should not be used", formalDefinition="Description of any misuses of the resource, i.e. contexts in which it should not be used.")
    protected StringType misuse;
    @Child(name="copyright", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional copyright statement for the resource as a knowledge resource", formalDefinition="Optional copyright statement for the resource as a knowledge resource.")
    protected StringType copyright;
    @Child(name="original_resource_uri", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="URIs of original clinical document(s) or description of which resource is a formalisation", formalDefinition="URIs of original clinical document(s) or description of which resource is a formalisation, in the language of this description item; keyed by meaning.")
    protected List<StringType> original_resource_uriList;
    @Child(name="other_details", type={StringType.class}, order=7, min=1, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional language-senstive resource metadata, as a list of name/value pairs", formalDefinition="Additional language-senstive resource metadata, as a list of name/value pairs.")
    protected List<StringType> other_detailsList;
    private static final long serialVersionUID = -1123991092L;

    public RESOURCE_DESCRIPTION_ITEM() {
    }

    public RESOURCE_DESCRIPTION_ITEM(CODE_PHRASE language, String purpose, String other_details) {
        this.setLanguage(language);
        this.setPurpose(purpose);
        this.addOther_details(other_details);
    }

    public CODE_PHRASE getLanguage() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION_ITEM.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CODE_PHRASE();
            }
        }
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public RESOURCE_DESCRIPTION_ITEM setLanguage(CODE_PHRASE value) {
        this.language = value;
        return this;
    }

    public StringType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION_ITEM.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new StringType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public RESOURCE_DESCRIPTION_ITEM setPurposeElement(StringType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public RESOURCE_DESCRIPTION_ITEM setPurpose(String value) {
        if (this.purpose == null) {
            this.purpose = new StringType();
        }
        this.purpose.setValue(value);
        return this;
    }

    public List<StringType> getKeywordsList() {
        if (this.keywordsList == null) {
            this.keywordsList = new ArrayList<StringType>();
        }
        return this.keywordsList;
    }

    public RESOURCE_DESCRIPTION_ITEM setKeywordsList(List<StringType> theKeywords) {
        this.keywordsList = theKeywords;
        return this;
    }

    public boolean hasKeywords() {
        if (this.keywordsList == null) {
            return false;
        }
        for (StringType item : this.keywordsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addKeywordsElement() {
        StringType t = new StringType();
        if (this.keywordsList == null) {
            this.keywordsList = new ArrayList<StringType>();
        }
        this.keywordsList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION_ITEM addKeywords(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.keywordsList == null) {
            this.keywordsList = new ArrayList<StringType>();
        }
        this.keywordsList.add(t);
        return this;
    }

    public boolean hasKeywords(String value) {
        if (this.keywordsList == null) {
            return false;
        }
        for (StringType v : this.keywordsList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public StringType getUseElement() {
        if (this.use == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION_ITEM.use");
            }
            if (Configuration.doAutoCreate()) {
                this.use = new StringType();
            }
        }
        return this.use;
    }

    public boolean hasUseElement() {
        return this.use != null && !this.use.isEmpty();
    }

    public boolean hasUse() {
        return this.use != null && !this.use.isEmpty();
    }

    public RESOURCE_DESCRIPTION_ITEM setUseElement(StringType value) {
        this.use = value;
        return this;
    }

    public String getUse() {
        return this.use == null ? null : (String)this.use.getValue();
    }

    public RESOURCE_DESCRIPTION_ITEM setUse(String value) {
        if (Utilities.noString((String)value)) {
            this.use = null;
        } else {
            if (this.use == null) {
                this.use = new StringType();
            }
            this.use.setValue(value);
        }
        return this;
    }

    public StringType getMisuseElement() {
        if (this.misuse == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION_ITEM.misuse");
            }
            if (Configuration.doAutoCreate()) {
                this.misuse = new StringType();
            }
        }
        return this.misuse;
    }

    public boolean hasMisuseElement() {
        return this.misuse != null && !this.misuse.isEmpty();
    }

    public boolean hasMisuse() {
        return this.misuse != null && !this.misuse.isEmpty();
    }

    public RESOURCE_DESCRIPTION_ITEM setMisuseElement(StringType value) {
        this.misuse = value;
        return this;
    }

    public String getMisuse() {
        return this.misuse == null ? null : (String)this.misuse.getValue();
    }

    public RESOURCE_DESCRIPTION_ITEM setMisuse(String value) {
        if (Utilities.noString((String)value)) {
            this.misuse = null;
        } else {
            if (this.misuse == null) {
                this.misuse = new StringType();
            }
            this.misuse.setValue(value);
        }
        return this;
    }

    public StringType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RESOURCE_DESCRIPTION_ITEM.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new StringType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public RESOURCE_DESCRIPTION_ITEM setCopyrightElement(StringType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public RESOURCE_DESCRIPTION_ITEM setCopyright(String value) {
        if (Utilities.noString((String)value)) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new StringType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<StringType> getOriginal_resource_uriList() {
        if (this.original_resource_uriList == null) {
            this.original_resource_uriList = new ArrayList<StringType>();
        }
        return this.original_resource_uriList;
    }

    public RESOURCE_DESCRIPTION_ITEM setOriginal_resource_uriList(List<StringType> theOriginal_resource_uri) {
        this.original_resource_uriList = theOriginal_resource_uri;
        return this;
    }

    public boolean hasOriginal_resource_uri() {
        if (this.original_resource_uriList == null) {
            return false;
        }
        for (StringType item : this.original_resource_uriList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addOriginal_resource_uriElement() {
        StringType t = new StringType();
        if (this.original_resource_uriList == null) {
            this.original_resource_uriList = new ArrayList<StringType>();
        }
        this.original_resource_uriList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION_ITEM addOriginal_resource_uri(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.original_resource_uriList == null) {
            this.original_resource_uriList = new ArrayList<StringType>();
        }
        this.original_resource_uriList.add(t);
        return this;
    }

    public boolean hasOriginal_resource_uri(String value) {
        if (this.original_resource_uriList == null) {
            return false;
        }
        for (StringType v : this.original_resource_uriList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getOther_detailsList() {
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<StringType>();
        }
        return this.other_detailsList;
    }

    public RESOURCE_DESCRIPTION_ITEM setOther_detailsList(List<StringType> theOther_details) {
        this.other_detailsList = theOther_details;
        return this;
    }

    public boolean hasOther_details() {
        if (this.other_detailsList == null) {
            return false;
        }
        for (StringType item : this.other_detailsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addOther_detailsElement() {
        StringType t = new StringType();
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<StringType>();
        }
        this.other_detailsList.add(t);
        return t;
    }

    public RESOURCE_DESCRIPTION_ITEM addOther_details(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.other_detailsList == null) {
            this.other_detailsList = new ArrayList<StringType>();
        }
        this.other_detailsList.add(t);
        return this;
    }

    public boolean hasOther_details(String value) {
        if (this.other_detailsList == null) {
            return false;
        }
        for (StringType v : this.other_detailsList) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "The localised language in which the items in this description item are written. Coded from openEHR code set languages.", 0, 1, this.language));
        children.add(new Property("purpose", "string", "Purpose of the resource.", 0, 1, this.purpose));
        children.add(new Property("keywords", "string", "Keywords which characterise this resource, used e.g. for indexing and searching.", 0, Integer.MAX_VALUE, this.keywordsList));
        children.add(new Property("use", "string", "Description of the uses of the resource, i.e. contexts in which it could be used.", 0, 1, this.use));
        children.add(new Property("misuse", "string", "Description of any misuses of the resource, i.e. contexts in which it should not be used.", 0, 1, this.misuse));
        children.add(new Property("copyright", "string", "Optional copyright statement for the resource as a knowledge resource.", 0, 1, this.copyright));
        children.add(new Property("original_resource_uri", "string", "URIs of original clinical document(s) or description of which resource is a formalisation, in the language of this description item; keyed by meaning.", 0, Integer.MAX_VALUE, this.original_resource_uriList));
        children.add(new Property("other_details", "string", "Additional language-senstive resource metadata, as a list of name/value pairs.", 0, Integer.MAX_VALUE, this.other_detailsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1613589672: {
                return new Property("language", "http://openehr.org/fhir/StructureDefinition/CODE-PHRASE", "The localised language in which the items in this description item are written. Coded from openEHR code set languages.", 0, 1, this.language);
            }
            case -220463842: {
                return new Property("purpose", "string", "Purpose of the resource.", 0, 1, this.purpose);
            }
            case 523149226: {
                return new Property("keywords", "string", "Keywords which characterise this resource, used e.g. for indexing and searching.", 0, Integer.MAX_VALUE, this.keywordsList);
            }
            case 116103: {
                return new Property("use", "string", "Description of the uses of the resource, i.e. contexts in which it could be used.", 0, 1, this.use);
            }
            case -1073878064: {
                return new Property("misuse", "string", "Description of any misuses of the resource, i.e. contexts in which it should not be used.", 0, 1, this.misuse);
            }
            case 1522889671: {
                return new Property("copyright", "string", "Optional copyright statement for the resource as a knowledge resource.", 0, 1, this.copyright);
            }
            case -775873175: {
                return new Property("original_resource_uri", "string", "URIs of original clinical document(s) or description of which resource is a formalisation, in the language of this description item; keyed by meaning.", 0, Integer.MAX_VALUE, this.original_resource_uriList);
            }
            case -1257043949: {
                return new Property("other_details", "string", "Additional language-senstive resource metadata, as a list of name/value pairs.", 0, Integer.MAX_VALUE, this.other_detailsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.language;
                }
                return baseArray;
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.purpose;
                }
                return baseArray;
            }
            case 523149226: {
                return this.keywordsList == null ? new Base[]{} : this.keywordsList.toArray(new Base[this.keywordsList.size()]);
            }
            case 116103: {
                Base[] baseArray;
                if (this.use == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.use;
                }
                return baseArray;
            }
            case -1073878064: {
                Base[] baseArray;
                if (this.misuse == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.misuse;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.copyright;
                }
                return baseArray;
            }
            case -775873175: {
                return this.original_resource_uriList == null ? new Base[]{} : this.original_resource_uriList.toArray(new Base[this.original_resource_uriList.size()]);
            }
            case -1257043949: {
                return this.other_detailsList == null ? new Base[]{} : this.other_detailsList.toArray(new Base[this.other_detailsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                this.language = (CODE_PHRASE)value;
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToString(value);
                return value;
            }
            case 523149226: {
                this.getKeywordsList().add(TypeConvertor.castToString(value));
                return value;
            }
            case 116103: {
                this.use = TypeConvertor.castToString(value);
                return value;
            }
            case -1073878064: {
                this.misuse = TypeConvertor.castToString(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToString(value);
                return value;
            }
            case -775873175: {
                this.getOriginal_resource_uriList().add(TypeConvertor.castToString(value));
                return value;
            }
            case -1257043949: {
                this.getOther_detailsList().add(TypeConvertor.castToString(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("language")) {
            this.language = (CODE_PHRASE)value;
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToString(value);
        } else if (name.equals("keywords")) {
            this.getKeywordsList().add(TypeConvertor.castToString(value));
        } else if (name.equals("use")) {
            this.use = TypeConvertor.castToString(value);
        } else if (name.equals("misuse")) {
            this.misuse = TypeConvertor.castToString(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToString(value);
        } else if (name.equals("original_resource_uri")) {
            this.getOriginal_resource_uriList().add(TypeConvertor.castToString(value));
        } else if (name.equals("other_details")) {
            this.getOther_detailsList().add(TypeConvertor.castToString(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return this.getLanguage();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 523149226: {
                return this.addKeywordsElement();
            }
            case 116103: {
                return this.getUseElement();
            }
            case -1073878064: {
                return this.getMisuseElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -775873175: {
                return this.addOriginal_resource_uriElement();
            }
            case -1257043949: {
                return this.addOther_detailsElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1613589672: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/CODE-PHRASE"};
            }
            case -220463842: {
                return new String[]{"string"};
            }
            case 523149226: {
                return new String[]{"string"};
            }
            case 116103: {
                return new String[]{"string"};
            }
            case -1073878064: {
                return new String[]{"string"};
            }
            case 1522889671: {
                return new String[]{"string"};
            }
            case -775873175: {
                return new String[]{"string"};
            }
            case -1257043949: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("language")) {
            this.language = new CODE_PHRASE();
            return this.language;
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.purpose");
        }
        if (name.equals("keywords")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.keywords");
        }
        if (name.equals("use")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.use");
        }
        if (name.equals("misuse")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.misuse");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.copyright");
        }
        if (name.equals("original_resource_uri")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.original_resource_uri");
        }
        if (name.equals("other_details")) {
            throw new FHIRException("Cannot call addChild on a singleton property RESOURCE_DESCRIPTION_ITEM.other_details");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RESOURCE_DESCRIPTION_ITEM";
    }

    @Override
    public RESOURCE_DESCRIPTION_ITEM copy() {
        RESOURCE_DESCRIPTION_ITEM dst = new RESOURCE_DESCRIPTION_ITEM();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RESOURCE_DESCRIPTION_ITEM dst) {
        super.copyValues(dst);
        dst.language = this.language == null ? null : this.language.copy();
        StringType stringType = dst.purpose = this.purpose == null ? null : this.purpose.copy();
        if (this.keywordsList != null) {
            dst.keywordsList = new ArrayList<StringType>();
            for (StringType i : this.keywordsList) {
                dst.keywordsList.add(i.copy());
            }
        }
        dst.use = this.use == null ? null : this.use.copy();
        dst.misuse = this.misuse == null ? null : this.misuse.copy();
        StringType stringType2 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.original_resource_uriList != null) {
            dst.original_resource_uriList = new ArrayList<StringType>();
            for (StringType i : this.original_resource_uriList) {
                dst.original_resource_uriList.add(i.copy());
            }
        }
        if (this.other_detailsList != null) {
            dst.other_detailsList = new ArrayList<StringType>();
            for (StringType i : this.other_detailsList) {
                dst.other_detailsList.add(i.copy());
            }
        }
    }

    protected RESOURCE_DESCRIPTION_ITEM typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RESOURCE_DESCRIPTION_ITEM)) {
            return false;
        }
        RESOURCE_DESCRIPTION_ITEM o = (RESOURCE_DESCRIPTION_ITEM)other_;
        return RESOURCE_DESCRIPTION_ITEM.compareDeep(this.language, o.language, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.purpose, o.purpose, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.keywordsList, o.keywordsList, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.use, o.use, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.misuse, o.misuse, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.copyright, o.copyright, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.original_resource_uriList, o.original_resource_uriList, true) && RESOURCE_DESCRIPTION_ITEM.compareDeep(this.other_detailsList, o.other_detailsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RESOURCE_DESCRIPTION_ITEM)) {
            return false;
        }
        RESOURCE_DESCRIPTION_ITEM o = (RESOURCE_DESCRIPTION_ITEM)other_;
        return RESOURCE_DESCRIPTION_ITEM.compareValues(this.purpose, o.purpose, true) && RESOURCE_DESCRIPTION_ITEM.compareValues(this.keywordsList, o.keywordsList, true) && RESOURCE_DESCRIPTION_ITEM.compareValues(this.use, o.use, true) && RESOURCE_DESCRIPTION_ITEM.compareValues(this.misuse, o.misuse, true) && RESOURCE_DESCRIPTION_ITEM.compareValues(this.copyright, o.copyright, true) && RESOURCE_DESCRIPTION_ITEM.compareValues(this.original_resource_uriList, o.original_resource_uriList, true) && RESOURCE_DESCRIPTION_ITEM.compareValues(this.other_detailsList, o.other_detailsList, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.language, this.purpose, this.keywordsList, this.use, this.misuse, this.copyright, this.original_resource_uriList, this.other_detailsList});
    }
}

