/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_IDENTIFIER;
import org.hl7.fhir.r5.openehr.PARTY_PROXY;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="PARTY_IDENTIFIED")
public class PARTY_IDENTIFIED
extends PARTY_PROXY
implements ICompositeType {
    @Child(name="name", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Optional human-readable name", formalDefinition="Optional human-readable name (in String form).")
    protected StringType name;
    @Child(name="identifiers", type={DV_IDENTIFIER.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="One or more formal identifiers (possibly computable)", formalDefinition="One or more formal identifiers (possibly computable).")
    protected List<DV_IDENTIFIER> identifiersList;
    private static final long serialVersionUID = 1762655878L;

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PARTY_IDENTIFIED.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public PARTY_IDENTIFIED setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public PARTY_IDENTIFIED setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<DV_IDENTIFIER> getIdentifiersList() {
        if (this.identifiersList == null) {
            this.identifiersList = new ArrayList<DV_IDENTIFIER>();
        }
        return this.identifiersList;
    }

    public PARTY_IDENTIFIED setIdentifiersList(List<DV_IDENTIFIER> theIdentifiers) {
        this.identifiersList = theIdentifiers;
        return this;
    }

    public boolean hasIdentifiers() {
        if (this.identifiersList == null) {
            return false;
        }
        for (DV_IDENTIFIER item : this.identifiersList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DV_IDENTIFIER addIdentifiers() {
        DV_IDENTIFIER t = new DV_IDENTIFIER();
        if (this.identifiersList == null) {
            this.identifiersList = new ArrayList<DV_IDENTIFIER>();
        }
        this.identifiersList.add(t);
        return t;
    }

    public PARTY_IDENTIFIED addIdentifiers(DV_IDENTIFIER t) {
        if (t == null) {
            return this;
        }
        if (this.identifiersList == null) {
            this.identifiersList = new ArrayList<DV_IDENTIFIER>();
        }
        this.identifiersList.add(t);
        return this;
    }

    public DV_IDENTIFIER getIdentifiersFirstRep() {
        if (this.getIdentifiersList().isEmpty()) {
            this.addIdentifiers();
        }
        return this.getIdentifiersList().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("name", "string", "Optional human-readable name (in String form).", 0, 1, this.name));
        children.add(new Property("identifiers", "http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER", "One or more formal identifiers (possibly computable).", 0, Integer.MAX_VALUE, this.identifiersList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3373707: {
                return new Property("name", "string", "Optional human-readable name (in String form).", 0, 1, this.name);
            }
            case 1368189162: {
                return new Property("identifiers", "http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER", "One or more formal identifiers (possibly computable).", 0, Integer.MAX_VALUE, this.identifiersList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.name;
                }
                return baseArray;
            }
            case 1368189162: {
                return this.identifiersList == null ? new Base[]{} : this.identifiersList.toArray(new Base[this.identifiersList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 1368189162: {
                this.getIdentifiersList().add((DV_IDENTIFIER)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("identifiers")) {
            this.getIdentifiersList().add((DV_IDENTIFIER)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return this.getNameElement();
            }
            case 1368189162: {
                return this.addIdentifiers();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3373707: {
                return new String[]{"string"};
            }
            case 1368189162: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-IDENTIFIER"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a singleton property PARTY_IDENTIFIED.name");
        }
        if (name.equals("identifiers")) {
            return this.addIdentifiers();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PARTY_IDENTIFIED";
    }

    @Override
    public PARTY_IDENTIFIED copy() {
        PARTY_IDENTIFIED dst = new PARTY_IDENTIFIED();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PARTY_IDENTIFIED dst) {
        super.copyValues(dst);
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.identifiersList != null) {
            dst.identifiersList = new ArrayList<DV_IDENTIFIER>();
            for (DV_IDENTIFIER i : this.identifiersList) {
                dst.identifiersList.add(i.copy());
            }
        }
    }

    protected PARTY_IDENTIFIED typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_IDENTIFIED)) {
            return false;
        }
        PARTY_IDENTIFIED o = (PARTY_IDENTIFIED)other_;
        return PARTY_IDENTIFIED.compareDeep(this.name, o.name, true) && PARTY_IDENTIFIED.compareDeep(this.identifiersList, o.identifiersList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PARTY_IDENTIFIED)) {
            return false;
        }
        PARTY_IDENTIFIED o = (PARTY_IDENTIFIED)other_;
        return PARTY_IDENTIFIED.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.identifiersList});
    }
}

