/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.OBJECT_ID;

@DatatypeDef(name="OBJECT_REF")
public class OBJECT_REF
extends LogicalBase
implements ICompositeType {
    @Child(name="namespace", type={StringType.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Namespace to which this identifier belongs in the local system context (and possibly in any other openEHR compliant environment)", formalDefinition="Namespace to which this identifier belongs in the local system context (and possibly in any other openEHR compliant environment) e.g. terminology , demographic . These names are not yet standardised. Legal values for namespace are: 'local', 'unknown', or a string matching the standard regex [a-zA-Z][a-zA-Z0-9_.:/&?=+-]*. Note that the first two are just special values of the regex, and will be matched by it.")
    protected StringType namespace;
    @Child(name="type", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Name of the class (concrete or abstract) of object to which this identifier type refers. These class names are from the relevant reference model", formalDefinition="Name of the class (concrete or abstract) of object to which this identifier type refers, e.g. PARTY, PERSON, GUIDELINE etc. These class names are from the relevant reference model. The type name ANY can be used to indicate that any type is accepted (e.g. if the type is unknown).")
    protected StringType type;
    @Child(name="id", type={OBJECT_ID.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Globally unique id of an object, regardless of where it is stored", formalDefinition="Globally unique id of an object, regardless of where it is stored.")
    protected OBJECT_ID id;
    private static final long serialVersionUID = 1415979947L;

    public OBJECT_REF() {
    }

    public OBJECT_REF(String namespace, String type, OBJECT_ID id) {
        this.setNamespace(namespace);
        this.setType(type);
        this.setId(id);
    }

    public StringType getNamespaceElement() {
        if (this.namespace == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OBJECT_REF.namespace");
            }
            if (Configuration.doAutoCreate()) {
                this.namespace = new StringType();
            }
        }
        return this.namespace;
    }

    public boolean hasNamespaceElement() {
        return this.namespace != null && !this.namespace.isEmpty();
    }

    public boolean hasNamespace() {
        return this.namespace != null && !this.namespace.isEmpty();
    }

    public OBJECT_REF setNamespaceElement(StringType value) {
        this.namespace = value;
        return this;
    }

    public String getNamespace() {
        return this.namespace == null ? null : (String)this.namespace.getValue();
    }

    public OBJECT_REF setNamespace(String value) {
        if (this.namespace == null) {
            this.namespace = new StringType();
        }
        this.namespace.setValue(value);
        return this;
    }

    public StringType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OBJECT_REF.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new StringType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public OBJECT_REF setTypeElement(StringType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public OBJECT_REF setType(String value) {
        if (this.type == null) {
            this.type = new StringType();
        }
        this.type.setValue(value);
        return this;
    }

    public OBJECT_ID getId() {
        return this.id;
    }

    public boolean hasId() {
        return this.id != null && !this.id.isEmpty();
    }

    public OBJECT_REF setId(OBJECT_ID value) {
        this.id = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("namespace", "string", "Namespace to which this identifier belongs in the local system context (and possibly in any other openEHR compliant environment) e.g. terminology , demographic . These names are not yet standardised. Legal values for namespace are: 'local', 'unknown', or a string matching the standard regex [a-zA-Z][a-zA-Z0-9_.:/&?=+-]*. Note that the first two are just special values of the regex, and will be matched by it.", 0, 1, this.namespace));
        children.add(new Property("type", "string", "Name of the class (concrete or abstract) of object to which this identifier type refers, e.g. PARTY, PERSON, GUIDELINE etc. These class names are from the relevant reference model. The type name ANY can be used to indicate that any type is accepted (e.g. if the type is unknown).", 0, 1, this.type));
        children.add(new Property("id", "http://openehr.org/fhir/StructureDefinition/OBJECT-ID", "Globally unique id of an object, regardless of where it is stored.", 0, 1, this.id));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1252218203: {
                return new Property("namespace", "string", "Namespace to which this identifier belongs in the local system context (and possibly in any other openEHR compliant environment) e.g. terminology , demographic . These names are not yet standardised. Legal values for namespace are: 'local', 'unknown', or a string matching the standard regex [a-zA-Z][a-zA-Z0-9_.:/&?=+-]*. Note that the first two are just special values of the regex, and will be matched by it.", 0, 1, this.namespace);
            }
            case 3575610: {
                return new Property("type", "string", "Name of the class (concrete or abstract) of object to which this identifier type refers, e.g. PARTY, PERSON, GUIDELINE etc. These class names are from the relevant reference model. The type name ANY can be used to indicate that any type is accepted (e.g. if the type is unknown).", 0, 1, this.type);
            }
            case 3355: {
                return new Property("id", "http://openehr.org/fhir/StructureDefinition/OBJECT-ID", "Globally unique id of an object, regardless of where it is stored.", 0, 1, this.id);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1252218203: {
                Base[] baseArray;
                if (this.namespace == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.namespace;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 3355: {
                Base[] baseArray;
                if (this.id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.id;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1252218203: {
                this.namespace = TypeConvertor.castToString(value);
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToString(value);
                return value;
            }
            case 3355: {
                this.id = (OBJECT_ID)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("namespace")) {
            this.namespace = TypeConvertor.castToString(value);
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToString(value);
        } else if (name.equals("id")) {
            this.id = (OBJECT_ID)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1252218203: {
                return this.getNamespaceElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 3355: {
                throw new Error("Unable to make an instance of the abstract property 'id'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1252218203: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"string"};
            }
            case 3355: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/OBJECT-ID"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("namespace")) {
            throw new FHIRException("Cannot call addChild on a singleton property OBJECT_REF.namespace");
        }
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a singleton property OBJECT_REF.type");
        }
        if (name.equals("id")) {
            throw new FHIRException("Cannot call addChild on an abstract type OBJECT_REF.id");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OBJECT_REF";
    }

    @Override
    public OBJECT_REF copy() {
        OBJECT_REF dst = new OBJECT_REF();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(OBJECT_REF dst) {
        super.copyValues(dst);
        dst.namespace = this.namespace == null ? null : this.namespace.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.id = this.id == null ? null : this.id.copy();
    }

    protected OBJECT_REF typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OBJECT_REF)) {
            return false;
        }
        OBJECT_REF o = (OBJECT_REF)other_;
        return OBJECT_REF.compareDeep(this.namespace, o.namespace, true) && OBJECT_REF.compareDeep(this.type, o.type, true) && OBJECT_REF.compareDeep(this.id, o.id, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OBJECT_REF)) {
            return false;
        }
        OBJECT_REF o = (OBJECT_REF)other_;
        return OBJECT_REF.compareValues(this.namespace, o.namespace, true) && OBJECT_REF.compareValues(this.type, o.type, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.namespace, this.type, this.id});
    }
}

