/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.LogicalBase;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.DV_EHR_URI;
import org.hl7.fhir.r5.openehr.DV_TEXT;

@DatatypeDef(name="LINK")
public class LINK
extends LogicalBase
implements ICompositeType {
    @Child(name="meaning", type={DV_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Used to describe the relationship, usually in clinical terms", formalDefinition="Used to describe the relationship, usually in clinical terms, such as in response to (the relationship between test results and an order), follow-up to and so on. Such relationships can represent any clinically meaningful connection between pieces of information. Values for meaning include those described in Annex C, ENV 13606 pt 2 under the categories of generic , documenting and reporting , organisational , clinical , circumstancial , and view management .")
    protected DV_TEXT meaning;
    @Child(name="type", type={DV_TEXT.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The type attribute is used to indicate a clinical or domain-level meaning for the kind of link", formalDefinition="The type attribute is used to indicate a clinical or domain-level meaning for the kind of link, for example problem or issue . If type values are designed appropriately, they can be used by the requestor of EHR extracts to categorise links which must be followed and which can be broken when the extract is created.")
    protected DV_TEXT type;
    @Child(name="target", type={DV_EHR_URI.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The logical to object in the link relation", formalDefinition="The logical to object in the link relation, as per the linguistic sense of the meaning attribute.")
    protected DV_EHR_URI target;
    private static final long serialVersionUID = -611201093L;

    public LINK() {
    }

    public LINK(DV_TEXT meaning, DV_TEXT type, DV_EHR_URI target) {
        this.setMeaning(meaning);
        this.setType(type);
        this.setTarget(target);
    }

    public DV_TEXT getMeaning() {
        if (this.meaning == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create LINK.meaning");
            }
            if (Configuration.doAutoCreate()) {
                this.meaning = new DV_TEXT();
            }
        }
        return this.meaning;
    }

    public boolean hasMeaning() {
        return this.meaning != null && !this.meaning.isEmpty();
    }

    public LINK setMeaning(DV_TEXT value) {
        this.meaning = value;
        return this;
    }

    public DV_TEXT getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create LINK.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new DV_TEXT();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public LINK setType(DV_TEXT value) {
        this.type = value;
        return this;
    }

    public DV_EHR_URI getTarget() {
        if (this.target == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create LINK.target");
            }
            if (Configuration.doAutoCreate()) {
                this.target = new DV_EHR_URI();
            }
        }
        return this.target;
    }

    public boolean hasTarget() {
        return this.target != null && !this.target.isEmpty();
    }

    public LINK setTarget(DV_EHR_URI value) {
        this.target = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("meaning", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Used to describe the relationship, usually in clinical terms, such as in response to (the relationship between test results and an order), follow-up to and so on. Such relationships can represent any clinically meaningful connection between pieces of information. Values for meaning include those described in Annex C, ENV 13606 pt 2 under the categories of generic , documenting and reporting , organisational , clinical , circumstancial , and view management .", 0, 1, this.meaning));
        children.add(new Property("type", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "The type attribute is used to indicate a clinical or domain-level meaning for the kind of link, for example problem or issue . If type values are designed appropriately, they can be used by the requestor of EHR extracts to categorise links which must be followed and which can be broken when the extract is created.", 0, 1, this.type));
        children.add(new Property("target", "http://openehr.org/fhir/StructureDefinition/DV-EHR-URI", "The logical to object in the link relation, as per the linguistic sense of the meaning attribute.", 0, 1, this.target));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 938160637: {
                return new Property("meaning", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "Used to describe the relationship, usually in clinical terms, such as in response to (the relationship between test results and an order), follow-up to and so on. Such relationships can represent any clinically meaningful connection between pieces of information. Values for meaning include those described in Annex C, ENV 13606 pt 2 under the categories of generic , documenting and reporting , organisational , clinical , circumstancial , and view management .", 0, 1, this.meaning);
            }
            case 3575610: {
                return new Property("type", "http://openehr.org/fhir/StructureDefinition/DV-TEXT", "The type attribute is used to indicate a clinical or domain-level meaning for the kind of link, for example problem or issue . If type values are designed appropriately, they can be used by the requestor of EHR extracts to categorise links which must be followed and which can be broken when the extract is created.", 0, 1, this.type);
            }
            case -880905839: {
                return new Property("target", "http://openehr.org/fhir/StructureDefinition/DV-EHR-URI", "The logical to object in the link relation, as per the linguistic sense of the meaning attribute.", 0, 1, this.target);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 938160637: {
                Base[] baseArray;
                if (this.meaning == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.meaning;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case -880905839: {
                Base[] baseArray;
                if (this.target == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.target;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 938160637: {
                this.meaning = (DV_TEXT)value;
                return value;
            }
            case 3575610: {
                this.type = (DV_TEXT)value;
                return value;
            }
            case -880905839: {
                this.target = (DV_EHR_URI)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("meaning")) {
            this.meaning = (DV_TEXT)value;
        } else if (name.equals("type")) {
            this.type = (DV_TEXT)value;
        } else if (name.equals("target")) {
            this.target = (DV_EHR_URI)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 938160637: {
                return this.getMeaning();
            }
            case 3575610: {
                return this.getType();
            }
            case -880905839: {
                return this.getTarget();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 938160637: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case 3575610: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-TEXT"};
            }
            case -880905839: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-EHR-URI"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("meaning")) {
            this.meaning = new DV_TEXT();
            return this.meaning;
        }
        if (name.equals("type")) {
            this.type = new DV_TEXT();
            return this.type;
        }
        if (name.equals("target")) {
            this.target = new DV_EHR_URI();
            return this.target;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "LINK";
    }

    @Override
    public LINK copy() {
        LINK dst = new LINK();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(LINK dst) {
        super.copyValues(dst);
        dst.meaning = this.meaning == null ? null : this.meaning.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.target = this.target == null ? null : this.target.copy();
    }

    protected LINK typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof LINK)) {
            return false;
        }
        LINK o = (LINK)other_;
        return LINK.compareDeep(this.meaning, o.meaning, true) && LINK.compareDeep(this.type, o.type, true) && LINK.compareDeep(this.target, o.target, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof LINK)) {
            return false;
        }
        LINK o = (LINK)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.meaning, this.type, this.target});
    }
}

