/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.openehr.ITEM;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;

@DatatypeDef(name="ITEM_TREE")
public class ITEM_TREE
extends ITEM_STRUCTURE
implements ICompositeType {
    @Child(name="items", type={ITEM.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The items comprising the ITEM_TREE. Can include 0 or more CLUSTERs and/or 0 or more individual ELEMENTs", formalDefinition="The items comprising the ITEM_TREE. Can include 0 or more CLUSTERs and/or 0 or more individual ELEMENTs.")
    protected List<ITEM> itemsList;
    private static final long serialVersionUID = -285267557L;

    public List<ITEM> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<ITEM>();
        }
        return this.itemsList;
    }

    public ITEM_TREE setItemsList(List<ITEM> theItems) {
        this.itemsList = theItems;
        return this;
    }

    public boolean hasItems() {
        if (this.itemsList == null) {
            return false;
        }
        for (ITEM item : this.itemsList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ITEM_TREE addItems(ITEM t) {
        if (t == null) {
            return this;
        }
        if (this.itemsList == null) {
            this.itemsList = new ArrayList<ITEM>();
        }
        this.itemsList.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("items", "http://openehr.org/fhir/StructureDefinition/ITEM", "The items comprising the ITEM_TREE. Can include 0 or more CLUSTERs and/or 0 or more individual ELEMENTs.", 0, Integer.MAX_VALUE, this.itemsList));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 100526016: {
                return new Property("items", "http://openehr.org/fhir/StructureDefinition/ITEM", "The items comprising the ITEM_TREE. Can include 0 or more CLUSTERs and/or 0 or more individual ELEMENTs.", 0, Integer.MAX_VALUE, this.itemsList);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return this.itemsList == null ? new Base[]{} : this.itemsList.toArray(new Base[this.itemsList.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 100526016: {
                this.getItemsList().add((ITEM)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (!name.equals("items")) {
            return super.setProperty(name, value);
        }
        this.getItemsList().add((ITEM)value);
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                throw new Error("Unable to make an instance of the abstract property 'items'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 100526016: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("items")) {
            throw new FHIRException("Cannot call addChild on an abstract type ITEM_TREE.items");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ITEM_TREE";
    }

    @Override
    public ITEM_TREE copy() {
        ITEM_TREE dst = new ITEM_TREE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ITEM_TREE dst) {
        super.copyValues(dst);
        if (this.itemsList != null) {
            dst.itemsList = new ArrayList<ITEM>();
            for (ITEM i : this.itemsList) {
                dst.itemsList.add(i.copy());
            }
        }
    }

    protected ITEM_TREE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_TREE)) {
            return false;
        }
        ITEM_TREE o = (ITEM_TREE)other_;
        return ITEM_TREE.compareDeep(this.itemsList, o.itemsList, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ITEM_TREE)) {
            return false;
        }
        ITEM_TREE o = (ITEM_TREE)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.itemsList);
    }
}

