/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE_REF;
import org.hl7.fhir.r5.openehr.PATHABLE;

@DatatypeDef(name="INSTRUCTION_DETAILS")
public class INSTRUCTION_DETAILS
extends PATHABLE
implements ICompositeType {
    @Child(name="instruction_id", type={LOCATABLE_REF.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to causing Instruction", formalDefinition="Reference to causing Instruction.")
    protected LOCATABLE_REF instruction_id;
    @Child(name="activity_id", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Identifier of Activity within Instruction, in the form of its archetype path", formalDefinition="Identifier of Activity within Instruction, in the form of its archetype path.")
    protected StringType activity_id;
    @Child(name="wf_details", type={ITEM_STRUCTURE.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Various workflow engine state details", formalDefinition="Various workflow engine state details, potentially including such things as:\r\n\r\n* condition that fired to cause this Action to be done (with actual variables substituted);\r\n* list of notifications which actually occurred (with all variables substituted);\r\n* other workflow engine state.\r\n\r\nThis specification does not currently define the actual structure or semantics of this field.")
    protected ITEM_STRUCTURE wf_details;
    private static final long serialVersionUID = -225495980L;

    public INSTRUCTION_DETAILS() {
    }

    public INSTRUCTION_DETAILS(LOCATABLE_REF instruction_id, String activity_id) {
        this.setInstruction_id(instruction_id);
        this.setActivity_id(activity_id);
    }

    public LOCATABLE_REF getInstruction_id() {
        if (this.instruction_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INSTRUCTION_DETAILS.instruction_id");
            }
            if (Configuration.doAutoCreate()) {
                this.instruction_id = new LOCATABLE_REF();
            }
        }
        return this.instruction_id;
    }

    public boolean hasInstruction_id() {
        return this.instruction_id != null && !this.instruction_id.isEmpty();
    }

    public INSTRUCTION_DETAILS setInstruction_id(LOCATABLE_REF value) {
        this.instruction_id = value;
        return this;
    }

    public StringType getActivity_idElement() {
        if (this.activity_id == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create INSTRUCTION_DETAILS.activity_id");
            }
            if (Configuration.doAutoCreate()) {
                this.activity_id = new StringType();
            }
        }
        return this.activity_id;
    }

    public boolean hasActivity_idElement() {
        return this.activity_id != null && !this.activity_id.isEmpty();
    }

    public boolean hasActivity_id() {
        return this.activity_id != null && !this.activity_id.isEmpty();
    }

    public INSTRUCTION_DETAILS setActivity_idElement(StringType value) {
        this.activity_id = value;
        return this;
    }

    public String getActivity_id() {
        return this.activity_id == null ? null : (String)this.activity_id.getValue();
    }

    public INSTRUCTION_DETAILS setActivity_id(String value) {
        if (this.activity_id == null) {
            this.activity_id = new StringType();
        }
        this.activity_id.setValue(value);
        return this;
    }

    public ITEM_STRUCTURE getWf_details() {
        return this.wf_details;
    }

    public boolean hasWf_details() {
        return this.wf_details != null && !this.wf_details.isEmpty();
    }

    public INSTRUCTION_DETAILS setWf_details(ITEM_STRUCTURE value) {
        this.wf_details = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("instruction_id", "http://openehr.org/fhir/StructureDefinition/LOCATABLE-REF", "Reference to causing Instruction.", 0, 1, this.instruction_id));
        children.add(new Property("activity_id", "string", "Identifier of Activity within Instruction, in the form of its archetype path.", 0, 1, this.activity_id));
        children.add(new Property("wf_details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Various workflow engine state details, potentially including such things as:\r\n\r\n* condition that fired to cause this Action to be done (with actual variables substituted);\r\n* list of notifications which actually occurred (with all variables substituted);\r\n* other workflow engine state.\r\n\r\nThis specification does not currently define the actual structure or semantics of this field.", 0, 1, this.wf_details));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1989251692: {
                return new Property("instruction_id", "http://openehr.org/fhir/StructureDefinition/LOCATABLE-REF", "Reference to causing Instruction.", 0, 1, this.instruction_id);
            }
            case -917278645: {
                return new Property("activity_id", "string", "Identifier of Activity within Instruction, in the form of its archetype path.", 0, 1, this.activity_id);
            }
            case -1966053166: {
                return new Property("wf_details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Various workflow engine state details, potentially including such things as:\r\n\r\n* condition that fired to cause this Action to be done (with actual variables substituted);\r\n* list of notifications which actually occurred (with all variables substituted);\r\n* other workflow engine state.\r\n\r\nThis specification does not currently define the actual structure or semantics of this field.", 0, 1, this.wf_details);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1989251692: {
                Base[] baseArray;
                if (this.instruction_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.instruction_id;
                }
                return baseArray;
            }
            case -917278645: {
                Base[] baseArray;
                if (this.activity_id == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.activity_id;
                }
                return baseArray;
            }
            case -1966053166: {
                Base[] baseArray;
                if (this.wf_details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.wf_details;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1989251692: {
                this.instruction_id = (LOCATABLE_REF)value;
                return value;
            }
            case -917278645: {
                this.activity_id = TypeConvertor.castToString(value);
                return value;
            }
            case -1966053166: {
                this.wf_details = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("instruction_id")) {
            this.instruction_id = (LOCATABLE_REF)value;
        } else if (name.equals("activity_id")) {
            this.activity_id = TypeConvertor.castToString(value);
        } else if (name.equals("wf_details")) {
            this.wf_details = (ITEM_STRUCTURE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1989251692: {
                return this.getInstruction_id();
            }
            case -917278645: {
                return this.getActivity_idElement();
            }
            case -1966053166: {
                throw new Error("Unable to make an instance of the abstract property 'wf_details'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1989251692: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/LOCATABLE-REF"};
            }
            case -917278645: {
                return new String[]{"string"};
            }
            case -1966053166: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("instruction_id")) {
            this.instruction_id = new LOCATABLE_REF();
            return this.instruction_id;
        }
        if (name.equals("activity_id")) {
            throw new FHIRException("Cannot call addChild on a singleton property INSTRUCTION_DETAILS.activity_id");
        }
        if (name.equals("wf_details")) {
            throw new FHIRException("Cannot call addChild on an abstract type INSTRUCTION_DETAILS.wf_details");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "INSTRUCTION_DETAILS";
    }

    @Override
    public INSTRUCTION_DETAILS copy() {
        INSTRUCTION_DETAILS dst = new INSTRUCTION_DETAILS();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(INSTRUCTION_DETAILS dst) {
        super.copyValues(dst);
        dst.instruction_id = this.instruction_id == null ? null : this.instruction_id.copy();
        dst.activity_id = this.activity_id == null ? null : this.activity_id.copy();
        dst.wf_details = this.wf_details == null ? null : this.wf_details.copy();
    }

    protected INSTRUCTION_DETAILS typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof INSTRUCTION_DETAILS)) {
            return false;
        }
        INSTRUCTION_DETAILS o = (INSTRUCTION_DETAILS)other_;
        return INSTRUCTION_DETAILS.compareDeep(this.instruction_id, o.instruction_id, true) && INSTRUCTION_DETAILS.compareDeep(this.activity_id, o.activity_id, true) && INSTRUCTION_DETAILS.compareDeep(this.wf_details, o.wf_details, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof INSTRUCTION_DETAILS)) {
            return false;
        }
        INSTRUCTION_DETAILS o = (INSTRUCTION_DETAILS)other_;
        return INSTRUCTION_DETAILS.compareValues(this.activity_id, o.activity_id, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.instruction_id, this.activity_id, this.wf_details});
    }
}

