/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.ITEM_STRUCTURE;
import org.hl7.fhir.r5.openehr.LOCATABLE;
import org.hl7.fhir.r5.openehr.PARTY_SELF;

@DatatypeDef(name="EHR_STATUS")
public class EHR_STATUS
extends LOCATABLE
implements ICompositeType {
    @Child(name="subject", type={PARTY_SELF.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The subject of this EHR. The external_ref attribute can be used to contain a direct reference to the subject in a demographic or identity service. Alternatively, the association between patients and their records may be done elsewhere for security reasons", formalDefinition="The subject of this EHR. The external_ref attribute can be used to contain a direct reference to the subject in a demographic or identity service. Alternatively, the association between patients and their records may be done elsewhere for security reasons.")
    protected PARTY_SELF subject;
    @Child(name="is_queryable", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="True if this EHR should be included in population queries, i.e. if this EHR is considered active in the population", formalDefinition="True if this EHR should be included in population queries, i.e. if this EHR is considered active in the population.")
    protected BooleanType is_queryable;
    @Child(name="is_modifiable", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="True if the EHR, other than the EHR_STATUS object, is allowed to be written to. The EHR_STATUS object itself can always be written to", formalDefinition="True if the EHR, other than the EHR_STATUS object, is allowed to be written to. The EHR_STATUS object itself can always be written to.")
    protected BooleanType is_modifiable;
    @Child(name="other_details", type={ITEM_STRUCTURE.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any other details of the EHR summary object, in the form of an archetyped ITEM_STRUCTURE", formalDefinition="Any other details of the EHR summary object, in the form of an archetyped ITEM_STRUCTURE.")
    protected ITEM_STRUCTURE other_details;
    private static final long serialVersionUID = -1523453193L;

    public EHR_STATUS() {
    }

    public EHR_STATUS(PARTY_SELF subject, boolean is_queryable, boolean is_modifiable) {
        this.setSubject(subject);
        this.setIs_queryable(is_queryable);
        this.setIs_modifiable(is_modifiable);
    }

    public PARTY_SELF getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR_STATUS.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new PARTY_SELF();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public EHR_STATUS setSubject(PARTY_SELF value) {
        this.subject = value;
        return this;
    }

    public BooleanType getIs_queryableElement() {
        if (this.is_queryable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR_STATUS.is_queryable");
            }
            if (Configuration.doAutoCreate()) {
                this.is_queryable = new BooleanType();
            }
        }
        return this.is_queryable;
    }

    public boolean hasIs_queryableElement() {
        return this.is_queryable != null && !this.is_queryable.isEmpty();
    }

    public boolean hasIs_queryable() {
        return this.is_queryable != null && !this.is_queryable.isEmpty();
    }

    public EHR_STATUS setIs_queryableElement(BooleanType value) {
        this.is_queryable = value;
        return this;
    }

    public boolean getIs_queryable() {
        return this.is_queryable == null || this.is_queryable.isEmpty() ? false : (Boolean)this.is_queryable.getValue();
    }

    public EHR_STATUS setIs_queryable(boolean value) {
        if (this.is_queryable == null) {
            this.is_queryable = new BooleanType();
        }
        this.is_queryable.setValue((Object)value);
        return this;
    }

    public BooleanType getIs_modifiableElement() {
        if (this.is_modifiable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create EHR_STATUS.is_modifiable");
            }
            if (Configuration.doAutoCreate()) {
                this.is_modifiable = new BooleanType();
            }
        }
        return this.is_modifiable;
    }

    public boolean hasIs_modifiableElement() {
        return this.is_modifiable != null && !this.is_modifiable.isEmpty();
    }

    public boolean hasIs_modifiable() {
        return this.is_modifiable != null && !this.is_modifiable.isEmpty();
    }

    public EHR_STATUS setIs_modifiableElement(BooleanType value) {
        this.is_modifiable = value;
        return this;
    }

    public boolean getIs_modifiable() {
        return this.is_modifiable == null || this.is_modifiable.isEmpty() ? false : (Boolean)this.is_modifiable.getValue();
    }

    public EHR_STATUS setIs_modifiable(boolean value) {
        if (this.is_modifiable == null) {
            this.is_modifiable = new BooleanType();
        }
        this.is_modifiable.setValue((Object)value);
        return this;
    }

    public ITEM_STRUCTURE getOther_details() {
        return this.other_details;
    }

    public boolean hasOther_details() {
        return this.other_details != null && !this.other_details.isEmpty();
    }

    public EHR_STATUS setOther_details(ITEM_STRUCTURE value) {
        this.other_details = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("subject", "http://openehr.org/fhir/StructureDefinition/PARTY-SELF", "The subject of this EHR. The external_ref attribute can be used to contain a direct reference to the subject in a demographic or identity service. Alternatively, the association between patients and their records may be done elsewhere for security reasons.", 0, 1, this.subject));
        children.add(new Property("is_queryable", "boolean", "True if this EHR should be included in population queries, i.e. if this EHR is considered active in the population.", 0, 1, this.is_queryable));
        children.add(new Property("is_modifiable", "boolean", "True if the EHR, other than the EHR_STATUS object, is allowed to be written to. The EHR_STATUS object itself can always be written to.", 0, 1, this.is_modifiable));
        children.add(new Property("other_details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Any other details of the EHR summary object, in the form of an archetyped ITEM_STRUCTURE.", 0, 1, this.other_details));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1867885268: {
                return new Property("subject", "http://openehr.org/fhir/StructureDefinition/PARTY-SELF", "The subject of this EHR. The external_ref attribute can be used to contain a direct reference to the subject in a demographic or identity service. Alternatively, the association between patients and their records may be done elsewhere for security reasons.", 0, 1, this.subject);
            }
            case 1177363789: {
                return new Property("is_queryable", "boolean", "True if this EHR should be included in population queries, i.e. if this EHR is considered active in the population.", 0, 1, this.is_queryable);
            }
            case -792595655: {
                return new Property("is_modifiable", "boolean", "True if the EHR, other than the EHR_STATUS object, is allowed to be written to. The EHR_STATUS object itself can always be written to.", 0, 1, this.is_modifiable);
            }
            case -1257043949: {
                return new Property("other_details", "http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE", "Any other details of the EHR summary object, in the form of an archetyped ITEM_STRUCTURE.", 0, 1, this.other_details);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.subject;
                }
                return baseArray;
            }
            case 1177363789: {
                Base[] baseArray;
                if (this.is_queryable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.is_queryable;
                }
                return baseArray;
            }
            case -792595655: {
                Base[] baseArray;
                if (this.is_modifiable == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.is_modifiable;
                }
                return baseArray;
            }
            case -1257043949: {
                Base[] baseArray;
                if (this.other_details == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.other_details;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                this.subject = (PARTY_SELF)value;
                return value;
            }
            case 1177363789: {
                this.is_queryable = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -792595655: {
                this.is_modifiable = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1257043949: {
                this.other_details = (ITEM_STRUCTURE)value;
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("subject")) {
            this.subject = (PARTY_SELF)value;
        } else if (name.equals("is_queryable")) {
            this.is_queryable = TypeConvertor.castToBoolean(value);
        } else if (name.equals("is_modifiable")) {
            this.is_modifiable = TypeConvertor.castToBoolean(value);
        } else if (name.equals("other_details")) {
            this.other_details = (ITEM_STRUCTURE)value;
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return this.getSubject();
            }
            case 1177363789: {
                return this.getIs_queryableElement();
            }
            case -792595655: {
                return this.getIs_modifiableElement();
            }
            case -1257043949: {
                throw new Error("Unable to make an instance of the abstract property 'other_details'");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1867885268: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/PARTY-SELF"};
            }
            case 1177363789: {
                return new String[]{"boolean"};
            }
            case -792595655: {
                return new String[]{"boolean"};
            }
            case -1257043949: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/ITEM-STRUCTURE"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("subject")) {
            this.subject = new PARTY_SELF();
            return this.subject;
        }
        if (name.equals("is_queryable")) {
            throw new FHIRException("Cannot call addChild on a singleton property EHR_STATUS.is_queryable");
        }
        if (name.equals("is_modifiable")) {
            throw new FHIRException("Cannot call addChild on a singleton property EHR_STATUS.is_modifiable");
        }
        if (name.equals("other_details")) {
            throw new FHIRException("Cannot call addChild on an abstract type EHR_STATUS.other_details");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "EHR_STATUS";
    }

    @Override
    public EHR_STATUS copy() {
        EHR_STATUS dst = new EHR_STATUS();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(EHR_STATUS dst) {
        super.copyValues(dst);
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.is_queryable = this.is_queryable == null ? null : this.is_queryable.copy();
        dst.is_modifiable = this.is_modifiable == null ? null : this.is_modifiable.copy();
        dst.other_details = this.other_details == null ? null : this.other_details.copy();
    }

    protected EHR_STATUS typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof EHR_STATUS)) {
            return false;
        }
        EHR_STATUS o = (EHR_STATUS)other_;
        return EHR_STATUS.compareDeep(this.subject, o.subject, true) && EHR_STATUS.compareDeep(this.is_queryable, o.is_queryable, true) && EHR_STATUS.compareDeep(this.is_modifiable, o.is_modifiable, true) && EHR_STATUS.compareDeep(this.other_details, o.other_details, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof EHR_STATUS)) {
            return false;
        }
        EHR_STATUS o = (EHR_STATUS)other_;
        return EHR_STATUS.compareValues(this.is_queryable, o.is_queryable, true) && EHR_STATUS.compareValues(this.is_modifiable, o.is_modifiable, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.subject, this.is_queryable, this.is_modifiable, this.other_details});
    }
}

