/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DATA_VALUE;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;

@DatatypeDef(name="DV_STATE")
public class DV_STATE
extends DATA_VALUE
implements ICompositeType {
    @Child(name="value", type={DV_CODED_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The state name", formalDefinition="The state name. State names are determined by a state/event table defined in archetypes, and coded using openEHR Terminology or local archetype terms, as specified by the archetype.")
    protected DV_CODED_TEXT value;
    @Child(name="is_terminal", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates whether this state is a terminal state", formalDefinition="Indicates whether this state is a terminal state, such as 'aborted', 'completed' etc. from which no further transitions are possible.")
    protected BooleanType is_terminal;
    private static final long serialVersionUID = -1675630194L;

    public DV_STATE() {
    }

    public DV_STATE(DV_CODED_TEXT value, boolean is_terminal) {
        this.setValue(value);
        this.setIs_terminal(is_terminal);
    }

    public DV_CODED_TEXT getValue() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_STATE.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new DV_CODED_TEXT();
            }
        }
        return this.value;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_STATE setValue(DV_CODED_TEXT value) {
        this.value = value;
        return this;
    }

    public BooleanType getIs_terminalElement() {
        if (this.is_terminal == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_STATE.is_terminal");
            }
            if (Configuration.doAutoCreate()) {
                this.is_terminal = new BooleanType();
            }
        }
        return this.is_terminal;
    }

    public boolean hasIs_terminalElement() {
        return this.is_terminal != null && !this.is_terminal.isEmpty();
    }

    public boolean hasIs_terminal() {
        return this.is_terminal != null && !this.is_terminal.isEmpty();
    }

    public DV_STATE setIs_terminalElement(BooleanType value) {
        this.is_terminal = value;
        return this;
    }

    public boolean getIs_terminal() {
        return this.is_terminal == null || this.is_terminal.isEmpty() ? false : (Boolean)this.is_terminal.getValue();
    }

    public DV_STATE setIs_terminal(boolean value) {
        if (this.is_terminal == null) {
            this.is_terminal = new BooleanType();
        }
        this.is_terminal.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("value", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The state name. State names are determined by a state/event table defined in archetypes, and coded using openEHR Terminology or local archetype terms, as specified by the archetype.", 0, 1, this.value));
        children.add(new Property("is_terminal", "boolean", "Indicates whether this state is a terminal state, such as 'aborted', 'completed' etc. from which no further transitions are possible.", 0, 1, this.is_terminal));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 111972721: {
                return new Property("value", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "The state name. State names are determined by a state/event table defined in archetypes, and coded using openEHR Terminology or local archetype terms, as specified by the archetype.", 0, 1, this.value);
            }
            case -1916279311: {
                return new Property("is_terminal", "boolean", "Indicates whether this state is a terminal state, such as 'aborted', 'completed' etc. from which no further transitions are possible.", 0, 1, this.is_terminal);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.value;
                }
                return baseArray;
            }
            case -1916279311: {
                Base[] baseArray;
                if (this.is_terminal == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.is_terminal;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 111972721: {
                this.value = (DV_CODED_TEXT)value;
                return value;
            }
            case -1916279311: {
                this.is_terminal = TypeConvertor.castToBoolean(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("value")) {
            this.value = (DV_CODED_TEXT)value;
        } else if (name.equals("is_terminal")) {
            this.is_terminal = TypeConvertor.castToBoolean(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return this.getValue();
            }
            case -1916279311: {
                return this.getIs_terminalElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 111972721: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case -1916279311: {
                return new String[]{"boolean"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("value")) {
            this.value = new DV_CODED_TEXT();
            return this.value;
        }
        if (name.equals("is_terminal")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_STATE.is_terminal");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_STATE";
    }

    @Override
    public DV_STATE copy() {
        DV_STATE dst = new DV_STATE();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_STATE dst) {
        super.copyValues(dst);
        dst.value = this.value == null ? null : this.value.copy();
        dst.is_terminal = this.is_terminal == null ? null : this.is_terminal.copy();
    }

    protected DV_STATE typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_STATE)) {
            return false;
        }
        DV_STATE o = (DV_STATE)other_;
        return DV_STATE.compareDeep(this.value, o.value, true) && DV_STATE.compareDeep(this.is_terminal, o.is_terminal, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_STATE)) {
            return false;
        }
        DV_STATE o = (DV_STATE)other_;
        return DV_STATE.compareValues(this.is_terminal, o.is_terminal, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value, this.is_terminal});
    }
}

