/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.openehr;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.openehr.DV_CODED_TEXT;
import org.hl7.fhir.r5.openehr.DV_ORDERED;

@DatatypeDef(name="DV_ORDINAL")
public class DV_ORDINAL
extends DV_ORDERED
implements ICompositeType {
    @Child(name="symbol", type={DV_CODED_TEXT.class}, order=0, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Coded textual representation of this value in the enumeration", formalDefinition="Coded textual representation of this value in the enumeration, which may be strings made from + symbols, or other enumerations of terms such as mild, moderate, severe, or even the same number series as the values, e.g. 1, 2, 3.")
    protected DV_CODED_TEXT symbol;
    @Child(name="value", type={IntegerType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Value in ordered enumeration of values", formalDefinition="Value in ordered enumeration of values. Any integer value can be used.")
    protected IntegerType value;
    private static final long serialVersionUID = -1263083887L;

    public DV_ORDINAL() {
    }

    public DV_ORDINAL(DV_CODED_TEXT symbol, int value) {
        this.setSymbol(symbol);
        this.setValue(value);
    }

    public DV_CODED_TEXT getSymbol() {
        if (this.symbol == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_ORDINAL.symbol");
            }
            if (Configuration.doAutoCreate()) {
                this.symbol = new DV_CODED_TEXT();
            }
        }
        return this.symbol;
    }

    public boolean hasSymbol() {
        return this.symbol != null && !this.symbol.isEmpty();
    }

    public DV_ORDINAL setSymbol(DV_CODED_TEXT value) {
        this.symbol = value;
        return this;
    }

    public IntegerType getValueElement() {
        if (this.value == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DV_ORDINAL.value");
            }
            if (Configuration.doAutoCreate()) {
                this.value = new IntegerType();
            }
        }
        return this.value;
    }

    public boolean hasValueElement() {
        return this.value != null && !this.value.isEmpty();
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public DV_ORDINAL setValueElement(IntegerType value) {
        this.value = value;
        return this;
    }

    public int getValue() {
        return this.value == null || this.value.isEmpty() ? 0 : (Integer)this.value.getValue();
    }

    public DV_ORDINAL setValue(int value) {
        if (this.value == null) {
            this.value = new IntegerType();
        }
        this.value.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("symbol", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Coded textual representation of this value in the enumeration, which may be strings made from + symbols, or other enumerations of terms such as mild, moderate, severe, or even the same number series as the values, e.g. 1, 2, 3.", 0, 1, this.symbol));
        children.add(new Property("value", "integer", "Value in ordered enumeration of values. Any integer value can be used.", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -887523944: {
                return new Property("symbol", "http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT", "Coded textual representation of this value in the enumeration, which may be strings made from + symbols, or other enumerations of terms such as mild, moderate, severe, or even the same number series as the values, e.g. 1, 2, 3.", 0, 1, this.symbol);
            }
            case 111972721: {
                return new Property("value", "integer", "Value in ordered enumeration of values. Any integer value can be used.", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -887523944: {
                Base[] baseArray;
                if (this.symbol == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.symbol;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -887523944: {
                this.symbol = (DV_CODED_TEXT)value;
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToInteger(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("symbol")) {
            this.symbol = (DV_CODED_TEXT)value;
        } else if (name.equals("value")) {
            this.value = TypeConvertor.castToInteger(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887523944: {
                return this.getSymbol();
            }
            case 111972721: {
                return this.getValueElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -887523944: {
                return new String[]{"http://openehr.org/fhir/StructureDefinition/DV-CODED-TEXT"};
            }
            case 111972721: {
                return new String[]{"integer"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("symbol")) {
            this.symbol = new DV_CODED_TEXT();
            return this.symbol;
        }
        if (name.equals("value")) {
            throw new FHIRException("Cannot call addChild on a singleton property DV_ORDINAL.value");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DV_ORDINAL";
    }

    @Override
    public DV_ORDINAL copy() {
        DV_ORDINAL dst = new DV_ORDINAL();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(DV_ORDINAL dst) {
        super.copyValues(dst);
        dst.symbol = this.symbol == null ? null : this.symbol.copy();
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected DV_ORDINAL typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_ORDINAL)) {
            return false;
        }
        DV_ORDINAL o = (DV_ORDINAL)other_;
        return DV_ORDINAL.compareDeep(this.symbol, o.symbol, true) && DV_ORDINAL.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof DV_ORDINAL)) {
            return false;
        }
        DV_ORDINAL o = (DV_ORDINAL)other_;
        return DV_ORDINAL.compareValues(this.value, o.value, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.symbol, this.value});
    }
}

